/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.shadows;

import android.app.VoiceInteractor;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.robolectric.annotation.Implementation;
import org.robolectric.annotation.Implements;
import org.robolectric.util.reflector.Accessor;
import org.robolectric.util.reflector.ForType;
import org.robolectric.util.reflector.Reflector;

@Implements(value=VoiceInteractor.class, minSdk=23)
public class ShadowVoiceInteractor {
    private int directActionsInvalidationCount = 0;
    private final List<String> voiceInteractions = new CopyOnWriteArrayList<String>();
    public static String assistantPackageName = "test_package";

    @Implementation(minSdk=33)
    protected String getPackageName() {
        return assistantPackageName;
    }

    public void setPackageName(String packageName) {
        assistantPackageName = packageName;
    }

    @Implementation(minSdk=29)
    protected void notifyDirectActionsChanged() {
        ++this.directActionsInvalidationCount;
    }

    @Implementation(minSdk=29)
    protected boolean submitRequest(VoiceInteractor.Request request, String name) {
        if (request instanceof VoiceInteractor.ConfirmationRequest) {
            this.processPrompt(((ReflectorConfirmationRequest)Reflector.reflector(ReflectorConfirmationRequest.class, (Object)request)).getPrompt());
        } else if (request instanceof VoiceInteractor.CompleteVoiceRequest) {
            this.processPrompt(((ReflectorCompleteVoiceRequest)Reflector.reflector(ReflectorCompleteVoiceRequest.class, (Object)request)).getPrompt());
        } else if (request instanceof VoiceInteractor.AbortVoiceRequest) {
            this.processPrompt(((ReflectorAbortVoiceRequest)Reflector.reflector(ReflectorAbortVoiceRequest.class, (Object)request)).getPrompt());
        } else if (request instanceof VoiceInteractor.CommandRequest) {
            this.voiceInteractions.add(((ReflectorCommandRequest)Reflector.reflector(ReflectorCommandRequest.class, (Object)request)).getCommand());
        } else if (request instanceof VoiceInteractor.PickOptionRequest) {
            this.processPrompt(((ReflectorPickOptionRequest)Reflector.reflector(ReflectorPickOptionRequest.class, (Object)request)).getPrompt());
        }
        return true;
    }

    @Implementation(minSdk=29)
    protected boolean submitRequest(VoiceInteractor.Request request) {
        return this.submitRequest(request, null);
    }

    public int getDirectActionsInvalidationCount() {
        return this.directActionsInvalidationCount;
    }

    public List<String> getVoiceInteractions() {
        return this.voiceInteractions;
    }

    private void processPrompt(VoiceInteractor.Prompt prompt) {
        if (prompt.countVoicePrompts() <= 0) {
            return;
        }
        for (int i = 0; i < prompt.countVoicePrompts(); ++i) {
            this.voiceInteractions.add(prompt.getVoicePromptAt(i).toString());
        }
    }

    @ForType(value=VoiceInteractor.ConfirmationRequest.class)
    static interface ReflectorConfirmationRequest {
        @Accessor(value="mPrompt")
        public VoiceInteractor.Prompt getPrompt();
    }

    @ForType(value=VoiceInteractor.CompleteVoiceRequest.class)
    static interface ReflectorCompleteVoiceRequest {
        @Accessor(value="mPrompt")
        public VoiceInteractor.Prompt getPrompt();
    }

    @ForType(value=VoiceInteractor.AbortVoiceRequest.class)
    static interface ReflectorAbortVoiceRequest {
        @Accessor(value="mPrompt")
        public VoiceInteractor.Prompt getPrompt();
    }

    @ForType(value=VoiceInteractor.CommandRequest.class)
    static interface ReflectorCommandRequest {
        @Accessor(value="mCommand")
        public String getCommand();
    }

    @ForType(value=VoiceInteractor.PickOptionRequest.class)
    static interface ReflectorPickOptionRequest {
        @Accessor(value="mPrompt")
        public VoiceInteractor.Prompt getPrompt();
    }
}

