/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.shadows;

import android.accounts.Account;
import android.app.Application;
import android.content.Context;
import android.content.Intent;
import android.content.pm.UserInfo;
import android.graphics.Bitmap;
import android.os.Bundle;
import android.os.IUserManager;
import android.os.Parcelable;
import android.os.PersistableBundle;
import android.os.Process;
import android.os.UserHandle;
import android.os.UserManager;
import com.google.common.base.Preconditions;
import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.robolectric.RuntimeEnvironment;
import org.robolectric.annotation.HiddenApi;
import org.robolectric.annotation.Implementation;
import org.robolectric.annotation.Implements;
import org.robolectric.annotation.RealObject;
import org.robolectric.annotation.Resetter;
import org.robolectric.shadow.api.Shadow;
import org.robolectric.shadows.ShadowApplication;
import org.robolectric.shadows.ShadowContextImpl;
import org.robolectric.shadows.ShadowProcess;
import org.robolectric.util.ReflectionHelpers;
import org.robolectric.util.reflector.Accessor;
import org.robolectric.util.reflector.Direct;
import org.robolectric.util.reflector.ForType;
import org.robolectric.util.reflector.Reflector;

@Implements(value=UserManager.class, minSdk=17)
public class ShadowUserManager {
    public static final int DEFAULT_SECONDARY_USER_ID = 10;
    private static final int DEFAULT_MAX_SUPPORTED_USERS = 1;
    public static final int FLAG_PRIMARY = 1;
    public static final int FLAG_ADMIN = 2;
    public static final int FLAG_GUEST = 4;
    public static final int FLAG_RESTRICTED = 8;
    public static final int FLAG_DEMO = 512;
    public static final int FLAG_MANAGED_PROFILE = 32;
    public static final int FLAG_PROFILE = 4096;
    public static final int FLAG_FULL = 1024;
    public static final int FLAG_SYSTEM = 2048;
    private static int maxSupportedUsers = 1;
    private static boolean isMultiUserSupported = false;
    private static boolean isHeadlessSystemUserMode = false;
    private final Object lock = new Object();
    @RealObject
    private UserManager realObject;
    private UserManagerState userManagerState;
    private Boolean managedProfile;
    private Boolean cloneProfile;
    private boolean userUnlocked = true;
    private boolean isSystemUser = true;
    private volatile boolean isForegroundUser = true;
    private String seedAccountName;
    private String seedAccountType;
    private PersistableBundle seedAccountOptions;
    private Context context;
    private boolean enforcePermissions;
    private int userSwitchability = 0;
    private final Set<Account> userAccounts = new HashSet<Account>();

    @Implementation
    protected void __constructor__(Context context, IUserManager service) {
        this.context = context;
        Shadow.invokeConstructor(UserManager.class, (Object)this.realObject, (ReflectionHelpers.ClassParameter[])new ReflectionHelpers.ClassParameter[]{ReflectionHelpers.ClassParameter.from(Context.class, (Object)context), ReflectionHelpers.ClassParameter.from(IUserManager.class, (Object)service)});
        this.userManagerState = ShadowApplication.getInstance().getUserManagerState();
    }

    @Implementation(minSdk=18)
    protected Bundle getApplicationRestrictions(String packageName) {
        Bundle bundle = (Bundle)this.userManagerState.applicationRestrictions.get(packageName);
        return bundle != null ? bundle : new Bundle();
    }

    public void setApplicationRestrictions(String packageName, Bundle restrictions) {
        this.userManagerState.applicationRestrictions.put(packageName, restrictions);
    }

    @Deprecated
    public long addUserProfile(UserHandle userHandle) {
        this.addProfile(UserHandle.myUserId(), userHandle.getIdentifier(), "", 0);
        return (Long)this.userManagerState.userSerialNumbers.get((Object)userHandle.getIdentifier());
    }

    @Implementation(minSdk=21)
    protected List<UserHandle> getUserProfiles() {
        ImmutableList.Builder builder = new ImmutableList.Builder();
        List profiles = (List)this.userManagerState.userProfilesListMap.get(UserHandle.myUserId());
        if (profiles != null) {
            return builder.addAll((Iterable)profiles).build();
        }
        for (List profileList : this.userManagerState.userProfilesListMap.values()) {
            if (!profileList.contains(Process.myUserHandle())) continue;
            return builder.addAll((Iterable)profileList).build();
        }
        return ImmutableList.of((Object)Process.myUserHandle());
    }

    @Implementation(minSdk=21)
    protected List<UserInfo> getProfiles(int userHandle) {
        if (this.userManagerState.userProfilesListMap.containsKey(userHandle)) {
            ArrayList<UserInfo> infos = new ArrayList<UserInfo>();
            for (UserHandle profileHandle : (List)this.userManagerState.userProfilesListMap.get(userHandle)) {
                infos.add((UserInfo)this.userManagerState.userInfoMap.get(profileHandle.getIdentifier()));
            }
            return infos;
        }
        return ((UserManagerReflector)Reflector.reflector(UserManagerReflector.class, (Object)this.realObject)).getProfiles(userHandle);
    }

    @Implementation(minSdk=30)
    protected List<UserHandle> getEnabledProfiles() {
        ArrayList<UserHandle> userHandles = new ArrayList<UserHandle>();
        for (UserHandle profileHandle : this.getAllProfiles()) {
            if (!((UserInfo)this.userManagerState.userInfoMap.get(profileHandle.getIdentifier())).isEnabled()) continue;
            userHandles.add(profileHandle);
        }
        return userHandles;
    }

    @Implementation(minSdk=30)
    protected List<UserHandle> getAllProfiles() {
        ArrayList<UserHandle> userHandles = new ArrayList<UserHandle>();
        if (this.userManagerState.userProfilesListMap.containsKey(this.context.getUserId())) {
            userHandles.addAll((Collection)this.userManagerState.userProfilesListMap.get(this.context.getUserId()));
            return userHandles;
        }
        userHandles.add(UserHandle.of((int)this.context.getUserId()));
        return userHandles;
    }

    @Implementation(minSdk=21)
    protected UserInfo getProfileParent(int userId) {
        if (this.enforcePermissions && !this.hasManageUsersPermission()) {
            throw new SecurityException("Requires MANAGE_USERS permission");
        }
        UserInfo profile = this.getUserInfo(userId);
        if (profile == null) {
            return null;
        }
        int parentUserId = profile.profileGroupId;
        if (parentUserId == userId || parentUserId == -10000) {
            return null;
        }
        return this.getUserInfo(parentUserId);
    }

    @Implementation(minSdk=30)
    protected UserHandle createProfile(String name, String userType, Set<String> disallowedPackages) {
        int flags = ShadowUserManager.getDefaultUserTypeFlags(userType);
        flags |= 0x1000;
        if (this.enforcePermissions && !this.hasManageUsersPermission() && !this.hasCreateUsersPermission()) {
            throw new SecurityException("You either need MANAGE_USERS or CREATE_USERS permission to create an user with flags: " + flags);
        }
        if (this.userManagerState.userInfoMap.size() >= ShadowUserManager.getMaxSupportedUsers()) {
            return null;
        }
        int profileId = this.userManagerState.nextUserId++;
        this.addProfile(this.context.getUserId(), profileId, name, flags);
        ((UserInfo)((UserManagerState)this.userManagerState).userInfoMap.get((Object)Integer.valueOf((int)profileId))).userType = userType;
        return UserHandle.of((int)profileId);
    }

    private static int getDefaultUserTypeFlags(String userType) {
        switch (userType) {
            case "android.os.usertype.profile.MANAGED": {
                return 4128;
            }
            case "android.os.usertype.full.SECONDARY": {
                return 1024;
            }
            case "android.os.usertype.full.GUEST": {
                return 1028;
            }
            case "android.os.usertype.full.DEMO": {
                return 1536;
            }
            case "android.os.usertype.full.RESTRICTED": {
                return 1032;
            }
            case "android.os.usertype.full.SYSTEM": {
                return 3072;
            }
            case "android.os.usertype.system.HEADLESS": {
                return 2048;
            }
        }
        return 0;
    }

    public void addProfile(int userHandle, int profileUserHandle, String profileName, int profileFlags) {
        UserInfo profileUserInfo = new UserInfo(profileUserHandle, profileName, profileFlags);
        this.addProfile(userHandle, profileUserHandle, profileUserInfo);
    }

    public void addProfile(int userHandle, int profileUserHandle, UserInfo profileUserInfo) {
        if (!this.userManagerState.userSerialNumbers.containsKey((Object)profileUserHandle)) {
            this.userManagerState.userSerialNumbers.put((Object)profileUserHandle, (Object)profileUserHandle);
        }
        if (RuntimeEnvironment.getApiLevel() >= 21) {
            profileUserInfo.profileGroupId = userHandle;
            UserInfo parentUserInfo = this.getUserInfo(userHandle);
            if (parentUserInfo != null) {
                parentUserInfo.profileGroupId = userHandle;
            }
        }
        this.userManagerState.userInfoMap.put(profileUserHandle, profileUserInfo);
        this.userManagerState.userProfilesListMap.putIfAbsent(userHandle, new ArrayList());
        List list = (List)this.userManagerState.userProfilesListMap.get(userHandle);
        UserHandle handle = new UserHandle(profileUserHandle);
        if (!list.contains(handle)) {
            list.add(handle);
        }
    }

    public void setUserUnlocked(boolean userUnlocked) {
        this.userUnlocked = userUnlocked;
    }

    @Implementation(minSdk=24)
    protected boolean isUserUnlocked() {
        return this.userUnlocked;
    }

    @Implementation(minSdk=24)
    protected boolean isUserUnlocked(UserHandle handle) {
        this.checkPermissions();
        UserState state = (UserState)((Object)this.userManagerState.userState.get(handle.getIdentifier()));
        return state == UserState.STATE_RUNNING_UNLOCKED;
    }

    @Implementation(minSdk=21)
    protected boolean isManagedProfile() {
        if (this.enforcePermissions && !this.hasManageUsersPermission()) {
            throw new SecurityException("You need MANAGE_USERS permission to: check if specified user a managed profile outside your profile group");
        }
        if (this.managedProfile != null) {
            return this.managedProfile;
        }
        if (RuntimeEnvironment.getApiLevel() >= 30) {
            return this.isManagedProfile(this.context.getUserId());
        }
        return false;
    }

    @Implementation(minSdk=24)
    protected boolean isManagedProfile(int userHandle) {
        if (this.enforcePermissions && !this.hasManageUsersPermission()) {
            throw new SecurityException("You need MANAGE_USERS permission to: check if specified user a managed profile outside your profile group");
        }
        UserInfo info = this.getUserInfo(userHandle);
        return info != null && (info.flags & 0x20) == 32;
    }

    public void enforcePermissionChecks(boolean enforcePermissions) {
        this.enforcePermissions = enforcePermissions;
    }

    public void setManagedProfile(boolean managedProfile) {
        this.managedProfile = managedProfile;
    }

    @Implementation(minSdk=31)
    protected boolean isCloneProfile() {
        if (this.enforcePermissions && !this.hasManageUsersPermission()) {
            throw new SecurityException("You need MANAGE_USERS permission to: check isCloneProfile");
        }
        if (this.cloneProfile != null) {
            return this.cloneProfile;
        }
        UserInfo info = this.getUserInfo(this.context.getUserId());
        return info != null && info.isCloneProfile();
    }

    public void setCloneProfile(boolean cloneProfile) {
        this.cloneProfile = cloneProfile;
    }

    @Implementation(minSdk=30)
    protected boolean isProfile() {
        if (this.enforcePermissions && !this.hasManageUsersPermission()) {
            throw new SecurityException("You need INTERACT_ACROSS_USERS or MANAGE_USERS permission to: check isProfile");
        }
        return this.getUserInfo(this.context.getUserId()).isProfile();
    }

    @Implementation(minSdk=30)
    protected boolean isUserOfType(String userType) {
        if (this.enforcePermissions && !this.hasManageUsersPermission()) {
            throw new SecurityException("You need MANAGE_USERS permission to: check user type");
        }
        UserInfo info = this.getUserInfo(this.context.getUserId());
        return info != null && info.userType != null && info.userType.equals(userType);
    }

    @Implementation(minSdk=30)
    protected boolean isSameProfileGroup(UserHandle user, UserHandle otherUser) {
        if (this.enforcePermissions && !this.hasManageUsersPermission()) {
            throw new SecurityException("You need MANAGE_USERS permission to: check if in the same profile group");
        }
        UserInfo userInfo = (UserInfo)this.userManagerState.userInfoMap.get(user.getIdentifier());
        UserInfo otherUserInfo = (UserInfo)this.userManagerState.userInfoMap.get(otherUser.getIdentifier());
        if (userInfo == null || otherUserInfo == null || userInfo.profileGroupId == -10000 || otherUserInfo.profileGroupId == -10000) {
            return false;
        }
        return userInfo.profileGroupId == otherUserInfo.profileGroupId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Implementation(minSdk=21)
    protected boolean hasUserRestriction(String restrictionKey, UserHandle userHandle) {
        Object object = this.lock;
        synchronized (object) {
            Bundle bundle = (Bundle)this.userManagerState.userRestrictions.get(userHandle.getIdentifier());
            return bundle != null && bundle.getBoolean(restrictionKey);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Implementation(minSdk=18)
    protected void setUserRestriction(String key, boolean value, UserHandle userHandle) {
        Bundle bundle = this.getUserRestrictionsForUser(userHandle);
        Object object = this.lock;
        synchronized (object) {
            bundle.putBoolean(key, value);
        }
    }

    @Implementation(minSdk=18)
    protected void setUserRestriction(String key, boolean value) {
        this.setUserRestriction(key, value, Process.myUserHandle());
    }

    @Deprecated
    public void setUserRestriction(UserHandle userHandle, String restrictionKey, boolean value) {
        this.setUserRestriction(restrictionKey, value, userHandle);
    }

    public void clearUserRestrictions(UserHandle userHandle) {
        this.userManagerState.userRestrictions.remove(userHandle.getIdentifier());
    }

    @Implementation(minSdk=18)
    protected Bundle getUserRestrictions(UserHandle userHandle) {
        return new Bundle(this.getUserRestrictionsForUser(userHandle));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Bundle getUserRestrictionsForUser(UserHandle userHandle) {
        Object object = this.lock;
        synchronized (object) {
            Bundle bundle = (Bundle)this.userManagerState.userRestrictions.get(userHandle.getIdentifier());
            if (bundle == null) {
                bundle = new Bundle();
                this.userManagerState.userRestrictions.put(userHandle.getIdentifier(), bundle);
            }
            return bundle;
        }
    }

    @Implementation
    protected long getSerialNumberForUser(UserHandle userHandle) {
        Long result = (Long)this.userManagerState.userSerialNumbers.get((Object)userHandle.getIdentifier());
        return result == null ? -1L : result;
    }

    public void setSerialNumberForUser(UserHandle userHandle, long serialNumber) {
        this.userManagerState.userSerialNumbers.put((Object)userHandle.getIdentifier(), (Object)serialNumber);
    }

    @Implementation
    protected UserHandle getUserForSerialNumber(long serialNumber) {
        Integer userHandle = (Integer)this.userManagerState.userSerialNumbers.inverse().get((Object)serialNumber);
        return userHandle == null ? null : new UserHandle(userHandle.intValue());
    }

    @Implementation
    protected int getUserSerialNumber(int userHandle) {
        Long result = (Long)this.userManagerState.userSerialNumbers.get((Object)userHandle);
        return result != null ? result.intValue() : -1;
    }

    private String getUserName(int userHandle) {
        UserInfo user = this.getUserInfo(userHandle);
        return user == null ? "" : user.name;
    }

    @Implementation(minSdk=29)
    protected String getUserName() {
        if (RuntimeEnvironment.getApiLevel() >= 30) {
            return this.getUserName(this.context.getUserId());
        }
        return this.getUserName(UserHandle.myUserId());
    }

    @Implementation(minSdk=30)
    protected void setUserName(String name) {
        if (this.enforcePermissions && !this.hasManageUsersPermission()) {
            throw new SecurityException("You need MANAGE_USERS permission to: rename users");
        }
        UserInfo user = this.getUserInfo(this.context.getUserId());
        user.name = name;
    }

    @Implementation(minSdk=29)
    protected Bitmap getUserIcon() {
        if (this.enforcePermissions && !this.hasManageUsersPermission() && !this.hasGetAccountsPrivilegedPermission()) {
            throw new SecurityException("You need MANAGE_USERS or GET_ACCOUNTS_PRIVILEGED permissions to: get user icon");
        }
        int userId = UserHandle.myUserId();
        if (RuntimeEnvironment.getApiLevel() >= 30) {
            userId = this.context.getUserId();
        }
        return (Bitmap)this.userManagerState.userIcon.get(userId);
    }

    @Implementation(minSdk=29)
    protected void setUserIcon(Bitmap icon) {
        if (this.enforcePermissions && !this.hasManageUsersPermission()) {
            throw new SecurityException("You need MANAGE_USERS permission to: update users");
        }
        int userId = UserHandle.myUserId();
        if (RuntimeEnvironment.getApiLevel() >= 30) {
            userId = this.context.getUserId();
        }
        this.userManagerState.userIcon.put(userId, icon);
    }

    @HiddenApi
    @Implementation(minSdk=17)
    protected int getUserHandle(int serialNumber) {
        Integer userHandle = (Integer)this.userManagerState.userSerialNumbers.inverse().get((Object)serialNumber);
        return userHandle == null ? -1 : userHandle;
    }

    @HiddenApi
    @Implementation(minSdk=30)
    protected List<UserHandle> getUserHandles(boolean excludeDying) {
        ArrayList<UserHandle> userHandles = new ArrayList<UserHandle>();
        Iterator iterator = this.userManagerState.userSerialNumbers.keySet().iterator();
        while (iterator.hasNext()) {
            int id2 = (Integer)iterator.next();
            userHandles.addAll((Collection)this.userManagerState.userProfilesListMap.get(id2));
        }
        return userHandles;
    }

    @HiddenApi
    @Implementation(minSdk=17)
    protected static int getMaxSupportedUsers() {
        return maxSupportedUsers;
    }

    public void setMaxSupportedUsers(int maxSupportedUsers) {
        ShadowUserManager.maxSupportedUsers = maxSupportedUsers;
    }

    private boolean hasManageUsersPermission() {
        return this.context.getPackageManager().checkPermission("android.permission.MANAGE_USERS", this.context.getPackageName()) == 0;
    }

    private boolean hasCreateUsersPermission() {
        return this.context.getPackageManager().checkPermission("android.permission.CREATE_USERS", this.context.getPackageName()) == 0;
    }

    private boolean hasModifyQuietModePermission() {
        return this.context.getPackageManager().checkPermission("android.permission.MODIFY_QUIET_MODE", this.context.getPackageName()) == 0;
    }

    private boolean hasGetAccountsPrivilegedPermission() {
        return this.context.getPackageManager().checkPermission("android.permission.GET_ACCOUNTS_PRIVILEGED", this.context.getPackageName()) == 0;
    }

    private void checkPermissions() {
    }

    @Implementation(minSdk=25)
    protected boolean isDemoUser() {
        return this.getUserInfo(UserHandle.myUserId()).isDemo();
    }

    @Deprecated
    public void setIsDemoUser(boolean isDemoUser) {
        UserInfo userInfo = this.getUserInfo(UserHandle.myUserId());
        userInfo.flags = isDemoUser ? (userInfo.flags |= 0x200) : (userInfo.flags &= 0xFFFFFDFF);
    }

    @Implementation(minSdk=23)
    protected boolean isSystemUser() {
        if (!this.isSystemUser) {
            return false;
        }
        return ((UserManagerReflector)Reflector.reflector(UserManagerReflector.class, (Object)this.realObject)).isSystemUser();
    }

    @Deprecated
    public void setIsSystemUser(boolean isSystemUser) {
        this.isSystemUser = isSystemUser;
    }

    @Deprecated
    public void setIsPrimaryUser(boolean isPrimaryUser) {
        UserInfo userInfo = this.getUserInfo(UserHandle.myUserId());
        userInfo.flags = isPrimaryUser ? (userInfo.flags |= 1) : (userInfo.flags &= 0xFFFFFFFE);
    }

    @Implementation(minSdk=18)
    protected boolean isLinkedUser() {
        return this.isRestrictedProfile();
    }

    @Deprecated
    public void setIsLinkedUser(boolean isLinkedUser) {
        this.setIsRestrictedProfile(isLinkedUser);
    }

    @Implementation(minSdk=28)
    protected boolean isRestrictedProfile() {
        return this.getUserInfo(UserHandle.myUserId()).isRestricted();
    }

    @Deprecated
    public void setIsRestrictedProfile(boolean isRestrictedProfile) {
        if (RuntimeEnvironment.getApiLevel() >= 30) {
            this.setUserType(isRestrictedProfile ? "android.os.usertype.full.RESTRICTED" : "android.os.usertype.full.SECONDARY");
            return;
        }
        UserInfo userInfo = this.getUserInfo(UserHandle.myUserId());
        userInfo.flags = isRestrictedProfile ? (userInfo.flags |= 8) : (userInfo.flags &= 0xFFFFFFF7);
    }

    @Deprecated
    public void setIsGuestUser(boolean isGuestUser) {
        if (RuntimeEnvironment.getApiLevel() >= 30) {
            this.setUserType(isGuestUser ? "android.os.usertype.full.GUEST" : "android.os.usertype.full.SECONDARY");
            return;
        }
        UserInfo userInfo = this.getUserInfo(UserHandle.myUserId());
        userInfo.flags = isGuestUser ? (userInfo.flags |= 4) : (userInfo.flags &= 0xFFFFFFFB);
    }

    public void setIsUserEnabled(int userId, boolean enabled) {
        UserInfo userInfo = this.getUserInfo(userId);
        userInfo.flags = enabled ? (userInfo.flags &= 0xFFFFFFBF) : (userInfo.flags |= 0x40);
    }

    @Implementation
    protected boolean isUserRunning(UserHandle handle) {
        this.checkPermissions();
        UserState state = (UserState)((Object)this.userManagerState.userState.get(handle.getIdentifier()));
        return state == UserState.STATE_RUNNING_LOCKED || state == UserState.STATE_RUNNING_UNLOCKED || state == UserState.STATE_RUNNING_UNLOCKING;
    }

    @Implementation
    protected boolean isUserRunningOrStopping(UserHandle handle) {
        this.checkPermissions();
        UserState state = (UserState)((Object)this.userManagerState.userState.get(handle.getIdentifier()));
        return state == UserState.STATE_RUNNING_LOCKED || state == UserState.STATE_RUNNING_UNLOCKED || state == UserState.STATE_RUNNING_UNLOCKING || state == UserState.STATE_STOPPING;
    }

    @Implementation(minSdk=30)
    protected boolean isUserUnlockingOrUnlocked(UserHandle handle) {
        this.checkPermissions();
        UserState state = (UserState)((Object)this.userManagerState.userState.get(handle.getIdentifier()));
        return state == UserState.STATE_RUNNING_UNLOCKING || state == UserState.STATE_RUNNING_UNLOCKED;
    }

    public void setUserState(UserHandle handle, UserState state) {
        this.userManagerState.userState.put(handle.getIdentifier(), state);
    }

    @Implementation(minSdk=24)
    protected boolean isQuietModeEnabled(UserHandle userHandle) {
        if (!this.isManagedProfileWithoutPermission(userHandle)) {
            return false;
        }
        UserInfo info = this.getUserInfo(userHandle.getIdentifier());
        return (info.flags & 0x80) == 128;
    }

    @Implementation(minSdk=29)
    protected boolean requestQuietModeEnabled(boolean enableQuietMode, UserHandle userHandle) {
        if (this.enforcePermissions && !this.hasManageUsersPermission() && !this.hasModifyQuietModePermission()) {
            throw new SecurityException("Requires MANAGE_USERS or MODIFY_QUIET_MODE permission");
        }
        Preconditions.checkArgument((boolean)this.isManagedProfileWithoutPermission(userHandle));
        int userProfileHandle = userHandle.getIdentifier();
        UserInfo info = this.getUserInfo(userHandle.getIdentifier());
        if (enableQuietMode) {
            this.userManagerState.userState.put(userProfileHandle, UserState.STATE_SHUTDOWN);
            info.flags |= 0x80;
        } else {
            if (this.userManagerState.profileIsLocked.getOrDefault(userProfileHandle, false).booleanValue()) {
                return false;
            }
            this.userManagerState.userState.put(userProfileHandle, UserState.STATE_RUNNING_UNLOCKED);
            info.flags &= 0xFFFFFF7F;
        }
        if (enableQuietMode) {
            this.sendQuietModeBroadcast("android.intent.action.MANAGED_PROFILE_UNAVAILABLE", userHandle);
        } else {
            this.sendQuietModeBroadcast("android.intent.action.MANAGED_PROFILE_AVAILABLE", userHandle);
            this.sendQuietModeBroadcast("android.intent.action.MANAGED_PROFILE_UNLOCKED", userHandle);
        }
        return true;
    }

    protected void sendQuietModeBroadcast(String action, UserHandle profileHandle) {
        Intent intent = new Intent(action);
        intent.putExtra("android.intent.extra.USER", (Parcelable)profileHandle);
        intent.setFlags(0x50000000);
        this.context.sendBroadcast(intent);
    }

    private boolean isManagedProfileWithoutPermission(UserHandle userHandle) {
        UserInfo info = this.getUserInfo(userHandle.getIdentifier());
        return info != null && (info.flags & 0x20) == 32;
    }

    public void setProfileIsLocked(UserHandle profileHandle, boolean isLocked) {
        this.userManagerState.profileIsLocked.put(profileHandle.getIdentifier(), isLocked);
    }

    @Implementation(minSdk=24)
    protected long[] getSerialNumbersOfUsers(boolean excludeDying) {
        return this.getUsers().stream().map(userInfo -> this.getUserSerialNumber(userInfo.getUserHandle().getIdentifier())).mapToLong(l -> l.intValue()).toArray();
    }

    @Implementation
    protected List<UserInfo> getUsers() {
        return new ArrayList<UserInfo>(this.userManagerState.userInfoMap.values());
    }

    @Implementation
    protected UserInfo getUserInfo(int userHandle) {
        return (UserInfo)this.userManagerState.userInfoMap.get(userHandle);
    }

    @Deprecated
    public void setCanSwitchUser(boolean canSwitchUser) {
        this.setUserSwitchability(canSwitchUser ? 0 : 2);
    }

    @Implementation(minSdk=24)
    protected String getSeedAccountName() {
        return this.seedAccountName;
    }

    public void setSeedAccountName(String seedAccountName) {
        this.seedAccountName = seedAccountName;
    }

    @Implementation(minSdk=24)
    protected String getSeedAccountType() {
        return this.seedAccountType;
    }

    public void setSeedAccountType(String seedAccountType) {
        this.seedAccountType = seedAccountType;
    }

    @Implementation(minSdk=24)
    protected PersistableBundle getSeedAccountOptions() {
        return this.seedAccountOptions;
    }

    public void setSeedAccountOptions(PersistableBundle seedAccountOptions) {
        this.seedAccountOptions = seedAccountOptions;
    }

    @Implementation(minSdk=24)
    protected void clearSeedAccountData() {
        this.seedAccountName = null;
        this.seedAccountType = null;
        this.seedAccountOptions = null;
    }

    @Implementation(minSdk=17)
    protected boolean removeUser(int userHandle) {
        List list;
        if (!this.userManagerState.userInfoMap.containsKey(userHandle)) {
            return false;
        }
        this.userManagerState.userInfoMap.remove(userHandle);
        this.userManagerState.userPidMap.remove(userHandle);
        this.userManagerState.userSerialNumbers.remove((Object)userHandle);
        this.userManagerState.userState.remove(userHandle);
        this.userManagerState.userRestrictions.remove(userHandle);
        this.userManagerState.profileIsLocked.remove(userHandle);
        this.userManagerState.userIcon.remove(userHandle);
        this.userManagerState.userProfilesListMap.remove(userHandle);
        UserHandle profileHandle = new UserHandle(userHandle);
        Iterator iterator = this.userManagerState.userProfilesListMap.values().iterator();
        while (iterator.hasNext() && !(list = (List)iterator.next()).remove(profileHandle)) {
        }
        return true;
    }

    @Implementation(minSdk=29)
    protected boolean removeUser(UserHandle user) {
        return this.removeUser(user.getIdentifier());
    }

    @Implementation(minSdk=33)
    protected int removeUserWhenPossible(UserHandle user, boolean overrideDevicePolicy) {
        return this.removeUser(user.getIdentifier()) ? 0 : -1;
    }

    @Implementation(minSdk=24)
    protected static boolean supportsMultipleUsers() {
        return isMultiUserSupported;
    }

    public void setSupportsMultipleUsers(boolean isMultiUserSupported) {
        ShadowUserManager.isMultiUserSupported = isMultiUserSupported;
    }

    public void switchUser(int userId) {
        if (!this.userManagerState.userInfoMap.containsKey(userId)) {
            throw new UnsupportedOperationException("Must add user before switching to it");
        }
        ShadowProcess.setUid((Integer)this.userManagerState.userPidMap.get(userId));
        Application application = (Application)this.context.getApplicationContext();
        ShadowContextImpl shadowContext = (ShadowContextImpl)Shadow.extract((Object)application.getBaseContext());
        shadowContext.setUserId(userId);
        if (RuntimeEnvironment.getApiLevel() >= 30) {
            ((UserManagerReflector)Reflector.reflector(UserManagerReflector.class, (Object)this.realObject)).setUserId(userId);
        }
    }

    public UserHandle addUser(int id2, String name, int flags) {
        UserHandle userHandle;
        UserHandle userHandle2 = userHandle = id2 == 0 ? Process.myUserHandle() : new UserHandle(id2);
        if (!this.userManagerState.userSerialNumbers.containsKey((Object)id2)) {
            this.userManagerState.userSerialNumbers.put((Object)id2, (Object)id2);
        }
        this.userManagerState.userState.put(id2, UserState.STATE_SHUTDOWN);
        this.userManagerState.userInfoMap.put(id2, new UserInfo(id2, name, flags));
        if (!this.userManagerState.userProfilesListMap.containsKey(id2)) {
            this.userManagerState.userProfilesListMap.put(id2, new ArrayList());
            ((List)this.userManagerState.userProfilesListMap.get(id2)).add(new UserHandle(id2));
            this.userManagerState.userPidMap.put(id2, id2 == 0 ? Process.myUid() : id2 * 100000 + ShadowProcess.getRandomApplicationUid());
        }
        return userHandle;
    }

    @Implementation(minSdk=24, maxSdk=29)
    protected boolean canSwitchUsers() {
        return this.getUserSwitchability() == 0;
    }

    @Implementation(minSdk=29)
    protected int getUserSwitchability() {
        return this.userSwitchability;
    }

    public void setUserSwitchability(int switchability) {
        this.userSwitchability = switchability;
    }

    @Implementation(minSdk=30)
    protected boolean hasUserRestrictionForUser(String restrictionKey, UserHandle userHandle) {
        return this.hasUserRestriction(restrictionKey, userHandle);
    }

    private void setUserType(String userType) {
        UserInfo userInfo = this.getUserInfo(UserHandle.myUserId());
        userInfo.userType = userType;
    }

    @Implementation(minSdk=30)
    protected boolean requestQuietModeEnabled(boolean enableQuietMode, UserHandle userHandle, int flags) {
        return this.requestQuietModeEnabled(enableQuietMode, userHandle);
    }

    @Implementation(minSdk=31)
    protected static boolean isHeadlessSystemUserMode() {
        return isHeadlessSystemUserMode;
    }

    public static void setHeadlessSystemUserMode(boolean isEnabled) {
        isHeadlessSystemUserMode = isEnabled;
    }

    @Implementation(minSdk=33)
    protected Bundle getUserRestrictions() {
        return this.getUserRestrictions(UserHandle.getUserHandleForUid((int)Process.myUid()));
    }

    @Implementation(minSdk=33)
    protected boolean hasUserRestrictionForUser(String restrictionKey, int userId) {
        Bundle bundle = this.getUserRestrictions(UserHandle.getUserHandleForUid((int)userId));
        return bundle != null && bundle.getBoolean(restrictionKey);
    }

    @Resetter
    public static void reset() {
        maxSupportedUsers = 1;
        isMultiUserSupported = false;
        isHeadlessSystemUserMode = false;
    }

    @Implementation(minSdk=33)
    protected boolean someUserHasAccount(String accountName, String accountType) {
        return this.userAccounts.contains(new Account(accountName, accountType));
    }

    public void setSomeUserHasAccount(String accountName, String accountType) {
        this.userAccounts.add(new Account(accountName, accountType));
    }

    public void removeSomeUserHasAccount(String accountName, String accountType) {
        this.userAccounts.remove(new Account(accountName, accountType));
    }

    public void setUserForeground(boolean foreground) {
        this.isForegroundUser = foreground;
    }

    @Implementation(minSdk=31)
    protected boolean isUserForeground() {
        return this.isForegroundUser;
    }

    static class UserManagerState {
        private final Map<Integer, Integer> userPidMap = new HashMap<Integer, Integer>();
        private final BiMap<Integer, Long> userSerialNumbers = HashBiMap.create();
        private final Map<Integer, UserState> userState = new HashMap<Integer, UserState>();
        private final Map<Integer, UserInfo> userInfoMap = new HashMap<Integer, UserInfo>();
        private final Map<Integer, List<UserHandle>> userProfilesListMap = new HashMap<Integer, List<UserHandle>>();
        private final Map<Integer, Bundle> userRestrictions = new HashMap<Integer, Bundle>();
        private final Map<String, Bundle> applicationRestrictions = new HashMap<String, Bundle>();
        private final Map<Integer, Boolean> profileIsLocked = new HashMap<Integer, Boolean>();
        private final Map<Integer, Bitmap> userIcon = new HashMap<Integer, Bitmap>();
        private int nextUserId = 10;
        private static final int FLAG_MAIN = 16384;

        public UserManagerState() {
            int id2 = 0;
            String name = "system_user";
            int flags = 16387;
            this.userSerialNumbers.put((Object)id2, (Object)id2);
            this.userState.put(id2, UserState.STATE_SHUTDOWN);
            this.userInfoMap.put(id2, new UserInfo(id2, name, flags));
            this.userProfilesListMap.put(id2, new ArrayList());
            this.userProfilesListMap.get(id2).add(new UserHandle(id2));
            this.userPidMap.put(id2, Process.myUid());
        }
    }

    @ForType(value=UserManager.class)
    static interface UserManagerReflector {
        @Direct
        public List getProfiles(int var1);

        @Direct
        public boolean isSystemUser();

        @Accessor(value="mUserId")
        public void setUserId(int var1);
    }

    public static enum UserState {
        STATE_BOOTING,
        STATE_RUNNING_LOCKED,
        STATE_RUNNING_UNLOCKING,
        STATE_RUNNING_UNLOCKED,
        STATE_STOPPING,
        STATE_SHUTDOWN;

    }
}

