/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.shadows;

import android.annotation.TargetApi;
import android.media.MediaCodecInfo;
import android.media.MediaCodecList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.robolectric.annotation.Implementation;
import org.robolectric.annotation.Implements;
import org.robolectric.annotation.Resetter;
import org.robolectric.util.ReflectionHelpers;

@Implements(value=MediaCodecList.class, minSdk=21)
public class ShadowMediaCodecList {
    private static final List<MediaCodecInfo> mediaCodecInfos = Collections.synchronizedList(new ArrayList());

    @TargetApi(value=29)
    public static void addCodec(MediaCodecInfo mediaCodecInfo) {
        mediaCodecInfos.add(mediaCodecInfo);
    }

    @Resetter
    public static void reset() {
        mediaCodecInfos.clear();
        ReflectionHelpers.setStaticField(MediaCodecList.class, (String)"sAllCodecInfos", null);
        ReflectionHelpers.setStaticField(MediaCodecList.class, (String)"sRegularCodecInfos", null);
    }

    @Implementation
    protected static int native_getCodecCount() {
        return mediaCodecInfos.size();
    }

    @Implementation
    protected static MediaCodecInfo getNewCodecInfoAt(int index) {
        return mediaCodecInfos.get(index);
    }

    @Implementation(minSdk=23)
    protected static Map<String, Object> native_getGlobalSettings() {
        return new HashMap<String, Object>();
    }
}

