/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.shadows;

import android.annotation.RequiresPermission;
import android.annotation.SystemApi;
import java.util.HashMap;
import java.util.Map;
import org.robolectric.annotation.Implementation;
import org.robolectric.annotation.Implements;

@Implements(className="android.hardware.display.ColorDisplayManager", isInAndroidSdk=false, minSdk=29)
public class ShadowColorDisplayManager {
    private boolean isNightDisplayActivated;
    private int nightDisplayTemperature;
    private int nightDisplayAutoMode;
    private final Map<String, Integer> packagesToSaturation = new HashMap<String, Integer>();
    private int saturationLevel = 100;
    private int transformCapabilities = 0;

    @Implementation
    protected void __constructor__() {
    }

    @Implementation
    @SystemApi
    @RequiresPermission(value="android.permission.CONTROL_DISPLAY_COLOR_TRANSFORMS")
    protected int getTransformCapabilities() {
        return this.transformCapabilities;
    }

    @Implementation
    @SystemApi
    @RequiresPermission(value="android.permission.CONTROL_DISPLAY_COLOR_TRANSFORMS")
    protected boolean setNightDisplayActivated(boolean activated) {
        this.isNightDisplayActivated = activated;
        return true;
    }

    @Implementation
    @SystemApi
    @RequiresPermission(value="android.permission.CONTROL_DISPLAY_COLOR_TRANSFORMS")
    protected boolean isNightDisplayActivated() {
        return this.isNightDisplayActivated;
    }

    @Implementation
    @SystemApi
    @RequiresPermission(value="android.permission.CONTROL_DISPLAY_COLOR_TRANSFORMS")
    protected boolean setNightDisplayColorTemperature(int temperature) {
        this.nightDisplayTemperature = temperature;
        return true;
    }

    @Implementation
    @SystemApi
    @RequiresPermission(value="android.permission.CONTROL_DISPLAY_COLOR_TRANSFORMS")
    protected int getNightDisplayColorTemperature() {
        return this.nightDisplayTemperature;
    }

    @Implementation
    @SystemApi
    @RequiresPermission(value="android.permission.CONTROL_DISPLAY_COLOR_TRANSFORMS")
    protected boolean setNightDisplayAutoMode(int autoMode) {
        this.nightDisplayAutoMode = autoMode;
        return true;
    }

    @Implementation
    @SystemApi
    @RequiresPermission(value="android.permission.CONTROL_DISPLAY_COLOR_TRANSFORMS")
    protected int getNightDisplayAutoMode() {
        return this.nightDisplayAutoMode;
    }

    @Implementation
    @SystemApi
    @RequiresPermission(value="android.permission.CONTROL_DISPLAY_COLOR_TRANSFORMS")
    protected boolean setSaturationLevel(int saturationLevel) {
        this.saturationLevel = saturationLevel;
        return true;
    }

    @Implementation
    @SystemApi
    @RequiresPermission(value="android.permission.CONTROL_DISPLAY_COLOR_TRANSFORMS")
    protected boolean setAppSaturationLevel(String packageName, int saturationLevel) {
        this.packagesToSaturation.put(packageName, saturationLevel);
        return true;
    }

    public boolean setTransformCapabilities(int transformCapabilities) {
        this.transformCapabilities = transformCapabilities;
        return true;
    }

    public int getAppSaturationLevel(String packageName) {
        return this.packagesToSaturation.getOrDefault(packageName, 100);
    }

    public int getSaturationLevel() {
        return this.saturationLevel;
    }
}

