/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.shadows;

import android.app.backup.BackupDataInput;
import com.google.common.collect.ImmutableList;
import java.io.FileDescriptor;
import java.util.ArrayList;
import java.util.List;
import org.robolectric.annotation.Implementation;
import org.robolectric.annotation.Implements;
import org.robolectric.shadows.BackupDataEntity;
import org.robolectric.util.reflector.Accessor;
import org.robolectric.util.reflector.ForType;
import org.robolectric.util.reflector.Reflector;

@Implements(value=BackupDataInput.class, minSdk=21, looseSignatures=true)
public class ShadowBackupDataInput {
    private List<BackupDataEntity> entities = new ArrayList<BackupDataEntity>();
    private int currentEntityIndex = -1;
    private int currentBytesRead = 0;
    private int currentBytesToRead = 0;

    void setEntities(ImmutableList<BackupDataEntity> entities) {
        this.entities = entities;
    }

    @Implementation
    protected static long ctor(FileDescriptor fd) {
        return 1L;
    }

    @Implementation
    protected int readNextHeader_native(Object backupReader, Object entity) {
        if (this.currentBytesRead < this.currentBytesToRead) {
            return -1;
        }
        ++this.currentEntityIndex;
        if (this.currentEntityIndex >= this.entities.size()) {
            return 1;
        }
        BackupDataEntity shadowEntity = this.entities.get(this.currentEntityIndex);
        this.currentBytesRead = 0;
        this.currentBytesToRead = shadowEntity.dataSize();
        ((EntityHeaderReflector)Reflector.reflector(EntityHeaderReflector.class, (Object)entity)).setKey(shadowEntity.key());
        ((EntityHeaderReflector)Reflector.reflector(EntityHeaderReflector.class, (Object)entity)).setDataSize(shadowEntity.dataSize());
        return 0;
    }

    @Implementation
    protected int readEntityData_native(long backupReader, byte[] data, int offset, int size) {
        if (this.currentEntityIndex >= this.entities.size() || this.currentBytesRead >= this.currentBytesToRead) {
            return 0;
        }
        if (offset + size > data.length) {
            return -1;
        }
        byte[] shadowData = this.entities.get(this.currentEntityIndex).data();
        int remainingBytes = this.currentBytesToRead - this.currentBytesRead;
        int bytesToRead = Math.min(size, remainingBytes);
        System.arraycopy(shadowData, this.currentBytesRead, data, offset, bytesToRead);
        this.currentBytesRead += bytesToRead;
        return bytesToRead;
    }

    @Implementation
    protected int skipEntityData_native(long backupReader) {
        if (this.currentEntityIndex < this.entities.size()) {
            this.currentBytesRead = this.entities.get(this.currentEntityIndex).dataSize();
        }
        return 0;
    }

    @ForType(className="android.app.backup.BackupDataInput$EntityHeader")
    private static interface EntityHeaderReflector {
        @Accessor(value="key")
        public void setKey(String var1);

        @Accessor(value="dataSize")
        public void setDataSize(int var1);
    }
}

