/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.shadows;

import android.app.Dialog;
import android.content.Intent;
import android.os.Binder;
import android.os.Bundle;
import android.os.IBinder;
import android.service.voice.VoiceInteractionSession;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import org.robolectric.annotation.Implements;
import org.robolectric.annotation.RealObject;
import org.robolectric.util.ReflectionHelpers;

@Implements(value=VoiceInteractionSession.class, minSdk=21)
public class ShadowVoiceInteractionSession {
    private final List<Intent> assistantActivityIntents = new ArrayList<Intent>();
    private final List<Intent> voiceActivityIntents = new ArrayList<Intent>();
    private boolean isFinishing;
    @Nullable
    private RuntimeException startVoiceActivityException;
    @RealObject
    private VoiceInteractionSession realSession;

    public void create() {
        try {
            Class<?> serviceClass = Class.forName("com.android.internal.app.IVoiceInteractionManagerService");
            Object service = ReflectionHelpers.createDelegatingProxy(serviceClass, (Object)new FakeVoiceInteractionManagerService());
            Binder token = new Binder();
            ReflectionHelpers.callInstanceMethod((Object)this.realSession, (String)"doCreate", (ReflectionHelpers.ClassParameter[])new ReflectionHelpers.ClassParameter[]{ReflectionHelpers.ClassParameter.from(serviceClass, (Object)service), ReflectionHelpers.ClassParameter.from(IBinder.class, (Object)token)});
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    @Nullable
    public Intent getLastAssistantActivityIntent() {
        return (Intent)Iterables.getLast(this.assistantActivityIntents, null);
    }

    public ImmutableList<Intent> getAssistantActivityIntents() {
        return ImmutableList.copyOf(this.assistantActivityIntents);
    }

    @Nullable
    public Intent getLastVoiceActivityIntent() {
        return (Intent)Iterables.getLast(this.voiceActivityIntents, null);
    }

    public ImmutableList<Intent> getVoiceActivityIntents() {
        return ImmutableList.copyOf(this.voiceActivityIntents);
    }

    public boolean isWindowVisible() {
        return (Boolean)ReflectionHelpers.getField((Object)this.realSession, (String)"mWindowVisible");
    }

    public boolean isWindowShowing() {
        Dialog window = (Dialog)ReflectionHelpers.getField((Object)this.realSession, (String)"mWindow");
        return this.isWindowVisible() && window != null && window.isShowing();
    }

    public boolean isUiEnabled() {
        return (Boolean)ReflectionHelpers.getField((Object)this.realSession, (String)"mUiEnabled");
    }

    public boolean isFinishing() {
        return this.isFinishing;
    }

    public void setStartVoiceActivityException(RuntimeException exception) {
        this.startVoiceActivityException = exception;
    }

    private class FakeVoiceInteractionManagerService {
        private FakeVoiceInteractionManagerService() {
        }

        public boolean showSessionFromSession(IBinder token, Bundle args, int flags) {
            try {
                Class<?> callbackClass = Class.forName("com.android.internal.app.IVoiceInteractionSessionShowCallback");
                Object callback = ReflectionHelpers.createDeepProxy(callbackClass);
                ReflectionHelpers.callInstanceMethod((Object)ShadowVoiceInteractionSession.this.realSession, (String)"doShow", (ReflectionHelpers.ClassParameter[])new ReflectionHelpers.ClassParameter[]{ReflectionHelpers.ClassParameter.from(Bundle.class, (Object)args), ReflectionHelpers.ClassParameter.from(Integer.TYPE, (Object)flags), ReflectionHelpers.ClassParameter.from(callbackClass, (Object)callback)});
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException(e);
            }
            return true;
        }

        public boolean hideSessionFromSession(IBinder token) {
            ReflectionHelpers.callInstanceMethod((Object)ShadowVoiceInteractionSession.this.realSession, (String)"doHide", (ReflectionHelpers.ClassParameter[])new ReflectionHelpers.ClassParameter[0]);
            return true;
        }

        public int startVoiceActivity(IBinder token, Intent intent, String resolvedType) {
            RuntimeException exception = ShadowVoiceInteractionSession.this.startVoiceActivityException;
            if (exception != null) {
                throw exception;
            }
            ShadowVoiceInteractionSession.this.voiceActivityIntents.add(intent);
            return 0;
        }

        public int startAssistantActivity(IBinder token, Intent intent, String resolvedType) {
            ShadowVoiceInteractionSession.this.assistantActivityIntents.add(intent);
            return 0;
        }

        public void finish(IBinder token) {
            ReflectionHelpers.callInstanceMethod((Object)ShadowVoiceInteractionSession.this.realSession, (String)"doDestroy", (ReflectionHelpers.ClassParameter[])new ReflectionHelpers.ClassParameter[0]);
            ShadowVoiceInteractionSession.this.isFinishing = true;
        }
    }
}

