/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.shadows;

import android.os.UserManager;
import android.os.storage.StorageManager;
import android.os.storage.StorageVolume;
import com.google.common.base.Preconditions;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.robolectric.RuntimeEnvironment;
import org.robolectric.annotation.HiddenApi;
import org.robolectric.annotation.Implementation;
import org.robolectric.annotation.Implements;
import org.robolectric.shadow.api.Shadow;
import org.robolectric.shadows.ShadowUserManager;

@Implements(value=StorageManager.class)
public class ShadowStorageManager {
    private static boolean isFileEncryptionSupported = true;
    private final List<StorageVolume> storageVolumeList = new ArrayList<StorageVolume>();

    @Implementation(minSdk=23)
    protected static StorageVolume[] getVolumeList(int userId, int flags) {
        return new StorageVolume[0];
    }

    @Implementation
    public StorageVolume[] getVolumeList() {
        return ShadowStorageManager.getVolumeList(0, 0);
    }

    public void addStorageVolume(StorageVolume storageVolume) {
        Preconditions.checkNotNull((Object)storageVolume);
        this.storageVolumeList.add(storageVolume);
    }

    @Implementation(minSdk=24)
    protected List<StorageVolume> getStorageVolumes() {
        return this.storageVolumeList;
    }

    public void resetStorageVolumeList() {
        this.storageVolumeList.clear();
    }

    @Implementation(minSdk=24)
    public StorageVolume getStorageVolume(File file) {
        for (StorageVolume volume : this.storageVolumeList) {
            File volumeFile = volume.getPathFile();
            if (!file.getAbsolutePath().startsWith(volumeFile.getAbsolutePath())) continue;
            return volume;
        }
        return null;
    }

    @HiddenApi
    @Implementation(minSdk=24)
    protected static boolean isFileEncryptedNativeOrEmulated() {
        return isFileEncryptionSupported;
    }

    public void setFileEncryptedNativeOrEmulated(boolean isSupported) {
        isFileEncryptionSupported = isSupported;
    }

    @HiddenApi
    @Implementation(minSdk=24)
    protected static boolean isUserKeyUnlocked(int userId) {
        ShadowUserManager extract = (ShadowUserManager)Shadow.extract((Object)RuntimeEnvironment.getApplication().getSystemService(UserManager.class));
        return extract.isUserUnlocked();
    }
}

