/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.shadows;

import android.os.DropBoxManager;
import java.nio.charset.StandardCharsets;
import java.util.SortedMap;
import java.util.TreeMap;
import org.robolectric.annotation.Implementation;
import org.robolectric.annotation.Implements;
import org.robolectric.shadows.ShadowSystem;

@Implements(value=DropBoxManager.class)
public class ShadowDropBoxManager {
    private final SortedMap<Long, DropBoxManager.Entry> entries = new TreeMap<Long, DropBoxManager.Entry>();

    public ShadowDropBoxManager() {
        this.reset();
    }

    public void addData(String tag, long wallTimestamp, byte[] data) {
        if (this.entries.containsKey(wallTimestamp)) {
            throw new AssertionError((Object)"Cannot add multiple entries with the exact same timestamp.");
        }
        this.entries.put(wallTimestamp, new DropBoxManager.Entry(tag, wallTimestamp, data, 2));
    }

    @Implementation
    protected void addText(String tag, String data) {
        this.addData(tag, ShadowSystem.currentTimeMillis(), data.getBytes(StandardCharsets.UTF_8));
    }

    public void reset() {
        this.entries.clear();
    }

    @Implementation
    protected DropBoxManager.Entry getNextEntry(String tag, long millis) {
        for (DropBoxManager.Entry entry : this.entries.tailMap(millis).values()) {
            if (tag != null && !entry.getTag().equals(tag) || entry.getTimeMillis() <= millis) continue;
            return entry;
        }
        return null;
    }
}

