/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.shadows;

import android.net.Uri;
import android.telephony.ims.RcsContactUceCapability;
import android.telephony.ims.RcsUceAdapter;
import com.google.auto.value.AutoValue;
import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Executor;
import org.robolectric.annotation.Implementation;
import org.robolectric.annotation.Implements;
import org.robolectric.annotation.RealObject;
import org.robolectric.annotation.Resetter;
import org.robolectric.shadows.AutoValue_ShadowRcsUceAdapter_CapabilityFailureInfo;
import org.robolectric.util.reflector.Accessor;
import org.robolectric.util.reflector.ForType;
import org.robolectric.util.reflector.Reflector;

@Implements(value=RcsUceAdapter.class, isInAndroidSdk=false, minSdk=30)
public class ShadowRcsUceAdapter {
    private static final Set<Integer> subscriptionIdsWithUceSettingEnabled = new HashSet<Integer>();
    private static final Map<Uri, RcsContactUceCapability> capabilitiesMap = new HashMap<Uri, RcsContactUceCapability>();
    private static final Map<Uri, CapabilityFailureInfo> capabilitiesFailureMap = new HashMap<Uri, CapabilityFailureInfo>();
    @RealObject
    private RcsUceAdapter realRcsUceAdapter;

    public static void setUceSettingEnabledForSubscriptionId(int subscriptionId, boolean uceSettingEnabled) {
        if (uceSettingEnabled) {
            subscriptionIdsWithUceSettingEnabled.add(subscriptionId);
        } else {
            subscriptionIdsWithUceSettingEnabled.remove(subscriptionId);
        }
    }

    @Resetter
    public static void reset() {
        subscriptionIdsWithUceSettingEnabled.clear();
        capabilitiesMap.clear();
        capabilitiesFailureMap.clear();
    }

    @Implementation
    protected boolean isUceSettingEnabled() {
        int subscriptionId = ((ReflectorRcsUceAdapter)Reflector.reflector(ReflectorRcsUceAdapter.class, (Object)this.realRcsUceAdapter)).getSubId();
        return subscriptionIdsWithUceSettingEnabled.contains(subscriptionId);
    }

    public static void setCapabilitiesForUri(Uri uri, RcsContactUceCapability capabilities) {
        capabilitiesMap.put(uri, capabilities);
    }

    public static void setCapabilitiesFailureForUri(Uri uri, CapabilityFailureInfo failureInfo) {
        capabilitiesFailureMap.put(uri, failureInfo);
    }

    @Implementation(minSdk=31)
    protected void requestCapabilities(Collection<Uri> contactNumbers, Executor executor, RcsUceAdapter.CapabilitiesCallback c) {
        boolean completedSuccessfully = true;
        for (Uri contact : contactNumbers) {
            if (capabilitiesFailureMap.containsKey(contact)) {
                CapabilityFailureInfo failureInfo = capabilitiesFailureMap.get(contact);
                executor.execute(() -> c.onError(failureInfo.errorCode(), failureInfo.retryMillis()));
                completedSuccessfully = false;
                break;
            }
            if (capabilitiesMap.containsKey(contact)) {
                executor.execute(() -> c.onCapabilitiesReceived((List)ImmutableList.of((Object)capabilitiesMap.get(contact))));
                continue;
            }
            executor.execute(() -> c.onCapabilitiesReceived((List)ImmutableList.of((Object)new RcsContactUceCapability.OptionsBuilder(contact).build())));
        }
        if (completedSuccessfully) {
            executor.execute(() -> ((RcsUceAdapter.CapabilitiesCallback)c).onComplete());
        }
    }

    @Implementation(minSdk=31)
    protected void requestAvailability(Uri contactNumber, Executor executor, RcsUceAdapter.CapabilitiesCallback c) {
        this.requestCapabilities((Collection<Uri>)ImmutableList.of((Object)contactNumber), executor, c);
    }

    @ForType(value=RcsUceAdapter.class)
    private static interface ReflectorRcsUceAdapter {
        @Accessor(value="mSubId")
        public int getSubId();
    }

    @AutoValue
    public static abstract class CapabilityFailureInfo {
        public static CapabilityFailureInfo create(int errorCode, long retryMillis) {
            return new AutoValue_ShadowRcsUceAdapter_CapabilityFailureInfo(errorCode, retryMillis);
        }

        public abstract int errorCode();

        public abstract long retryMillis();
    }
}

