/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.shadows;

import android.companion.AssociationInfo;
import android.companion.AssociationRequest;
import android.companion.CompanionDeviceManager;
import android.content.ComponentName;
import android.os.Handler;
import androidx.annotation.Nullable;
import com.google.auto.value.AutoValue;
import com.google.common.base.Ascii;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.stream.Collectors;
import org.robolectric.annotation.Implementation;
import org.robolectric.annotation.Implements;
import org.robolectric.shadows.AssociationInfoBuilder;
import org.robolectric.shadows.AutoValue_ShadowCompanionDeviceManager_RoboAssociationInfo;

@Implements(value=CompanionDeviceManager.class, minSdk=26)
public class ShadowCompanionDeviceManager {
    protected final Set<RoboAssociationInfo> associations = new HashSet<RoboAssociationInfo>();
    protected final Set<ComponentName> hasNotificationAccess = new HashSet<ComponentName>();
    protected ComponentName lastRequestedNotificationAccess;
    protected AssociationRequest lastAssociationRequest;
    protected CompanionDeviceManager.Callback lastAssociationCallback;

    @Implementation
    protected List<String> getAssociations() {
        return ImmutableList.copyOf((Collection)this.associations.stream().map(RoboAssociationInfo::deviceMacAddress).collect(Collectors.toList()));
    }

    public void addAssociation(String newAssociation) {
        this.associations.add(RoboAssociationInfo.builder().setDeviceMacAddress(newAssociation).build());
    }

    public void addAssociation(AssociationInfo info) {
        this.associations.add(this.createShadowAssociationInfo(info));
    }

    @Implementation
    protected void disassociate(String deviceMacAddress) {
        RoboAssociationInfo associationInfo = this.associations.stream().filter(association -> Ascii.equalsIgnoreCase((CharSequence)deviceMacAddress, (CharSequence)association.deviceMacAddress())).findFirst().orElseThrow(() -> new IllegalArgumentException("Association does not exist"));
        this.associations.remove(associationInfo);
    }

    @Implementation(minSdk=33)
    protected void disassociate(int associationId) {
        RoboAssociationInfo associationInfo = this.associations.stream().filter(association -> associationId == association.id()).findFirst().orElseThrow(() -> new IllegalArgumentException("Association does not exist"));
        this.associations.remove(associationInfo);
    }

    @Implementation
    protected boolean hasNotificationAccess(ComponentName component) {
        this.checkHasAssociation();
        return this.hasNotificationAccess.contains(component);
    }

    public void setNotificationAccess(ComponentName component, boolean hasAccess) {
        if (hasAccess) {
            this.hasNotificationAccess.add(component);
        } else {
            this.hasNotificationAccess.remove(component);
        }
    }

    @Implementation
    protected void requestNotificationAccess(ComponentName component) {
        this.checkHasAssociation();
        this.lastRequestedNotificationAccess = component;
    }

    @Implementation
    protected void associate(AssociationRequest request, CompanionDeviceManager.Callback callback, Handler handler) {
        this.lastAssociationRequest = request;
        this.lastAssociationCallback = callback;
    }

    @Implementation(minSdk=33)
    protected void associate(AssociationRequest request, Executor executor, CompanionDeviceManager.Callback callback) {
        this.associate(request, callback, null);
    }

    public AssociationRequest getLastAssociationRequest() {
        return this.lastAssociationRequest;
    }

    public CompanionDeviceManager.Callback getLastAssociationCallback() {
        return this.lastAssociationCallback;
    }

    public ComponentName getLastRequestedNotificationAccess() {
        return this.lastRequestedNotificationAccess;
    }

    private void checkHasAssociation() {
        if (this.associations.isEmpty()) {
            throw new IllegalStateException("App must have an association before calling this API");
        }
    }

    @Implementation(minSdk=33)
    protected List<AssociationInfo> getMyAssociations() {
        return this.associations.stream().map(this::createAssociationInfo).collect(Collectors.toCollection(ArrayList::new));
    }

    private AssociationInfo createAssociationInfo(RoboAssociationInfo info) {
        return AssociationInfoBuilder.newBuilder().setId(info.id()).setUserId(info.userId()).setPackageName(info.packageName()).setDeviceMacAddress(info.deviceMacAddress()).setDisplayName(info.displayName()).setDeviceProfile(info.deviceProfile()).setSelfManaged(info.selfManaged()).setNotifyOnDeviceNearby(info.notifyOnDeviceNearby()).setApprovedMs(info.timeApprovedMs()).setLastTimeConnectedMs(info.lastTimeConnectedMs()).build();
    }

    private RoboAssociationInfo createShadowAssociationInfo(AssociationInfo info) {
        return RoboAssociationInfo.create(info.getId(), info.getUserId(), info.getPackageName(), info.getDeviceMacAddress().toString(), info.getDisplayName(), info.getDeviceProfile(), info.isSelfManaged(), info.isNotifyOnDeviceNearby(), info.getTimeApprovedMs(), info.getLastTimeConnectedMs());
    }

    @AutoValue
    static abstract class RoboAssociationInfo {
        RoboAssociationInfo() {
        }

        public abstract int id();

        public abstract int userId();

        @Nullable
        public abstract String packageName();

        @Nullable
        public abstract String deviceMacAddress();

        @Nullable
        public abstract CharSequence displayName();

        @Nullable
        public abstract String deviceProfile();

        public abstract boolean selfManaged();

        public abstract boolean notifyOnDeviceNearby();

        public abstract long timeApprovedMs();

        public abstract long lastTimeConnectedMs();

        public static Builder builder() {
            return new AutoValue_ShadowCompanionDeviceManager_RoboAssociationInfo.Builder().setId(1).setUserId(1).setSelfManaged(false).setNotifyOnDeviceNearby(false).setTimeApprovedMs(0L).setLastTimeConnectedMs(0L);
        }

        public static RoboAssociationInfo create(int id2, int userId, String packageName, String deviceMacAddress, CharSequence displayName, String deviceProfile, boolean selfManaged, boolean notifyOnDeviceNearby, long timeApprovedMs, long lastTimeConnectedMs) {
            return RoboAssociationInfo.builder().setId(id2).setUserId(userId).setPackageName(packageName).setDeviceMacAddress(deviceMacAddress).setDisplayName(displayName).setDeviceProfile(deviceProfile).setSelfManaged(selfManaged).setNotifyOnDeviceNearby(notifyOnDeviceNearby).setTimeApprovedMs(timeApprovedMs).setLastTimeConnectedMs(lastTimeConnectedMs).build();
        }

        @AutoValue.Builder
        public static abstract class Builder {
            public abstract Builder setId(int var1);

            public abstract Builder setUserId(int var1);

            public abstract Builder setPackageName(String var1);

            public abstract Builder setDeviceMacAddress(String var1);

            public abstract Builder setDisplayName(CharSequence var1);

            public abstract Builder setDeviceProfile(String var1);

            public abstract Builder setSelfManaged(boolean var1);

            public abstract Builder setNotifyOnDeviceNearby(boolean var1);

            public abstract Builder setTimeApprovedMs(long var1);

            public abstract Builder setLastTimeConnectedMs(long var1);

            public abstract RoboAssociationInfo build();
        }
    }
}

