/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.shadows;

import android.content.res.Configuration;
import android.util.DisplayMetrics;
import android.view.Display;
import android.view.View;
import android.view.ViewGroup;
import android.view.WindowManagerImpl;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Multimap;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.robolectric.RuntimeEnvironment;
import org.robolectric.annotation.Implementation;
import org.robolectric.annotation.Implements;
import org.robolectric.annotation.RealObject;
import org.robolectric.annotation.Resetter;
import org.robolectric.shadow.api.Shadow;
import org.robolectric.shadows.ShadowDisplay;
import org.robolectric.shadows.ShadowWindowManager;
import org.robolectric.util.ReflectionHelpers;

@Implements(value=WindowManagerImpl.class, isInAndroidSdk=false)
public class ShadowWindowManagerImpl
extends ShadowWindowManager {
    private static Display defaultDisplayJB;
    @RealObject
    WindowManagerImpl realObject;
    private static Multimap<Display, View> views;

    public static void configureDefaultDisplayForJBOnly(Configuration configuration, DisplayMetrics displayMetrics) {
        Class arg2Type = ReflectionHelpers.loadClass((ClassLoader)ShadowWindowManagerImpl.class.getClassLoader(), (String)"android.view.CompatibilityInfoHolder");
        defaultDisplayJB = (Display)ReflectionHelpers.callConstructor(Display.class, (ReflectionHelpers.ClassParameter[])new ReflectionHelpers.ClassParameter[]{ReflectionHelpers.ClassParameter.from(Integer.TYPE, (Object)0), ReflectionHelpers.ClassParameter.from((Class)arg2Type, null)});
        ShadowDisplay shadowDisplay = (ShadowDisplay)Shadow.extract((Object)defaultDisplayJB);
        shadowDisplay.configureForJBOnly(configuration, displayMetrics);
    }

    @Implementation
    public void addView(View view, ViewGroup.LayoutParams layoutParams) {
        views.put((Object)this.realObject.getDefaultDisplay(), (Object)view);
        Shadow.directlyOn((Object)this.realObject, WindowManagerImpl.class, (String)"addView", (ReflectionHelpers.ClassParameter[])new ReflectionHelpers.ClassParameter[]{ReflectionHelpers.ClassParameter.from(View.class, (Object)view), ReflectionHelpers.ClassParameter.from(ViewGroup.LayoutParams.class, (Object)layoutParams)});
    }

    @Implementation
    public void removeView(View view) {
        views.remove((Object)this.realObject.getDefaultDisplay(), (Object)view);
        Shadow.directlyOn((Object)this.realObject, WindowManagerImpl.class, (String)"removeView", (ReflectionHelpers.ClassParameter[])new ReflectionHelpers.ClassParameter[]{ReflectionHelpers.ClassParameter.from(View.class, (Object)view)});
    }

    public List<View> getViews() {
        return ImmutableList.copyOf((Collection)views.get((Object)this.realObject.getDefaultDisplay()));
    }

    @Implementation(maxSdk=16)
    public Display getDefaultDisplay() {
        if (RuntimeEnvironment.getApiLevel() > 16) {
            return ((WindowManagerImpl)Shadow.directlyOn((Object)this.realObject, WindowManagerImpl.class)).getDefaultDisplay();
        }
        return defaultDisplayJB;
    }

    @Resetter
    public static void reset() {
        defaultDisplayJB = null;
        views.clear();
        if (RuntimeEnvironment.getApiLevel() <= 16) {
            ReflectionHelpers.setStaticField(WindowManagerImpl.class, (String)"sWindowManager", (Object)ReflectionHelpers.newInstance(WindowManagerImpl.class));
            HashMap windowManagers = (HashMap)ReflectionHelpers.getStaticField(WindowManagerImpl.class, (String)"sCompatWindowManagers");
            windowManagers.clear();
        }
    }

    static {
        views = ArrayListMultimap.create();
    }

    @Implements(className="android.view.WindowManagerImpl$CompatModeWrapper", maxSdk=16)
    public static class ShadowCompatModeWrapper {
        @Implementation(maxSdk=16)
        protected Display getDefaultDisplay() {
            return defaultDisplayJB;
        }
    }
}

