/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.shadows;

import android.app.PendingIntent;
import android.app.usage.UsageEvents;
import android.app.usage.UsageStats;
import android.app.usage.UsageStatsManager;
import android.content.Context;
import android.content.Intent;
import android.content.res.Configuration;
import android.os.Parcel;
import android.util.ArraySet;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Range;
import com.google.common.collect.SetMultimap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.TimeUnit;
import org.robolectric.RuntimeEnvironment;
import org.robolectric.annotation.HiddenApi;
import org.robolectric.annotation.Implementation;
import org.robolectric.annotation.Implements;
import org.robolectric.annotation.Resetter;

@Implements(value=UsageStatsManager.class, minSdk=21)
public class ShadowUsageStatsManager {
    private static int currentAppStandbyBucket = 10;
    private static final TreeMap<Long, UsageEvents.Event> eventsByTimeStamp = new TreeMap();
    private SetMultimap<Integer, UsageStats> usageStatsByIntervalType = HashMultimap.create();
    private static final Map<String, Integer> appStandbyBuckets = new HashMap<String, Integer>();
    private static final Map<Integer, AppUsageObserver> appUsageObserversById = new HashMap<Integer, AppUsageObserver>();

    @Implementation
    protected UsageEvents queryEvents(long beginTime, long endTime) {
        ImmutableList results = ImmutableList.copyOf(eventsByTimeStamp.subMap(beginTime, endTime).values());
        ArraySet names = new ArraySet();
        for (UsageEvents.Event result : results) {
            names.add((Object)result.mPackage);
            if (result.mClass == null) continue;
            names.add((Object)result.mClass);
        }
        Object[] table = (String[])names.toArray((Object[])new String[0]);
        Arrays.sort(table);
        UsageEvents usageEvents = new UsageEvents((List)results, (String[])table);
        Parcel parcel = Parcel.obtain();
        usageEvents.writeToParcel(parcel, 0);
        parcel.setDataPosition(0);
        return new UsageEvents(parcel);
    }

    @Deprecated
    public void addEvent(String packageName, long timeStamp, int eventType) {
        EventBuilder eventBuilder = EventBuilder.buildEvent().setPackage(packageName).setTimeStamp(timeStamp).setEventType(eventType);
        if (eventType == 5) {
            eventBuilder.setConfiguration(new Configuration());
        }
        this.addEvent(eventBuilder.build());
    }

    public void addEvent(UsageEvents.Event event) {
        eventsByTimeStamp.put(event.getTimeStamp(), event);
    }

    public void simulateTimeChange(long offsetToAddInMillis) {
        ImmutableMap.Builder eventMapBuilder = ImmutableMap.builder();
        for (UsageEvents.Event event : eventsByTimeStamp.values()) {
            long newTimestamp = event.getTimeStamp() + offsetToAddInMillis;
            eventMapBuilder.put((Object)newTimestamp, (Object)EventBuilder.fromEvent(event).setTimeStamp(newTimestamp).build());
        }
        eventsByTimeStamp.putAll((Map<Long, UsageEvents.Event>)eventMapBuilder.build());
    }

    @Implementation
    protected List<UsageStats> queryUsageStats(int intervalType, long beginTime, long endTime) {
        ArrayList<UsageStats> results = new ArrayList<UsageStats>();
        Range queryRange = Range.closed((Comparable)Long.valueOf(beginTime), (Comparable)Long.valueOf(endTime));
        for (UsageStats stats : this.usageStatsByIntervalType.get((Object)intervalType)) {
            Range statsRange = Range.closed((Comparable)Long.valueOf(stats.getFirstTimeStamp()), (Comparable)Long.valueOf(stats.getLastTimeStamp()));
            if (!queryRange.isConnected(statsRange)) continue;
            results.add(stats);
        }
        return results;
    }

    public void addUsageStats(int intervalType, UsageStats stats) {
        this.usageStatsByIntervalType.put((Object)intervalType, (Object)stats);
    }

    @Implementation(minSdk=28)
    @HiddenApi
    public int getAppStandbyBucket(String packageName) {
        Integer bucket = appStandbyBuckets.get(packageName);
        return bucket == null ? 10 : bucket;
    }

    @Implementation(minSdk=28)
    @HiddenApi
    public Map<String, Integer> getAppStandbyBuckets() {
        return new HashMap<String, Integer>(appStandbyBuckets);
    }

    @Implementation(minSdk=28)
    @HiddenApi
    public void setAppStandbyBucket(String packageName, int bucket) {
        appStandbyBuckets.put(packageName, bucket);
    }

    @Implementation(minSdk=28)
    @HiddenApi
    public void setAppStandbyBuckets(Map<String, Integer> appBuckets) {
        appStandbyBuckets.putAll(appBuckets);
    }

    @Implementation(minSdk=28)
    @HiddenApi
    protected void registerAppUsageObserver(int observerId, String[] packages, long timeLimit, TimeUnit timeUnit, PendingIntent callbackIntent) {
        appUsageObserversById.put(observerId, new AppUsageObserver(observerId, (Collection<String>)ImmutableList.copyOf((Object[])packages), timeLimit, timeUnit, callbackIntent));
    }

    @Implementation(minSdk=28)
    @HiddenApi
    protected void unregisterAppUsageObserver(int observerId) {
        appUsageObserversById.remove(observerId);
    }

    public Collection<AppUsageObserver> getRegisteredAppUsageObservers() {
        return ImmutableList.copyOf(appUsageObserversById.values());
    }

    public void triggerRegisteredAppUsageObserver(int observerId, long timeUsedInMillis) {
        AppUsageObserver observer = appUsageObserversById.remove(observerId);
        long timeLimitInMillis = observer.timeUnit.toMillis(observer.timeLimit);
        Intent intent = new Intent().putExtra("android.app.usage.extra.OBSERVER_ID", observerId).putExtra("android.app.usage.extra.TIME_LIMIT", timeLimitInMillis).putExtra("android.app.usage.extra.TIME_USED", timeUsedInMillis);
        try {
            observer.callbackIntent.send((Context)RuntimeEnvironment.application, 0, intent);
        }
        catch (PendingIntent.CanceledException e) {
            throw new RuntimeException(e);
        }
    }

    @Implementation(minSdk=28)
    protected int getAppStandbyBucket() {
        return currentAppStandbyBucket;
    }

    public void setCurrentAppStandbyBucket(int bucket) {
        currentAppStandbyBucket = bucket;
    }

    @Resetter
    public static void reset() {
        currentAppStandbyBucket = 10;
        eventsByTimeStamp.clear();
        appStandbyBuckets.clear();
        appUsageObserversById.clear();
    }

    public static class EventBuilder {
        private UsageEvents.Event event = new UsageEvents.Event();

        private EventBuilder() {
        }

        public static EventBuilder fromEvent(UsageEvents.Event event) {
            EventBuilder eventBuilder = new EventBuilder().setPackage(event.mPackage).setClass(event.mClass).setTimeStamp(event.mTimeStamp).setEventType(event.mEventType).setConfiguration(event.mConfiguration);
            if (event.mEventType == 5) {
                eventBuilder.setConfiguration(new Configuration());
            }
            return eventBuilder;
        }

        public static EventBuilder buildEvent() {
            return new EventBuilder();
        }

        public UsageEvents.Event build() {
            return this.event;
        }

        public EventBuilder setPackage(String packageName) {
            this.event.mPackage = packageName;
            return this;
        }

        public EventBuilder setClass(String className) {
            this.event.mClass = className;
            return this;
        }

        public EventBuilder setTimeStamp(long timeStamp) {
            this.event.mTimeStamp = timeStamp;
            return this;
        }

        public EventBuilder setEventType(int eventType) {
            this.event.mEventType = eventType;
            return this;
        }

        public EventBuilder setConfiguration(Configuration configuration) {
            this.event.mConfiguration = configuration;
            return this;
        }

        public EventBuilder setShortcutId(String shortcutId) {
            this.event.mShortcutId = shortcutId;
            return this;
        }
    }

    public static class UsageStatsBuilder {
        private UsageStats usageStats = new UsageStats();

        private UsageStatsBuilder() {
        }

        public static UsageStatsBuilder newBuilder() {
            return new UsageStatsBuilder();
        }

        public UsageStats build() {
            return this.usageStats;
        }

        public UsageStatsBuilder setPackageName(String packageName) {
            this.usageStats.mPackageName = packageName;
            return this;
        }

        public UsageStatsBuilder setFirstTimeStamp(long firstTimeStamp) {
            this.usageStats.mBeginTimeStamp = firstTimeStamp;
            return this;
        }

        public UsageStatsBuilder setLastTimeStamp(long lastTimeStamp) {
            this.usageStats.mEndTimeStamp = lastTimeStamp;
            return this;
        }

        public UsageStatsBuilder setTotalTimeInForeground(long totalTimeInForeground) {
            this.usageStats.mTotalTimeInForeground = totalTimeInForeground;
            return this;
        }

        public UsageStatsBuilder setLastTimeUsed(long lastTimeUsed) {
            this.usageStats.mLastTimeUsed = lastTimeUsed;
            return this;
        }
    }

    public static final class AppUsageObserver {
        private final int observerId;
        private final Collection<String> packageNames;
        private final long timeLimit;
        private final TimeUnit timeUnit;
        private final PendingIntent callbackIntent;

        public AppUsageObserver(int observerId, Collection<String> packageNames, long timeLimit, TimeUnit timeUnit, PendingIntent callbackIntent) {
            this.observerId = observerId;
            this.packageNames = packageNames;
            this.timeLimit = timeLimit;
            this.timeUnit = timeUnit;
            this.callbackIntent = callbackIntent;
        }

        public int getObserverId() {
            return this.observerId;
        }

        public Collection<String> getPackageNames() {
            return this.packageNames;
        }

        public long getTimeLimit() {
            return this.timeLimit;
        }

        public TimeUnit getTimeUnit() {
            return this.timeUnit;
        }

        public PendingIntent getCallbackIntent() {
            return this.callbackIntent;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            AppUsageObserver that = (AppUsageObserver)o;
            return this.observerId == that.observerId && this.timeLimit == that.timeLimit && this.packageNames.equals(that.packageNames) && this.timeUnit == that.timeUnit && this.callbackIntent.equals((Object)that.callbackIntent);
        }

        public int hashCode() {
            int result = this.observerId;
            result = 31 * result + this.packageNames.hashCode();
            result = 31 * result + (int)(this.timeLimit ^ this.timeLimit >>> 32);
            result = 31 * result + this.timeUnit.hashCode();
            result = 31 * result + this.callbackIntent.hashCode();
            return result;
        }
    }
}

