/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.shadows;

import android.os.Looper;
import android.widget.OverScroller;
import org.robolectric.annotation.Implementation;
import org.robolectric.annotation.Implements;
import org.robolectric.shadow.api.Shadow;
import org.robolectric.shadows.ShadowLooper;
import org.robolectric.util.Scheduler;

@Implements(value=OverScroller.class)
public class ShadowOverScroller {
    private int startX;
    private int startY;
    private int finalX;
    private int finalY;
    private long startTime;
    private long duration;
    private boolean started;

    @Implementation
    protected int getStartX() {
        return this.startX;
    }

    @Implementation
    protected int getStartY() {
        return this.startY;
    }

    @Implementation
    protected int getCurrX() {
        long dt = this.deltaTime();
        return dt >= this.duration ? this.finalX : this.startX + (int)((long)this.deltaX() * dt / this.duration);
    }

    @Implementation
    protected int getCurrY() {
        long dt = this.deltaTime();
        return dt >= this.duration ? this.finalY : this.startY + (int)((long)this.deltaY() * dt / this.duration);
    }

    @Implementation
    protected int getFinalX() {
        return this.finalX;
    }

    @Implementation
    protected int getFinalY() {
        return this.finalY;
    }

    @Implementation
    protected int getDuration() {
        return (int)this.duration;
    }

    @Implementation
    protected void startScroll(int startX, int startY, int dx, int dy, int duration) {
        this.startX = startX;
        this.startY = startY;
        this.finalX = startX + dx;
        this.finalY = startY + dy;
        this.startTime = this.getScheduler().getCurrentTime();
        this.duration = duration;
        this.started = true;
        this.getScheduler().postDelayed(new Runnable(){

            @Override
            public void run() {
            }
        }, (long)duration);
    }

    @Implementation
    protected void abortAnimation() {
        this.duration = this.deltaTime() - 1L;
    }

    @Implementation
    protected void forceFinished(boolean finished) {
        if (!finished) {
            throw new RuntimeException("Not implemented.");
        }
        this.finalX = this.getCurrX();
        this.finalY = this.getCurrY();
        this.duration = this.deltaTime() - 1L;
    }

    @Implementation
    protected boolean computeScrollOffset() {
        if (!this.started) {
            return false;
        }
        this.started &= this.deltaTime() < this.duration;
        return true;
    }

    @Implementation
    protected boolean isFinished() {
        return this.deltaTime() > this.duration;
    }

    @Implementation
    protected int timePassed() {
        return (int)this.deltaTime();
    }

    @Implementation
    protected boolean isScrollingInDirection(float xvel, float yvel) {
        int dx = this.finalX - this.startX;
        int dy = this.finalY - this.startY;
        return !this.isFinished() && Math.signum(xvel) == Math.signum(dx) && Math.signum(yvel) == Math.signum(dy);
    }

    private long deltaTime() {
        return this.getScheduler().getCurrentTime() - this.startTime;
    }

    private Scheduler getScheduler() {
        ShadowLooper shadowLooper = (ShadowLooper)Shadow.extract((Object)Looper.getMainLooper());
        return shadowLooper.getScheduler();
    }

    private int deltaX() {
        return this.finalX - this.startX;
    }

    private int deltaY() {
        return this.finalY - this.startY;
    }
}

