/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.shadows;

import android.app.ActivityThread;
import android.content.BroadcastReceiver;
import android.content.ComponentName;
import android.content.ContentResolver;
import android.content.Context;
import android.content.IContentProvider;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.IntentSender;
import android.content.ServiceConnection;
import android.os.Bundle;
import android.os.Environment;
import android.os.Handler;
import android.os.UserHandle;
import java.io.File;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.robolectric.RuntimeEnvironment;
import org.robolectric.annotation.Implementation;
import org.robolectric.annotation.Implements;
import org.robolectric.annotation.RealObject;
import org.robolectric.annotation.Resetter;
import org.robolectric.shadow.api.Shadow;
import org.robolectric.shadows.ShadowInstrumentation;
import org.robolectric.util.ReflectionHelpers;

@Implements(className="android.app.ContextImpl")
public class ShadowContextImpl {
    public static final String CLASS_NAME = "android.app.ContextImpl";
    private ContentResolver contentResolver;
    @RealObject
    private Context realContextImpl;
    private Map<String, Object> systemServices = new HashMap<String, Object>();
    private final Set<String> removedSystemServices = new HashSet<String>();

    @Implementation
    protected Object getSystemService(String name) {
        if (this.removedSystemServices.contains(name)) {
            return null;
        }
        if (!this.systemServices.containsKey(name)) {
            return Shadow.directlyOn((Object)this.realContextImpl, (String)CLASS_NAME, (String)"getSystemService", (ReflectionHelpers.ClassParameter[])new ReflectionHelpers.ClassParameter[]{ReflectionHelpers.ClassParameter.from(String.class, (Object)name)});
        }
        return this.systemServices.get(name);
    }

    public void setSystemService(String key, Object service) {
        this.systemServices.put(key, service);
    }

    public void removeSystemService(String name) {
        this.removedSystemServices.add(name);
    }

    @Implementation
    protected void startIntentSender(IntentSender intent, Intent fillInIntent, int flagsMask, int flagsValues, int extraFlags, Bundle options) throws IntentSender.SendIntentException {
        intent.sendIntent(this.realContextImpl, 0, fillInIntent, null, null, null);
    }

    @Implementation
    protected ClassLoader getClassLoader() {
        return this.getClass().getClassLoader();
    }

    @Implementation
    protected int checkCallingPermission(String permission2) {
        return this.checkPermission(permission2, -1, -1);
    }

    @Implementation
    protected int checkCallingOrSelfPermission(String permission2) {
        return this.checkPermission(permission2, -1, -1);
    }

    @Implementation
    protected ContentResolver getContentResolver() {
        if (this.contentResolver == null) {
            this.contentResolver = new ContentResolver(this.realContextImpl){

                protected IContentProvider acquireProvider(Context c, String name) {
                    return null;
                }

                public boolean releaseProvider(IContentProvider icp) {
                    return false;
                }

                protected IContentProvider acquireUnstableProvider(Context c, String name) {
                    return null;
                }

                public boolean releaseUnstableProvider(IContentProvider icp) {
                    return false;
                }

                public void unstableProviderDied(IContentProvider icp) {
                }
            };
        }
        return this.contentResolver;
    }

    @Implementation
    protected void sendBroadcast(Intent intent) {
        this.getShadowInstrumentation().sendBroadcastWithPermission(intent, null, this.realContextImpl);
    }

    @Implementation
    protected void sendBroadcast(Intent intent, String receiverPermission) {
        this.getShadowInstrumentation().sendBroadcastWithPermission(intent, receiverPermission, this.realContextImpl);
    }

    @Implementation
    protected void sendOrderedBroadcast(Intent intent, String receiverPermission) {
        this.getShadowInstrumentation().sendOrderedBroadcastWithPermission(intent, receiverPermission, this.realContextImpl);
    }

    @Implementation
    protected void sendOrderedBroadcast(Intent intent, String receiverPermission, BroadcastReceiver resultReceiver, Handler scheduler, int initialCode, String initialData, Bundle initialExtras) {
        this.getShadowInstrumentation().sendOrderedBroadcast(intent, receiverPermission, resultReceiver, scheduler, initialCode, initialData, initialExtras, this.realContextImpl);
    }

    @Implementation
    protected void sendStickyBroadcast(Intent intent) {
        this.getShadowInstrumentation().sendStickyBroadcast(intent, this.realContextImpl);
    }

    @Implementation
    protected int checkPermission(String permission2, int pid, int uid) {
        return this.getShadowInstrumentation().checkPermission(permission2, pid, uid);
    }

    @Implementation
    protected Intent registerReceiver(BroadcastReceiver receiver, IntentFilter filter) {
        return this.getShadowInstrumentation().registerReceiver(receiver, filter, this.realContextImpl);
    }

    @Implementation
    protected Intent registerReceiver(BroadcastReceiver receiver, IntentFilter filter, String broadcastPermission, Handler scheduler) {
        return this.getShadowInstrumentation().registerReceiver(receiver, filter, broadcastPermission, scheduler, this.realContextImpl);
    }

    @Implementation(minSdk=17)
    protected Intent registerReceiverAsUser(BroadcastReceiver receiver, UserHandle user, IntentFilter filter, String broadcastPermission, Handler scheduler) {
        return this.getShadowInstrumentation().registerReceiverWithContext(receiver, filter, broadcastPermission, scheduler, this.realContextImpl);
    }

    @Implementation
    protected void unregisterReceiver(BroadcastReceiver broadcastReceiver) {
        this.getShadowInstrumentation().unregisterReceiver(broadcastReceiver);
    }

    @Implementation
    protected ComponentName startService(Intent service) {
        return this.getShadowInstrumentation().startService(service);
    }

    @Implementation(minSdk=26)
    protected ComponentName startForegroundService(Intent service) {
        return this.getShadowInstrumentation().startService(service);
    }

    @Implementation
    protected boolean stopService(Intent name) {
        return this.getShadowInstrumentation().stopService(name);
    }

    @Implementation
    protected boolean bindService(Intent intent, ServiceConnection serviceConnection, int i) {
        return this.getShadowInstrumentation().bindService(intent, serviceConnection, i);
    }

    @Implementation(minSdk=21)
    protected boolean bindServiceAsUser(Intent intent, ServiceConnection serviceConnection, int i, UserHandle userHandle) {
        return this.getShadowInstrumentation().bindService(intent, serviceConnection, i);
    }

    @Implementation
    protected void unbindService(ServiceConnection serviceConnection) {
        this.getShadowInstrumentation().unbindService(serviceConnection);
    }

    @Implementation(minSdk=17)
    protected int getUserId() {
        return 0;
    }

    @Implementation
    protected File getExternalCacheDir() {
        return Environment.getExternalStorageDirectory();
    }

    @Implementation(maxSdk=18)
    protected File getExternalFilesDir(String type) {
        return Environment.getExternalStoragePublicDirectory((String)type);
    }

    @Implementation(minSdk=19)
    protected File[] getExternalFilesDirs(String type) {
        return new File[]{Environment.getExternalStoragePublicDirectory((String)type)};
    }

    @Resetter
    public static void reset() {
        String prefsCacheFieldName = RuntimeEnvironment.getApiLevel() >= 24 ? "sSharedPrefsCache" : "sSharedPrefs";
        HashMap prefsDefaultValue = RuntimeEnvironment.getApiLevel() >= 19 ? null : new HashMap();
        Class contextImplClass = ReflectionHelpers.loadClass((ClassLoader)ShadowContextImpl.class.getClassLoader(), (String)CLASS_NAME);
        ReflectionHelpers.setStaticField((Class)contextImplClass, (String)prefsCacheFieldName, prefsDefaultValue);
        if (RuntimeEnvironment.getApiLevel() <= 22) {
            HashMap fetchers = (HashMap)ReflectionHelpers.getStaticField((Class)contextImplClass, (String)"SYSTEM_SERVICE_MAP");
            Class staticServiceFetcherClass = ReflectionHelpers.loadClass((ClassLoader)ShadowContextImpl.class.getClassLoader(), (String)"android.app.ContextImpl$StaticServiceFetcher");
            for (Object o : fetchers.values()) {
                if (!staticServiceFetcherClass.isInstance(o)) continue;
                ReflectionHelpers.setField((Class)staticServiceFetcherClass, o, (String)"mCachedInstance", null);
            }
            if (RuntimeEnvironment.getApiLevel() >= 19) {
                Class serviceFetcherClass = ReflectionHelpers.loadClass((ClassLoader)ShadowContextImpl.class.getClassLoader(), (String)"android.app.ContextImpl$ServiceFetcher");
                Object windowServiceFetcher = fetchers.get("window");
                ReflectionHelpers.setField(windowServiceFetcher.getClass(), windowServiceFetcher, (String)"mDefaultDisplay", null);
            }
        }
    }

    private ShadowInstrumentation getShadowInstrumentation() {
        ActivityThread activityThread = (ActivityThread)RuntimeEnvironment.getActivityThread();
        return (ShadowInstrumentation)Shadow.extract((Object)activityThread.getInstrumentation());
    }
}

