/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.shadows;

import android.app.ApplicationPackageManager;
import android.app.admin.DevicePolicyManager;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.IntentSender;
import android.content.pm.ActivityInfo;
import android.content.pm.ApplicationInfo;
import android.content.pm.ChangedPackages;
import android.content.pm.ComponentInfo;
import android.content.pm.FeatureInfo;
import android.content.pm.IPackageDataObserver;
import android.content.pm.IPackageDeleteObserver;
import android.content.pm.IPackageManager;
import android.content.pm.IPackageStatsObserver;
import android.content.pm.InstrumentationInfo;
import android.content.pm.IntentFilterVerificationInfo;
import android.content.pm.PackageInfo;
import android.content.pm.PackageItemInfo;
import android.content.pm.PackageManager;
import android.content.pm.PackageParser;
import android.content.pm.PackageStats;
import android.content.pm.PermissionGroupInfo;
import android.content.pm.PermissionInfo;
import android.content.pm.ProviderInfo;
import android.content.pm.ResolveInfo;
import android.content.pm.ServiceInfo;
import android.content.pm.VerifierDeviceIdentity;
import android.content.res.AssetManager;
import android.content.res.Resources;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.net.Uri;
import android.os.Build;
import android.os.Handler;
import android.os.Looper;
import android.os.PersistableBundle;
import android.os.RemoteException;
import android.os.UserHandle;
import android.os.storage.VolumeInfo;
import android.telecom.TelecomManager;
import android.util.Pair;
import com.google.common.base.Function;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.robolectric.RuntimeEnvironment;
import org.robolectric.annotation.HiddenApi;
import org.robolectric.annotation.Implementation;
import org.robolectric.annotation.Implements;
import org.robolectric.annotation.RealObject;
import org.robolectric.shadow.api.Shadow;
import org.robolectric.shadows.ShadowPackageManager;
import org.robolectric.util.ReflectionHelpers;

@Implements(value=ApplicationPackageManager.class, isInAndroidSdk=false, looseSignatures=true)
public class ShadowApplicationPackageManager
extends ShadowPackageManager {
    private static final String PLATFORM_PACKAGE_NAME = "android";
    private static final String PACKAGE_MIME_TYPE = "application/vnd.android.package-archive";
    private static final String PACKAGE_SCHEME = "package";
    @RealObject
    private ApplicationPackageManager realObject;
    private Context context;

    @Implementation
    protected void __constructor__(Object contextImpl, Object pm) {
        try {
            Shadow.invokeConstructor(ApplicationPackageManager.class, (Object)this.realObject, (ReflectionHelpers.ClassParameter[])new ReflectionHelpers.ClassParameter[]{ReflectionHelpers.ClassParameter.from(Class.forName("android.app.ContextImpl"), (Object)contextImpl), ReflectionHelpers.ClassParameter.from(IPackageManager.class, (Object)pm)});
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
        this.context = (Context)contextImpl;
    }

    @Implementation
    public List<PackageInfo> getInstalledPackages(int flags) {
        ArrayList<PackageInfo> result = new ArrayList<PackageInfo>();
        for (PackageInfo packageInfo : packageInfos.values()) {
            String packageName = packageInfo.packageName;
            if ((Integer)applicationEnabledSettingMap.get(packageName) == 2 && (flags & 0x2000) != 8192 && (flags & 0x200) != 512 || hiddenPackages.contains(packageName) && !ShadowApplicationPackageManager.isFlagSet(flags, 8192)) continue;
            result.add(packageInfo);
        }
        return result;
    }

    @Implementation
    protected ActivityInfo getActivityInfo(ComponentName component, int flags) throws PackageManager.NameNotFoundException {
        String activityName = component.getClassName();
        String packageName = component.getPackageName();
        PackageInfo packageInfo = (PackageInfo)packageInfos.get(packageName);
        if (packageInfo != null) {
            if (packageInfo.activities != null) {
                for (ActivityInfo activity : packageInfo.activities) {
                    if (!activityName.equals(activity.name)) continue;
                    ActivityInfo result = new ActivityInfo(activity);
                    if ((flags & 0x80) != 0) {
                        result.metaData = activity.metaData;
                    }
                    return result;
                }
            }
            ActivityInfo result = new ActivityInfo();
            result.name = activityName;
            result.packageName = packageName;
            result.applicationInfo = new ApplicationInfo(packageInfo.applicationInfo);
            return result;
        }
        ActivityInfo result = new ActivityInfo();
        result.name = activityName;
        result.packageName = packageName;
        result.applicationInfo = new ApplicationInfo();
        result.applicationInfo.packageName = packageName;
        return result;
    }

    @Implementation
    protected boolean hasSystemFeature(String name) {
        return systemFeatureList.containsKey(name) ? (Boolean)systemFeatureList.get(name) : false;
    }

    @Implementation
    protected int getComponentEnabledSetting(ComponentName componentName) {
        ShadowPackageManager.ComponentState state = (ShadowPackageManager.ComponentState)componentList.get(componentName);
        return state != null ? state.newState : 0;
    }

    @Implementation
    protected String getNameForUid(int uid) {
        return (String)namesForUid.get(uid);
    }

    @Implementation
    protected String[] getPackagesForUid(int uid) {
        String[] packageNames = (String[])packagesForUid.get(uid);
        if (packageNames != null) {
            return packageNames;
        }
        HashSet<String> results = new HashSet<String>();
        for (PackageInfo packageInfo : packageInfos.values()) {
            if (packageInfo.applicationInfo == null || packageInfo.applicationInfo.uid != uid) continue;
            results.add(packageInfo.packageName);
        }
        return results.isEmpty() ? null : results.toArray(new String[results.size()]);
    }

    @Implementation
    protected int getApplicationEnabledSetting(String packageName) {
        try {
            this.getPackageInfo(packageName, -1);
        }
        catch (PackageManager.NameNotFoundException e) {
            throw new IllegalArgumentException(e);
        }
        return (Integer)applicationEnabledSettingMap.get(packageName);
    }

    @Implementation
    protected ProviderInfo getProviderInfo(ComponentName component, int flags) throws PackageManager.NameNotFoundException {
        String packageName = component.getPackageName();
        PackageInfo packageInfo = (PackageInfo)packageInfos.get(packageName);
        if (packageInfo != null && packageInfo.providers != null) {
            for (ProviderInfo provider : packageInfo.providers) {
                if (!ShadowApplicationPackageManager.resolvePackageName(packageName, component).equals(provider.name)) continue;
                ProviderInfo result = new ProviderInfo();
                result.packageName = provider.packageName;
                result.name = provider.name;
                result.authority = provider.authority;
                result.readPermission = provider.readPermission;
                result.writePermission = provider.writePermission;
                result.pathPermissions = provider.pathPermissions;
                if ((flags & 0x80) != 0) {
                    result.metaData = provider.metaData;
                }
                return result;
            }
        }
        throw new PackageManager.NameNotFoundException("Package not found: " + packageName);
    }

    @Implementation
    protected void setComponentEnabledSetting(ComponentName componentName, int newState, int flags) {
        componentList.put(componentName, new ShadowPackageManager.ComponentState(newState, flags));
    }

    @Implementation
    protected void setApplicationEnabledSetting(String packageName, int newState, int flags) {
        applicationEnabledSettingMap.put(packageName, newState);
    }

    @Implementation
    protected ResolveInfo resolveActivity(Intent intent, int flags) {
        HashSet<ComponentName> preferredComponents = new HashSet<ComponentName>();
        for (Map.Entry preferred : preferredActivities.entrySet()) {
            if ((((ShadowPackageManager.IntentFilterWrapper)preferred.getKey()).getFilter().match(this.context.getContentResolver(), intent, false, "robo") & 0xFFF0000) == 0) continue;
            preferredComponents.add((ComponentName)preferred.getValue());
        }
        List<ResolveInfo> candidates = this.queryIntentActivities(intent, flags);
        return candidates.isEmpty() ? null : Collections.max(candidates, new ShadowPackageManager.ResolveInfoComparator(preferredComponents));
    }

    @Implementation
    protected ProviderInfo resolveContentProvider(String name, int flags) {
        if (name == null) {
            return null;
        }
        for (PackageInfo packageInfo : packageInfos.values()) {
            if (packageInfo.providers == null) continue;
            for (ProviderInfo providerInfo : packageInfo.providers) {
                if (!name.equals(providerInfo.authority)) continue;
                return providerInfo;
            }
        }
        return null;
    }

    @Implementation(minSdk=21)
    protected ProviderInfo resolveContentProviderAsUser(String name, int flags, int userId) {
        return null;
    }

    @Implementation
    protected PackageInfo getPackageInfo(String packageName, int flags) throws PackageManager.NameNotFoundException {
        PackageInfo info = (PackageInfo)packageInfos.get(packageName);
        if (info != null) {
            if ((Integer)applicationEnabledSettingMap.get(packageName) == 2 && (flags & 0x2000) != 8192 && (flags & 0x200) != 512) {
                throw new PackageManager.NameNotFoundException("Package is disabled, can't find");
            }
            if (hiddenPackages.contains(packageName) && !ShadowApplicationPackageManager.isFlagSet(flags, 8192)) {
                throw new PackageManager.NameNotFoundException("Package is hidden, can't find");
            }
            return info;
        }
        throw new PackageManager.NameNotFoundException(packageName);
    }

    @Implementation
    protected List<ResolveInfo> queryIntentServices(Intent intent, int flags) {
        ArrayList<ResolveInfo> result = new ArrayList<ResolveInfo>();
        List<ResolveInfo> resolveInfoList = this.queryOverriddenIntents(intent, flags);
        if (!resolveInfoList.isEmpty()) {
            result.addAll(this.filterResolvedComponent(resolveInfoList, flags, (Function<ResolveInfo, ComponentInfo>)((Function)resolveInfo -> resolveInfo.serviceInfo)));
        }
        if (ShadowApplicationPackageManager.isExplicitIntent(intent)) {
            ResolveInfo resolvedService = this.resolveServiceForExplicitIntent(intent);
            if (resolvedService != null) {
                result.addAll(this.filterResolvedComponent(Arrays.asList(resolvedService), flags, (Function<ResolveInfo, ComponentInfo>)((Function)resolveInfo -> resolveInfo.serviceInfo)));
            }
        } else {
            result.addAll(this.filterResolvedComponent(this.queryImplicitIntentServices(intent, flags), flags, (Function<ResolveInfo, ComponentInfo>)((Function)resolveInfo -> resolveInfo.serviceInfo)));
        }
        return result;
    }

    private List<ResolveInfo> filterResolvedComponent(List<ResolveInfo> resolveInfoList, int flags, Function<ResolveInfo, ComponentInfo> componentInfoFn) {
        if (ShadowApplicationPackageManager.isFlagSet(flags, 131072)) {
            return resolveInfoList;
        }
        resolveInfoList = new ArrayList<ResolveInfo>(resolveInfoList);
        Iterator<ResolveInfo> iterator = resolveInfoList.iterator();
        while (iterator.hasNext()) {
            ComponentName componentName;
            boolean hasSomeComponentInfo;
            ResolveInfo resolveInfo = iterator.next();
            ComponentInfo componentInfo = (ComponentInfo)componentInfoFn.apply((Object)resolveInfo);
            boolean bl = hasSomeComponentInfo = resolveInfo.activityInfo != null || resolveInfo.serviceInfo != null || Build.VERSION.SDK_INT >= 19 && resolveInfo.providerInfo != null;
            if (componentInfo == null && hasSomeComponentInfo) {
                iterator.remove();
                continue;
            }
            if (ShadowApplicationPackageManager.isFlagSet(flags, 0x100000)) {
                if (componentInfo == null || componentInfo.applicationInfo == null) {
                    iterator.remove();
                    continue;
                }
                int applicationFlags = componentInfo.applicationInfo.flags;
                if ((applicationFlags & 1) != 1) {
                    iterator.remove();
                    continue;
                }
            }
            if (!ShadowApplicationPackageManager.isFlagSet(flags, 512) && resolveInfo != null && ShadowApplicationPackageManager.isValidComponentInfo(componentInfo) && (this.getComponentEnabledSetting(componentName = new ComponentName(componentInfo.applicationInfo.packageName, componentInfo.name)) & 2) != 0) {
                iterator.remove();
                continue;
            }
            if (ShadowApplicationPackageManager.isFlagSet(flags, 8192) || resolveInfo == null || !ShadowApplicationPackageManager.isValidComponentInfo(componentInfo) || !hiddenPackages.contains(componentInfo.applicationInfo.packageName)) continue;
            iterator.remove();
        }
        return resolveInfoList;
    }

    private static boolean isFlagSet(int flags, int matchFlag) {
        return (flags & matchFlag) == matchFlag;
    }

    private static boolean isValidComponentInfo(ComponentInfo componentInfo) {
        return componentInfo != null && componentInfo.applicationInfo != null && componentInfo.applicationInfo.packageName != null && componentInfo.name != null;
    }

    @Implementation(minSdk=17)
    protected List<ResolveInfo> queryIntentServicesAsUser(Intent intent, int flags, int userId) {
        return this.queryIntentServices(intent, flags);
    }

    @Implementation
    protected List<ResolveInfo> queryIntentActivities(Intent intent, int flags) {
        ArrayList<ResolveInfo> result = new ArrayList<ResolveInfo>();
        List<ResolveInfo> resolveInfoList = this.queryOverriddenIntents(intent, flags);
        if (!resolveInfoList.isEmpty()) {
            result.addAll(this.filterResolvedComponent(resolveInfoList, flags, (Function<ResolveInfo, ComponentInfo>)((Function)resolveInfo -> resolveInfo.activityInfo)));
        }
        if (ShadowApplicationPackageManager.isExplicitIntent(intent)) {
            ResolveInfo resolvedActivity = this.resolveActivityForExplicitIntent(intent);
            if (resolvedActivity != null) {
                result.addAll(this.filterResolvedComponent(Arrays.asList(resolvedActivity), flags, (Function<ResolveInfo, ComponentInfo>)((Function)resolveInfo -> resolveInfo.activityInfo)));
            }
        } else {
            result.addAll(this.filterResolvedComponent(this.queryImplicitIntentActivities(intent, flags), flags, (Function<ResolveInfo, ComponentInfo>)((Function)resolveInfo -> resolveInfo.activityInfo)));
        }
        return result;
    }

    @Implementation(minSdk=17)
    protected List<ResolveInfo> queryIntentActivitiesAsUser(Intent intent, int flags, int userId) {
        return this.queryIntentActivities(intent, flags);
    }

    private static boolean isExplicitIntent(Intent intent) {
        return ShadowApplicationPackageManager.getComponentForIntent(intent) != null;
    }

    private ResolveInfo resolveActivityForExplicitIntent(Intent intent) {
        ComponentName component = ShadowApplicationPackageManager.getComponentForIntent(intent);
        for (PackageParser.Package appPackage : packages.values()) {
            PackageParser.Activity activity = (PackageParser.Activity)ShadowApplicationPackageManager.findMatchingComponent(component, appPackage.activities);
            if (activity == null) continue;
            return ShadowApplicationPackageManager.buildResolveInfo(activity);
        }
        return null;
    }

    private ResolveInfo resolveServiceForExplicitIntent(Intent intent) {
        ComponentName component = ShadowApplicationPackageManager.getComponentForIntent(intent);
        for (PackageParser.Package appPackage : packages.values()) {
            PackageParser.Service service = (PackageParser.Service)ShadowApplicationPackageManager.findMatchingComponent(component, appPackage.services);
            if (service == null) continue;
            return ShadowApplicationPackageManager.buildResolveInfo(service);
        }
        return null;
    }

    private ResolveInfo resolveReceiverForExplicitIntent(Intent intent) {
        ComponentName component = ShadowApplicationPackageManager.getComponentForIntent(intent);
        for (PackageParser.Package appPackage : packages.values()) {
            PackageParser.Activity receiver = (PackageParser.Activity)ShadowApplicationPackageManager.findMatchingComponent(component, appPackage.receivers);
            if (receiver == null) continue;
            return ShadowApplicationPackageManager.buildResolveInfo(receiver);
        }
        return null;
    }

    private ResolveInfo resolveContentProviderForExplicitIntent(Intent intent) {
        ComponentName component = ShadowApplicationPackageManager.getComponentForIntent(intent);
        for (PackageParser.Package appPackage : packages.values()) {
            PackageParser.Provider provider = (PackageParser.Provider)ShadowApplicationPackageManager.findMatchingComponent(component, appPackage.providers);
            if (provider == null) continue;
            return ShadowApplicationPackageManager.buildResolveInfo(provider);
        }
        return null;
    }

    private static <T extends PackageParser.Component> T findMatchingComponent(ComponentName componentName, List<T> components) {
        for (PackageParser.Component component : components) {
            if (!componentName.equals((Object)component.getComponentName())) continue;
            return (T)component;
        }
        return null;
    }

    private static ComponentName getComponentForIntent(Intent intent) {
        ComponentName component = intent.getComponent();
        if (component == null && intent.getSelector() != null) {
            intent = intent.getSelector();
            component = intent.getComponent();
        }
        return component;
    }

    private List<ResolveInfo> queryImplicitIntentContentProviders(Intent intent, int flags) {
        ArrayList<ResolveInfo> resolveInfoList = new ArrayList<ResolveInfo>();
        for (PackageParser.Package appPackage : packages.values()) {
            if (intent.getPackage() != null && !intent.getPackage().equals(appPackage.packageName)) continue;
            for (PackageParser.Provider provider : appPackage.providers) {
                IntentFilter intentFilter = ShadowApplicationPackageManager.matchIntentFilter(intent, provider.intents, flags);
                if (intentFilter == null) continue;
                resolveInfoList.add(ShadowApplicationPackageManager.buildResolveInfo(provider));
            }
        }
        return resolveInfoList;
    }

    private List<ResolveInfo> queryImplicitIntentActivities(Intent intent, int flags) {
        ArrayList<ResolveInfo> resolveInfoList = new ArrayList<ResolveInfo>();
        for (PackageParser.Package appPackage : packages.values()) {
            if (intent.getPackage() != null && !intent.getPackage().equals(appPackage.packageName)) continue;
            for (PackageParser.Activity activity : appPackage.activities) {
                IntentFilter intentFilter = ShadowApplicationPackageManager.matchIntentFilter(intent, activity.intents, flags);
                if (intentFilter == null) continue;
                resolveInfoList.add(ShadowApplicationPackageManager.buildResolveInfo(activity, intentFilter));
            }
        }
        return resolveInfoList;
    }

    private List<ResolveInfo> queryImplicitIntentServices(Intent intent, int flags) {
        ArrayList<ResolveInfo> resolveInfoList = new ArrayList<ResolveInfo>();
        for (PackageParser.Package appPackage : packages.values()) {
            if (intent.getPackage() != null && !intent.getPackage().equals(appPackage.packageName)) continue;
            for (PackageParser.Service service : appPackage.services) {
                IntentFilter intentFilter = ShadowApplicationPackageManager.matchIntentFilter(intent, service.intents, flags);
                if (intentFilter == null) continue;
                resolveInfoList.add(ShadowApplicationPackageManager.buildResolveInfo(service, intentFilter));
            }
        }
        return resolveInfoList;
    }

    private List<ResolveInfo> queryImplicitIntentReceivers(Intent intent, int flags) {
        ArrayList<ResolveInfo> resolveInfoList = new ArrayList<ResolveInfo>();
        for (PackageParser.Package appPackage : packages.values()) {
            if (intent.getPackage() != null && !intent.getPackage().equals(appPackage.packageName)) continue;
            for (PackageParser.Activity activity : appPackage.receivers) {
                IntentFilter intentFilter = ShadowApplicationPackageManager.matchIntentFilter(intent, activity.intents, flags);
                if (intentFilter == null) continue;
                resolveInfoList.add(ShadowApplicationPackageManager.buildResolveInfo(activity, intentFilter));
            }
        }
        return resolveInfoList;
    }

    static ResolveInfo buildResolveInfo(PackageParser.Activity activity) {
        ResolveInfo resolveInfo = ShadowApplicationPackageManager.buildResolveInfo((ComponentInfo)activity.info);
        resolveInfo.activityInfo = activity.info;
        return resolveInfo;
    }

    static ResolveInfo buildResolveInfo(PackageParser.Service service) {
        ResolveInfo resolveInfo = ShadowApplicationPackageManager.buildResolveInfo((ComponentInfo)service.info);
        resolveInfo.serviceInfo = service.info;
        return resolveInfo;
    }

    static ResolveInfo buildResolveInfo(PackageParser.Provider provider) {
        ResolveInfo resolveInfo = ShadowApplicationPackageManager.buildResolveInfo((ComponentInfo)provider.info);
        resolveInfo.providerInfo = provider.info;
        return resolveInfo;
    }

    private static ResolveInfo buildResolveInfo(ComponentInfo componentInfo) {
        ResolveInfo resolveInfo = new ResolveInfo();
        resolveInfo.resolvePackageName = componentInfo.applicationInfo.packageName;
        return resolveInfo;
    }

    static ResolveInfo buildResolveInfo(PackageParser.Activity activity, IntentFilter intentFilter) {
        ResolveInfo info = ShadowApplicationPackageManager.buildResolveInfo(activity);
        info.isDefault = intentFilter.hasCategory("Intent.CATEGORY_DEFAULT");
        info.filter = new IntentFilter(intentFilter);
        return info;
    }

    static ResolveInfo buildResolveInfo(PackageParser.Service service, IntentFilter intentFilter) {
        ResolveInfo info = ShadowApplicationPackageManager.buildResolveInfo(service);
        info.isDefault = intentFilter.hasCategory("Intent.CATEGORY_DEFAULT");
        info.serviceInfo = service.info;
        info.filter = new IntentFilter(intentFilter);
        return info;
    }

    @Implementation
    protected int checkPermission(String permName, String pkgName) {
        PackageInfo permissionsInfo = (PackageInfo)packageInfos.get(pkgName);
        if (permissionsInfo == null || permissionsInfo.requestedPermissions == null) {
            return -1;
        }
        for (int i = 0; i < permissionsInfo.requestedPermissions.length; ++i) {
            String permission2 = permissionsInfo.requestedPermissions[i];
            if (permission2 == null || !permission2.equals(permName)) continue;
            if (this.isGrantedForBackwardsCompatibility(pkgName, permissionsInfo)) {
                return 0;
            }
            if ((permissionsInfo.requestedPermissionsFlags[i] & 2) != 2) continue;
            return 0;
        }
        return -1;
    }

    private boolean isGrantedForBackwardsCompatibility(String pkgName, PackageInfo permissionsInfo) {
        return permissionsInfo.requestedPermissionsFlags == null || pkgName.equals(RuntimeEnvironment.application.getPackageName());
    }

    @Implementation
    protected ActivityInfo getReceiverInfo(ComponentName className, int flags) throws PackageManager.NameNotFoundException {
        String packageName = className.getPackageName();
        PackageInfo packageInfo = (PackageInfo)packageInfos.get(packageName);
        if (packageInfo != null && packageInfo.receivers != null) {
            for (ActivityInfo receiver : packageInfo.receivers) {
                if (!ShadowApplicationPackageManager.resolvePackageName(packageName, className).equals(receiver.name)) continue;
                ActivityInfo result = new ActivityInfo();
                result.packageName = receiver.packageName;
                result.name = receiver.name;
                if ((flags & 0x80) != 0) {
                    result.metaData = receiver.metaData;
                }
                return result;
            }
        }
        return null;
    }

    @Implementation
    protected List<ResolveInfo> queryBroadcastReceivers(Intent intent, int flags) {
        ArrayList<ResolveInfo> result = new ArrayList<ResolveInfo>();
        List<ResolveInfo> resolveInfoList = this.queryOverriddenIntents(intent, flags);
        if (!resolveInfoList.isEmpty()) {
            result.addAll(this.filterResolvedComponent(resolveInfoList, flags, (Function<ResolveInfo, ComponentInfo>)((Function)resolveInfo -> resolveInfo.activityInfo)));
        }
        if (ShadowApplicationPackageManager.isExplicitIntent(intent)) {
            ResolveInfo resolvedReceiver = this.resolveReceiverForExplicitIntent(intent);
            if (resolvedReceiver != null) {
                result.addAll(this.filterResolvedComponent(Arrays.asList(resolvedReceiver), flags, (Function<ResolveInfo, ComponentInfo>)((Function)resolveInfo -> resolveInfo.activityInfo)));
            }
        } else {
            result.addAll(this.filterResolvedComponent(this.queryImplicitIntentReceivers(intent, flags), flags, (Function<ResolveInfo, ComponentInfo>)((Function)resolveInfo -> resolveInfo.activityInfo)));
        }
        return result;
    }

    private static IntentFilter matchIntentFilter(Intent intent, ArrayList<? extends PackageParser.IntentInfo> intentFilters, int flags) {
        for (PackageParser.IntentInfo intentInfo : intentFilters) {
            if (intentInfo.match(intent.getAction(), intent.getType(), intent.getScheme(), intent.getData(), intent.getCategories(), "ShadowPackageManager") < 0) continue;
            return intentInfo;
        }
        return null;
    }

    @Implementation
    protected ResolveInfo resolveService(Intent intent, int flags) {
        List<ResolveInfo> candidates = this.queryIntentServices(intent, flags);
        return candidates.isEmpty() ? null : candidates.get(0);
    }

    @Implementation
    protected ServiceInfo getServiceInfo(ComponentName className, int flags) throws PackageManager.NameNotFoundException {
        String packageName = className.getPackageName();
        PackageInfo packageInfo = (PackageInfo)packageInfos.get(packageName);
        if (packageInfo != null) {
            String serviceName = className.getClassName();
            if (packageInfo.services != null) {
                for (ServiceInfo service : packageInfo.services) {
                    if (!serviceName.equals(service.name)) continue;
                    ServiceInfo result = new ServiceInfo();
                    result.packageName = service.packageName;
                    result.name = service.name;
                    result.applicationInfo = service.applicationInfo;
                    result.permission = service.permission;
                    if ((flags & 0x80) != 0) {
                        result.metaData = service.metaData;
                    }
                    return result;
                }
            }
            throw new PackageManager.NameNotFoundException(serviceName);
        }
        return null;
    }

    @Implementation
    protected Resources getResourcesForApplication(ApplicationInfo applicationInfo) throws PackageManager.NameNotFoundException {
        return this.getResourcesForApplication(applicationInfo.packageName);
    }

    @Implementation
    protected List<ApplicationInfo> getInstalledApplications(int flags) {
        ArrayList<ApplicationInfo> result = new ArrayList<ApplicationInfo>();
        for (PackageInfo packageInfo : packageInfos.values()) {
            result.add(packageInfo.applicationInfo);
        }
        return result;
    }

    @Implementation
    protected String getInstallerPackageName(String packageName) {
        return (String)packageInstallerMap.get(packageName);
    }

    @Implementation
    protected PermissionInfo getPermissionInfo(String name, int flags) throws PackageManager.NameNotFoundException {
        PermissionInfo permissionInfo = (PermissionInfo)extraPermissions.get(name);
        if (permissionInfo != null) {
            return permissionInfo;
        }
        for (PackageInfo packageInfo : packageInfos.values()) {
            if (packageInfo.permissions == null) continue;
            for (PermissionInfo permission2 : packageInfo.permissions) {
                if (!name.equals(permission2.name)) continue;
                return ShadowApplicationPackageManager.createCopyPermissionInfo(permission2, flags);
            }
        }
        throw new PackageManager.NameNotFoundException(name);
    }

    @Implementation(minSdk=23)
    protected boolean shouldShowRequestPermissionRationale(String permission2) {
        return permissionRationaleMap.containsKey(permission2) ? (Boolean)permissionRationaleMap.get(permission2) : false;
    }

    @Implementation
    protected FeatureInfo[] getSystemAvailableFeatures() {
        return systemAvailableFeatures.isEmpty() ? null : systemAvailableFeatures.toArray(new FeatureInfo[systemAvailableFeatures.size()]);
    }

    @Implementation
    protected void verifyPendingInstall(int id2, int verificationCode) {
        if (verificationResults.containsKey(id2)) {
            throw new IllegalStateException("Multiple verifications for id=" + id2);
        }
        verificationResults.put(id2, verificationCode);
    }

    @Implementation(minSdk=17)
    protected void extendVerificationTimeout(int id2, int verificationCodeAtTimeout, long millisecondsToDelay) {
        verificationTimeoutExtension.put(id2, millisecondsToDelay);
    }

    @Override
    @Implementation(maxSdk=22)
    protected void freeStorageAndNotify(long freeStorageSize, IPackageDataObserver observer) {
    }

    @Implementation(minSdk=23)
    protected void freeStorageAndNotify(String volumeUuid, long freeStorageSize, IPackageDataObserver observer) {
    }

    @Implementation
    protected void setInstallerPackageName(String targetPackage, String installerPackageName) {
        packageInstallerMap.put(targetPackage, installerPackageName);
    }

    @Implementation(minSdk=19)
    protected List<ResolveInfo> queryIntentContentProviders(Intent intent, int flags) {
        ArrayList<ResolveInfo> result = new ArrayList<ResolveInfo>();
        List<ResolveInfo> resolveInfoList = this.queryOverriddenIntents(intent, flags);
        if (!resolveInfoList.isEmpty()) {
            result.addAll(this.filterResolvedComponent(resolveInfoList, flags, (Function<ResolveInfo, ComponentInfo>)((Function)resolveInfo -> resolveInfo.providerInfo)));
        }
        if (ShadowApplicationPackageManager.isExplicitIntent(intent)) {
            ResolveInfo resolvedProvider = this.resolveContentProviderForExplicitIntent(intent);
            if (resolvedProvider != null) {
                result.addAll(this.filterResolvedComponent(Arrays.asList(resolvedProvider), flags, (Function<ResolveInfo, ComponentInfo>)((Function)resolveInfo -> resolveInfo.providerInfo)));
            }
        } else {
            result.addAll(this.filterResolvedComponent(this.queryImplicitIntentContentProviders(intent, flags), flags, (Function<ResolveInfo, ComponentInfo>)((Function)resolveInfo -> resolveInfo.providerInfo)));
        }
        return result;
    }

    @Implementation(minSdk=19)
    protected List<ResolveInfo> queryIntentContentProvidersAsUser(Intent intent, int flags, int userId) {
        return Collections.emptyList();
    }

    @Implementation(minSdk=23)
    protected String getPermissionControllerPackageName() {
        return null;
    }

    @Implementation(maxSdk=16)
    protected void getPackageSizeInfo(Object pkgName, Object observer) {
        PackageStats packageStats = (PackageStats)packageStatsMap.get((String)pkgName);
        new Handler(Looper.getMainLooper()).post(() -> {
            try {
                ((IPackageStatsObserver)observer).onGetStatsCompleted(packageStats, packageStats != null);
            }
            catch (RemoteException remoteException) {
                remoteException.rethrowFromSystemServer();
            }
        });
    }

    @Implementation(minSdk=17, maxSdk=23)
    protected void getPackageSizeInfo(Object pkgName, Object uid, Object observer) {
        PackageStats packageStats = (PackageStats)packageStatsMap.get((String)pkgName);
        new Handler(Looper.getMainLooper()).post(() -> {
            try {
                ((IPackageStatsObserver)observer).onGetStatsCompleted(packageStats, packageStats != null);
            }
            catch (RemoteException remoteException) {
                remoteException.rethrowFromSystemServer();
            }
        });
    }

    @Implementation(minSdk=24)
    protected void getPackageSizeInfoAsUser(Object pkgName, Object uid, Object observer) {
        PackageStats packageStats = (PackageStats)packageStatsMap.get((String)pkgName);
        new Handler(Looper.getMainLooper()).post(() -> {
            try {
                ((IPackageStatsObserver)observer).onGetStatsCompleted(packageStats, packageStats != null);
            }
            catch (RemoteException remoteException) {
                remoteException.rethrowFromSystemServer();
            }
        });
    }

    @Implementation
    protected void deletePackage(String packageName, IPackageDeleteObserver observer, int flags) {
        pendingDeleteCallbacks.put(packageName, observer);
    }

    @Implementation
    protected String[] currentToCanonicalPackageNames(String[] names) {
        String[] out = new String[names.length];
        for (int i = names.length - 1; i >= 0; --i) {
            out[i] = currentToCanonicalNames.containsKey(names[i]) ? (String)currentToCanonicalNames.get(names[i]) : names[i];
        }
        return out;
    }

    @Implementation
    protected boolean isSafeMode() {
        return false;
    }

    @Implementation
    protected Drawable getApplicationIcon(String packageName) throws PackageManager.NameNotFoundException {
        return (Drawable)applicationIcons.get(packageName);
    }

    @Implementation
    protected Drawable getApplicationIcon(ApplicationInfo info) {
        return null;
    }

    @Implementation(minSdk=21)
    protected Drawable getUserBadgeForDensity(UserHandle userHandle, int i) {
        return null;
    }

    @Implementation
    protected int checkSignatures(String pkg1, String pkg2) {
        try {
            PackageInfo packageInfo1 = this.getPackageInfo(pkg1, 64);
            PackageInfo packageInfo2 = this.getPackageInfo(pkg2, 64);
            return ShadowApplicationPackageManager.compareSignature(packageInfo1.signatures, packageInfo2.signatures);
        }
        catch (PackageManager.NameNotFoundException e) {
            return -4;
        }
    }

    @Implementation
    protected int checkSignatures(int uid1, int uid2) {
        return 0;
    }

    @Implementation
    protected List<PermissionInfo> queryPermissionsByGroup(String group, int flags) throws PackageManager.NameNotFoundException {
        ArrayList<PermissionInfo> result = new ArrayList<PermissionInfo>();
        for (PermissionInfo permissionInfo : extraPermissions.values()) {
            if (!Objects.equals(permissionInfo.group, group)) continue;
            result.add(permissionInfo);
        }
        for (PackageInfo packageInfo : packageInfos.values()) {
            if (packageInfo.permissions == null) continue;
            for (PermissionInfo permission2 : packageInfo.permissions) {
                if (!Objects.equals(group, permission2.group)) continue;
                result.add(ShadowApplicationPackageManager.createCopyPermissionInfo(permission2, flags));
            }
        }
        if (result.isEmpty()) {
            throw new PackageManager.NameNotFoundException(group);
        }
        return result;
    }

    private static PermissionInfo createCopyPermissionInfo(PermissionInfo src, int flags) {
        PermissionInfo matchedPermission = new PermissionInfo(src);
        if ((flags & 0x80) != 128) {
            matchedPermission.metaData = null;
        }
        return matchedPermission;
    }

    @Implementation
    protected Intent getLaunchIntentForPackage(String packageName) {
        Intent intentToResolve = new Intent("android.intent.action.MAIN");
        intentToResolve.addCategory("android.intent.category.INFO");
        intentToResolve.setPackage(packageName);
        List<ResolveInfo> ris = this.queryIntentActivities(intentToResolve, 0);
        if (ris == null || ris.isEmpty()) {
            intentToResolve.removeCategory("android.intent.category.INFO");
            intentToResolve.addCategory("android.intent.category.LAUNCHER");
            intentToResolve.setPackage(packageName);
            ris = this.queryIntentActivities(intentToResolve, 0);
        }
        if (ris == null || ris.isEmpty()) {
            return null;
        }
        Intent intent = new Intent(intentToResolve);
        intent.setFlags(0x10000000);
        intent.setClassName(packageName, ris.get((int)0).activityInfo.name);
        return intent;
    }

    @Implementation(minSdk=24)
    protected PackageInfo getPackageInfoAsUser(String packageName, int flags, int userId) throws PackageManager.NameNotFoundException {
        return null;
    }

    @Implementation
    protected String[] canonicalToCurrentPackageNames(String[] names) {
        return new String[0];
    }

    @Implementation
    protected int[] getPackageGids(String packageName) throws PackageManager.NameNotFoundException {
        return new int[0];
    }

    @Implementation(minSdk=24)
    protected int[] getPackageGids(String packageName, int flags) throws PackageManager.NameNotFoundException {
        return null;
    }

    @Implementation(minSdk=18)
    protected int getPackageUid(String packageName, int flags) throws PackageManager.NameNotFoundException {
        Integer uid = (Integer)uidForPackage.get(packageName);
        if (uid == null) {
            throw new PackageManager.NameNotFoundException(packageName);
        }
        return uid;
    }

    @Implementation(minSdk=24)
    protected int getPackageUidAsUser(String packageName, int userId) throws PackageManager.NameNotFoundException {
        return 0;
    }

    @Implementation(minSdk=24)
    protected int getPackageUidAsUser(String packageName, int flags, int userId) throws PackageManager.NameNotFoundException {
        return 0;
    }

    @Implementation
    protected PermissionGroupInfo getPermissionGroupInfo(String name, int flags) throws PackageManager.NameNotFoundException {
        if (extraPermissionGroups.containsKey(name)) {
            return new PermissionGroupInfo((PermissionGroupInfo)extraPermissionGroups.get(name));
        }
        for (PackageParser.Package pkg : packages.values()) {
            for (PackageParser.PermissionGroup permissionGroup : pkg.permissionGroups) {
                if (!name.equals(permissionGroup.info.name)) continue;
                return PackageParser.generatePermissionGroupInfo((PackageParser.PermissionGroup)permissionGroup, (int)flags);
            }
        }
        throw new PackageManager.NameNotFoundException(name);
    }

    @Implementation
    protected List<PermissionGroupInfo> getAllPermissionGroups(int flags) {
        ArrayList<PermissionGroupInfo> allPermissionGroups = new ArrayList<PermissionGroupInfo>();
        HashSet<String> handledPermissionGroups = new HashSet<String>();
        for (PermissionGroupInfo permissionGroupInfo : extraPermissionGroups.values()) {
            allPermissionGroups.add(new PermissionGroupInfo(permissionGroupInfo));
            handledPermissionGroups.add(permissionGroupInfo.name);
        }
        for (PackageParser.Package pkg : packages.values()) {
            for (PackageParser.PermissionGroup permissionGroup : pkg.permissionGroups) {
                if (handledPermissionGroups.contains(permissionGroup.info.name)) continue;
                PermissionGroupInfo permissionGroupInfo = PackageParser.generatePermissionGroupInfo((PackageParser.PermissionGroup)permissionGroup, (int)flags);
                allPermissionGroups.add(new PermissionGroupInfo(permissionGroupInfo));
                handledPermissionGroups.add(permissionGroup.info.name);
            }
        }
        return allPermissionGroups;
    }

    @Implementation
    protected ApplicationInfo getApplicationInfo(String packageName, int flags) throws PackageManager.NameNotFoundException {
        PackageInfo info = (PackageInfo)packageInfos.get(packageName);
        if (info != null) {
            try {
                PackageInfo packageInfo = this.getPackageInfo(packageName, -1);
            }
            catch (PackageManager.NameNotFoundException e) {
                throw new IllegalArgumentException(e);
            }
            if ((Integer)applicationEnabledSettingMap.get(packageName) == 2 && (flags & 0x2000) != 8192 && (flags & 0x200) != 512) {
                throw new PackageManager.NameNotFoundException("Package is disabled, can't find");
            }
            if (hiddenPackages.contains(packageName) && !ShadowApplicationPackageManager.isFlagSet(flags, 8192)) {
                throw new PackageManager.NameNotFoundException("Package is hidden, can't find");
            }
            return info.applicationInfo;
        }
        throw new PackageManager.NameNotFoundException(packageName);
    }

    @Implementation
    protected String[] getSystemSharedLibraryNames() {
        return systemSharedLibraryNames.toArray(new String[systemSharedLibraryNames.size()]);
    }

    @Implementation(minSdk=24)
    protected String getServicesSystemSharedLibraryPackageName() {
        return null;
    }

    @Implementation(minSdk=24)
    protected String getSharedSystemSharedLibraryPackageName() {
        return "";
    }

    @Implementation(minSdk=24)
    protected boolean hasSystemFeature(String name, int version) {
        return false;
    }

    @Implementation(minSdk=23)
    protected boolean isPermissionRevokedByPolicy(String permName, String pkgName) {
        return false;
    }

    @Implementation
    protected boolean addPermission(PermissionInfo info) {
        return false;
    }

    @Implementation
    protected boolean addPermissionAsync(PermissionInfo info) {
        return false;
    }

    @Implementation
    protected void removePermission(String name) {
    }

    @Implementation(minSdk=23)
    protected void grantRuntimePermission(String packageName, String permissionName, UserHandle user) {
        if (!packageInfos.containsKey(packageName)) {
            throw new SecurityException("Package not found: " + packageName);
        }
        PackageInfo packageInfo = (PackageInfo)packageInfos.get(packageName);
        this.checkPermissionGrantStateInitialized(packageInfo);
        int permissionIndex = this.getPermissionIndex(packageInfo, permissionName);
        if (permissionIndex < 0) {
            throw new SecurityException("Permission " + permissionName + " not requested by package " + packageName);
        }
        int n = permissionIndex;
        packageInfo.requestedPermissionsFlags[n] = packageInfo.requestedPermissionsFlags[n] | 2;
    }

    @Implementation(minSdk=23)
    protected void revokeRuntimePermission(String packageName, String permissionName, UserHandle user) {
        if (!packageInfos.containsKey(packageName)) {
            throw new SecurityException("Package not found: " + packageName);
        }
        PackageInfo packageInfo = (PackageInfo)packageInfos.get(packageName);
        this.checkPermissionGrantStateInitialized(packageInfo);
        int permissionIndex = this.getPermissionIndex(packageInfo, permissionName);
        if (permissionIndex < 0) {
            throw new SecurityException("Permission " + permissionName + " not requested by package " + packageName);
        }
        int n = permissionIndex;
        packageInfo.requestedPermissionsFlags[n] = packageInfo.requestedPermissionsFlags[n] & 0xFFFFFFFD;
    }

    private void checkPermissionGrantStateInitialized(PackageInfo packageInfo) {
        if (packageInfo.requestedPermissionsFlags == null) {
            throw new SecurityException("Permission grant state (PackageInfo.requestedPermissionFlags) is null. This operation requires this variable to be initialized.");
        }
    }

    private int getPermissionIndex(PackageInfo packageInfo, String permissionName) {
        if (packageInfo.requestedPermissions != null) {
            for (int i = 0; i < packageInfo.requestedPermissions.length; ++i) {
                if (!permissionName.equals(packageInfo.requestedPermissions[i])) continue;
                return i;
            }
        }
        return -1;
    }

    @Implementation(minSdk=23)
    protected int getPermissionFlags(String permissionName, String packageName, UserHandle user) {
        return 0;
    }

    @Implementation(minSdk=23)
    protected void updatePermissionFlags(String permissionName, String packageName, int flagMask, int flagValues, UserHandle user) {
    }

    @Implementation
    protected int getUidForSharedUser(String sharedUserName) throws PackageManager.NameNotFoundException {
        return 0;
    }

    @Implementation(minSdk=24)
    protected List<PackageInfo> getInstalledPackagesAsUser(int flags, int userId) {
        return null;
    }

    @Implementation(minSdk=18)
    protected List<PackageInfo> getPackagesHoldingPermissions(String[] permissions, int flags) {
        return null;
    }

    @Implementation(minSdk=17)
    protected ResolveInfo resolveActivityAsUser(Intent intent, int flags, int userId) {
        return null;
    }

    @Implementation
    protected List<ResolveInfo> queryIntentActivityOptions(ComponentName caller, Intent[] specifics, Intent intent, int flags) {
        return null;
    }

    @Implementation(minSdk=24)
    protected List<ResolveInfo> queryBroadcastReceiversAsUser(Intent intent, int flags, int userId) {
        return null;
    }

    @Implementation
    protected List<ProviderInfo> queryContentProviders(String processName, int uid, int flags) {
        return null;
    }

    @Implementation
    protected InstrumentationInfo getInstrumentationInfo(ComponentName className, int flags) throws PackageManager.NameNotFoundException {
        return null;
    }

    @Implementation
    protected List<InstrumentationInfo> queryInstrumentation(String targetPackage, int flags) {
        return null;
    }

    @Implementation
    protected Drawable getDrawable(String packageName, int resId, ApplicationInfo appInfo) {
        return (Drawable)drawables.get(new Pair((Object)packageName, (Object)resId));
    }

    @Implementation
    protected Drawable getActivityIcon(ComponentName activityName) throws PackageManager.NameNotFoundException {
        return (Drawable)drawableList.get(activityName);
    }

    @Implementation
    protected Drawable getDefaultActivityIcon() {
        return Resources.getSystem().getDrawable(17301651);
    }

    @Implementation(minSdk=21)
    protected Drawable getActivityBanner(ComponentName activityName) throws PackageManager.NameNotFoundException {
        return null;
    }

    @Implementation(minSdk=21)
    protected Drawable getActivityBanner(Intent intent) throws PackageManager.NameNotFoundException {
        return null;
    }

    @Implementation(minSdk=21)
    protected Drawable getApplicationBanner(ApplicationInfo info) {
        return null;
    }

    @Implementation(minSdk=21)
    protected Drawable getApplicationBanner(String packageName) throws PackageManager.NameNotFoundException {
        return null;
    }

    @Implementation
    protected Drawable getActivityLogo(ComponentName activityName) throws PackageManager.NameNotFoundException {
        return null;
    }

    @Implementation
    protected Drawable getActivityLogo(Intent intent) throws PackageManager.NameNotFoundException {
        return null;
    }

    @Implementation
    protected Drawable getApplicationLogo(ApplicationInfo info) {
        return null;
    }

    @Implementation
    protected Drawable getApplicationLogo(String packageName) throws PackageManager.NameNotFoundException {
        return null;
    }

    @Implementation(minSdk=21)
    protected Drawable getUserBadgedIcon(Drawable icon, UserHandle user) {
        return null;
    }

    @Implementation(minSdk=21)
    protected Drawable getUserBadgedDrawableForDensity(Drawable drawable2, UserHandle user, Rect badgeLocation, int badgeDensity) {
        return null;
    }

    @Implementation(minSdk=24)
    protected Drawable getUserBadgeForDensityNoBackground(UserHandle user, int density) {
        return null;
    }

    @Implementation(minSdk=21)
    protected CharSequence getUserBadgedLabel(CharSequence label, UserHandle user) {
        return null;
    }

    @Implementation
    protected Resources getResourcesForActivity(ComponentName activityName) throws PackageManager.NameNotFoundException {
        return null;
    }

    @Implementation
    protected Resources getResourcesForApplication(String appPackageName) throws PackageManager.NameNotFoundException {
        if (this.context.getPackageName().equals(appPackageName)) {
            return this.context.getResources();
        }
        if (packageInfos.containsKey(appPackageName)) {
            Resources appResources = (Resources)resources.get(appPackageName);
            if (appResources == null) {
                appResources = new Resources(new AssetManager(), null, null);
                resources.put(appPackageName, appResources);
            }
            return appResources;
        }
        throw new PackageManager.NameNotFoundException(appPackageName);
    }

    @Implementation(minSdk=17)
    protected Resources getResourcesForApplicationAsUser(String appPackageName, int userId) throws PackageManager.NameNotFoundException {
        return null;
    }

    @Implementation(minSdk=23)
    protected void addOnPermissionsChangeListener(Object listener) {
    }

    @Implementation(minSdk=23)
    protected void removeOnPermissionsChangeListener(Object listener) {
    }

    @Implementation(maxSdk=27)
    protected void installPackage(Object packageURI, Object observer, Object flags, Object installerPackageName) {
    }

    @Implementation(minSdk=17)
    protected int installExistingPackage(String packageName) throws PackageManager.NameNotFoundException {
        return 0;
    }

    @Implementation(minSdk=24)
    protected int installExistingPackageAsUser(String packageName, int userId) throws PackageManager.NameNotFoundException {
        return 0;
    }

    @Implementation(minSdk=23)
    protected void verifyIntentFilter(int id2, int verificationCode, List<String> failedDomains) {
    }

    @Implementation(minSdk=24)
    protected int getIntentVerificationStatusAsUser(String packageName, int userId) {
        return 0;
    }

    @Implementation(minSdk=24)
    protected boolean updateIntentVerificationStatusAsUser(String packageName, int status, int userId) {
        return false;
    }

    @Implementation(minSdk=23)
    protected List<IntentFilterVerificationInfo> getIntentFilterVerifications(String packageName) {
        return null;
    }

    @Implementation(minSdk=23)
    protected List<IntentFilter> getAllIntentFilters(String packageName) {
        return null;
    }

    @Implementation(minSdk=24)
    protected String getDefaultBrowserPackageNameAsUser(int userId) {
        return null;
    }

    @Implementation(minSdk=24)
    protected boolean setDefaultBrowserPackageNameAsUser(String packageName, int userId) {
        return false;
    }

    @Implementation(minSdk=23)
    protected int getMoveStatus(int moveId) {
        return 0;
    }

    @Implementation(minSdk=23)
    protected void registerMoveCallback(Object callback, Object handler) {
    }

    @Implementation(minSdk=23)
    protected void unregisterMoveCallback(Object callback) {
    }

    @Implementation(minSdk=23)
    protected Object movePackage(Object packageName, Object vol) {
        return 0;
    }

    @Implementation(minSdk=23)
    protected Object getPackageCurrentVolume(Object app) {
        return null;
    }

    @Implementation(minSdk=23)
    protected List<VolumeInfo> getPackageCandidateVolumes(ApplicationInfo app) {
        return null;
    }

    @Implementation(minSdk=23)
    protected Object movePrimaryStorage(Object vol) {
        return 0;
    }

    @Implementation(minSdk=23)
    protected Object getPrimaryStorageCurrentVolume() {
        return null;
    }

    @Implementation(minSdk=23)
    protected List<VolumeInfo> getPrimaryStorageCandidateVolumes() {
        return null;
    }

    @Implementation(minSdk=24)
    protected void deletePackageAsUser(String packageName, IPackageDeleteObserver observer, int flags, int userId) {
    }

    @Implementation
    protected void clearApplicationUserData(String packageName, IPackageDataObserver observer) {
    }

    @Implementation
    protected void deleteApplicationCacheFiles(String packageName, IPackageDataObserver observer) {
    }

    @Implementation(minSdk=24)
    protected void deleteApplicationCacheFilesAsUser(String packageName, int userId, IPackageDataObserver observer) {
    }

    @Implementation(minSdk=23)
    protected void freeStorage(String volumeUuid, long freeStorageSize, IntentSender pi) {
    }

    @Implementation(minSdk=24, maxSdk=27)
    protected String[] setPackagesSuspendedAsUser(String[] packageNames, boolean suspended, int userId) {
        return null;
    }

    @Implementation(minSdk=24)
    protected boolean isPackageSuspendedForUser(String packageName, int userId) {
        return false;
    }

    @Implementation
    protected void addPackageToPreferred(String packageName) {
    }

    @Implementation
    protected void removePackageFromPreferred(String packageName) {
    }

    @Implementation
    protected List<PackageInfo> getPreferredPackages(int flags) {
        return null;
    }

    @Implementation
    public void addPreferredActivity(IntentFilter filter, int match, ComponentName[] set, ComponentName activity) {
        preferredActivities.put(new ShadowPackageManager.IntentFilterWrapper(filter), activity);
    }

    @Implementation
    protected void replacePreferredActivity(IntentFilter filter, int match, ComponentName[] set, ComponentName activity) {
        this.addPreferredActivity(filter, match, set, activity);
    }

    @Implementation
    public int getPreferredActivities(List<IntentFilter> outFilters, List<ComponentName> outActivities, String packageName) {
        if (outFilters == null) {
            return 0;
        }
        Set filters = preferredActivities.keySet();
        for (IntentFilter filter : outFilters) {
            block1: for (ShadowPackageManager.IntentFilterWrapper testFilterWrapper : filters) {
                ComponentName name = (ComponentName)preferredActivities.get(testFilterWrapper);
                IntentFilter testFilter = testFilterWrapper.getFilter();
                if (packageName != null && !name.getPackageName().equals(packageName)) continue;
                Iterator iterator = filter.actionsIterator();
                while (iterator.hasNext()) {
                    if (testFilter.matchAction((String)iterator.next())) continue;
                    continue block1;
                }
                iterator = filter.categoriesIterator();
                while (iterator.hasNext()) {
                    if (filter.hasCategory((String)iterator.next())) continue;
                    continue block1;
                }
                if (outActivities == null) {
                    outActivities = new ArrayList<ComponentName>();
                }
                outActivities.add(name);
            }
        }
        return 0;
    }

    @Implementation
    protected void clearPackagePreferredActivities(String packageName) {
        Iterator entryIterator = preferredActivities.values().iterator();
        while (entryIterator.hasNext()) {
            ComponentName next = (ComponentName)entryIterator.next();
            if (!next.getPackageName().equals(packageName)) continue;
            entryIterator.remove();
        }
    }

    @Implementation(minSdk=19)
    protected ComponentName getHomeActivities(List<ResolveInfo> outActivities) {
        return null;
    }

    @Implementation(minSdk=24)
    protected void flushPackageRestrictionsAsUser(int userId) {
    }

    @Implementation(minSdk=21)
    protected boolean setApplicationHiddenSettingAsUser(String packageName, boolean hidden, UserHandle user) {
        if (!packageInfos.containsKey(packageName)) {
            return false;
        }
        if (hidden) {
            hiddenPackages.add(packageName);
        } else {
            hiddenPackages.remove(packageName);
        }
        return true;
    }

    @Implementation(minSdk=21)
    protected boolean getApplicationHiddenSettingAsUser(String packageName, UserHandle user) {
        if (!packageInfos.containsKey(packageName)) {
            return true;
        }
        return hiddenPackages.contains(packageName);
    }

    @Implementation(minSdk=21)
    protected Object getKeySetByAlias(String packageName, String alias) {
        return null;
    }

    @Implementation(minSdk=21)
    protected Object getSigningKeySet(String packageName) {
        return null;
    }

    @Implementation(minSdk=21)
    protected boolean isSignedBy(String packageName, Object ks) {
        return false;
    }

    @Implementation(minSdk=21)
    protected boolean isSignedByExactly(String packageName, Object ks) {
        return false;
    }

    @Implementation
    protected VerifierDeviceIdentity getVerifierDeviceIdentity() {
        return null;
    }

    @Implementation(minSdk=22)
    protected boolean isUpgrade() {
        return false;
    }

    @Implementation(minSdk=21)
    protected boolean isPackageAvailable(String packageName) {
        return false;
    }

    @Implementation(minSdk=21)
    protected void addCrossProfileIntentFilter(IntentFilter filter, int sourceUserId, int targetUserId, int flags) {
    }

    @Implementation(minSdk=21)
    protected void clearCrossProfileIntentFilters(int sourceUserId) {
    }

    @Implementation(minSdk=21)
    protected Drawable loadItemIcon(PackageItemInfo itemInfo, ApplicationInfo appInfo) {
        return null;
    }

    @Implementation(minSdk=22)
    protected Drawable loadUnbadgedItemIcon(PackageItemInfo itemInfo, ApplicationInfo appInfo) {
        return (Drawable)unbadgedApplicationIcons.get(itemInfo.packageName);
    }

    @Implementation(minSdk=26)
    protected boolean canRequestPackageInstalls() {
        return canRequestPackageInstalls;
    }

    @Implementation(minSdk=26)
    protected Object getChangedPackages(int sequenceNumber) {
        if (sequenceNumber < 0 || sequenceNumberChangedPackagesMap.get((Object)sequenceNumber).isEmpty()) {
            return null;
        }
        return new ChangedPackages(sequenceNumber + 1, new ArrayList(sequenceNumberChangedPackagesMap.get((Object)sequenceNumber)));
    }

    @Implementation(minSdk=28)
    public String getSystemTextClassifierPackageName() {
        return "";
    }

    @Implementation(minSdk=28)
    @HiddenApi
    protected String[] setPackagesSuspended(String[] packageNames, boolean suspended, PersistableBundle appExtras, PersistableBundle launcherExtras, String dialogMessage) {
        if (this.hasProfileOwnerOrDeviceOwnerOnCurrentUser()) {
            throw new UnsupportedOperationException();
        }
        ArrayList<String> unupdatedPackages = new ArrayList<String>();
        for (String packageName : packageNames) {
            if (!this.canSuspendPackage(packageName)) {
                unupdatedPackages.add(packageName);
                continue;
            }
            ShadowPackageManager.PackageSetting setting = (ShadowPackageManager.PackageSetting)packageSettings.get(packageName);
            if (setting == null) {
                unupdatedPackages.add(packageName);
                continue;
            }
            setting.setSuspended(suspended, dialogMessage, appExtras, launcherExtras);
        }
        return unupdatedPackages.toArray(new String[0]);
    }

    private boolean hasProfileOwnerOrDeviceOwnerOnCurrentUser() {
        DevicePolicyManager devicePolicyManager = (DevicePolicyManager)this.context.getSystemService("device_policy");
        return devicePolicyManager.getProfileOwner() != null || UserHandle.of((int)UserHandle.myUserId()).isSystem() && devicePolicyManager.getDeviceOwner() != null;
    }

    private boolean canSuspendPackage(String packageName) {
        return !packageName.equals(this.context.getPackageName()) && !this.isPackageDeviceAdmin(packageName) && !this.isPackageActiveLauncher(packageName) && !this.isPackageRequiredInstaller(packageName) && !this.isPackageRequiredUninstaller(packageName) && !this.isPackageRequiredVerifier(packageName) && !this.isPackageDefaultDialer(packageName) && !packageName.equals(PLATFORM_PACKAGE_NAME);
    }

    private boolean isPackageDeviceAdmin(String packageName) {
        DevicePolicyManager devicePolicyManager = (DevicePolicyManager)this.context.getSystemService("device_policy");
        return packageName.equals(devicePolicyManager.getDeviceOwner());
    }

    private boolean isPackageActiveLauncher(String packageName) {
        Intent intent = new Intent("android.intent.action.MAIN").addCategory("android.intent.category.HOME");
        ResolveInfo info = this.resolveActivity(intent, 65536);
        return info != null && packageName.equals(info.activityInfo.packageName);
    }

    private boolean isPackageRequiredInstaller(String packageName) {
        Intent intent = new Intent("android.intent.action.INSTALL_PACKAGE");
        intent.addCategory("android.intent.category.DEFAULT");
        intent.setDataAndType(Uri.fromFile((File)new File("foo.apk")), PACKAGE_MIME_TYPE);
        ResolveInfo info = this.resolveActivity(intent, 0x1C0000);
        return info != null && packageName.equals(info.activityInfo.packageName);
    }

    private boolean isPackageRequiredUninstaller(String packageName) {
        Intent intent = new Intent("android.intent.action.UNINSTALL_PACKAGE");
        intent.addCategory("android.intent.category.DEFAULT");
        intent.setData(Uri.fromParts((String)PACKAGE_SCHEME, (String)"foo.bar", null));
        ResolveInfo info = this.resolveActivity(intent, 0x1C0000);
        return info != null && packageName.equals(info.activityInfo.packageName);
    }

    private boolean isPackageRequiredVerifier(String packageName) {
        Intent intent = new Intent("android.intent.action.PACKAGE_NEEDS_VERIFICATION");
        List<ResolveInfo> infos = this.queryBroadcastReceivers(intent, 0x1C0000);
        if (infos != null) {
            for (ResolveInfo info : infos) {
                if (!packageName.equals(info.activityInfo.packageName)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean isPackageDefaultDialer(String packageName) {
        TelecomManager telecomManager = (TelecomManager)this.context.getSystemService("telecom");
        return packageName.equals(telecomManager.getDefaultDialerPackage());
    }

    @HiddenApi
    @Implementation(minSdk=28)
    protected boolean isPackageSuspended(String packageName) throws PackageManager.NameNotFoundException {
        ShadowPackageManager.PackageSetting setting = (ShadowPackageManager.PackageSetting)packageSettings.get(packageName);
        if (setting == null) {
            throw new PackageManager.NameNotFoundException(packageName);
        }
        return setting.isSuspended();
    }
}

