/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.shadows;

import android.util.TypedValue;
import org.robolectric.res.AttrData;
import org.robolectric.shadows.ResourceHelper;
import org.robolectric.shadows.ResourceHelper2;
import org.robolectric.util.Util;

public class Converter2<T> {
    private static int nextStringCookie = 764581;

    static synchronized int getNextStringCookie() {
        return nextStringCookie++;
    }

    public static Converter2 getConverterFor(AttrData attrData, String type) {
        switch (type) {
            case "enum": {
                return new EnumConverter(attrData);
            }
            case "flag": 
            case "flags": {
                return new FlagConverter(attrData);
            }
            case "boolean": {
                return new FromBoolean();
            }
            case "color": {
                return new FromColor();
            }
            case "dimension": {
                return new FromDimen();
            }
            case "float": {
                return new FromFloat();
            }
            case "integer": {
                return new FromInt();
            }
            case "string": {
                return new FromCharSequence();
            }
            case "fraction": {
                return new FromFraction();
            }
        }
        throw new UnsupportedOperationException("Type not supported: " + type);
    }

    public boolean fillTypedValue(T data, TypedValue typedValue, boolean throwOnFailure) {
        return false;
    }

    private static int convertInt(String rawValue) {
        try {
            return (int)Long.parseLong(rawValue);
        }
        catch (NumberFormatException nfe) {
            return Long.decode(rawValue).intValue();
        }
    }

    private static class EnumOrFlagConverter
    extends Converter2<String> {
        private final AttrData attrData;

        EnumOrFlagConverter(AttrData attrData) {
            this.attrData = attrData;
        }

        int findValueFor(String key) {
            String valueFor = this.attrData.getValueFor(key);
            if (valueFor == null) {
                if (this.attrData.isValue(key)) {
                    valueFor = key;
                } else {
                    throw new RuntimeException("no value found for " + key);
                }
            }
            return Util.parseInt((String)valueFor);
        }
    }

    private static class FlagConverter
    extends EnumOrFlagConverter {
        FlagConverter(AttrData attrData) {
            super(attrData);
        }

        @Override
        public boolean fillTypedValue(String data, TypedValue typedValue, boolean throwOnFailure) {
            int flags = 0;
            for (String key : data.split("\\|")) {
                if (throwOnFailure) {
                    flags |= this.findValueFor(key);
                    continue;
                }
                try {
                    flags |= this.findValueFor(key);
                }
                catch (Exception e) {
                    return false;
                }
            }
            typedValue.type = 17;
            typedValue.data = flags;
            typedValue.assetCookie = 0;
            typedValue.string = null;
            return true;
        }
    }

    private static class EnumConverter
    extends EnumOrFlagConverter {
        EnumConverter(AttrData attrData) {
            super(attrData);
        }

        @Override
        public boolean fillTypedValue(String data, TypedValue typedValue, boolean throwOnFailure) {
            typedValue.type = 17;
            if (throwOnFailure) {
                typedValue.data = this.findValueFor(data);
            } else {
                try {
                    typedValue.data = this.findValueFor(data);
                }
                catch (Exception e) {
                    return false;
                }
            }
            typedValue.assetCookie = 0;
            typedValue.string = null;
            return true;
        }
    }

    private static class FromDimen
    extends Converter2<String> {
        private FromDimen() {
        }

        @Override
        public boolean fillTypedValue(String data, TypedValue typedValue, boolean throwOnFailure) {
            return ResourceHelper2.parseFloatAttribute(null, data, typedValue, true);
        }
    }

    private static class FromBoolean
    extends Converter2<String> {
        private FromBoolean() {
        }

        @Override
        public boolean fillTypedValue(String data, TypedValue typedValue, boolean throwOnFailure) {
            typedValue.type = 18;
            typedValue.assetCookie = 0;
            typedValue.string = null;
            if ("true".equalsIgnoreCase(data)) {
                typedValue.data = 1;
                return true;
            }
            if ("false".equalsIgnoreCase(data)) {
                typedValue.data = 0;
                return true;
            }
            return false;
        }
    }

    private static class FromFloat
    extends Converter2<String> {
        private FromFloat() {
        }

        @Override
        public boolean fillTypedValue(String data, TypedValue typedValue, boolean throwOnFailure) {
            return ResourceHelper2.parseFloatAttribute(null, data, typedValue, false);
        }
    }

    private static class FromFraction
    extends Converter2<String> {
        private FromFraction() {
        }

        @Override
        public boolean fillTypedValue(String data, TypedValue typedValue, boolean throwOnFailure) {
            return ResourceHelper2.parseFloatAttribute(null, data, typedValue, false);
        }
    }

    private static class FromInt
    extends Converter2<String> {
        private FromInt() {
        }

        @Override
        public boolean fillTypedValue(String data, TypedValue typedValue, boolean throwOnFailure) {
            try {
                typedValue.type = data.startsWith("0x") ? 17 : 16;
                typedValue.data = Converter2.convertInt(data);
                typedValue.assetCookie = 0;
                typedValue.string = null;
                return true;
            }
            catch (NumberFormatException nfe) {
                return false;
            }
        }
    }

    public static class FromColor
    extends Converter2<String> {
        @Override
        public boolean fillTypedValue(String data, TypedValue typedValue, boolean throwOnFailure) {
            try {
                typedValue.type = ResourceHelper.getColorType(data);
                typedValue.data = ResourceHelper.getColor(data);
                typedValue.assetCookie = 0;
                typedValue.string = null;
                return true;
            }
            catch (NumberFormatException nfe) {
                return false;
            }
        }
    }

    public static class FromCharSequence
    extends Converter2<String> {
        @Override
        public boolean fillTypedValue(String data, TypedValue typedValue, boolean throwOnFailure) {
            typedValue.type = 3;
            typedValue.data = 0;
            typedValue.assetCookie = FromCharSequence.getNextStringCookie();
            typedValue.string = data;
            return true;
        }
    }
}

