/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.shadows;

import android.content.res.AssetManager;
import android.graphics.FontFamily;
import android.graphics.Typeface;
import android.util.ArrayMap;
import java.io.File;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.robolectric.RuntimeEnvironment;
import org.robolectric.Shadows;
import org.robolectric.annotation.HiddenApi;
import org.robolectric.annotation.Implementation;
import org.robolectric.annotation.Implements;
import org.robolectric.annotation.RealObject;
import org.robolectric.annotation.Resetter;
import org.robolectric.res.FsFile;
import org.robolectric.util.ReflectionHelpers;

@Implements(value=Typeface.class, looseSignatures=true)
public class ShadowTypeface {
    private static Map<Long, FontDesc> FONTS = new HashMap<Long, FontDesc>();
    private static long nextFontId = 1L;
    private FontDesc description;
    @RealObject
    private Typeface realTypeface;

    @HiddenApi
    @Implementation
    public void __constructor__(int fontId) {
        this.description = ShadowTypeface.findById(fontId);
    }

    @HiddenApi
    @Implementation
    public void __constructor__(long fontId) {
        this.description = ShadowTypeface.findById(fontId);
    }

    @Implementation
    public static Typeface create(String familyName, int style) {
        return ShadowTypeface.createUnderlyingTypeface(familyName, style);
    }

    @Implementation
    public static Typeface create(Typeface family, int style) {
        if (family == null) {
            return ShadowTypeface.createUnderlyingTypeface(null, style);
        }
        return ShadowTypeface.createUnderlyingTypeface(Shadows.shadowOf(family).getFontDescription().getFamilyName(), style);
    }

    @Implementation
    public static Typeface createFromAsset(AssetManager mgr, String path) {
        Collection<FsFile> assetDirs = Shadows.shadowOf(mgr).getAllAssetsDirectories();
        for (FsFile assetDir : assetDirs) {
            FsFile[] files = assetDir.listFiles((FsFile.Filter)new StartsWith(path));
            FsFile assetFile = assetDir.join(new String[]{path});
            if (!assetFile.exists() && files.length == 0) continue;
            return ShadowTypeface.createUnderlyingTypeface(path, 0);
        }
        throw new RuntimeException("Font not found at " + assetDirs);
    }

    @Implementation
    public static Typeface createFromFile(File path) {
        String familyName = path.toPath().getFileName().toString();
        return ShadowTypeface.createUnderlyingTypeface(familyName, 0);
    }

    @Implementation
    public static Typeface createFromFile(String path) {
        return ShadowTypeface.createFromFile(new File(path));
    }

    @Implementation
    public int getStyle() {
        return this.description.getStyle();
    }

    @HiddenApi
    @Implementation(minSdk=21)
    public static Typeface createFromFamilies(Object families) {
        return null;
    }

    @HiddenApi
    @Implementation(minSdk=21)
    public static Typeface createFromFamiliesWithDefault(Object families) {
        return null;
    }

    @Implementation(minSdk=10000)
    protected static void buildSystemFallback(String xmlPath, String fontDir, ArrayMap<String, Typeface> fontMap, ArrayMap<String, FontFamily[]> fallbackMap) {
        fontMap.put((Object)"sans-serif", (Object)ShadowTypeface.createUnderlyingTypeface("sans-serif", 0));
    }

    @Resetter
    public static synchronized void reset() {
        FONTS.clear();
    }

    private static Typeface createUnderlyingTypeface(String familyName, int style) {
        long thisFontId = nextFontId++;
        FONTS.put(thisFontId, new FontDesc(familyName, style));
        if (RuntimeEnvironment.getApiLevel() >= 21) {
            return (Typeface)ReflectionHelpers.callConstructor(Typeface.class, (ReflectionHelpers.ClassParameter[])new ReflectionHelpers.ClassParameter[]{ReflectionHelpers.ClassParameter.from(Long.TYPE, (Object)thisFontId)});
        }
        return (Typeface)ReflectionHelpers.callConstructor(Typeface.class, (ReflectionHelpers.ClassParameter[])new ReflectionHelpers.ClassParameter[]{ReflectionHelpers.ClassParameter.from(Integer.TYPE, (Object)((int)thisFontId))});
    }

    private static synchronized FontDesc findById(long fontId) {
        if (FONTS.containsKey(fontId)) {
            return FONTS.get(fontId);
        }
        throw new RuntimeException("Unknown font id: " + fontId);
    }

    public FontDesc getFontDescription() {
        return this.description;
    }

    private static class StartsWith
    implements FsFile.Filter {
        private final String contains;

        public StartsWith(String contains) {
            this.contains = contains;
        }

        public boolean accept(FsFile file) {
            return file.getName().startsWith(this.contains);
        }
    }

    public static class FontDesc {
        public final String familyName;
        public final int style;

        public FontDesc(String familyName, int style) {
            this.familyName = familyName;
            this.style = style;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            FontDesc fontDesc = (FontDesc)o;
            if (this.style != fontDesc.style) {
                return false;
            }
            return !(this.familyName != null ? !this.familyName.equals(fontDesc.familyName) : fontDesc.familyName != null);
        }

        public int hashCode() {
            int result = this.familyName != null ? this.familyName.hashCode() : 0;
            result = 31 * result + this.style;
            return result;
        }

        public String getFamilyName() {
            return this.familyName;
        }

        public int getStyle() {
            return this.style;
        }
    }
}

