/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.shadows;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.graphics.drawable.Drawable;
import android.view.View;
import android.widget.TabHost;
import android.widget.TabWidget;
import java.util.ArrayList;
import java.util.List;
import org.robolectric.Shadows;
import org.robolectric.annotation.Implementation;
import org.robolectric.annotation.Implements;
import org.robolectric.annotation.RealObject;
import org.robolectric.shadow.api.Shadow;
import org.robolectric.shadows.ShadowFrameLayout;

@Implements(value=TabHost.class)
public class ShadowTabHost
extends ShadowFrameLayout {
    private List<TabHost.TabSpec> tabSpecs = new ArrayList<TabHost.TabSpec>();
    private TabHost.OnTabChangeListener listener;
    private int currentTab = -1;
    @RealObject
    private TabHost realObject;

    @Implementation
    public TabHost.TabSpec newTabSpec(String tag) {
        TabHost.TabSpec realTabSpec = (TabHost.TabSpec)Shadow.newInstanceOf(TabHost.TabSpec.class);
        Shadows.shadowOf(realTabSpec).setTag(tag);
        return realTabSpec;
    }

    @Implementation
    public void addTab(TabHost.TabSpec tabSpec) {
        this.tabSpecs.add(tabSpec);
        View indicatorAsView = Shadows.shadowOf(tabSpec).getIndicatorAsView();
        if (indicatorAsView != null) {
            this.realObject.addView(indicatorAsView);
        }
    }

    @Implementation
    public void setCurrentTab(int index) {
        this.currentTab = index;
        if (this.listener != null) {
            this.listener.onTabChanged(this.getCurrentTabTag());
        }
    }

    @Implementation
    public void setCurrentTabByTag(String tag) {
        for (int x = 0; x < this.tabSpecs.size(); ++x) {
            TabHost.TabSpec tabSpec = this.tabSpecs.get(x);
            if (!tabSpec.getTag().equals(tag)) continue;
            this.currentTab = x;
        }
        if (this.listener != null) {
            this.listener.onTabChanged(this.getCurrentTabTag());
        }
    }

    @Implementation
    public int getCurrentTab() {
        if (this.currentTab == -1 && this.tabSpecs.size() > 0) {
            this.currentTab = 0;
        }
        return this.currentTab;
    }

    public TabHost.TabSpec getCurrentTabSpec() {
        return this.tabSpecs.get(this.getCurrentTab());
    }

    @Implementation
    public String getCurrentTabTag() {
        int i = this.getCurrentTab();
        if (i >= 0 && i < this.tabSpecs.size()) {
            return this.tabSpecs.get(i).getTag();
        }
        return null;
    }

    @Implementation
    public void setOnTabChangedListener(TabHost.OnTabChangeListener listener) {
        this.listener = listener;
    }

    @Implementation
    public View getCurrentView() {
        ShadowTabSpec ts = Shadows.shadowOf(this.getCurrentTabSpec());
        View v = ts.getContentView();
        if (v == null) {
            int viewId = ts.getContentViewId();
            if (this.realView.getContext() instanceof Activity) {
                v = ((Activity)this.realView.getContext()).findViewById(viewId);
            } else {
                return null;
            }
        }
        return v;
    }

    @Implementation
    public TabWidget getTabWidget() {
        Context context = this.realView.getContext();
        if (context instanceof Activity) {
            return (TabWidget)((Activity)context).findViewById(16908307);
        }
        return null;
    }

    public TabHost.TabSpec getSpecByTag(String tag) {
        for (TabHost.TabSpec tabSpec : this.tabSpecs) {
            if (!tag.equals(tabSpec.getTag())) continue;
            return tabSpec;
        }
        return null;
    }

    @Implements(value=TabHost.TabSpec.class)
    public static class ShadowTabSpec {
        @RealObject
        TabHost.TabSpec realObject;
        private String tag;
        private View indicatorView;
        private Intent intent;
        private int viewId;
        private View contentView;
        private CharSequence label;
        private Drawable icon;

        public void setTag(String tag) {
            this.tag = tag;
        }

        @Implementation
        public String getTag() {
            return this.tag;
        }

        public View getIndicatorAsView() {
            return this.indicatorView;
        }

        public String getIndicatorLabel() {
            return this.label.toString();
        }

        public Drawable getIndicatorIcon() {
            return this.icon;
        }

        public String getText() {
            return this.label.toString();
        }

        @Implementation
        public TabHost.TabSpec setIndicator(View view) {
            this.indicatorView = view;
            return this.realObject;
        }

        @Implementation
        public TabHost.TabSpec setIndicator(CharSequence label) {
            this.label = label;
            return this.realObject;
        }

        @Implementation
        public TabHost.TabSpec setIndicator(CharSequence label, Drawable icon) {
            this.label = label;
            this.icon = icon;
            return this.realObject;
        }

        public Intent getContentAsIntent() {
            return this.intent;
        }

        @Implementation
        public TabHost.TabSpec setContent(Intent intent) {
            this.intent = intent;
            return this.realObject;
        }

        @Implementation
        public TabHost.TabSpec setContent(TabHost.TabContentFactory factory) {
            this.contentView = factory.createTabContent(this.tag);
            return this.realObject;
        }

        @Implementation
        public TabHost.TabSpec setContent(int viewId) {
            this.viewId = viewId;
            return this.realObject;
        }

        public int getContentViewId() {
            return this.viewId;
        }

        public View getContentView() {
            return this.contentView;
        }
    }
}

