/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.shadows;

import java.util.HashMap;
import org.robolectric.RuntimeEnvironment;
import org.robolectric.annotation.Implements;
import org.robolectric.annotation.Resetter;
import org.robolectric.util.ReflectionHelpers;

@Implements(className="android.app.SystemServiceRegistry", isInAndroidSdk=false, minSdk=23)
public class ShadowSystemServiceRegistry {
    @Resetter
    public static void reset() {
        HashMap fetchers = (HashMap)ReflectionHelpers.getStaticField((Class)ShadowSystemServiceRegistry.classForName("android.app.SystemServiceRegistry"), (String)"SYSTEM_SERVICE_FETCHERS");
        Class staticApplicationServiceFetcherClass = null;
        if (RuntimeEnvironment.getApiLevel() >= 24) {
            staticApplicationServiceFetcherClass = ShadowSystemServiceRegistry.classForName("android.app.SystemServiceRegistry$StaticApplicationContextServiceFetcher");
        } else if (RuntimeEnvironment.getApiLevel() == 23) {
            staticApplicationServiceFetcherClass = ShadowSystemServiceRegistry.classForName("android.app.SystemServiceRegistry$StaticOuterContextServiceFetcher");
        }
        Class staticServiceFetcherClass = ShadowSystemServiceRegistry.classForName("android.app.SystemServiceRegistry$StaticServiceFetcher");
        for (Object o : fetchers.values()) {
            if (staticApplicationServiceFetcherClass.isInstance(o)) {
                ReflectionHelpers.setField((Class)staticApplicationServiceFetcherClass, o, (String)"mCachedInstance", null);
                continue;
            }
            if (!staticServiceFetcherClass.isInstance(o)) continue;
            ReflectionHelpers.setField((Class)staticServiceFetcherClass, o, (String)"mCachedInstance", null);
        }
    }

    private static Class classForName(String className) {
        try {
            return Class.forName(className);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    }
}

