/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.shadows;

import android.app.Notification;
import android.app.NotificationManager;
import android.app.Service;
import org.robolectric.RuntimeEnvironment;
import org.robolectric.annotation.Implementation;
import org.robolectric.annotation.Implements;
import org.robolectric.annotation.RealObject;
import org.robolectric.shadows.ShadowContextWrapper;

@Implements(value=Service.class)
public class ShadowService
extends ShadowContextWrapper {
    @RealObject
    Service realService;
    private int lastForegroundNotificationId;
    private Notification lastForegroundNotification;
    private boolean selfStopped = false;
    private boolean foregroundStopped;
    private boolean notificationShouldRemoved;

    @Implementation
    public void onDestroy() {
        this.removeForegroundNotification();
    }

    @Implementation
    public void stopSelf() {
        this.selfStopped = true;
    }

    @Implementation
    public void stopSelf(int id2) {
        this.selfStopped = true;
    }

    @Implementation
    public final void startForeground(int id2, Notification notification) {
        this.foregroundStopped = false;
        this.lastForegroundNotificationId = id2;
        this.lastForegroundNotification = notification;
        notification.flags |= 0x40;
        NotificationManager nm = (NotificationManager)RuntimeEnvironment.application.getSystemService("notification");
        nm.notify(id2, notification);
    }

    @Implementation
    public void stopForeground(boolean removeNotification) {
        this.foregroundStopped = true;
        this.notificationShouldRemoved = removeNotification;
        if (removeNotification) {
            this.removeForegroundNotification();
        }
    }

    private void removeForegroundNotification() {
        NotificationManager nm = (NotificationManager)RuntimeEnvironment.application.getSystemService("notification");
        nm.cancel(this.lastForegroundNotificationId);
        this.lastForegroundNotification = null;
    }

    public int getLastForegroundNotificationId() {
        return this.lastForegroundNotificationId;
    }

    public Notification getLastForegroundNotification() {
        return this.lastForegroundNotification;
    }

    public boolean isStoppedBySelf() {
        return this.selfStopped;
    }

    public boolean isForegroundStopped() {
        return this.foregroundStopped;
    }

    public boolean getNotificationShouldRemoved() {
        return this.notificationShouldRemoved;
    }
}

