/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.shadows;

import android.content.pm.PackageParser;
import android.content.pm.Signature;
import android.content.res.AssetManager;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.content.res.XmlResourceParser;
import android.os.Bundle;
import android.util.AttributeSet;
import android.util.DisplayMetrics;
import android.util.Slog;
import android.util.TypedValue;
import com.android.internal.R;
import com.android.internal.util.XmlUtils;
import java.io.File;
import java.io.IOException;
import java.security.cert.Certificate;
import libcore.io.IoUtils;
import org.robolectric.RuntimeEnvironment;
import org.robolectric.annotation.Implementation;
import org.robolectric.annotation.Implements;
import org.robolectric.annotation.RealObject;
import org.robolectric.res.FsFile;
import org.robolectric.shadow.api.Shadow;
import org.robolectric.util.ReflectionHelpers;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

@Implements(value=PackageParser.class, isInAndroidSdk=false)
public class ShadowPackageParser {
    private static final String TAG = "ShadowPackageParser";
    private int mParseError;
    private String mArchiveSourcePath;
    @RealObject
    PackageParser realObject;
    private static String MANIFEST_FILE;

    public static PackageParser.Package callParsePackage(FsFile manifestFile) {
        MANIFEST_FILE = manifestFile.getPath();
        PackageParser packageParser = new PackageParser();
        int flags = 2;
        try {
            if (RuntimeEnvironment.getApiLevel() >= 21) {
                return packageParser.parsePackage(new File(manifestFile.getPath()), flags);
            }
            return (PackageParser.Package)ReflectionHelpers.callInstanceMethod(PackageParser.class, (Object)packageParser, (String)"parsePackage", (ReflectionHelpers.ClassParameter[])new ReflectionHelpers.ClassParameter[]{ReflectionHelpers.ClassParameter.from(File.class, (Object)new File(manifestFile.getPath())), ReflectionHelpers.ClassParameter.from(String.class, (Object)manifestFile.getPath()), ReflectionHelpers.ClassParameter.from(DisplayMetrics.class, (Object)new DisplayMetrics()), ReflectionHelpers.ClassParameter.from(Integer.TYPE, (Object)flags)});
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Implementation(minSdk=16, maxSdk=19)
    public PackageParser.Package parsePackage(File sourceFile, String destCodePath, DisplayMetrics metrics, int flags) {
        this.mParseError = 1;
        XmlResourceParser parser = null;
        AssetManager assmgr = null;
        Resources res = null;
        boolean assetError = true;
        try {
            int cookie;
            assmgr = new AssetManager();
            int n = cookie = this.mArchiveSourcePath != null ? assmgr.addAssetPath(this.mArchiveSourcePath) : 1;
            if (cookie != 0) {
                res = new Resources(assmgr, metrics, null);
                parser = assmgr.openXmlResourceParser(cookie, MANIFEST_FILE);
                assetError = false;
            } else {
                Slog.w((String)TAG, (String)("Failed adding asset path:" + this.mArchiveSourcePath));
            }
        }
        catch (Exception e) {
            Slog.w((String)TAG, (String)("Unable to read AndroidManifest.xml of " + this.mArchiveSourcePath), (Throwable)e);
        }
        if (assetError) {
            if (assmgr != null) {
                assmgr.close();
            }
            this.mParseError = -101;
            throw new RuntimeException("Failed to parse Manifest");
        }
        String[] errorText = new String[1];
        PackageParser.Package pkg = null;
        try {
            pkg = (PackageParser.Package)Shadow.directlyOn((Object)this.realObject, PackageParser.class, (String)"parsePackage", (ReflectionHelpers.ClassParameter[])new ReflectionHelpers.ClassParameter[]{ReflectionHelpers.ClassParameter.from(Resources.class, (Object)res), ReflectionHelpers.ClassParameter.from(XmlResourceParser.class, (Object)parser), ReflectionHelpers.ClassParameter.from(Integer.TYPE, (Object)flags), ReflectionHelpers.ClassParameter.from(String[].class, (Object)errorText)});
        }
        catch (Exception e) {
            this.mParseError = -102;
            throw new RuntimeException("Failed to parse Manifest", e);
        }
        if (pkg == null) {
            parser.close();
            assmgr.close();
            throw new RuntimeException("Failed to parse Manifest" + errorText[0]);
        }
        parser.close();
        assmgr.close();
        return pkg;
    }

    @Implementation
    public Bundle parseMetaData(Resources res, XmlPullParser parser, AttributeSet attrs, Bundle data, String[] outError) throws XmlPullParserException, IOException {
        String name;
        TypedArray sa = res.obtainAttributes(attrs, R.styleable.AndroidManifestMetaData);
        if (data == null) {
            data = new Bundle();
        }
        if ((name = sa.getNonConfigurationString(0, 0)) == null) {
            outError[0] = "<meta-data> requires an android:name attribute";
            sa.recycle();
            return null;
        }
        name = name.intern();
        TypedValue v = sa.peekValue(2);
        if (v != null && v.resourceId != 0) {
            data.putInt(name, v.resourceId);
        } else {
            v = sa.peekValue(1);
            if (v != null) {
                if (v.type == 3) {
                    CharSequence cs = v.coerceToString();
                    data.putString(name, cs != null ? cs.toString().intern() : null);
                } else if (v.type == 18) {
                    data.putBoolean(name, v.data != 0);
                } else if (v.type >= 16 && v.type <= 31) {
                    data.putInt(name, v.data);
                } else if (v.type == 4) {
                    data.putFloat(name, v.getFloat());
                } else {
                    Slog.w((String)TAG, (String)("<meta-data> only supports string, integer, float, color, boolean, and resource reference types: " + parser.getName() + " at " + this.mArchiveSourcePath + " " + parser.getPositionDescription()));
                }
            } else {
                outError[0] = "<meta-data> requires an android:value or android:resource attribute";
                data = null;
            }
        }
        sa.recycle();
        XmlUtils.skipCurrentTag((XmlPullParser)parser);
        return data;
    }

    @Implementation(minSdk=21)
    public PackageParser.Package parseBaseApk(File apkFile, AssetManager assets, int flags) {
        PackageParser.Package package_;
        String apkPath = apkFile.getAbsolutePath();
        this.mParseError = 1;
        this.mArchiveSourcePath = apkFile.getAbsolutePath();
        boolean cookie = false;
        Resources res = null;
        XmlResourceParser parser = null;
        try {
            res = new Resources(assets, new DisplayMetrics(), null);
            parser = assets.openXmlResourceParser(0, MANIFEST_FILE);
            String[] outError = new String[1];
            PackageParser.Package pkg = RuntimeEnvironment.getApiLevel() >= 26 ? (PackageParser.Package)Shadow.directlyOn((Object)this.realObject, PackageParser.class, (String)"parseBaseApk", (ReflectionHelpers.ClassParameter[])new ReflectionHelpers.ClassParameter[]{ReflectionHelpers.ClassParameter.from(String.class, (Object)apkFile.getAbsolutePath()), ReflectionHelpers.ClassParameter.from(Resources.class, (Object)res), ReflectionHelpers.ClassParameter.from(XmlResourceParser.class, (Object)parser), ReflectionHelpers.ClassParameter.from(Integer.TYPE, (Object)flags), ReflectionHelpers.ClassParameter.from(String[].class, (Object)outError)}) : (PackageParser.Package)Shadow.directlyOn((Object)this.realObject, PackageParser.class, (String)"parseBaseApk", (ReflectionHelpers.ClassParameter[])new ReflectionHelpers.ClassParameter[]{ReflectionHelpers.ClassParameter.from(Resources.class, (Object)res), ReflectionHelpers.ClassParameter.from(XmlResourceParser.class, (Object)parser), ReflectionHelpers.ClassParameter.from(Integer.TYPE, (Object)flags), ReflectionHelpers.ClassParameter.from(String[].class, (Object)outError)});
            if (pkg == null) {
                throw new Exception("Parse error at " + parser.getPositionDescription() + "): " + outError[0]);
            }
            pkg.baseCodePath = apkPath;
            package_ = pkg;
        }
        catch (Exception e) {
            try {
                throw new RuntimeException("Failed to read manifest from " + apkPath + "Error code: " + -102, e);
            }
            catch (Throwable throwable) {
                IoUtils.closeQuietly(parser);
                throw throwable;
            }
        }
        IoUtils.closeQuietly((AutoCloseable)parser);
        return package_;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Implementation(minSdk=24)
    public static Object parseApkLite(File apkFile, int flags) {
        String apkPath;
        block14: {
            Object object;
            XmlResourceParser attrs;
            PackageParser.SigningDetails signingDetails;
            XmlResourceParser parser;
            AssetManager assets;
            block13: {
                Certificate[][] certificates;
                Signature[] signatures;
                block12: {
                    block11: {
                        apkPath = apkFile.getAbsolutePath();
                        assets = null;
                        parser = null;
                        assets = new AssetManager();
                        int cookie = assets.addAssetPath(apkPath);
                        if (cookie == 0) {
                            throw new RuntimeException("Failed to parse " + apkPath + "Error code: " + -100);
                        }
                        DisplayMetrics metrics = new DisplayMetrics();
                        metrics.setToDefaults();
                        Resources res = new Resources(assets, metrics, null);
                        parser = assets.openXmlResourceParser(cookie, MANIFEST_FILE);
                        signatures = null;
                        certificates = null;
                        signingDetails = null;
                        if ((flags & 0x20) != 0) {
                            PackageParser.Package tempPkg = (PackageParser.Package)ReflectionHelpers.newInstance(PackageParser.Package.class);
                            Shadow.directlyOn(PackageParser.class, (String)"collectCertificates", (ReflectionHelpers.ClassParameter[])new ReflectionHelpers.ClassParameter[]{ReflectionHelpers.ClassParameter.from(PackageParser.Package.class, (Object)tempPkg), ReflectionHelpers.ClassParameter.from(File.class, (Object)apkFile), ReflectionHelpers.ClassParameter.from(Integer.TYPE, (Object)0)});
                            if (RuntimeEnvironment.getApiLevel() <= 27) {
                                signatures = (Signature[])ReflectionHelpers.getField((Object)tempPkg, (String)"mSignatures");
                                certificates = (Certificate[][])ReflectionHelpers.getField((Object)tempPkg, (String)"mCertificates");
                            } else {
                                signingDetails = tempPkg.mSigningDetails;
                            }
                        }
                        attrs = parser;
                        if (RuntimeEnvironment.getApiLevel() > 25) break block11;
                        Object object2 = Shadow.directlyOn(PackageParser.class, (String)"parseApkLite", (ReflectionHelpers.ClassParameter[])new ReflectionHelpers.ClassParameter[]{ReflectionHelpers.ClassParameter.from(String.class, (Object)apkPath), ReflectionHelpers.ClassParameter.from(Resources.class, (Object)res), ReflectionHelpers.ClassParameter.from(XmlPullParser.class, (Object)parser), ReflectionHelpers.ClassParameter.from(AttributeSet.class, (Object)attrs), ReflectionHelpers.ClassParameter.from(Integer.TYPE, (Object)flags), ReflectionHelpers.ClassParameter.from(Signature[].class, (Object)signatures), ReflectionHelpers.ClassParameter.from(Certificate[][].class, (Object)certificates)});
                        IoUtils.closeQuietly((AutoCloseable)parser);
                        IoUtils.closeQuietly((AutoCloseable)assets);
                        return object2;
                    }
                    if (RuntimeEnvironment.getApiLevel() > 26) break block12;
                    Object object3 = Shadow.directlyOn(PackageParser.class, (String)"parseApkLite", (ReflectionHelpers.ClassParameter[])new ReflectionHelpers.ClassParameter[]{ReflectionHelpers.ClassParameter.from(String.class, (Object)apkPath), ReflectionHelpers.ClassParameter.from(XmlPullParser.class, (Object)parser), ReflectionHelpers.ClassParameter.from(AttributeSet.class, (Object)attrs), ReflectionHelpers.ClassParameter.from(Integer.TYPE, (Object)flags), ReflectionHelpers.ClassParameter.from(Signature[].class, (Object)signatures), ReflectionHelpers.ClassParameter.from(Certificate[][].class, (Object)certificates)});
                    IoUtils.closeQuietly((AutoCloseable)parser);
                    IoUtils.closeQuietly((AutoCloseable)assets);
                    return object3;
                }
                if (RuntimeEnvironment.getApiLevel() > 27) break block13;
                Object object4 = Shadow.directlyOn(PackageParser.class, (String)"parseApkLite", (ReflectionHelpers.ClassParameter[])new ReflectionHelpers.ClassParameter[]{ReflectionHelpers.ClassParameter.from(String.class, (Object)apkPath), ReflectionHelpers.ClassParameter.from(XmlPullParser.class, (Object)parser), ReflectionHelpers.ClassParameter.from(AttributeSet.class, (Object)attrs), ReflectionHelpers.ClassParameter.from(Signature[].class, (Object)signatures), ReflectionHelpers.ClassParameter.from(Certificate[][].class, (Object)certificates)});
                IoUtils.closeQuietly((AutoCloseable)parser);
                IoUtils.closeQuietly((AutoCloseable)assets);
                return object4;
            }
            try {
                object = Shadow.directlyOn(PackageParser.class, (String)"parseApkLite", (ReflectionHelpers.ClassParameter[])new ReflectionHelpers.ClassParameter[]{ReflectionHelpers.ClassParameter.from(String.class, (Object)apkPath), ReflectionHelpers.ClassParameter.from(XmlPullParser.class, (Object)parser), ReflectionHelpers.ClassParameter.from(AttributeSet.class, (Object)attrs), ReflectionHelpers.ClassParameter.from(PackageParser.SigningDetails.class, (Object)signingDetails)});
            }
            catch (Exception exception) {
                IoUtils.closeQuietly(parser);
                IoUtils.closeQuietly((AutoCloseable)assets);
                break block14;
                catch (Throwable throwable) {
                    IoUtils.closeQuietly(parser);
                    IoUtils.closeQuietly((AutoCloseable)assets);
                    throw throwable;
                }
            }
            IoUtils.closeQuietly((AutoCloseable)parser);
            IoUtils.closeQuietly((AutoCloseable)assets);
            return object;
        }
        throw new RuntimeException("Failed to parse " + apkPath + "Error code: " + -102);
    }
}

