/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.shadows;

import android.net.NetworkInfo;
import org.robolectric.Shadows;
import org.robolectric.annotation.Implementation;
import org.robolectric.annotation.Implements;
import org.robolectric.shadow.api.Shadow;

@Implements(value=NetworkInfo.class)
public class ShadowNetworkInfo {
    private boolean isAvailable;
    private NetworkInfo.State state;
    private int connectionType;
    private int connectionSubType;
    private NetworkInfo.DetailedState detailedState;

    @Implementation
    public static void __staticInitializer__() {
    }

    @Deprecated
    public static NetworkInfo newInstance(NetworkInfo.DetailedState detailedState, int type, int subType, boolean isAvailable, boolean isConnected) {
        return ShadowNetworkInfo.newInstance(detailedState, type, subType, isAvailable, isConnected ? NetworkInfo.State.CONNECTED : NetworkInfo.State.DISCONNECTED);
    }

    public static NetworkInfo newInstance(NetworkInfo.DetailedState detailedState, int type, int subType, boolean isAvailable, NetworkInfo.State state) {
        NetworkInfo networkInfo = (NetworkInfo)Shadow.newInstanceOf(NetworkInfo.class);
        ShadowNetworkInfo info = Shadows.shadowOf(networkInfo);
        info.setConnectionType(type);
        info.setSubType(subType);
        info.setDetailedState(detailedState);
        info.setAvailableStatus(isAvailable);
        info.setConnectionStatus(state);
        return networkInfo;
    }

    @Implementation
    public boolean isConnected() {
        return this.state == NetworkInfo.State.CONNECTED;
    }

    @Implementation
    public boolean isConnectedOrConnecting() {
        return this.isConnected() || this.state == NetworkInfo.State.CONNECTING;
    }

    @Implementation
    public NetworkInfo.State getState() {
        return this.state;
    }

    @Implementation
    public NetworkInfo.DetailedState getDetailedState() {
        return this.detailedState;
    }

    @Implementation
    public int getType() {
        return this.connectionType;
    }

    @Implementation
    public int getSubtype() {
        return this.connectionSubType;
    }

    @Implementation
    public boolean isAvailable() {
        return this.isAvailable;
    }

    public void setAvailableStatus(boolean isAvailable) {
        this.isAvailable = isAvailable;
    }

    @Deprecated
    public void setConnectionStatus(boolean isConnected) {
        this.setConnectionStatus(isConnected ? NetworkInfo.State.CONNECTED : NetworkInfo.State.DISCONNECTED);
    }

    public void setConnectionStatus(NetworkInfo.State state) {
        this.state = state;
    }

    public void setConnectionType(int connectionType) {
        this.connectionType = connectionType;
    }

    public void setSubType(int subType) {
        this.connectionSubType = subType;
    }

    public void setDetailedState(NetworkInfo.DetailedState detailedState) {
        this.detailedState = detailedState;
    }
}

