/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.shadows;

import android.content.BroadcastReceiver;
import android.content.ComponentName;
import android.content.ContentResolver;
import android.content.Context;
import android.content.IContentProvider;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.IntentSender;
import android.content.ServiceConnection;
import android.os.Bundle;
import android.os.Environment;
import android.os.Handler;
import android.os.UserHandle;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import org.robolectric.RuntimeEnvironment;
import org.robolectric.annotation.Implementation;
import org.robolectric.annotation.Implements;
import org.robolectric.annotation.RealObject;
import org.robolectric.annotation.Resetter;
import org.robolectric.shadow.api.Shadow;
import org.robolectric.shadows.ShadowApplication;
import org.robolectric.util.ReflectionHelpers;

@Implements(className="android.app.ContextImpl")
public class ShadowContextImpl {
    public static final String CLASS_NAME = "android.app.ContextImpl";
    private ContentResolver contentResolver;
    @RealObject
    private Context realObject;
    private Map<String, Object> systemServices = new HashMap<String, Object>();

    @Implementation
    public Object getSystemService(String name) {
        Object service = this.systemServices.get(name);
        if (service == null) {
            return Shadow.directlyOn((Object)this.realObject, (String)CLASS_NAME, (String)"getSystemService", (ReflectionHelpers.ClassParameter[])new ReflectionHelpers.ClassParameter[]{ReflectionHelpers.ClassParameter.from(String.class, (Object)name)});
        }
        return service;
    }

    public void setSystemService(String key, Object service) {
        this.systemServices.put(key, service);
    }

    @Implementation
    public void startIntentSender(IntentSender intent, Intent fillInIntent, int flagsMask, int flagsValues, int extraFlags, Bundle options) throws IntentSender.SendIntentException {
        intent.sendIntent(this.realObject, 0, fillInIntent, null, null, null);
    }

    @Implementation
    public ComponentName startService(Intent service) {
        return ShadowApplication.getInstance().startService(service);
    }

    @Implementation(minSdk=26)
    public ComponentName startForegroundService(Intent service) {
        return ShadowApplication.getInstance().startService(service);
    }

    @Implementation
    public void sendBroadcast(Intent intent) {
        ShadowApplication.getInstance().sendBroadcast(intent);
    }

    @Implementation
    public ClassLoader getClassLoader() {
        return this.getClass().getClassLoader();
    }

    @Implementation
    public boolean bindService(Intent intent, ServiceConnection serviceConnection, int i) {
        return ShadowApplication.getInstance().bindService(intent, serviceConnection, i);
    }

    @Implementation
    public void unbindService(ServiceConnection serviceConnection) {
        ShadowApplication.getInstance().unbindService(serviceConnection);
    }

    @Implementation
    public int checkCallingPermission(String permission) {
        return this.checkPermission(permission, -1, -1);
    }

    @Implementation
    public int checkCallingOrSelfPermission(String permission) {
        return this.checkPermission(permission, -1, -1);
    }

    @Implementation
    public ContentResolver getContentResolver() {
        if (this.contentResolver == null) {
            this.contentResolver = new ContentResolver(this.realObject){

                protected IContentProvider acquireProvider(Context c, String name) {
                    return null;
                }

                public boolean releaseProvider(IContentProvider icp) {
                    return false;
                }

                protected IContentProvider acquireUnstableProvider(Context c, String name) {
                    return null;
                }

                public boolean releaseUnstableProvider(IContentProvider icp) {
                    return false;
                }

                public void unstableProviderDied(IContentProvider icp) {
                }
            };
        }
        return this.contentResolver;
    }

    @Implementation
    public void sendBroadcast(Intent intent, String receiverPermission) {
        ShadowApplication.getInstance().sendBroadcast(intent, receiverPermission);
    }

    @Implementation
    public void sendOrderedBroadcast(Intent intent, String receiverPermission) {
        ShadowApplication.getInstance().sendOrderedBroadcast(intent, receiverPermission);
    }

    @Implementation
    public void sendOrderedBroadcast(Intent intent, String receiverPermission, BroadcastReceiver resultReceiver, Handler scheduler, int initialCode, String initialData, Bundle initialExtras) {
        ShadowApplication.getInstance().sendOrderedBroadcast(intent, receiverPermission, resultReceiver, scheduler, initialCode, initialData, initialExtras);
    }

    @Implementation
    public void sendStickyBroadcast(Intent intent) {
        ShadowApplication.getInstance().sendStickyBroadcast(intent);
    }

    @Implementation
    public int checkPermission(String permission, int pid, int uid) {
        return ShadowApplication.getInstance().checkPermission(permission, pid, uid);
    }

    @Implementation
    public Intent registerReceiver(BroadcastReceiver receiver, IntentFilter filter) {
        return ShadowApplication.getInstance().registerReceiverWithContext(receiver, filter, null, null, this.realObject);
    }

    @Implementation
    public Intent registerReceiver(BroadcastReceiver receiver, IntentFilter filter, String broadcastPermission, Handler scheduler) {
        return ShadowApplication.getInstance().registerReceiverWithContext(receiver, filter, broadcastPermission, scheduler, this.realObject);
    }

    @Implementation
    public Intent registerReceiverAsUser(BroadcastReceiver receiver, UserHandle user, IntentFilter filter, String broadcastPermission, Handler scheduler) {
        return ShadowApplication.getInstance().registerReceiverWithContext(receiver, filter, broadcastPermission, scheduler, this.realObject);
    }

    @Implementation
    public void unregisterReceiver(BroadcastReceiver broadcastReceiver) {
        ShadowApplication.getInstance().unregisterReceiver(broadcastReceiver);
    }

    @Implementation
    public boolean stopService(Intent name) {
        return ShadowApplication.getInstance().stopService(name);
    }

    @Implementation
    public int getUserId() {
        return 0;
    }

    @Implementation
    public File getExternalCacheDir() {
        return Environment.getExternalStorageDirectory();
    }

    @Implementation(maxSdk=18)
    public File getExternalFilesDir(String type) {
        return Environment.getExternalStoragePublicDirectory((String)type);
    }

    @Implementation(minSdk=19)
    public File[] getExternalFilesDirs(String type) {
        return new File[]{Environment.getExternalStoragePublicDirectory((String)type)};
    }

    @Resetter
    public static void reset() {
        String prefsCacheFieldName = RuntimeEnvironment.getApiLevel() >= 24 ? "sSharedPrefsCache" : "sSharedPrefs";
        HashMap prefsDefaultValue = RuntimeEnvironment.getApiLevel() >= 19 ? null : new HashMap();
        Class contextImplClass = ReflectionHelpers.loadClass((ClassLoader)ShadowContextImpl.class.getClassLoader(), (String)CLASS_NAME);
        ReflectionHelpers.setStaticField((Class)contextImplClass, (String)prefsCacheFieldName, prefsDefaultValue);
        if (RuntimeEnvironment.getApiLevel() <= 22) {
            HashMap fetchers = (HashMap)ReflectionHelpers.getStaticField((Class)contextImplClass, (String)"SYSTEM_SERVICE_MAP");
            Class staticServiceFetcherClass = ReflectionHelpers.loadClass((ClassLoader)ShadowContextImpl.class.getClassLoader(), (String)"android.app.ContextImpl$StaticServiceFetcher");
            for (Object o : fetchers.values()) {
                if (!staticServiceFetcherClass.isInstance(o)) continue;
                ReflectionHelpers.setField((Class)staticServiceFetcherClass, o, (String)"mCachedInstance", null);
            }
            if (RuntimeEnvironment.getApiLevel() >= 19) {
                Class serviceFetcherClass = ReflectionHelpers.loadClass((ClassLoader)ShadowContextImpl.class.getClassLoader(), (String)"android.app.ContextImpl$ServiceFetcher");
                Object windowServiceFetcher = fetchers.get("window");
                ReflectionHelpers.setField(windowServiceFetcher.getClass(), windowServiceFetcher, (String)"mDefaultDisplay", null);
            }
        }
    }
}

