/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.shadows;

import android.accounts.Account;
import android.accounts.AccountManager;
import android.accounts.AccountManagerCallback;
import android.accounts.AccountManagerFuture;
import android.accounts.AuthenticatorDescription;
import android.accounts.AuthenticatorException;
import android.accounts.IAccountManager;
import android.accounts.OnAccountsUpdateListener;
import android.accounts.OperationCanceledException;
import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.os.Handler;
import android.os.Parcelable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.robolectric.annotation.Implementation;
import org.robolectric.annotation.Implements;

@Implements(value=AccountManager.class)
public class ShadowAccountManager {
    private List<Account> accounts = new ArrayList<Account>();
    private Map<Account, Map<String, String>> authTokens = new HashMap<Account, Map<String, String>>();
    private Map<String, AuthenticatorDescription> authenticators = new LinkedHashMap<String, AuthenticatorDescription>();
    private List<OnAccountsUpdateListener> listeners = new ArrayList<OnAccountsUpdateListener>();
    private Map<Account, Map<String, String>> userData = new HashMap<Account, Map<String, String>>();
    private Map<Account, String> passwords = new HashMap<Account, String>();
    private Map<Account, Set<String>> accountFeatures = new HashMap<Account, Set<String>>();
    private Map<Account, Set<String>> packageVisibileAccounts = new HashMap<Account, Set<String>>();
    private List<Bundle> addAccountOptionsList = new ArrayList<Bundle>();
    private Handler mainHandler;
    private RoboAccountManagerFuture pendingAddFuture;
    private Map<Account, String> previousNames = new HashMap<Account, String>();

    @Implementation
    public void __constructor__(Context context, IAccountManager service) {
        this.mainHandler = new Handler(context.getMainLooper());
    }

    @Deprecated
    @Implementation
    public static AccountManager get(Context context) {
        return (AccountManager)context.getSystemService("account");
    }

    @Implementation
    public Account[] getAccounts() {
        return this.accounts.toArray(new Account[this.accounts.size()]);
    }

    @Implementation
    public Account[] getAccountsByType(String type) {
        if (type == null) {
            return this.getAccounts();
        }
        ArrayList<Account> accountsByType = new ArrayList<Account>();
        for (Account a : this.accounts) {
            if (!type.equals(a.type)) continue;
            accountsByType.add(a);
        }
        return accountsByType.toArray(new Account[accountsByType.size()]);
    }

    @Implementation
    public synchronized void setAuthToken(Account account, String tokenType, String authToken) {
        if (this.accounts.contains(account)) {
            Map<String, String> tokenMap = this.authTokens.get(account);
            if (tokenMap == null) {
                tokenMap = new HashMap<String, String>();
                this.authTokens.put(account, tokenMap);
            }
            tokenMap.put(tokenType, authToken);
        }
    }

    @Implementation
    public String peekAuthToken(Account account, String tokenType) {
        Map<String, String> tokenMap = this.authTokens.get(account);
        if (tokenMap != null) {
            return tokenMap.get(tokenType);
        }
        return null;
    }

    @Implementation
    public boolean addAccountExplicitly(Account account, String password, Bundle userdata) {
        if (account == null) {
            throw new IllegalArgumentException("account is null");
        }
        for (Account a : this.getAccountsByType(account.type)) {
            if (!a.name.equals(account.name)) continue;
            return false;
        }
        if (!this.accounts.add(account)) {
            return false;
        }
        this.setPassword(account, password);
        if (userdata != null) {
            for (String key : userdata.keySet()) {
                this.setUserData(account, key, userdata.get(key).toString());
            }
        }
        this.notifyListeners();
        return true;
    }

    @Implementation
    public String blockingGetAuthToken(Account account, String authTokenType, boolean notifyAuthFailure) {
        if (account == null) {
            throw new IllegalArgumentException("account is null");
        }
        if (authTokenType == null) {
            throw new IllegalArgumentException("authTokenType is null");
        }
        Map<String, String> tokensForAccount = this.authTokens.get(account);
        if (tokensForAccount == null) {
            return null;
        }
        return tokensForAccount.get(authTokenType);
    }

    @Implementation
    public AccountManagerFuture<Boolean> removeAccount(final Account account, AccountManagerCallback<Boolean> callback, Handler handler) {
        if (account == null) {
            throw new IllegalArgumentException("account is null");
        }
        return this.start(new BaseRoboAccountManagerFuture<Boolean>(callback, handler){

            @Override
            public Boolean doWork() throws OperationCanceledException, IOException, AuthenticatorException {
                return ShadowAccountManager.this.removeAccountExplicitly(account);
            }
        });
    }

    @Implementation(minSdk=22)
    public boolean removeAccountExplicitly(Account account) {
        this.passwords.remove(account);
        this.userData.remove(account);
        if (this.accounts.remove(account)) {
            this.notifyListeners();
            return true;
        }
        return false;
    }

    public void removeAllAccounts() {
        this.passwords.clear();
        this.userData.clear();
        this.accounts.clear();
    }

    @Implementation
    public AuthenticatorDescription[] getAuthenticatorTypes() {
        return this.authenticators.values().toArray(new AuthenticatorDescription[this.authenticators.size()]);
    }

    @Implementation
    public void addOnAccountsUpdatedListener(OnAccountsUpdateListener listener, Handler handler, boolean updateImmediately) {
        if (this.listeners.contains(listener)) {
            return;
        }
        this.listeners.add(listener);
        if (updateImmediately) {
            listener.onAccountsUpdated(this.getAccounts());
        }
    }

    @Implementation
    public void removeOnAccountsUpdatedListener(OnAccountsUpdateListener listener) {
        this.listeners.remove(listener);
    }

    @Implementation
    public String getUserData(Account account, String key) {
        if (account == null) {
            throw new IllegalArgumentException("account is null");
        }
        if (!this.userData.containsKey(account)) {
            return null;
        }
        Map<String, String> userDataMap = this.userData.get(account);
        if (userDataMap.containsKey(key)) {
            return userDataMap.get(key);
        }
        return null;
    }

    @Implementation
    public void setUserData(Account account, String key, String value) {
        if (account == null) {
            throw new IllegalArgumentException("account is null");
        }
        if (!this.userData.containsKey(account)) {
            this.userData.put(account, new HashMap());
        }
        Map<String, String> userDataMap = this.userData.get(account);
        if (value == null) {
            userDataMap.remove(key);
        } else {
            userDataMap.put(key, value);
        }
    }

    @Implementation
    public void setPassword(Account account, String password) {
        if (account == null) {
            throw new IllegalArgumentException("account is null");
        }
        if (password == null) {
            this.passwords.remove(account);
        } else {
            this.passwords.put(account, password);
        }
    }

    @Implementation
    public String getPassword(Account account) {
        if (account == null) {
            throw new IllegalArgumentException("account is null");
        }
        if (this.passwords.containsKey(account)) {
            return this.passwords.get(account);
        }
        return null;
    }

    @Implementation
    public void invalidateAuthToken(String accountType, String authToken) {
        Account[] accountsByType;
        for (Account account : accountsByType = this.getAccountsByType(accountType)) {
            Map<String, String> tokenMap = this.authTokens.get(account);
            if (tokenMap == null) continue;
            Iterator<Map.Entry<String, String>> it = tokenMap.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry<String, String> map = it.next();
                if (!map.getValue().equals(authToken)) continue;
                it.remove();
            }
            this.authTokens.put(account, tokenMap);
        }
    }

    private void notifyListeners() {
        Account[] accounts = this.getAccounts();
        for (OnAccountsUpdateListener listener : this.listeners) {
            listener.onAccountsUpdated(accounts);
        }
    }

    public void addAccount(Account account) {
        this.accounts.add(account);
        if (this.pendingAddFuture != null) {
            this.pendingAddFuture.resultBundle.putString("authAccount", account.name);
            this.start(this.pendingAddFuture);
            this.pendingAddFuture = null;
        }
        this.notifyListeners();
    }

    public void addAccount(Account account, String ... visibileToPackages) {
        this.addAccount(account);
        HashSet value = new HashSet();
        Collections.addAll(value, visibileToPackages);
        this.packageVisibileAccounts.put(account, value);
    }

    public Bundle getNextAddAccountOptions() {
        if (this.addAccountOptionsList.isEmpty()) {
            return null;
        }
        return this.addAccountOptionsList.remove(0);
    }

    public Bundle peekNextAddAccountOptions() {
        if (this.addAccountOptionsList.isEmpty()) {
            return null;
        }
        return this.addAccountOptionsList.get(0);
    }

    @Implementation
    public AccountManagerFuture<Bundle> addAccount(String accountType, String authTokenType, String[] requiredFeatures, Bundle addAccountOptions, Activity activity, AccountManagerCallback<Bundle> callback, Handler handler) {
        this.addAccountOptionsList.add(addAccountOptions);
        this.pendingAddFuture = new RoboAccountManagerFuture(callback, handler, accountType, activity);
        return this.pendingAddFuture;
    }

    public void setFeatures(Account account, String[] accountFeatures) {
        HashSet<String> featureSet = new HashSet<String>();
        featureSet.addAll(Arrays.asList(accountFeatures));
        this.accountFeatures.put(account, featureSet);
    }

    public void addAuthenticator(AuthenticatorDescription authenticator) {
        this.authenticators.put(authenticator.type, authenticator);
    }

    public void addAuthenticator(String type) {
        this.addAuthenticator(AuthenticatorDescription.newKey((String)type));
    }

    public void setPreviousAccountName(Account account, String previousName) {
        this.previousNames.put(account, previousName);
    }

    @Implementation(minSdk=21)
    public String getPreviousName(Account account) {
        return this.previousNames.get(account);
    }

    @Implementation
    public AccountManagerFuture<Bundle> getAuthToken(final Account account, final String authTokenType, Bundle options, Activity activity, AccountManagerCallback<Bundle> callback, Handler handler) {
        return this.start(new BaseRoboAccountManagerFuture<Bundle>(callback, handler){

            @Override
            public Bundle doWork() throws OperationCanceledException, IOException, AuthenticatorException {
                Bundle result = new Bundle();
                String authToken = ShadowAccountManager.this.blockingGetAuthToken(account, authTokenType, false);
                result.putString("authAccount", account.name);
                result.putString("accountType", account.type);
                result.putString("authtoken", authToken);
                return result;
            }
        });
    }

    @Implementation
    public AccountManagerFuture<Bundle> getAuthToken(final Account account, final String authTokenType, Bundle options, boolean notifyAuthFailure, AccountManagerCallback<Bundle> callback, Handler handler) {
        return this.start(new BaseRoboAccountManagerFuture<Bundle>(callback, handler){

            @Override
            public Bundle doWork() throws OperationCanceledException, IOException, AuthenticatorException {
                Bundle result = new Bundle();
                String authToken = ShadowAccountManager.this.blockingGetAuthToken(account, authTokenType, false);
                result.putString("authAccount", account.name);
                result.putString("accountType", account.type);
                result.putString("authtoken", authToken);
                return result;
            }
        });
    }

    @Implementation
    public AccountManagerFuture<Boolean> hasFeatures(final Account account, final String[] features, AccountManagerCallback<Boolean> callback, Handler handler) {
        return this.start(new BaseRoboAccountManagerFuture<Boolean>(callback, handler){

            @Override
            public Boolean doWork() throws OperationCanceledException, IOException, AuthenticatorException {
                Set availableFeatures = (Set)ShadowAccountManager.this.accountFeatures.get(account);
                for (String feature : features) {
                    if (availableFeatures.contains(feature)) continue;
                    return false;
                }
                return true;
            }
        });
    }

    @Implementation
    public AccountManagerFuture<Account[]> getAccountsByTypeAndFeatures(final String type, final String[] features, AccountManagerCallback<Account[]> callback, Handler handler) {
        return this.start(new BaseRoboAccountManagerFuture<Account[]>(callback, handler){

            @Override
            public Account[] doWork() throws OperationCanceledException, IOException, AuthenticatorException {
                Account[] accountsByType;
                ArrayList<Account> result = new ArrayList<Account>();
                for (Account account : accountsByType = ShadowAccountManager.this.getAccountsByType(type)) {
                    Set featureSet = (Set)ShadowAccountManager.this.accountFeatures.get(account);
                    if (!featureSet.containsAll(Arrays.asList(features))) continue;
                    result.add(account);
                }
                return result.toArray(new Account[result.size()]);
            }
        });
    }

    private <T extends BaseRoboAccountManagerFuture> T start(T future) {
        future.start();
        return future;
    }

    @Implementation(minSdk=18)
    public Account[] getAccountsByTypeForPackage(String type, String packageName) {
        Account[] accountsByType;
        ArrayList<Account> result = new ArrayList<Account>();
        for (Account account : accountsByType = this.getAccountsByType(type)) {
            if (!this.packageVisibileAccounts.containsKey(account) || !this.packageVisibileAccounts.get(account).contains(packageName)) continue;
            result.add(account);
        }
        return result.toArray(new Account[result.size()]);
    }

    private abstract class BaseRoboAccountManagerFuture<T>
    implements AccountManagerFuture<T> {
        protected final AccountManagerCallback<T> callback;
        private final Handler handler;
        protected T result;
        private Exception exception;
        private boolean started = false;

        BaseRoboAccountManagerFuture(AccountManagerCallback<T> callback, Handler handler) {
            this.callback = callback;
            this.handler = handler == null ? ShadowAccountManager.this.mainHandler : handler;
        }

        void start() {
            if (this.started) {
                return;
            }
            this.started = true;
            try {
                this.result = this.doWork();
            }
            catch (AuthenticatorException | OperationCanceledException | IOException e) {
                this.exception = e;
            }
            if (this.callback != null) {
                this.handler.post(new Runnable(){

                    @Override
                    public void run() {
                        BaseRoboAccountManagerFuture.this.callback.run((AccountManagerFuture)BaseRoboAccountManagerFuture.this);
                    }
                });
            }
        }

        public boolean cancel(boolean mayInterruptIfRunning) {
            return false;
        }

        public boolean isCancelled() {
            return false;
        }

        public boolean isDone() {
            return this.result != null || this.exception != null || this.isCancelled();
        }

        public T getResult() throws OperationCanceledException, IOException, AuthenticatorException {
            this.start();
            if (this.exception instanceof OperationCanceledException) {
                throw new OperationCanceledException((Throwable)this.exception);
            }
            if (this.exception instanceof IOException) {
                throw new IOException(this.exception);
            }
            if (this.exception instanceof AuthenticatorException) {
                throw new AuthenticatorException((Throwable)this.exception);
            }
            return this.result;
        }

        public T getResult(long timeout, TimeUnit unit) throws OperationCanceledException, IOException, AuthenticatorException {
            return this.getResult();
        }

        public abstract T doWork() throws OperationCanceledException, IOException, AuthenticatorException;
    }

    private class RoboAccountManagerFuture
    extends BaseRoboAccountManagerFuture<Bundle> {
        private final String accountType;
        private final Activity activity;
        private final Bundle resultBundle;

        RoboAccountManagerFuture(AccountManagerCallback<Bundle> callback, Handler handler, String accountType, Activity activity) {
            super(callback, handler);
            this.accountType = accountType;
            this.activity = activity;
            this.resultBundle = new Bundle();
        }

        @Override
        public Bundle doWork() throws OperationCanceledException, IOException, AuthenticatorException {
            if (!ShadowAccountManager.this.authenticators.containsKey(this.accountType)) {
                throw new AuthenticatorException("No authenticator specified for " + this.accountType);
            }
            this.resultBundle.putString("accountType", this.accountType);
            if (this.activity == null) {
                Intent resultIntent = new Intent();
                this.resultBundle.putParcelable("intent", (Parcelable)resultIntent);
            } else if (this.callback == null) {
                this.resultBundle.putString("authAccount", "some_user@gmail.com");
            }
            return this.resultBundle;
        }
    }
}

