/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.android.controller;

import android.app.ActivityThread;
import android.app.Application;
import android.app.IntentService;
import android.app.Service;
import android.content.Context;
import android.content.Intent;
import android.os.IBinder;
import org.robolectric.RuntimeEnvironment;
import org.robolectric.android.controller.ComponentController;
import org.robolectric.util.ReflectionHelpers;

public class IntentServiceController<T extends IntentService>
extends ComponentController<IntentServiceController<T>, T> {
    public static <T extends IntentService> IntentServiceController<T> of(T service, Intent intent) {
        IntentServiceController<T> controller = new IntentServiceController<T>(service, intent);
        super.attach();
        return controller;
    }

    private IntentServiceController(T service, Intent intent) {
        super(service, intent);
    }

    private IntentServiceController<T> attach() {
        if (this.attached) {
            return this;
        }
        ReflectionHelpers.callInstanceMethod(Service.class, (Object)this.component, (String)"attach", (ReflectionHelpers.ClassParameter[])new ReflectionHelpers.ClassParameter[]{ReflectionHelpers.ClassParameter.from(Context.class, (Object)RuntimeEnvironment.application.getBaseContext()), ReflectionHelpers.ClassParameter.from(ActivityThread.class, null), ReflectionHelpers.ClassParameter.from(String.class, (Object)((IntentService)this.component).getClass().getSimpleName()), ReflectionHelpers.ClassParameter.from(IBinder.class, null), ReflectionHelpers.ClassParameter.from(Application.class, (Object)RuntimeEnvironment.application), ReflectionHelpers.ClassParameter.from(Object.class, null)});
        this.attached = true;
        return this;
    }

    public IntentServiceController<T> bind() {
        this.invokeWhilePaused("onBind", ReflectionHelpers.ClassParameter.from(Intent.class, (Object)this.getIntent()));
        return this;
    }

    @Override
    public IntentServiceController<T> create() {
        this.invokeWhilePaused("onCreate", new ReflectionHelpers.ClassParameter[0]);
        return this;
    }

    @Override
    public IntentServiceController<T> destroy() {
        this.invokeWhilePaused("onDestroy", new ReflectionHelpers.ClassParameter[0]);
        return this;
    }

    public IntentServiceController<T> rebind() {
        this.invokeWhilePaused("onRebind", ReflectionHelpers.ClassParameter.from(Intent.class, (Object)this.getIntent()));
        return this;
    }

    public IntentServiceController<T> startCommand(int flags, int startId) {
        IntentServiceController<T> intentServiceController = this.handleIntent();
        ((IntentService)this.get()).stopSelf(startId);
        return intentServiceController;
    }

    public IntentServiceController<T> unbind() {
        this.invokeWhilePaused("onUnbind", ReflectionHelpers.ClassParameter.from(Intent.class, (Object)this.getIntent()));
        return this;
    }

    public IntentServiceController<T> handleIntent() {
        this.invokeWhilePaused("onHandleIntent", ReflectionHelpers.ClassParameter.from(Intent.class, (Object)this.getIntent()));
        return this;
    }

    @Deprecated
    public IntentServiceController<T> withIntent(Intent intent) {
        this.intent = intent;
        return this;
    }
}

