/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.shadows;

import android.content.res.Configuration;
import android.util.DisplayMetrics;
import android.view.Display;
import android.view.View;
import android.view.ViewGroup;
import android.view.WindowManagerImpl;
import java.util.ArrayList;
import java.util.List;
import org.robolectric.RuntimeEnvironment;
import org.robolectric.annotation.Implementation;
import org.robolectric.annotation.Implements;
import org.robolectric.annotation.RealObject;
import org.robolectric.annotation.Resetter;
import org.robolectric.shadow.api.Shadow;
import org.robolectric.shadows.ShadowDisplay;
import org.robolectric.shadows.ShadowWindowManager;
import org.robolectric.util.ReflectionHelpers;

@Implements(value=WindowManagerImpl.class, isInAndroidSdk=false)
public class ShadowWindowManagerImpl
extends ShadowWindowManager {
    private static Display defaultDisplayJB;
    @RealObject
    WindowManagerImpl realObject;
    private List<View> views = new ArrayList<View>();

    public static void configureDefaultDisplayForJBOnly(Configuration configuration, DisplayMetrics displayMetrics) {
        Class arg2Type = ReflectionHelpers.loadClass((ClassLoader)ShadowWindowManagerImpl.class.getClassLoader(), (String)"android.view.CompatibilityInfoHolder");
        defaultDisplayJB = (Display)ReflectionHelpers.callConstructor(Display.class, (ReflectionHelpers.ClassParameter[])new ReflectionHelpers.ClassParameter[]{ReflectionHelpers.ClassParameter.from(Integer.TYPE, (Object)0), ReflectionHelpers.ClassParameter.from((Class)arg2Type, null)});
        ShadowDisplay shadowDisplay = (ShadowDisplay)Shadow.extract((Object)defaultDisplayJB);
        shadowDisplay.configureForJBOnly(configuration, displayMetrics);
    }

    @Implementation
    public void addView(View view, ViewGroup.LayoutParams layoutParams) {
        this.views.add(view);
        Shadow.directlyOn((Object)this.realObject, WindowManagerImpl.class, (String)"addView", (ReflectionHelpers.ClassParameter[])new ReflectionHelpers.ClassParameter[]{ReflectionHelpers.ClassParameter.from(View.class, (Object)view), ReflectionHelpers.ClassParameter.from(ViewGroup.LayoutParams.class, (Object)layoutParams)});
    }

    @Implementation
    public void removeView(View view) {
        this.views.remove(view);
        Shadow.directlyOn((Object)this.realObject, WindowManagerImpl.class, (String)"removeView", (ReflectionHelpers.ClassParameter[])new ReflectionHelpers.ClassParameter[]{ReflectionHelpers.ClassParameter.from(View.class, (Object)view)});
    }

    public List<View> getViews() {
        return this.views;
    }

    @Implementation(maxSdk=16)
    public Display getDefaultDisplay() {
        if (RuntimeEnvironment.getApiLevel() > 16) {
            return ((WindowManagerImpl)Shadow.directlyOn((Object)this.realObject, WindowManagerImpl.class)).getDefaultDisplay();
        }
        return defaultDisplayJB;
    }

    @Resetter
    public static void reset() {
        defaultDisplayJB = null;
    }

    @Implements(className="android.view.WindowManagerImpl$CompatModeWrapper", maxSdk=16)
    public static class ShadowCompatModeWrapper {
        @Implementation(maxSdk=16)
        public Display getDefaultDisplay() {
            return defaultDisplayJB;
        }
    }
}

