/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.shadows;

import android.app.ApplicationPackageManager;
import android.content.ComponentName;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.IntentSender;
import android.content.pm.ActivityInfo;
import android.content.pm.ApplicationInfo;
import android.content.pm.ComponentInfo;
import android.content.pm.FeatureInfo;
import android.content.pm.IPackageDataObserver;
import android.content.pm.IPackageDeleteObserver;
import android.content.pm.IPackageStatsObserver;
import android.content.pm.InstrumentationInfo;
import android.content.pm.IntentFilterVerificationInfo;
import android.content.pm.PackageInfo;
import android.content.pm.PackageItemInfo;
import android.content.pm.PackageManager;
import android.content.pm.PackageParser;
import android.content.pm.PackageStats;
import android.content.pm.PermissionGroupInfo;
import android.content.pm.PermissionInfo;
import android.content.pm.ProviderInfo;
import android.content.pm.ResolveInfo;
import android.content.pm.ServiceInfo;
import android.content.pm.VerifierDeviceIdentity;
import android.content.res.AssetManager;
import android.content.res.Resources;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.os.Handler;
import android.os.Looper;
import android.os.RemoteException;
import android.os.UserHandle;
import android.os.storage.VolumeInfo;
import android.util.Pair;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.robolectric.RuntimeEnvironment;
import org.robolectric.annotation.Implementation;
import org.robolectric.annotation.Implements;
import org.robolectric.shadows.ShadowPackageManager;

@Implements(value=ApplicationPackageManager.class, isInAndroidSdk=false, looseSignatures=true)
public class ShadowApplicationPackageManager
extends ShadowPackageManager {
    @Implementation
    public List<PackageInfo> getInstalledPackages(int flags) {
        ArrayList<PackageInfo> result = new ArrayList<PackageInfo>();
        for (PackageInfo packageInfo : this.packageInfos.values()) {
            if ((Integer)this.applicationEnabledSettingMap.get(packageInfo.packageName) == 2 && (flags & 0x2000) != 8192 && (flags & 0x200) != 512) continue;
            result.add(packageInfo);
        }
        return result;
    }

    @Implementation
    protected ActivityInfo getActivityInfo(ComponentName component, int flags) throws PackageManager.NameNotFoundException {
        String activityName = component.getClassName();
        String packageName = component.getPackageName();
        PackageInfo packageInfo = (PackageInfo)this.packageInfos.get(packageName);
        if (packageInfo != null) {
            if (packageInfo.activities != null) {
                for (ActivityInfo activity : packageInfo.activities) {
                    if (!activityName.equals(activity.name)) continue;
                    ActivityInfo result = new ActivityInfo(activity);
                    if ((flags & 0x80) != 0) {
                        result.metaData = activity.metaData;
                    }
                    return result;
                }
            }
            ActivityInfo result = new ActivityInfo();
            result.name = activityName;
            result.packageName = packageName;
            result.applicationInfo = new ApplicationInfo(packageInfo.applicationInfo);
            return result;
        }
        ActivityInfo result = new ActivityInfo();
        result.name = activityName;
        result.packageName = packageName;
        result.applicationInfo = new ApplicationInfo();
        result.applicationInfo.packageName = packageName;
        return result;
    }

    @Implementation
    protected boolean hasSystemFeature(String name) {
        return this.systemFeatureList.containsKey(name) ? (Boolean)this.systemFeatureList.get(name) : false;
    }

    @Implementation
    protected int getComponentEnabledSetting(ComponentName componentName) {
        ShadowPackageManager.ComponentState state = (ShadowPackageManager.ComponentState)this.componentList.get(componentName);
        return state != null ? state.newState : 0;
    }

    @Implementation
    protected String getNameForUid(int uid) {
        return (String)this.namesForUid.get(uid);
    }

    @Implementation
    protected String[] getPackagesForUid(int uid) {
        String[] packageNames = (String[])this.packagesForUid.get(uid);
        if (packageNames != null) {
            return packageNames;
        }
        HashSet<String> results = new HashSet<String>();
        for (PackageInfo packageInfo : this.packageInfos.values()) {
            if (packageInfo.applicationInfo == null || packageInfo.applicationInfo.uid != uid) continue;
            results.add(packageInfo.packageName);
        }
        return results.isEmpty() ? null : results.toArray(new String[results.size()]);
    }

    @Implementation
    protected int getApplicationEnabledSetting(String packageName) {
        try {
            this.getPackageInfo(packageName, -1);
        }
        catch (PackageManager.NameNotFoundException e) {
            throw new IllegalArgumentException(e);
        }
        return (Integer)this.applicationEnabledSettingMap.get(packageName);
    }

    @Implementation
    protected ProviderInfo getProviderInfo(ComponentName component, int flags) throws PackageManager.NameNotFoundException {
        String packageName = component.getPackageName();
        PackageInfo packageInfo = (PackageInfo)this.packageInfos.get(packageName);
        if (packageInfo != null && packageInfo.providers != null) {
            for (ProviderInfo provider : packageInfo.providers) {
                if (!ShadowApplicationPackageManager.resolvePackageName(packageName, component).equals(provider.name)) continue;
                ProviderInfo result = new ProviderInfo();
                result.packageName = provider.packageName;
                result.name = provider.name;
                result.authority = provider.authority;
                result.readPermission = provider.readPermission;
                result.writePermission = provider.writePermission;
                result.pathPermissions = provider.pathPermissions;
                if ((flags & 0x80) != 0) {
                    result.metaData = provider.metaData;
                }
                return result;
            }
        }
        throw new PackageManager.NameNotFoundException("Package not found: " + packageName);
    }

    @Implementation
    protected void setComponentEnabledSetting(ComponentName componentName, int newState, int flags) {
        this.componentList.put(componentName, new ShadowPackageManager.ComponentState(newState, flags));
    }

    @Implementation
    protected void setApplicationEnabledSetting(String packageName, int newState, int flags) {
        this.applicationEnabledSettingMap.put(packageName, newState);
    }

    @Implementation
    protected ResolveInfo resolveActivity(Intent intent, int flags) {
        List<ResolveInfo> candidates = this.queryIntentActivities(intent, flags);
        return candidates.isEmpty() ? null : candidates.get(0);
    }

    @Implementation
    protected ProviderInfo resolveContentProvider(String name, int flags) {
        if (name == null) {
            return null;
        }
        for (PackageInfo packageInfo : this.packageInfos.values()) {
            if (packageInfo.providers == null) continue;
            for (ProviderInfo providerInfo : packageInfo.providers) {
                if (!name.equals(providerInfo.authority)) continue;
                return providerInfo;
            }
        }
        return null;
    }

    @Implementation
    protected ProviderInfo resolveContentProviderAsUser(String name, int flags, int userId) {
        return null;
    }

    @Implementation
    protected PackageInfo getPackageInfo(String packageName, int flags) throws PackageManager.NameNotFoundException {
        PackageInfo info = (PackageInfo)this.packageInfos.get(packageName);
        if (info != null) {
            if ((Integer)this.applicationEnabledSettingMap.get(packageName) == 2 && (flags & 0x2000) != 8192 && (flags & 0x200) != 512) {
                throw new PackageManager.NameNotFoundException("Package is disabled, can't find");
            }
            return info;
        }
        throw new PackageManager.NameNotFoundException(packageName);
    }

    @Implementation
    protected List<ResolveInfo> queryIntentServices(Intent intent, int flags) {
        List<ResolveInfo> resolveInfoList = this.queryOverriddenIntents(intent, flags);
        if (!resolveInfoList.isEmpty()) {
            return this.filterResolvedServices(resolveInfoList, flags);
        }
        if (ShadowApplicationPackageManager.isExplicitIntent(intent)) {
            ResolveInfo resolvedService = this.resolveServiceForExplicitIntent(intent);
            if (resolvedService != null) {
                resolveInfoList = this.filterResolvedServices(Arrays.asList(resolvedService), flags);
            }
        } else {
            resolveInfoList = this.filterResolvedServices(this.queryImplicitIntentServices(intent, flags), flags);
        }
        return resolveInfoList;
    }

    private List<ResolveInfo> filterResolvedServices(List<ResolveInfo> resolveInfoList, int flags) {
        if (ShadowApplicationPackageManager.isFlagSet(flags, 131072)) {
            return resolveInfoList;
        }
        resolveInfoList = new ArrayList<ResolveInfo>(resolveInfoList);
        Iterator<ResolveInfo> iterator = resolveInfoList.iterator();
        while (iterator.hasNext()) {
            ComponentName componentName;
            ResolveInfo resolveInfo = iterator.next();
            if (ShadowApplicationPackageManager.isFlagSet(flags, 0x100000)) {
                if (resolveInfo.serviceInfo == null || resolveInfo.serviceInfo.applicationInfo == null) {
                    iterator.remove();
                    continue;
                }
                int applicationFlags = resolveInfo.serviceInfo.applicationInfo.flags;
                if ((applicationFlags & 1) == 1) continue;
                iterator.remove();
                continue;
            }
            if (ShadowApplicationPackageManager.isFlagSet(flags, 512) || resolveInfo == null || !ShadowApplicationPackageManager.isValidComponentInfo((ComponentInfo)resolveInfo.serviceInfo) || (this.getComponentEnabledSetting(componentName = new ComponentName(resolveInfo.serviceInfo.applicationInfo.packageName, resolveInfo.serviceInfo.name)) & 2) == 0) continue;
            iterator.remove();
        }
        return resolveInfoList;
    }

    private static boolean isFlagSet(int flags, int matchFlag) {
        return (flags & matchFlag) == matchFlag;
    }

    private static boolean isValidComponentInfo(ComponentInfo componentInfo) {
        return componentInfo != null && componentInfo.applicationInfo != null && componentInfo.applicationInfo.packageName != null && componentInfo.name != null;
    }

    @Implementation(minSdk=17)
    protected List<ResolveInfo> queryIntentServicesAsUser(Intent intent, int flags, int userId) {
        return this.queryIntentServices(intent, flags);
    }

    @Implementation
    protected List<ResolveInfo> queryIntentActivities(Intent intent, int flags) {
        List<ResolveInfo> resolveInfoList = this.queryOverriddenIntents(intent, flags);
        if (!resolveInfoList.isEmpty()) {
            return this.filterResolvedActivities(resolveInfoList, flags);
        }
        if (ShadowApplicationPackageManager.isExplicitIntent(intent)) {
            ResolveInfo resolvedActivity = this.resolveActivityForExplicitIntent(intent);
            if (resolvedActivity != null) {
                resolveInfoList = this.filterResolvedActivities(Arrays.asList(resolvedActivity), flags);
            }
        } else {
            resolveInfoList = this.filterResolvedActivities(this.queryImplicitIntentActivities(intent, flags), flags);
        }
        return resolveInfoList;
    }

    private List<ResolveInfo> filterResolvedActivities(List<ResolveInfo> resolveInfoList, int flags) {
        if (ShadowApplicationPackageManager.isFlagSet(flags, 131072)) {
            return resolveInfoList;
        }
        resolveInfoList = new ArrayList<ResolveInfo>(resolveInfoList);
        Iterator<ResolveInfo> iterator = resolveInfoList.iterator();
        while (iterator.hasNext()) {
            ComponentName componentName;
            ResolveInfo resolveInfo = iterator.next();
            if (ShadowApplicationPackageManager.isFlagSet(flags, 0x100000)) {
                if (resolveInfo.activityInfo == null || resolveInfo.activityInfo.applicationInfo == null) {
                    iterator.remove();
                    continue;
                }
                int applicationFlags = resolveInfo.activityInfo.applicationInfo.flags;
                if (ShadowApplicationPackageManager.isFlagSet(applicationFlags, 1)) continue;
                iterator.remove();
                continue;
            }
            if (ShadowApplicationPackageManager.isFlagSet(flags, 512) || resolveInfo == null || !ShadowApplicationPackageManager.isValidComponentInfo((ComponentInfo)resolveInfo.activityInfo) || (this.getComponentEnabledSetting(componentName = new ComponentName(resolveInfo.activityInfo.applicationInfo.packageName, resolveInfo.activityInfo.name)) & 2) == 0) continue;
            iterator.remove();
        }
        return resolveInfoList;
    }

    private static boolean isExplicitIntent(Intent intent) {
        return ShadowApplicationPackageManager.getComponentForIntent(intent) != null;
    }

    private ResolveInfo resolveActivityForExplicitIntent(Intent intent) {
        ComponentName component = ShadowApplicationPackageManager.getComponentForIntent(intent);
        for (PackageParser.Package appPackage : this.packages.values()) {
            PackageParser.Activity activity = (PackageParser.Activity)ShadowApplicationPackageManager.findMatchingComponent(component, appPackage.activities);
            if (activity == null) continue;
            return ShadowApplicationPackageManager.buildResolveInfo(activity);
        }
        return null;
    }

    private ResolveInfo resolveServiceForExplicitIntent(Intent intent) {
        ComponentName component = ShadowApplicationPackageManager.getComponentForIntent(intent);
        for (PackageParser.Package appPackage : this.packages.values()) {
            PackageParser.Service service = (PackageParser.Service)ShadowApplicationPackageManager.findMatchingComponent(component, appPackage.services);
            if (service == null) continue;
            return ShadowApplicationPackageManager.buildResolveInfo(service);
        }
        return null;
    }

    private ResolveInfo resolveReceiverForExplicitIntent(Intent intent) {
        ComponentName component = ShadowApplicationPackageManager.getComponentForIntent(intent);
        for (PackageParser.Package appPackage : this.packages.values()) {
            PackageParser.Activity receiver = (PackageParser.Activity)ShadowApplicationPackageManager.findMatchingComponent(component, appPackage.receivers);
            if (receiver == null) continue;
            return ShadowApplicationPackageManager.buildResolveInfo(receiver);
        }
        return null;
    }

    private static <T extends PackageParser.Component> T findMatchingComponent(ComponentName componentName, List<T> components) {
        for (PackageParser.Component component : components) {
            if (!componentName.equals((Object)component.getComponentName())) continue;
            return (T)component;
        }
        return null;
    }

    private static ComponentName getComponentForIntent(Intent intent) {
        ComponentName component = intent.getComponent();
        if (component == null && intent.getSelector() != null) {
            intent = intent.getSelector();
            component = intent.getComponent();
        }
        return component;
    }

    private List<ResolveInfo> queryImplicitIntentActivities(Intent intent, int flags) {
        ArrayList<ResolveInfo> resolveInfoList = new ArrayList<ResolveInfo>();
        for (PackageParser.Package appPackage : this.packages.values()) {
            if (intent.getPackage() != null && !intent.getPackage().equals(appPackage.packageName)) continue;
            for (PackageParser.Activity activity : appPackage.activities) {
                IntentFilter intentFilter = ShadowApplicationPackageManager.matchIntentFilter(intent, activity.intents, flags);
                if (intentFilter == null) continue;
                resolveInfoList.add(ShadowApplicationPackageManager.buildResolveInfo(activity, intentFilter));
            }
        }
        return resolveInfoList;
    }

    private List<ResolveInfo> queryImplicitIntentServices(Intent intent, int flags) {
        ArrayList<ResolveInfo> resolveInfoList = new ArrayList<ResolveInfo>();
        for (PackageParser.Package appPackage : this.packages.values()) {
            if (intent.getPackage() != null && !intent.getPackage().equals(appPackage.packageName)) continue;
            for (PackageParser.Service service : appPackage.services) {
                IntentFilter intentFilter = ShadowApplicationPackageManager.matchIntentFilter(intent, service.intents, flags);
                if (intentFilter == null) continue;
                resolveInfoList.add(ShadowApplicationPackageManager.buildResolveInfo(service, intentFilter));
            }
        }
        return resolveInfoList;
    }

    private List<ResolveInfo> queryImplicitIntentReceivers(Intent intent, int flags) {
        ArrayList<ResolveInfo> resolveInfoList = new ArrayList<ResolveInfo>();
        for (PackageParser.Package appPackage : this.packages.values()) {
            if (intent.getPackage() != null && !intent.getPackage().equals(appPackage.packageName)) continue;
            for (PackageParser.Activity activity : appPackage.receivers) {
                IntentFilter intentFilter = ShadowApplicationPackageManager.matchIntentFilter(intent, activity.intents, flags);
                if (intentFilter == null) continue;
                resolveInfoList.add(ShadowApplicationPackageManager.buildResolveInfo(activity, intentFilter));
            }
        }
        return resolveInfoList;
    }

    static ResolveInfo buildResolveInfo(PackageParser.Activity activity) {
        ResolveInfo resolveInfo = ShadowApplicationPackageManager.buildResolveInfo((ComponentInfo)activity.info);
        resolveInfo.activityInfo = activity.info;
        return resolveInfo;
    }

    static ResolveInfo buildResolveInfo(PackageParser.Service service) {
        ResolveInfo resolveInfo = ShadowApplicationPackageManager.buildResolveInfo((ComponentInfo)service.info);
        resolveInfo.serviceInfo = service.info;
        return resolveInfo;
    }

    private static ResolveInfo buildResolveInfo(ComponentInfo componentInfo) {
        ResolveInfo resolveInfo = new ResolveInfo();
        resolveInfo.resolvePackageName = componentInfo.applicationInfo.packageName;
        return resolveInfo;
    }

    static ResolveInfo buildResolveInfo(PackageParser.Activity activity, IntentFilter intentFilter) {
        ResolveInfo info = ShadowApplicationPackageManager.buildResolveInfo(activity);
        info.isDefault = intentFilter.hasCategory("Intent.CATEGORY_DEFAULT");
        info.filter = new IntentFilter(intentFilter);
        return info;
    }

    static ResolveInfo buildResolveInfo(PackageParser.Service service, IntentFilter intentFilter) {
        ResolveInfo info = ShadowApplicationPackageManager.buildResolveInfo(service);
        info.isDefault = intentFilter.hasCategory("Intent.CATEGORY_DEFAULT");
        info.serviceInfo = service.info;
        info.filter = new IntentFilter(intentFilter);
        return info;
    }

    @Implementation
    protected int checkPermission(String permName, String pkgName) {
        PackageInfo permissionsInfo = (PackageInfo)this.packageInfos.get(pkgName);
        if (permissionsInfo == null || permissionsInfo.requestedPermissions == null) {
            return -1;
        }
        for (String permission2 : permissionsInfo.requestedPermissions) {
            if (permission2 == null || !permission2.equals(permName)) continue;
            return 0;
        }
        return -1;
    }

    @Implementation
    protected ActivityInfo getReceiverInfo(ComponentName className, int flags) throws PackageManager.NameNotFoundException {
        String packageName = className.getPackageName();
        PackageInfo packageInfo = (PackageInfo)this.packageInfos.get(packageName);
        if (packageInfo != null && packageInfo.receivers != null) {
            for (ActivityInfo receiver : packageInfo.receivers) {
                if (!ShadowApplicationPackageManager.resolvePackageName(packageName, className).equals(receiver.name)) continue;
                ActivityInfo result = new ActivityInfo();
                result.packageName = receiver.packageName;
                result.name = receiver.name;
                if ((flags & 0x80) != 0) {
                    result.metaData = receiver.metaData;
                }
                return result;
            }
        }
        return null;
    }

    @Implementation
    protected List<ResolveInfo> queryBroadcastReceivers(Intent intent, int flags) {
        List<ResolveInfo> resolveInfoList = this.queryOverriddenIntents(intent, flags);
        if (!resolveInfoList.isEmpty()) {
            return this.filterResolvedActivities(resolveInfoList, flags);
        }
        if (ShadowApplicationPackageManager.isExplicitIntent(intent)) {
            ResolveInfo resolvedReceiver = this.resolveReceiverForExplicitIntent(intent);
            if (resolvedReceiver != null) {
                resolveInfoList = this.filterResolvedActivities(Arrays.asList(resolvedReceiver), flags);
            }
        } else {
            resolveInfoList = this.filterResolvedActivities(this.queryImplicitIntentReceivers(intent, flags), flags);
        }
        return resolveInfoList;
    }

    private static IntentFilter matchIntentFilter(Intent intent, ArrayList<? extends PackageParser.IntentInfo> intentFilters, int flags) {
        for (PackageParser.IntentInfo intentInfo : intentFilters) {
            if (intentInfo.match(intent.getAction(), intent.getType(), intent.getScheme(), intent.getData(), intent.getCategories(), "ShadowPackageManager") < 0) continue;
            return intentInfo;
        }
        return null;
    }

    @Implementation
    protected ResolveInfo resolveService(Intent intent, int flags) {
        List<ResolveInfo> candidates = this.queryIntentServices(intent, flags);
        return candidates.isEmpty() ? null : candidates.get(0);
    }

    @Implementation
    protected ServiceInfo getServiceInfo(ComponentName className, int flags) throws PackageManager.NameNotFoundException {
        String packageName = className.getPackageName();
        PackageInfo packageInfo = (PackageInfo)this.packageInfos.get(packageName);
        if (packageInfo != null) {
            String serviceName = className.getClassName();
            if (packageInfo.services != null) {
                for (ServiceInfo service : packageInfo.services) {
                    if (!serviceName.equals(service.name)) continue;
                    ServiceInfo result = new ServiceInfo();
                    result.packageName = service.packageName;
                    result.name = service.name;
                    result.applicationInfo = service.applicationInfo;
                    result.permission = service.permission;
                    if ((flags & 0x80) != 0) {
                        result.metaData = service.metaData;
                    }
                    return result;
                }
            }
            throw new PackageManager.NameNotFoundException(serviceName);
        }
        return null;
    }

    @Implementation
    protected Resources getResourcesForApplication(ApplicationInfo applicationInfo) throws PackageManager.NameNotFoundException {
        return this.getResourcesForApplication(applicationInfo.packageName);
    }

    @Implementation
    protected List<ApplicationInfo> getInstalledApplications(int flags) {
        ArrayList<ApplicationInfo> result = new ArrayList<ApplicationInfo>();
        for (PackageInfo packageInfo : this.packageInfos.values()) {
            result.add(packageInfo.applicationInfo);
        }
        return result;
    }

    @Implementation
    protected String getInstallerPackageName(String packageName) {
        return (String)this.packageInstallerMap.get(packageName);
    }

    @Implementation
    protected PermissionInfo getPermissionInfo(String name, int flags) throws PackageManager.NameNotFoundException {
        PermissionInfo permissionInfo = (PermissionInfo)this.extraPermissions.get(name);
        if (permissionInfo != null) {
            return permissionInfo;
        }
        for (PackageInfo packageInfo : this.packageInfos.values()) {
            if (packageInfo.permissions == null) continue;
            for (PermissionInfo permission2 : packageInfo.permissions) {
                if (!name.equals(permission2.name)) continue;
                return ShadowApplicationPackageManager.createCopyPermissionInfo(permission2, flags);
            }
        }
        throw new PackageManager.NameNotFoundException(name);
    }

    @Implementation(minSdk=23)
    protected boolean shouldShowRequestPermissionRationale(String permission2) {
        return this.permissionRationaleMap.containsKey(permission2) ? (Boolean)this.permissionRationaleMap.get(permission2) : false;
    }

    @Implementation
    protected FeatureInfo[] getSystemAvailableFeatures() {
        return this.systemAvailableFeatures.isEmpty() ? null : this.systemAvailableFeatures.toArray(new FeatureInfo[this.systemAvailableFeatures.size()]);
    }

    @Implementation
    protected void verifyPendingInstall(int id2, int verificationCode) {
        if (this.verificationResults.containsKey(id2)) {
            throw new IllegalStateException("Multiple verifications for id=" + id2);
        }
        this.verificationResults.put(id2, verificationCode);
    }

    @Implementation
    protected void extendVerificationTimeout(int id2, int verificationCodeAtTimeout, long millisecondsToDelay) {
        this.verificationTimeoutExtension.put(id2, millisecondsToDelay);
    }

    @Override
    @Implementation
    protected void freeStorageAndNotify(long freeStorageSize, IPackageDataObserver observer) {
    }

    @Implementation
    protected void freeStorageAndNotify(String volumeUuid, long freeStorageSize, IPackageDataObserver observer) {
    }

    @Implementation
    protected void setInstallerPackageName(String targetPackage, String installerPackageName) {
        this.packageInstallerMap.put(targetPackage, installerPackageName);
    }

    @Implementation
    protected List<ResolveInfo> queryIntentContentProviders(Intent intent, int flags) {
        return Collections.emptyList();
    }

    @Implementation
    protected List<ResolveInfo> queryIntentContentProvidersAsUser(Intent intent, int flags, int userId) {
        return Collections.emptyList();
    }

    @Implementation
    protected String getPermissionControllerPackageName() {
        return null;
    }

    @Implementation(maxSdk=16)
    protected void getPackageSizeInfo(Object pkgName, Object observer) {
        PackageStats packageStats = (PackageStats)this.packageStatsMap.get((String)pkgName);
        new Handler(Looper.getMainLooper()).post(() -> {
            try {
                ((IPackageStatsObserver)observer).onGetStatsCompleted(packageStats, packageStats != null);
            }
            catch (RemoteException remoteException) {
                remoteException.rethrowFromSystemServer();
            }
        });
    }

    @Implementation(minSdk=17, maxSdk=23)
    protected void getPackageSizeInfo(Object pkgName, Object uid, Object observer) {
        PackageStats packageStats = (PackageStats)this.packageStatsMap.get((String)pkgName);
        new Handler(Looper.getMainLooper()).post(() -> {
            try {
                ((IPackageStatsObserver)observer).onGetStatsCompleted(packageStats, packageStats != null);
            }
            catch (RemoteException remoteException) {
                remoteException.rethrowFromSystemServer();
            }
        });
    }

    @Implementation(minSdk=24)
    protected void getPackageSizeInfoAsUser(Object pkgName, Object uid, Object observer) {
        PackageStats packageStats = (PackageStats)this.packageStatsMap.get((String)pkgName);
        new Handler(Looper.getMainLooper()).post(() -> {
            try {
                ((IPackageStatsObserver)observer).onGetStatsCompleted(packageStats, packageStats != null);
            }
            catch (RemoteException remoteException) {
                remoteException.rethrowFromSystemServer();
            }
        });
    }

    @Implementation
    protected void deletePackage(String packageName, IPackageDeleteObserver observer, int flags) {
        this.pendingDeleteCallbacks.put(packageName, observer);
    }

    @Implementation
    protected String[] currentToCanonicalPackageNames(String[] names) {
        String[] out = new String[names.length];
        for (int i = names.length - 1; i >= 0; --i) {
            out[i] = this.currentToCanonicalNames.containsKey(names[i]) ? (String)this.currentToCanonicalNames.get(names[i]) : names[i];
        }
        return out;
    }

    @Implementation
    protected boolean isSafeMode() {
        return false;
    }

    @Implementation
    protected Drawable getApplicationIcon(String packageName) throws PackageManager.NameNotFoundException {
        return (Drawable)this.applicationIcons.get(packageName);
    }

    @Implementation
    protected Drawable getApplicationIcon(ApplicationInfo info) {
        return null;
    }

    @Implementation
    protected Drawable getUserBadgeForDensity(UserHandle userHandle, int i) {
        return null;
    }

    @Implementation
    protected int checkSignatures(String pkg1, String pkg2) {
        try {
            PackageInfo packageInfo1 = this.getPackageInfo(pkg1, 64);
            PackageInfo packageInfo2 = this.getPackageInfo(pkg2, 64);
            return ShadowApplicationPackageManager.compareSignature(packageInfo1.signatures, packageInfo2.signatures);
        }
        catch (PackageManager.NameNotFoundException e) {
            return -4;
        }
    }

    @Implementation
    protected int checkSignatures(int uid1, int uid2) {
        return 0;
    }

    @Implementation
    protected List<PermissionInfo> queryPermissionsByGroup(String group, int flags) throws PackageManager.NameNotFoundException {
        ArrayList<PermissionInfo> result = new ArrayList<PermissionInfo>();
        for (PermissionInfo permissionInfo : this.extraPermissions.values()) {
            if (!Objects.equals(permissionInfo.group, group)) continue;
            result.add(permissionInfo);
        }
        for (PackageInfo packageInfo : this.packageInfos.values()) {
            if (packageInfo.permissions == null) continue;
            for (PermissionInfo permission2 : packageInfo.permissions) {
                if (!Objects.equals(group, permission2.group)) continue;
                result.add(ShadowApplicationPackageManager.createCopyPermissionInfo(permission2, flags));
            }
        }
        return result;
    }

    private static PermissionInfo createCopyPermissionInfo(PermissionInfo src, int flags) {
        PermissionInfo matchedPermission = new PermissionInfo(src);
        if ((flags & 0x80) != 128) {
            matchedPermission.metaData = null;
        }
        return matchedPermission;
    }

    @Implementation
    protected Intent getLaunchIntentForPackage(String packageName) {
        Intent intentToResolve = new Intent("android.intent.action.MAIN");
        intentToResolve.addCategory("android.intent.category.INFO");
        intentToResolve.setPackage(packageName);
        List<ResolveInfo> ris = this.queryIntentActivities(intentToResolve, 0);
        if (ris == null || ris.isEmpty()) {
            intentToResolve.removeCategory("android.intent.category.INFO");
            intentToResolve.addCategory("android.intent.category.LAUNCHER");
            intentToResolve.setPackage(packageName);
            ris = this.queryIntentActivities(intentToResolve, 0);
        }
        if (ris == null || ris.isEmpty()) {
            return null;
        }
        Intent intent = new Intent(intentToResolve);
        intent.setFlags(0x10000000);
        intent.setClassName(packageName, ris.get((int)0).activityInfo.name);
        return intent;
    }

    @Implementation
    protected PackageInfo getPackageInfoAsUser(String packageName, int flags, int userId) throws PackageManager.NameNotFoundException {
        return null;
    }

    @Implementation
    protected String[] canonicalToCurrentPackageNames(String[] names) {
        return new String[0];
    }

    @Implementation
    protected Intent getLeanbackLaunchIntentForPackage(String packageName) {
        return null;
    }

    @Implementation
    protected int[] getPackageGids(String packageName) throws PackageManager.NameNotFoundException {
        return new int[0];
    }

    @Implementation
    protected int[] getPackageGids(String packageName, int flags) throws PackageManager.NameNotFoundException {
        return null;
    }

    @Implementation
    protected int getPackageUid(String packageName, int flags) throws PackageManager.NameNotFoundException {
        Integer uid = (Integer)this.uidForPackage.get(packageName);
        if (uid == null) {
            throw new PackageManager.NameNotFoundException(packageName);
        }
        return uid;
    }

    @Implementation
    protected int getPackageUidAsUser(String packageName, int userId) throws PackageManager.NameNotFoundException {
        return 0;
    }

    @Implementation
    protected int getPackageUidAsUser(String packageName, int flags, int userId) throws PackageManager.NameNotFoundException {
        return 0;
    }

    @Implementation
    protected PermissionGroupInfo getPermissionGroupInfo(String name, int flags) throws PackageManager.NameNotFoundException {
        if (this.extraPermissionGroups.containsKey(name)) {
            return new PermissionGroupInfo((PermissionGroupInfo)this.extraPermissionGroups.get(name));
        }
        for (PackageParser.Package pkg : this.packages.values()) {
            for (PackageParser.PermissionGroup permissionGroup : pkg.permissionGroups) {
                if (!name.equals(permissionGroup.info.name)) continue;
                return PackageParser.generatePermissionGroupInfo((PackageParser.PermissionGroup)permissionGroup, (int)flags);
            }
        }
        throw new PackageManager.NameNotFoundException(name);
    }

    @Implementation
    protected List<PermissionGroupInfo> getAllPermissionGroups(int flags) {
        ArrayList<PermissionGroupInfo> allPermissionGroups = new ArrayList<PermissionGroupInfo>();
        HashSet<String> handledPermissionGroups = new HashSet<String>();
        for (PermissionGroupInfo permissionGroupInfo : this.extraPermissionGroups.values()) {
            allPermissionGroups.add(new PermissionGroupInfo(permissionGroupInfo));
            handledPermissionGroups.add(permissionGroupInfo.name);
        }
        for (PackageParser.Package pkg : this.packages.values()) {
            for (PackageParser.PermissionGroup permissionGroup : pkg.permissionGroups) {
                if (handledPermissionGroups.contains(permissionGroup.info.name)) continue;
                PermissionGroupInfo permissionGroupInfo = PackageParser.generatePermissionGroupInfo((PackageParser.PermissionGroup)permissionGroup, (int)flags);
                allPermissionGroups.add(new PermissionGroupInfo(permissionGroupInfo));
                handledPermissionGroups.add(permissionGroup.info.name);
            }
        }
        return allPermissionGroups;
    }

    @Implementation
    protected ApplicationInfo getApplicationInfo(String packageName, int flags) throws PackageManager.NameNotFoundException {
        PackageInfo info = (PackageInfo)this.packageInfos.get(packageName);
        if (info != null) {
            try {
                PackageInfo packageInfo = this.getPackageInfo(packageName, -1);
            }
            catch (PackageManager.NameNotFoundException e) {
                throw new IllegalArgumentException(e);
            }
            if ((Integer)this.applicationEnabledSettingMap.get(packageName) == 2 && (flags & 0x2000) != 8192 && (flags & 0x200) != 512) {
                throw new PackageManager.NameNotFoundException("Package is disabled, can't find");
            }
            return info.applicationInfo;
        }
        throw new PackageManager.NameNotFoundException(packageName);
    }

    @Implementation
    protected String[] getSystemSharedLibraryNames() {
        return new String[0];
    }

    @Implementation
    protected String getServicesSystemSharedLibraryPackageName() {
        return null;
    }

    @Implementation
    protected String getSharedSystemSharedLibraryPackageName() {
        return "";
    }

    @Implementation
    protected boolean hasSystemFeature(String name, int version) {
        return false;
    }

    @Implementation
    protected boolean isPermissionRevokedByPolicy(String permName, String pkgName) {
        return false;
    }

    @Implementation
    protected boolean addPermission(PermissionInfo info) {
        return false;
    }

    @Implementation
    protected boolean addPermissionAsync(PermissionInfo info) {
        return false;
    }

    @Implementation
    protected void removePermission(String name) {
    }

    @Implementation
    protected void grantRuntimePermission(String packageName, String permissionName, UserHandle user) {
    }

    @Implementation
    protected void revokeRuntimePermission(String packageName, String permissionName, UserHandle user) {
    }

    @Implementation
    protected int getPermissionFlags(String permissionName, String packageName, UserHandle user) {
        return 0;
    }

    @Implementation
    protected void updatePermissionFlags(String permissionName, String packageName, int flagMask, int flagValues, UserHandle user) {
    }

    @Implementation
    protected int getUidForSharedUser(String sharedUserName) throws PackageManager.NameNotFoundException {
        return 0;
    }

    @Implementation
    protected List<PackageInfo> getInstalledPackagesAsUser(int flags, int userId) {
        return null;
    }

    @Implementation
    protected List<PackageInfo> getPackagesHoldingPermissions(String[] permissions, int flags) {
        return null;
    }

    @Implementation
    protected ResolveInfo resolveActivityAsUser(Intent intent, int flags, int userId) {
        return null;
    }

    @Implementation
    protected List<ResolveInfo> queryIntentActivitiesAsUser(Intent intent, int flags, int userId) {
        return null;
    }

    @Implementation
    protected List<ResolveInfo> queryIntentActivityOptions(ComponentName caller, Intent[] specifics, Intent intent, int flags) {
        return null;
    }

    @Implementation
    protected List<ResolveInfo> queryBroadcastReceiversAsUser(Intent intent, int flags, int userId) {
        return null;
    }

    @Implementation
    protected List<ProviderInfo> queryContentProviders(String processName, int uid, int flags) {
        return null;
    }

    @Implementation
    protected InstrumentationInfo getInstrumentationInfo(ComponentName className, int flags) throws PackageManager.NameNotFoundException {
        return null;
    }

    @Implementation
    protected List<InstrumentationInfo> queryInstrumentation(String targetPackage, int flags) {
        return null;
    }

    @Implementation
    protected Drawable getDrawable(String packageName, int resId, ApplicationInfo appInfo) {
        return (Drawable)this.drawables.get(new Pair((Object)packageName, (Object)resId));
    }

    @Implementation
    protected Drawable getActivityIcon(ComponentName activityName) throws PackageManager.NameNotFoundException {
        return (Drawable)this.drawableList.get(activityName);
    }

    @Implementation
    protected Drawable getDefaultActivityIcon() {
        return Resources.getSystem().getDrawable(17301651);
    }

    @Implementation
    protected Drawable getActivityBanner(ComponentName activityName) throws PackageManager.NameNotFoundException {
        return null;
    }

    @Implementation
    protected Drawable getActivityBanner(Intent intent) throws PackageManager.NameNotFoundException {
        return null;
    }

    @Implementation
    protected Drawable getApplicationBanner(ApplicationInfo info) {
        return null;
    }

    @Implementation
    protected Drawable getApplicationBanner(String packageName) throws PackageManager.NameNotFoundException {
        return null;
    }

    @Implementation
    protected Drawable getActivityLogo(ComponentName activityName) throws PackageManager.NameNotFoundException {
        return null;
    }

    @Implementation
    protected Drawable getActivityLogo(Intent intent) throws PackageManager.NameNotFoundException {
        return null;
    }

    @Implementation
    protected Drawable getApplicationLogo(ApplicationInfo info) {
        return null;
    }

    @Implementation
    protected Drawable getApplicationLogo(String packageName) throws PackageManager.NameNotFoundException {
        return null;
    }

    @Implementation
    protected Drawable getUserBadgedIcon(Drawable icon, UserHandle user) {
        return null;
    }

    @Implementation
    protected Drawable getUserBadgedDrawableForDensity(Drawable drawable2, UserHandle user, Rect badgeLocation, int badgeDensity) {
        return null;
    }

    @Implementation
    protected Drawable getUserBadgeForDensityNoBackground(UserHandle user, int density) {
        return null;
    }

    @Implementation
    protected CharSequence getUserBadgedLabel(CharSequence label, UserHandle user) {
        return null;
    }

    @Implementation
    protected Resources getResourcesForActivity(ComponentName activityName) throws PackageManager.NameNotFoundException {
        return null;
    }

    @Implementation
    protected Resources getResourcesForApplication(String appPackageName) throws PackageManager.NameNotFoundException {
        if (RuntimeEnvironment.application.getPackageName().equals(appPackageName)) {
            return RuntimeEnvironment.application.getResources();
        }
        if (this.packageInfos.containsKey(appPackageName)) {
            Resources appResources = (Resources)this.resources.get(appPackageName);
            if (appResources == null) {
                appResources = new Resources(new AssetManager(), null, null);
                this.resources.put(appPackageName, appResources);
            }
            return appResources;
        }
        throw new PackageManager.NameNotFoundException(appPackageName);
    }

    @Implementation
    protected Resources getResourcesForApplicationAsUser(String appPackageName, int userId) throws PackageManager.NameNotFoundException {
        return null;
    }

    @Implementation
    protected void addOnPermissionsChangeListener(Object listener) {
    }

    @Implementation
    protected void removeOnPermissionsChangeListener(Object listener) {
    }

    @Implementation
    protected void installPackage(Object packageURI, Object observer, Object flags, Object installerPackageName) {
    }

    @Implementation
    protected int installExistingPackage(String packageName) throws PackageManager.NameNotFoundException {
        return 0;
    }

    @Implementation
    protected int installExistingPackageAsUser(String packageName, int userId) throws PackageManager.NameNotFoundException {
        return 0;
    }

    @Implementation
    protected void verifyIntentFilter(int id2, int verificationCode, List<String> failedDomains) {
    }

    @Implementation
    protected int getIntentVerificationStatusAsUser(String packageName, int userId) {
        return 0;
    }

    @Implementation
    protected boolean updateIntentVerificationStatusAsUser(String packageName, int status, int userId) {
        return false;
    }

    @Implementation
    protected List<IntentFilterVerificationInfo> getIntentFilterVerifications(String packageName) {
        return null;
    }

    @Implementation
    protected List<IntentFilter> getAllIntentFilters(String packageName) {
        return null;
    }

    @Implementation
    protected String getDefaultBrowserPackageNameAsUser(int userId) {
        return null;
    }

    @Implementation
    protected boolean setDefaultBrowserPackageNameAsUser(String packageName, int userId) {
        return false;
    }

    @Implementation
    protected int getMoveStatus(int moveId) {
        return 0;
    }

    @Implementation
    protected void registerMoveCallback(Object callback, Object handler) {
    }

    @Implementation
    protected void unregisterMoveCallback(Object callback) {
    }

    @Implementation
    protected Object movePackage(Object packageName, Object vol) {
        return 0;
    }

    @Implementation
    protected Object getPackageCurrentVolume(Object app) {
        return null;
    }

    @Implementation
    protected List<VolumeInfo> getPackageCandidateVolumes(ApplicationInfo app) {
        return null;
    }

    @Implementation
    protected Object movePrimaryStorage(Object vol) {
        return 0;
    }

    @Implementation
    protected Object getPrimaryStorageCurrentVolume() {
        return null;
    }

    @Implementation
    protected List<VolumeInfo> getPrimaryStorageCandidateVolumes() {
        return null;
    }

    @Implementation
    protected void deletePackageAsUser(String packageName, IPackageDeleteObserver observer, int flags, int userId) {
    }

    @Implementation
    protected void clearApplicationUserData(String packageName, IPackageDataObserver observer) {
    }

    @Implementation
    protected void deleteApplicationCacheFiles(String packageName, IPackageDataObserver observer) {
    }

    @Implementation
    protected void deleteApplicationCacheFilesAsUser(String packageName, int userId, IPackageDataObserver observer) {
    }

    @Implementation
    protected void freeStorage(String volumeUuid, long freeStorageSize, IntentSender pi) {
    }

    @Implementation
    protected String[] setPackagesSuspendedAsUser(String[] packageNames, boolean suspended, int userId) {
        return null;
    }

    @Implementation
    protected boolean isPackageSuspendedForUser(String packageName, int userId) {
        return false;
    }

    @Implementation
    protected void addPackageToPreferred(String packageName) {
    }

    @Implementation
    protected void removePackageFromPreferred(String packageName) {
    }

    @Implementation
    protected List<PackageInfo> getPreferredPackages(int flags) {
        return null;
    }

    @Override
    public void addPreferredActivity(IntentFilter filter, int match, ComponentName[] set, ComponentName activity) {
        this.preferredActivities.put(filter, activity);
    }

    @Implementation
    protected void replacePreferredActivity(IntentFilter filter, int match, ComponentName[] set, ComponentName activity) {
    }

    @Implementation
    protected void clearPackagePreferredActivities(String packageName) {
    }

    @Override
    public int getPreferredActivities(List<IntentFilter> outFilters, List<ComponentName> outActivities, String packageName) {
        if (outFilters == null) {
            return 0;
        }
        Set filters = this.preferredActivities.keySet();
        for (IntentFilter filter : outFilters) {
            block1: for (IntentFilter testFilter : filters) {
                ComponentName name = (ComponentName)this.preferredActivities.get(testFilter);
                if (packageName != null && !name.getPackageName().equals(packageName)) continue;
                Iterator iterator = filter.actionsIterator();
                while (iterator.hasNext()) {
                    if (testFilter.matchAction((String)iterator.next())) continue;
                    continue block1;
                }
                iterator = filter.categoriesIterator();
                while (iterator.hasNext()) {
                    if (filter.hasCategory((String)iterator.next())) continue;
                    continue block1;
                }
                if (outActivities == null) {
                    outActivities = new ArrayList<ComponentName>();
                }
                outActivities.add(name);
            }
        }
        return 0;
    }

    @Implementation
    protected ComponentName getHomeActivities(List<ResolveInfo> outActivities) {
        return null;
    }

    @Implementation
    protected void flushPackageRestrictionsAsUser(int userId) {
    }

    @Implementation
    protected boolean setApplicationHiddenSettingAsUser(String packageName, boolean hidden, UserHandle user) {
        return false;
    }

    @Implementation
    protected boolean getApplicationHiddenSettingAsUser(String packageName, UserHandle user) {
        return false;
    }

    @Implementation
    protected Object getKeySetByAlias(String packageName, String alias) {
        return null;
    }

    @Implementation
    protected Object getSigningKeySet(String packageName) {
        return null;
    }

    @Implementation
    protected boolean isSignedBy(String packageName, Object ks) {
        return false;
    }

    @Implementation
    protected boolean isSignedByExactly(String packageName, Object ks) {
        return false;
    }

    @Implementation
    protected VerifierDeviceIdentity getVerifierDeviceIdentity() {
        return null;
    }

    @Implementation
    protected boolean isUpgrade() {
        return false;
    }

    @Implementation
    protected boolean isPackageAvailable(String packageName) {
        return false;
    }

    @Implementation
    protected void addCrossProfileIntentFilter(IntentFilter filter, int sourceUserId, int targetUserId, int flags) {
    }

    @Implementation
    protected void clearCrossProfileIntentFilters(int sourceUserId) {
    }

    @Implementation
    protected Drawable loadItemIcon(PackageItemInfo itemInfo, ApplicationInfo appInfo) {
        return null;
    }

    @Implementation
    protected Drawable loadUnbadgedItemIcon(PackageItemInfo itemInfo, ApplicationInfo appInfo) {
        return null;
    }
}

