/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.android.controller;

import android.app.Activity;
import android.app.Fragment;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.view.View;
import android.widget.LinearLayout;
import org.robolectric.android.controller.ActivityController;
import org.robolectric.android.controller.ComponentController;
import org.robolectric.util.ReflectionHelpers;

public class FragmentController<F extends Fragment>
extends ComponentController<FragmentController<F>, F> {
    private final F fragment;
    private final ActivityController<? extends Activity> activityController;

    public static <F extends Fragment> FragmentController<F> of(F fragment) {
        return FragmentController.of(fragment, FragmentControllerActivity.class, null, null);
    }

    public static <F extends Fragment> FragmentController<F> of(F fragment, Class<? extends Activity> activityClass) {
        return FragmentController.of(fragment, activityClass, null, null);
    }

    public static <F extends Fragment> FragmentController<F> of(F fragment, Intent intent) {
        return new FragmentController<F>(fragment, FragmentControllerActivity.class, intent);
    }

    public static <F extends Fragment> FragmentController<F> of(F fragment, Bundle arguments) {
        return new FragmentController<F>(fragment, FragmentControllerActivity.class, arguments);
    }

    public static <F extends Fragment> FragmentController<F> of(F fragment, Intent intent, Bundle arguments) {
        return new FragmentController<F>(fragment, FragmentControllerActivity.class, intent, arguments);
    }

    public static <F extends Fragment> FragmentController<F> of(F fragment, Class<? extends Activity> activityClass, Intent intent) {
        return new FragmentController<F>(fragment, activityClass, intent);
    }

    public static <F extends Fragment> FragmentController<F> of(F fragment, Class<? extends Activity> activityClass, Bundle arguments) {
        return new FragmentController<F>(fragment, activityClass, arguments);
    }

    public static <F extends Fragment> FragmentController<F> of(F fragment, Class<? extends Activity> activityClass, Intent intent, Bundle arguments) {
        return new FragmentController<F>(fragment, activityClass, intent, arguments);
    }

    private FragmentController(F fragment, Class<? extends Activity> activityClass, Intent intent) {
        this(fragment, activityClass, intent, null);
    }

    private FragmentController(F fragment, Class<? extends Activity> activityClass, Bundle arguments) {
        this(fragment, activityClass, null, arguments);
    }

    private FragmentController(F fragment, Class<? extends Activity> activityClass, Intent intent, Bundle arguments) {
        super(fragment, intent);
        this.fragment = fragment;
        if (arguments != null) {
            this.fragment.setArguments(arguments);
        }
        this.activityController = ActivityController.of((Activity)ReflectionHelpers.callConstructor(activityClass, (ReflectionHelpers.ClassParameter[])new ReflectionHelpers.ClassParameter[0]), intent);
    }

    public FragmentController<F> create(final int contentViewId, final Bundle bundle) {
        this.shadowMainLooper.runPaused(new Runnable(){

            @Override
            public void run() {
                ((Activity)FragmentController.this.activityController.create(bundle).get()).getFragmentManager().beginTransaction().add(contentViewId, FragmentController.this.fragment).commit();
            }
        });
        return this;
    }

    public FragmentController<F> create(Bundle bundle) {
        return this.create(1, bundle);
    }

    @Override
    public FragmentController<F> create() {
        return this.create(null);
    }

    @Override
    public FragmentController<F> destroy() {
        this.shadowMainLooper.runPaused(new Runnable(){

            @Override
            public void run() {
                FragmentController.this.activityController.destroy();
            }
        });
        return this;
    }

    public FragmentController<F> start() {
        this.shadowMainLooper.runPaused(new Runnable(){

            @Override
            public void run() {
                FragmentController.this.activityController.start();
            }
        });
        return this;
    }

    public FragmentController<F> resume() {
        this.shadowMainLooper.runPaused(new Runnable(){

            @Override
            public void run() {
                FragmentController.this.activityController.resume();
            }
        });
        return this;
    }

    public FragmentController<F> pause() {
        this.shadowMainLooper.runPaused(new Runnable(){

            @Override
            public void run() {
                FragmentController.this.activityController.pause();
            }
        });
        return this;
    }

    public FragmentController<F> visible() {
        this.shadowMainLooper.runPaused(new Runnable(){

            @Override
            public void run() {
                FragmentController.this.activityController.visible();
            }
        });
        return this;
    }

    public FragmentController<F> stop() {
        this.shadowMainLooper.runPaused(new Runnable(){

            @Override
            public void run() {
                FragmentController.this.activityController.stop();
            }
        });
        return this;
    }

    public FragmentController<F> saveInstanceState(final Bundle outState) {
        this.shadowMainLooper.runPaused(new Runnable(){

            @Override
            public void run() {
                FragmentController.this.activityController.saveInstanceState(outState);
            }
        });
        return this;
    }

    private static class FragmentControllerActivity
    extends Activity {
        private FragmentControllerActivity() {
        }

        protected void onCreate(Bundle savedInstanceState) {
            super.onCreate(savedInstanceState);
            LinearLayout view = new LinearLayout((Context)this);
            view.setId(1);
            this.setContentView((View)view);
        }
    }
}

