/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.config;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.HashMap;
import java.util.Map;

public class ConfigurationRegistry {
    public static ConfigurationRegistry instance;
    private final Map<String, Object> configurations = new HashMap<String, Object>();

    public static <T> T get(Class<T> configClass) {
        return instance.getInSandboxClassLoader(configClass);
    }

    public ConfigurationRegistry(Map<Class<?>, Object> configClassMap) {
        for (Class<?> classInParentLoader : configClassMap.keySet()) {
            Object configInParentLoader = configClassMap.get(classInParentLoader);
            this.configurations.put(classInParentLoader.getName(), configInParentLoader);
        }
    }

    private <T> T getInSandboxClassLoader(Class<T> someConfigClass) {
        Object configInParentLoader = this.configurations.get(someConfigClass.getName());
        Object configInSandboxLoader = ConfigurationRegistry.maybeReloadInSandboxClassLoader(configInParentLoader);
        return someConfigClass.cast(configInSandboxLoader);
    }

    private static Object maybeReloadInSandboxClassLoader(Object configInParentLoader) {
        Object object;
        if (configInParentLoader.getClass().getName().startsWith("org.robolectric.annotation.")) {
            return configInParentLoader;
        }
        ByteArrayOutputStream buf = new ByteArrayOutputStream();
        try (ObjectOutputStream out = new ObjectOutputStream(buf);){
            out.writeObject(configInParentLoader);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        byte[] bytes = buf.toByteArray();
        ObjectInputStream in = new ObjectInputStream(new ByteArrayInputStream(bytes));
        try {
            object = in.readObject();
        }
        catch (Throwable throwable) {
            try {
                try {
                    in.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException | ClassNotFoundException e) {
                throw new RuntimeException(e);
            }
        }
        in.close();
        return object;
    }
}

