/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.util;

import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Proxy;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class ReflectionHelpers {
    private static final Map<String, Object> PRIMITIVE_RETURN_VALUES;

    public static <T> T createNullProxy(Class<T> clazz) {
        return (T)Proxy.newProxyInstance(clazz.getClassLoader(), new Class[]{clazz}, (proxy, method, args) -> PRIMITIVE_RETURN_VALUES.get(method.getReturnType().getName()));
    }

    public static <T> T createDeepProxy(Class<T> clazz) {
        return (T)Proxy.newProxyInstance(clazz.getClassLoader(), new Class[]{clazz}, new InvocationHandler(){

            @Override
            public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                if (PRIMITIVE_RETURN_VALUES.containsKey(method.getReturnType().getName())) {
                    return PRIMITIVE_RETURN_VALUES.get(method.getReturnType().getName());
                }
                if (method.getReturnType().isInterface()) {
                    return ReflectionHelpers.createDeepProxy(method.getReturnType());
                }
                return null;
            }
        });
    }

    public static <T> T createDelegatingProxy(Class<T> clazz, final Object delegate) {
        final Class<?> delegateClass = delegate.getClass();
        return (T)Proxy.newProxyInstance(clazz.getClassLoader(), new Class[]{clazz}, new InvocationHandler(){

            @Override
            public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                try {
                    Method delegateMethod = delegateClass.getMethod(method.getName(), method.getParameterTypes());
                    delegateMethod.setAccessible(true);
                    return delegateMethod.invoke(delegate, args);
                }
                catch (NoSuchMethodException e) {
                    return PRIMITIVE_RETURN_VALUES.get(method.getReturnType().getName());
                }
                catch (InvocationTargetException e) {
                    throw e.getTargetException();
                }
            }
        });
    }

    public static <A extends Annotation> A defaultsFor(Class<A> annotation) {
        return (A)((Annotation)annotation.cast(Proxy.newProxyInstance(annotation.getClassLoader(), new Class[]{annotation}, new InvocationHandler(){

            @Override
            public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                return method.getDefaultValue();
            }
        })));
    }

    public static <R> R getField(final Object object, final String fieldName) {
        try {
            return ReflectionHelpers.traverseClassHierarchy(object.getClass(), NoSuchFieldException.class, new InsideTraversal<R>(){

                @Override
                public R run(Class<?> traversalClass) throws Exception {
                    Field field = traversalClass.getDeclaredField(fieldName);
                    field.setAccessible(true);
                    return field.get(object);
                }
            });
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static void setField(final Object object, final String fieldName, final Object fieldNewValue) {
        try {
            ReflectionHelpers.traverseClassHierarchy(object.getClass(), NoSuchFieldException.class, new InsideTraversal<Void>(){

                @Override
                public Void run(Class<?> traversalClass) throws Exception {
                    Field field = traversalClass.getDeclaredField(fieldName);
                    field.setAccessible(true);
                    field.set(object, fieldNewValue);
                    return null;
                }
            });
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static void setField(Class<?> type, Object object, String fieldName, Object fieldNewValue) {
        try {
            Field field = type.getDeclaredField(fieldName);
            field.setAccessible(true);
            field.set(object, fieldNewValue);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static <R> R getStaticField(Field field) {
        try {
            ReflectionHelpers.makeFieldVeryAccessible(field);
            return (R)field.get(null);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static <R> R getStaticField(Class<?> clazz, String fieldName) {
        try {
            return ReflectionHelpers.getStaticField(clazz.getDeclaredField(fieldName));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static void setStaticField(Field field, Object fieldNewValue) {
        try {
            ReflectionHelpers.makeFieldVeryAccessible(field);
            field.set(null, fieldNewValue);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static void setStaticField(Class<?> clazz, String fieldName, Object fieldNewValue) {
        try {
            ReflectionHelpers.setStaticField(clazz.getDeclaredField(fieldName), fieldNewValue);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static <R> R callInstanceMethod(final Object instance, final String methodName, ClassParameter<?> ... classParameters) {
        try {
            final Class[] classes = ClassParameter.getClasses(classParameters);
            final Object[] values = ClassParameter.getValues(classParameters);
            return ReflectionHelpers.traverseClassHierarchy(instance.getClass(), NoSuchMethodException.class, new InsideTraversal<R>(){

                @Override
                public R run(Class<?> traversalClass) throws Exception {
                    Method declaredMethod = traversalClass.getDeclaredMethod(methodName, classes);
                    declaredMethod.setAccessible(true);
                    return declaredMethod.invoke(instance, values);
                }
            });
        }
        catch (InvocationTargetException e) {
            if (e.getTargetException() instanceof RuntimeException) {
                throw (RuntimeException)e.getTargetException();
            }
            if (e.getTargetException() instanceof Error) {
                throw (Error)e.getTargetException();
            }
            throw new RuntimeException(e.getTargetException());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static <R> R callInstanceMethod(Class<?> cl, Object instance, String methodName, ClassParameter<?> ... classParameters) {
        try {
            Class<?>[] classes = ClassParameter.getClasses(classParameters);
            Object[] values = ClassParameter.getValues(classParameters);
            Method method = cl.getDeclaredMethod(methodName, classes);
            method.setAccessible(true);
            if (Modifier.isStatic(method.getModifiers())) {
                String string = String.valueOf(method);
                throw new IllegalArgumentException(new StringBuilder(10 + String.valueOf(string).length()).append(string).append(" is static").toString());
            }
            return (R)method.invoke(instance, values);
        }
        catch (InvocationTargetException e) {
            if (e.getTargetException() instanceof RuntimeException) {
                throw (RuntimeException)e.getTargetException();
            }
            if (e.getTargetException() instanceof Error) {
                throw (Error)e.getTargetException();
            }
            throw new RuntimeException(e.getTargetException());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static <R> R callStaticMethod(ClassLoader classLoader, String fullyQualifiedClassName, String methodName, ClassParameter<?> ... classParameters) {
        Class<?> clazz = ReflectionHelpers.loadClass(classLoader, fullyQualifiedClassName);
        return ReflectionHelpers.callStaticMethod(clazz, methodName, classParameters);
    }

    public static <R> R callStaticMethod(Class<?> clazz, String methodName, ClassParameter<?> ... classParameters) {
        try {
            Class<?>[] classes = ClassParameter.getClasses(classParameters);
            Object[] values = ClassParameter.getValues(classParameters);
            Method method = clazz.getDeclaredMethod(methodName, classes);
            method.setAccessible(true);
            if (!Modifier.isStatic(method.getModifiers())) {
                String string = String.valueOf(method);
                throw new IllegalArgumentException(new StringBuilder(14 + String.valueOf(string).length()).append(string).append(" is not static").toString());
            }
            return (R)method.invoke(null, values);
        }
        catch (InvocationTargetException e) {
            if (e.getTargetException() instanceof RuntimeException) {
                throw (RuntimeException)e.getTargetException();
            }
            if (e.getTargetException() instanceof Error) {
                throw (Error)e.getTargetException();
            }
            throw new RuntimeException(e.getTargetException());
        }
        catch (NoSuchMethodException e) {
            String string = String.valueOf(clazz);
            throw new RuntimeException(new StringBuilder(16 + String.valueOf(string).length() + String.valueOf(methodName).length()).append("no such method ").append(string).append(".").append(methodName).toString(), e);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static Class<?> loadClass(ClassLoader classLoader, String fullyQualifiedClassName) {
        try {
            return classLoader.loadClass(fullyQualifiedClassName);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    public static <T> T newInstance(Class<T> cl) {
        try {
            return cl.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    public static <R> R callConstructor(Class<? extends R> clazz, ClassParameter<?> ... classParameters) {
        try {
            Class<?>[] classes = ClassParameter.getClasses(classParameters);
            Object[] values = ClassParameter.getValues(classParameters);
            Constructor<R> constructor = clazz.getDeclaredConstructor(classes);
            constructor.setAccessible(true);
            return constructor.newInstance(values);
        }
        catch (InstantiationException e) {
            String string = String.valueOf(clazz.getName());
            throw new RuntimeException(string.length() != 0 ? "error instantiating ".concat(string) : new String("error instantiating "), e);
        }
        catch (InvocationTargetException e) {
            if (e.getTargetException() instanceof RuntimeException) {
                throw (RuntimeException)e.getTargetException();
            }
            if (e.getTargetException() instanceof Error) {
                throw (Error)e.getTargetException();
            }
            throw new RuntimeException(e.getTargetException());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static <R, E extends Exception> R traverseClassHierarchy(Class<?> targetClass, Class<? extends E> exceptionClass, InsideTraversal<R> insideTraversal) throws Exception {
        Class<?> hierarchyTraversalClass = targetClass;
        while (true) {
            try {
                return insideTraversal.run(hierarchyTraversalClass);
            }
            catch (Exception e) {
                if (exceptionClass.isInstance(e)) continue;
                throw e;
                if ((hierarchyTraversalClass = hierarchyTraversalClass.getSuperclass()) != null) continue;
                throw new RuntimeException(e);
            }
            break;
        }
    }

    private static void makeFieldVeryAccessible(Field field) {
        field.setAccessible(true);
        if ((field.getModifiers() & 0x10) == 16) {
            try {
                Field modifiersField = Field.class.getDeclaredField("modifiers");
                modifiersField.setAccessible(true);
                try {
                    modifiersField.setInt(field, field.getModifiers() & 0xFFFFFFEF);
                }
                catch (IllegalAccessException e) {
                    throw new AssertionError((Object)e);
                }
            }
            catch (NoSuchFieldException noSuchFieldException) {
                // empty catch block
            }
        }
    }

    public static Object defaultValueForType(String returnType) {
        return PRIMITIVE_RETURN_VALUES.get(returnType);
    }

    static {
        HashMap<String, Comparable<Boolean>> map = new HashMap<String, Comparable<Boolean>>();
        map.put("boolean", Boolean.FALSE);
        map.put("int", Integer.valueOf(0));
        map.put("long", Long.valueOf(0L));
        map.put("float", Float.valueOf(0.0f));
        map.put("double", Double.valueOf(0.0));
        map.put("short", Short.valueOf((short)0));
        map.put("byte", Byte.valueOf((byte)0));
        PRIMITIVE_RETURN_VALUES = Collections.unmodifiableMap(map);
    }

    public static class StringParameter<V> {
        public final String className;
        public final V val;

        public StringParameter(String className, V val) {
            this.className = className;
            this.val = val;
        }

        public static <V> StringParameter<V> from(String className, V val) {
            return new StringParameter<V>(className, val);
        }
    }

    public static class ClassParameter<V> {
        public final Class<? extends V> clazz;
        public final V val;

        public ClassParameter(Class<? extends V> clazz, V val) {
            this.clazz = clazz;
            this.val = val;
        }

        public static <V> ClassParameter<V> from(Class<? extends V> clazz, V val) {
            return new ClassParameter<V>(clazz, val);
        }

        public static ClassParameter<?>[] fromComponentLists(Class<?>[] classes, Object[] values) {
            ClassParameter[] classParameters = new ClassParameter[classes.length];
            for (int i = 0; i < classes.length; ++i) {
                classParameters[i] = ClassParameter.from(classes[i], values[i]);
            }
            return classParameters;
        }

        public static Class<?>[] getClasses(ClassParameter<?> ... classParameters) {
            Class[] classes = new Class[classParameters.length];
            for (int i = 0; i < classParameters.length; ++i) {
                Class paramClass;
                classes[i] = paramClass = classParameters[i].clazz;
            }
            return classes;
        }

        public static Object[] getValues(ClassParameter<?> ... classParameters) {
            Object[] values = new Object[classParameters.length];
            for (int i = 0; i < classParameters.length; ++i) {
                Object paramValue = classParameters[i].val;
                values[i] = paramValue;
            }
            return values;
        }
    }

    private static interface InsideTraversal<R> {
        public R run(Class<?> var1) throws Exception;
    }
}

