/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.util;

import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Proxy;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.robolectric.util.PerfStatsCollector;

public class ReflectionHelpers {
    private static final Map<String, Object> PRIMITIVE_RETURN_VALUES;
    private static final PerfStatsCollector perfStatsCollector;

    public static <T> T createNullProxy(Class<T> clazz) {
        return (T)Proxy.newProxyInstance(clazz.getClassLoader(), new Class[]{clazz}, (proxy, method, args) -> PRIMITIVE_RETURN_VALUES.get(method.getReturnType().getName()));
    }

    public static <T> T createDeepProxy(Class<T> clazz) {
        return (T)Proxy.newProxyInstance(clazz.getClassLoader(), new Class[]{clazz}, (proxy, method, args) -> {
            if (PRIMITIVE_RETURN_VALUES.containsKey(method.getReturnType().getName())) {
                return PRIMITIVE_RETURN_VALUES.get(method.getReturnType().getName());
            }
            if (method.getReturnType().isInterface()) {
                return ReflectionHelpers.createDeepProxy(method.getReturnType());
            }
            return null;
        });
    }

    public static <T> T createDelegatingProxy(Class<T> clazz, Object delegate) {
        Class<?> delegateClass = delegate.getClass();
        return (T)Proxy.newProxyInstance(clazz.getClassLoader(), new Class[]{clazz}, (proxy, method, args) -> {
            try {
                Method delegateMethod = delegateClass.getMethod(method.getName(), method.getParameterTypes());
                delegateMethod.setAccessible(true);
                return delegateMethod.invoke(delegate, args);
            }
            catch (NoSuchMethodException e) {
                return PRIMITIVE_RETURN_VALUES.get(method.getReturnType().getName());
            }
            catch (InvocationTargetException e) {
                throw e.getTargetException();
            }
        });
    }

    public static <A extends Annotation> A defaultsFor(Class<A> annotation) {
        return (A)((Annotation)annotation.cast(Proxy.newProxyInstance(annotation.getClassLoader(), new Class[]{annotation}, (proxy, method, args) -> method.getDefaultValue())));
    }

    public static <R> R getField(Object object, String fieldName) {
        try {
            return (R)ReflectionHelpers.traverseClassHierarchy(object.getClass(), NoSuchFieldException.class, traversalClass -> {
                Field field = traversalClass.getDeclaredField(fieldName);
                field.setAccessible(true);
                return field.get(object);
            });
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static void setField(Object object, String fieldName, Object fieldNewValue) {
        try {
            ReflectionHelpers.traverseClassHierarchy(object.getClass(), NoSuchFieldException.class, traversalClass -> {
                Field field = traversalClass.getDeclaredField(fieldName);
                field.setAccessible(true);
                field.set(object, fieldNewValue);
                return null;
            });
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static void setField(Class<?> type, Object object, String fieldName, Object fieldNewValue) {
        try {
            Field field = type.getDeclaredField(fieldName);
            field.setAccessible(true);
            field.set(object, fieldNewValue);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static boolean hasField(Class<?> clazz, String fieldName) {
        try {
            Field field = clazz.getDeclaredField(fieldName);
            return field != null;
        }
        catch (NoSuchFieldException e) {
            return false;
        }
    }

    public static <R> R getStaticField(Field field) {
        try {
            field.setAccessible(true);
            return (R)field.get(null);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static <R> R getStaticField(Class<?> clazz, String fieldName) {
        try {
            return ReflectionHelpers.getStaticField(clazz.getDeclaredField(fieldName));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static void setStaticField(Field field, Object fieldNewValue) {
        try {
            if ((field.getModifiers() & 0x10) == 16) {
                throw new IllegalArgumentException("Cannot set the value of final field " + field);
            }
            field.setAccessible(true);
            field.set(null, fieldNewValue);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static void setStaticField(Class<?> clazz, String fieldName, Object fieldNewValue) {
        try {
            ReflectionHelpers.setStaticField(clazz.getDeclaredField(fieldName), fieldNewValue);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static <R> R callInstanceMethod(Object instance, String methodName, ClassParameter<?> ... classParameters) {
        perfStatsCollector.incrementCount(String.format("ReflectionHelpers.callInstanceMethod-%s_%s", instance.getClass().getName(), methodName));
        try {
            Class[] classes = ClassParameter.getClasses(classParameters);
            Object[] values = ClassParameter.getValues(classParameters);
            return (R)ReflectionHelpers.traverseClassHierarchy(instance.getClass(), NoSuchMethodException.class, traversalClass -> {
                Method declaredMethod = traversalClass.getDeclaredMethod(methodName, classes);
                declaredMethod.setAccessible(true);
                return declaredMethod.invoke(instance, values);
            });
        }
        catch (InvocationTargetException e) {
            if (e.getTargetException() instanceof RuntimeException) {
                throw (RuntimeException)e.getTargetException();
            }
            if (e.getTargetException() instanceof Error) {
                throw (Error)e.getTargetException();
            }
            throw new RuntimeException(e.getTargetException());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static <R> R callInstanceMethod(Class<?> cl, Object instance, String methodName, ClassParameter<?> ... classParameters) {
        perfStatsCollector.incrementCount(String.format("ReflectionHelpers.callInstanceMethod-%s_%s", cl.getName(), methodName));
        try {
            Class<?>[] classes = ClassParameter.getClasses(classParameters);
            Object[] values = ClassParameter.getValues(classParameters);
            Method method = cl.getDeclaredMethod(methodName, classes);
            method.setAccessible(true);
            if (Modifier.isStatic(method.getModifiers())) {
                throw new IllegalArgumentException(method + " is static");
            }
            return (R)method.invoke(instance, values);
        }
        catch (InvocationTargetException e) {
            if (e.getTargetException() instanceof RuntimeException) {
                throw (RuntimeException)e.getTargetException();
            }
            if (e.getTargetException() instanceof Error) {
                throw (Error)e.getTargetException();
            }
            throw new RuntimeException(e.getTargetException());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static <R> R callStaticMethod(ClassLoader classLoader, String fullyQualifiedClassName, String methodName, ClassParameter<?> ... classParameters) {
        Class<?> clazz = ReflectionHelpers.loadClass(classLoader, fullyQualifiedClassName);
        return ReflectionHelpers.callStaticMethod(clazz, methodName, classParameters);
    }

    public static <R> R callStaticMethod(Class<?> clazz, String methodName, ClassParameter<?> ... classParameters) {
        perfStatsCollector.incrementCount(String.format("ReflectionHelpers.callStaticMethod-%s_%s", clazz.getName(), methodName));
        try {
            Class<?>[] classes = ClassParameter.getClasses(classParameters);
            Object[] values = ClassParameter.getValues(classParameters);
            Method method = clazz.getDeclaredMethod(methodName, classes);
            method.setAccessible(true);
            if (!Modifier.isStatic(method.getModifiers())) {
                throw new IllegalArgumentException(method + " is not static");
            }
            return (R)method.invoke(null, values);
        }
        catch (InvocationTargetException e) {
            if (e.getTargetException() instanceof RuntimeException) {
                throw (RuntimeException)e.getTargetException();
            }
            if (e.getTargetException() instanceof Error) {
                throw (Error)e.getTargetException();
            }
            throw new RuntimeException(e.getTargetException());
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException("no such method " + clazz + "." + methodName, e);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static Class<?> loadClass(ClassLoader classLoader, String fullyQualifiedClassName) {
        try {
            return classLoader.loadClass(fullyQualifiedClassName);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    public static Optional<Class<?>> attemptLoadClass(ClassLoader classLoader, String fullyQualifiedClassName) {
        try {
            return Optional.of(classLoader.loadClass(fullyQualifiedClassName));
        }
        catch (ClassNotFoundException e) {
            return Optional.empty();
        }
    }

    public static <T> T newInstance(Class<T> cl) {
        try {
            return cl.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    public static <R> R callConstructor(Class<? extends R> clazz, ClassParameter<?> ... classParameters) {
        perfStatsCollector.incrementCount("ReflectionHelpers.callConstructor-" + clazz.getName());
        try {
            Class<?>[] classes = ClassParameter.getClasses(classParameters);
            Object[] values = ClassParameter.getValues(classParameters);
            Constructor<R> constructor = clazz.getDeclaredConstructor(classes);
            constructor.setAccessible(true);
            return constructor.newInstance(values);
        }
        catch (InstantiationException e) {
            throw new RuntimeException("error instantiating " + clazz.getName(), e);
        }
        catch (InvocationTargetException e) {
            if (e.getTargetException() instanceof RuntimeException) {
                throw (RuntimeException)e.getTargetException();
            }
            if (e.getTargetException() instanceof Error) {
                throw (Error)e.getTargetException();
            }
            throw new RuntimeException(e.getTargetException());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static <R, E extends Exception> R traverseClassHierarchy(Class<?> targetClass, Class<? extends E> exceptionClass, InsideTraversal<R> insideTraversal) throws Exception {
        Class<?> hierarchyTraversalClass = targetClass;
        while (true) {
            try {
                return insideTraversal.run(hierarchyTraversalClass);
            }
            catch (Exception e) {
                if (exceptionClass.isInstance(e)) continue;
                throw e;
                if ((hierarchyTraversalClass = hierarchyTraversalClass.getSuperclass()) != null) continue;
                throw new RuntimeException(e);
            }
            break;
        }
    }

    public static Object defaultValueForType(String returnType) {
        return PRIMITIVE_RETURN_VALUES.get(returnType);
    }

    static {
        perfStatsCollector = PerfStatsCollector.getInstance();
        HashMap<String, Comparable<Boolean>> map = new HashMap<String, Comparable<Boolean>>();
        map.put("boolean", Boolean.FALSE);
        map.put("int", Integer.valueOf(0));
        map.put("long", Long.valueOf(0L));
        map.put("float", Float.valueOf(0.0f));
        map.put("double", Double.valueOf(0.0));
        map.put("short", Short.valueOf((short)0));
        map.put("byte", Byte.valueOf((byte)0));
        PRIMITIVE_RETURN_VALUES = Collections.unmodifiableMap(map);
    }

    private static interface InsideTraversal<R> {
        public R run(Class<?> var1) throws Exception;
    }

    public static class ClassParameter<V> {
        public final Class<? extends V> clazz;
        public final V value;

        public ClassParameter(Class<? extends V> clazz, V value) {
            this.clazz = clazz;
            this.value = value;
        }

        public static <V> ClassParameter<V> from(Class<? extends V> clazz, V value) {
            return new ClassParameter<V>(clazz, value);
        }

        public static ClassParameter<?>[] fromComponentLists(Class<?>[] classes, Object[] values) {
            ClassParameter[] classParameters = new ClassParameter[classes.length];
            for (int i = 0; i < classes.length; ++i) {
                classParameters[i] = ClassParameter.from(classes[i], values[i]);
            }
            return classParameters;
        }

        public static Class<?>[] getClasses(ClassParameter<?> ... classParameters) {
            Class[] classes = new Class[classParameters.length];
            for (int i = 0; i < classParameters.length; ++i) {
                Class paramClass;
                classes[i] = paramClass = classParameters[i].clazz;
            }
            return classes;
        }

        public static Object[] getValues(ClassParameter<?> ... classParameters) {
            Object[] values = new Object[classParameters.length];
            for (int i = 0; i < classParameters.length; ++i) {
                Object paramValue = classParameters[i].value;
                values[i] = paramValue;
            }
            return values;
        }
    }
}

