/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.internal.dependency;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.nio.file.Paths;
import java.util.Hashtable;
import org.apache.maven.artifact.ant.Authentication;
import org.apache.maven.artifact.ant.DependenciesTask;
import org.apache.maven.artifact.ant.RemoteRepository;
import org.apache.maven.model.Dependency;
import org.apache.tools.ant.Project;
import org.robolectric.MavenRoboSettings;
import org.robolectric.internal.dependency.DependencyJar;
import org.robolectric.internal.dependency.DependencyResolver;

public class MavenDependencyResolver
implements DependencyResolver {
    private final String repositoryUrl;
    private final String repositoryId;
    private final String repositoryUserName;
    private final String repositoryPassword;

    public MavenDependencyResolver() {
        this(MavenRoboSettings.getMavenRepositoryUrl(), MavenRoboSettings.getMavenRepositoryId(), MavenRoboSettings.getMavenRepositoryUserName(), MavenRoboSettings.getMavenRepositoryPassword());
    }

    public MavenDependencyResolver(String repositoryUrl, String repositoryId, String repositoryUserName, String repositoryPassword) {
        this.repositoryUrl = repositoryUrl;
        this.repositoryId = repositoryId;
        this.repositoryUserName = repositoryUserName;
        this.repositoryPassword = repositoryPassword;
    }

    public URL[] getLocalArtifactUrls(DependencyJar dependency) {
        return this.getLocalArtifactUrls(new DependencyJar[]{dependency});
    }

    public URL[] getLocalArtifactUrls(DependencyJar ... dependencies) {
        DependenciesTask dependenciesTask = this.createDependenciesTask();
        this.configureMaven(dependenciesTask);
        RemoteRepository remoteRepository = new RemoteRepository();
        remoteRepository.setUrl(this.repositoryUrl);
        remoteRepository.setId(this.repositoryId);
        if (this.repositoryUserName != null || this.repositoryPassword != null) {
            Authentication authentication = new Authentication();
            authentication.setUserName(this.repositoryUserName);
            authentication.setPassword(this.repositoryPassword);
            remoteRepository.addAuthentication(authentication);
        }
        dependenciesTask.addConfiguredRemoteRepository(remoteRepository);
        Project project = new Project();
        dependenciesTask.setProject(project);
        for (DependencyJar dependencyJar : dependencies) {
            Dependency dependency = new Dependency();
            dependency.setArtifactId(dependencyJar.getArtifactId());
            dependency.setGroupId(dependencyJar.getGroupId());
            dependency.setType(dependencyJar.getType());
            dependency.setVersion(dependencyJar.getVersion());
            if (dependencyJar.getClassifier() != null) {
                dependency.setClassifier(dependencyJar.getClassifier());
            }
            dependenciesTask.addDependency(dependency);
        }
        this.whileLocked(() -> ((DependenciesTask)dependenciesTask).execute());
        Hashtable artifacts = project.getProperties();
        URL[] urls = new URL[dependencies.length];
        for (int i = 0; i < urls.length; ++i) {
            try {
                urls[i] = Paths.get((String)artifacts.get(this.key(dependencies[i])), new String[0]).toUri().toURL();
                continue;
            }
            catch (MalformedURLException e) {
                throw new RuntimeException(e);
            }
        }
        return urls;
    }

    private void whileLocked(Runnable runnable) {
        File lockFile = new File(System.getProperty("user.home"), ".robolectric-download-lock");
        try (RandomAccessFile raf = new RandomAccessFile(lockFile, "rw");
             FileChannel channel = raf.getChannel();
             FileLock ignored = channel.lock();){
            System.out.println("Downloading from maven ");
            runnable.run();
        }
        catch (IOException e) {
            throw new IllegalStateException("Couldn't create lock file " + lockFile, e);
        }
        finally {
            lockFile.delete();
        }
    }

    public URL getLocalArtifactUrl(DependencyJar dependency) {
        URL[] urls = this.getLocalArtifactUrls(dependency);
        if (urls.length > 0) {
            return urls[0];
        }
        return null;
    }

    private String key(DependencyJar dependency) {
        String key = dependency.getGroupId() + ":" + dependency.getArtifactId() + ":" + dependency.getType();
        if (dependency.getClassifier() != null) {
            key = key + ":" + dependency.getClassifier();
        }
        return key;
    }

    protected DependenciesTask createDependenciesTask() {
        return new DependenciesTask();
    }

    protected void configureMaven(DependenciesTask dependenciesTask) {
    }
}

