/*
 * Decompiled with CFR 0.152.
 */
package org.roaringbitmap;

import org.roaringbitmap.BatchIterator;
import org.roaringbitmap.ContainerBatchIterator;
import org.roaringbitmap.RoaringArray;

public class RoaringBatchIterator
implements BatchIterator {
    private final RoaringArray highLowContainer;
    int index = 0;
    int key;
    ContainerBatchIterator iterator;

    public RoaringBatchIterator(RoaringArray highLowContainer) {
        this.highLowContainer = highLowContainer;
        this.nextIterator();
    }

    @Override
    public int nextBatch(int[] buffer) {
        int consumed = 0;
        if (this.iterator.hasNext() && (consumed += this.iterator.next(this.key, buffer)) > 0) {
            return consumed;
        }
        ++this.index;
        this.nextIterator();
        if (null != this.iterator) {
            return this.nextBatch(buffer);
        }
        return consumed;
    }

    @Override
    public boolean hasNext() {
        return null != this.iterator;
    }

    @Override
    public BatchIterator clone() {
        try {
            RoaringBatchIterator it = (RoaringBatchIterator)super.clone();
            if (null != this.iterator) {
                it.iterator = this.iterator.clone();
            }
            return it;
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException();
        }
    }

    private void nextIterator() {
        if (this.index < this.highLowContainer.size()) {
            this.iterator = this.highLowContainer.getContainerAtIndex(this.index).getBatchIterator();
            this.key = this.highLowContainer.getKeyAtIndex(this.index) << 16;
        } else {
            this.iterator = null;
        }
    }
}

