/*
 * Decompiled with CFR 0.152.
 */
package org.roaringbitmap;

import org.roaringbitmap.BitmapContainerShortIterator;
import org.roaringbitmap.PeekableShortRankIterator;
import org.roaringbitmap.Util;

final class BitmapContainerShortRankIterator
extends BitmapContainerShortIterator
implements PeekableShortRankIterator {
    short nextRank = 1;

    public BitmapContainerShortRankIterator(long[] p) {
        super(p);
    }

    @Override
    public short peekNextRank() {
        return this.nextRank;
    }

    @Override
    public short next() {
        this.nextRank = (short)(this.nextRank + 1);
        return super.next();
    }

    @Override
    public void advanceIfNeeded(short minval) {
        if (Util.toIntUnsigned(minval) >= (this.x + 1) * 64) {
            int nextX = Util.toIntUnsigned(minval) / 64;
            this.nextRank = (short)(this.nextRank + Long.bitCount(this.w));
            ++this.x;
            while (this.x < nextX) {
                this.w = this.bitmap[this.x];
                this.nextRank = (short)(this.nextRank + Long.bitCount(this.w));
                ++this.x;
            }
            this.x = nextX;
            this.w = this.bitmap[this.x];
            while (this.w == 0L) {
                ++this.x;
                if (this.x == this.bitmap.length) {
                    return;
                }
                this.w = this.bitmap[this.x];
            }
        }
        while (this.hasNext() && Util.toIntUnsigned(this.peekNext()) < Util.toIntUnsigned(minval)) {
            this.next();
        }
    }

    @Override
    public PeekableShortRankIterator clone() {
        return (PeekableShortRankIterator)super.clone();
    }
}

