/*
 * Decompiled with CFR 0.152.
 */
package org.roaringbitmap;

import org.roaringbitmap.DenseOrderedWriter;
import org.roaringbitmap.OrderedWriter;
import org.roaringbitmap.RoaringBitmap;
import org.roaringbitmap.SparseOrderedWriter;

public class AdaptiveOrderedWriter
implements OrderedWriter {
    private SparseOrderedWriter sparseWriter;
    private DenseOrderedWriter denseWriter;
    private boolean sparse;

    public AdaptiveOrderedWriter(RoaringBitmap underlying) {
        this.sparseWriter = new SparseOrderedWriter(underlying);
        this.sparse = true;
    }

    public AdaptiveOrderedWriter(RoaringBitmap underlying, int size) {
        this.sparseWriter = new SparseOrderedWriter(underlying, size);
        this.sparse = true;
    }

    @Override
    public void add(int value) {
        if (this.sparse) {
            try {
                this.sparseWriter.add(value);
            }
            catch (IndexOutOfBoundsException e) {
                this.denseWriter = this.sparseWriter.transfer();
                this.denseWriter.add(value);
                this.sparse = false;
            }
        } else {
            this.denseWriter.add(value);
        }
    }

    @Override
    public void flush() {
        if (this.sparse) {
            this.sparseWriter.flush();
        } else {
            this.denseWriter.flush();
        }
    }
}

