/*
 * Decompiled with CFR 0.152.
 */
package org.roaringbitmap;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.nio.ShortBuffer;
import java.util.Arrays;
import java.util.Iterator;
import org.roaringbitmap.ArrayContainerShortIterator;
import org.roaringbitmap.BitmapContainer;
import org.roaringbitmap.Container;
import org.roaringbitmap.PeekableShortIterator;
import org.roaringbitmap.ReverseArrayContainerShortIterator;
import org.roaringbitmap.RunContainer;
import org.roaringbitmap.ShortIterator;
import org.roaringbitmap.Util;
import org.roaringbitmap.buffer.MappeableArrayContainer;
import org.roaringbitmap.buffer.MappeableContainer;

public final class ArrayContainer
extends Container
implements Cloneable {
    private static final int DEFAULT_INIT_SIZE = 4;
    static final int DEFAULT_MAX_SIZE = 4096;
    private static final long serialVersionUID = 1L;
    protected int cardinality = 0;
    short[] content;

    protected static int serializedSizeInBytes(int cardinality) {
        return cardinality * 2 + 2;
    }

    public ArrayContainer() {
        this(4);
    }

    public ArrayContainer(int capacity) {
        this.content = new short[capacity];
    }

    public ArrayContainer(int firstOfRun, int lastOfRun) {
        int valuesInRange = lastOfRun - firstOfRun;
        this.content = new short[valuesInRange];
        for (int i = 0; i < valuesInRange; ++i) {
            this.content[i] = (short)(firstOfRun + i);
        }
        this.cardinality = valuesInRange;
    }

    public ArrayContainer(int newCard, short[] newContent) {
        this.cardinality = newCard;
        this.content = Arrays.copyOf(newContent, newCard);
    }

    public ArrayContainer(MappeableArrayContainer bc) {
        this.cardinality = bc.getCardinality();
        this.content = bc.toShortArray();
    }

    protected ArrayContainer(short[] newContent) {
        this.cardinality = newContent.length;
        this.content = newContent;
    }

    @Override
    public Container add(int begin, int end) {
        int indexend;
        int indexstart = Util.unsignedBinarySearch(this.content, 0, this.cardinality, (short)begin);
        if (indexstart < 0) {
            indexstart = -indexstart - 1;
        }
        indexend = (indexend = Util.unsignedBinarySearch(this.content, 0, this.cardinality, (short)(end - 1))) < 0 ? -indexend - 1 : ++indexend;
        int rangelength = end - begin;
        int newcardinality = indexstart + (this.cardinality - indexend) + rangelength;
        if (newcardinality > 4096) {
            BitmapContainer a = this.toBitmapContainer();
            return a.iadd(begin, end);
        }
        ArrayContainer answer = new ArrayContainer(newcardinality, this.content);
        System.arraycopy(this.content, indexend, answer.content, indexstart + rangelength, this.cardinality - indexend);
        for (int k = 0; k < rangelength; ++k) {
            answer.content[k + indexstart] = (short)(begin + k);
        }
        answer.cardinality = newcardinality;
        return answer;
    }

    @Override
    public Container add(short x) {
        int loc = Util.unsignedBinarySearch(this.content, 0, this.cardinality, x);
        if (loc < 0) {
            if (this.cardinality >= 4096) {
                BitmapContainer a = this.toBitmapContainer();
                a.add(x);
                return a;
            }
            if (this.cardinality >= this.content.length) {
                this.increaseCapacity();
            }
            System.arraycopy(this.content, -loc - 1, this.content, -loc, this.cardinality + loc + 1);
            this.content[-loc - 1] = x;
            ++this.cardinality;
        }
        return this;
    }

    private int advance(ShortIterator it) {
        if (it.hasNext()) {
            return Util.toIntUnsigned(it.next());
        }
        return -1;
    }

    @Override
    public ArrayContainer and(ArrayContainer value2) {
        ArrayContainer value1 = this;
        int desiredCapacity = Math.min(value1.getCardinality(), value2.getCardinality());
        ArrayContainer answer = new ArrayContainer(desiredCapacity);
        answer.cardinality = Util.unsignedIntersect2by2(value1.content, value1.getCardinality(), value2.content, value2.getCardinality(), answer.content);
        return answer;
    }

    @Override
    public Container and(BitmapContainer x) {
        return x.and(this);
    }

    @Override
    public Container and(RunContainer x) {
        return x.and(this);
    }

    @Override
    public int andCardinality(ArrayContainer value2) {
        return Util.unsignedLocalIntersect2by2Cardinality(this.content, this.cardinality, value2.content, value2.getCardinality());
    }

    @Override
    public int andCardinality(BitmapContainer x) {
        return x.andCardinality(this);
    }

    @Override
    public int andCardinality(RunContainer x) {
        return x.andCardinality(this);
    }

    @Override
    public ArrayContainer andNot(ArrayContainer value2) {
        ArrayContainer value1 = this;
        int desiredCapacity = value1.getCardinality();
        ArrayContainer answer = new ArrayContainer(desiredCapacity);
        answer.cardinality = Util.unsignedDifference(value1.content, value1.getCardinality(), value2.content, value2.getCardinality(), answer.content);
        return answer;
    }

    @Override
    public ArrayContainer andNot(BitmapContainer value2) {
        ArrayContainer answer = new ArrayContainer(this.content.length);
        int pos = 0;
        for (int k = 0; k < this.cardinality; ++k) {
            short val = this.content[k];
            if (value2.contains(val)) continue;
            answer.content[pos++] = val;
        }
        answer.cardinality = pos;
        return answer;
    }

    @Override
    public Container andNot(RunContainer x) {
        int writeLocation = 0;
        short[] buffer = new short[this.cardinality];
        if (x.nbrruns == 0) {
            return this.clone();
        }
        int runStart = Util.toIntUnsigned(x.getValue(0));
        int runEnd = runStart + Util.toIntUnsigned(x.getLength(0));
        int whichRun = 0;
        for (int i = 0; i < this.cardinality; ++i) {
            short val = this.content[i];
            int valInt = Util.toIntUnsigned(val);
            if (valInt < runStart) {
                buffer[writeLocation++] = val;
                continue;
            }
            if (valInt <= runEnd) continue;
            do {
                if (whichRun + 1 < x.nbrruns) {
                    runStart = Util.toIntUnsigned(x.getValue(++whichRun));
                    runEnd = runStart + Util.toIntUnsigned(x.getLength(whichRun));
                    continue;
                }
                runEnd = 65537;
                runStart = 65537;
            } while (valInt > runEnd);
            --i;
        }
        return new ArrayContainer(writeLocation, buffer);
    }

    @Override
    public void clear() {
        this.cardinality = 0;
    }

    @Override
    public ArrayContainer clone() {
        return new ArrayContainer(this.cardinality, this.content);
    }

    @Override
    public boolean contains(short x) {
        return Util.unsignedBinarySearch(this.content, 0, this.cardinality, x) >= 0;
    }

    @Override
    public void deserialize(DataInput in) throws IOException {
        this.cardinality = 0xFFFF & Short.reverseBytes(in.readShort());
        if (this.content.length < this.cardinality) {
            this.content = new short[this.cardinality];
        }
        for (int k = 0; k < this.cardinality; ++k) {
            this.content[k] = Short.reverseBytes(in.readShort());
        }
    }

    private void emit(short val) {
        if (this.cardinality == this.content.length) {
            this.increaseCapacity(true);
        }
        this.content[this.cardinality++] = val;
    }

    public boolean equals(Object o) {
        if (o instanceof ArrayContainer) {
            ArrayContainer srb = (ArrayContainer)o;
            if (srb.cardinality != this.cardinality) {
                return false;
            }
            for (int i = 0; i < this.cardinality; ++i) {
                if (this.content[i] == srb.content[i]) continue;
                return false;
            }
            return true;
        }
        if (o instanceof RunContainer) {
            return o.equals(this);
        }
        return false;
    }

    @Override
    public void fillLeastSignificant16bits(int[] x, int i, int mask) {
        for (int k = 0; k < this.cardinality; ++k) {
            x[k + i] = Util.toIntUnsigned(this.content[k]) | mask;
        }
    }

    @Override
    public Container flip(short x) {
        int loc = Util.unsignedBinarySearch(this.content, 0, this.cardinality, x);
        if (loc < 0) {
            if (this.cardinality >= 4096) {
                BitmapContainer a = this.toBitmapContainer();
                a.add(x);
                return a;
            }
            if (this.cardinality >= this.content.length) {
                this.increaseCapacity();
            }
            System.arraycopy(this.content, -loc - 1, this.content, -loc, this.cardinality + loc + 1);
            this.content[-loc - 1] = x;
            ++this.cardinality;
        } else {
            System.arraycopy(this.content, loc + 1, this.content, loc, this.cardinality - loc - 1);
            --this.cardinality;
        }
        return this;
    }

    @Override
    protected int getArraySizeInBytes() {
        return this.cardinality * 2;
    }

    @Override
    public int getCardinality() {
        return this.cardinality;
    }

    @Override
    public ShortIterator getReverseShortIterator() {
        return new ReverseArrayContainerShortIterator(this);
    }

    @Override
    public PeekableShortIterator getShortIterator() {
        return new ArrayContainerShortIterator(this);
    }

    @Override
    public int getSizeInBytes() {
        return this.cardinality * 2 + 4;
    }

    public int hashCode() {
        int hash = 0;
        for (int k = 0; k < this.cardinality; ++k) {
            hash += 31 * hash + this.content[k];
        }
        return hash;
    }

    @Override
    public Container iadd(int begin, int end) {
        int indexend;
        int indexstart = Util.unsignedBinarySearch(this.content, 0, this.cardinality, (short)begin);
        if (indexstart < 0) {
            indexstart = -indexstart - 1;
        }
        indexend = (indexend = Util.unsignedBinarySearch(this.content, 0, this.cardinality, (short)(end - 1))) < 0 ? -indexend - 1 : ++indexend;
        int rangelength = end - begin;
        int newcardinality = indexstart + (this.cardinality - indexend) + rangelength;
        if (newcardinality > 4096) {
            BitmapContainer a = this.toBitmapContainer();
            return a.iadd(begin, end);
        }
        if (newcardinality >= this.content.length) {
            this.increaseCapacity(newcardinality);
        }
        System.arraycopy(this.content, indexend, this.content, indexstart + rangelength, this.cardinality - indexend);
        for (int k = 0; k < rangelength; ++k) {
            this.content[k + indexstart] = (short)(begin + k);
        }
        this.cardinality = newcardinality;
        return this;
    }

    @Override
    public ArrayContainer iand(ArrayContainer value2) {
        ArrayContainer value1 = this;
        value1.cardinality = Util.unsignedIntersect2by2(value1.content, value1.getCardinality(), value2.content, value2.getCardinality(), value1.content);
        return this;
    }

    @Override
    public Container iand(BitmapContainer value2) {
        int pos = 0;
        for (int k = 0; k < this.cardinality; ++k) {
            short v = this.content[k];
            if (!value2.contains(v)) continue;
            this.content[pos++] = v;
        }
        this.cardinality = pos;
        return this;
    }

    @Override
    public Container iand(RunContainer x) {
        return x.and(this);
    }

    @Override
    public ArrayContainer iandNot(ArrayContainer value2) {
        this.cardinality = Util.unsignedDifference(this.content, this.getCardinality(), value2.content, value2.getCardinality(), this.content);
        return this;
    }

    @Override
    public ArrayContainer iandNot(BitmapContainer value2) {
        int pos = 0;
        for (int k = 0; k < this.cardinality; ++k) {
            short v = this.content[k];
            if (value2.contains(v)) continue;
            this.content[pos++] = v;
        }
        this.cardinality = pos;
        return this;
    }

    @Override
    public Container iandNot(RunContainer x) {
        return this.andNot(x);
    }

    private void increaseCapacity() {
        this.increaseCapacity(false);
    }

    private void increaseCapacity(boolean allowIllegalSize) {
        int newCapacity;
        int n = this.content.length == 0 ? 4 : (this.content.length < 64 ? this.content.length * 2 : (newCapacity = this.content.length < 1067 ? this.content.length * 3 / 2 : this.content.length * 5 / 4));
        if (newCapacity > 4096 && !allowIllegalSize) {
            newCapacity = 4096;
        }
        if (newCapacity > 3840 && !allowIllegalSize) {
            newCapacity = 4096;
        }
        this.content = Arrays.copyOf(this.content, newCapacity);
    }

    private void increaseCapacity(int min) {
        int newCapacity;
        int n = this.content.length == 0 ? 4 : (this.content.length < 64 ? this.content.length * 2 : (newCapacity = this.content.length < 1024 ? this.content.length * 3 / 2 : this.content.length * 5 / 4));
        if (newCapacity < min) {
            newCapacity = min;
        }
        if (newCapacity > 4096) {
            newCapacity = 4096;
        }
        if (newCapacity > 3840) {
            newCapacity = 4096;
        }
        this.content = Arrays.copyOf(this.content, newCapacity);
    }

    @Override
    public Container inot(int firstOfRange, int lastOfRange) {
        int lastIndex;
        int startIndex = Util.unsignedBinarySearch(this.content, 0, this.cardinality, (short)firstOfRange);
        if (startIndex < 0) {
            startIndex = -startIndex - 1;
        }
        if ((lastIndex = Util.unsignedBinarySearch(this.content, 0, this.cardinality, (short)(lastOfRange - 1))) < 0) {
            lastIndex = -lastIndex - 1 - 1;
        }
        int currentValuesInRange = lastIndex - startIndex + 1;
        int spanToBeFlipped = lastOfRange - firstOfRange;
        int newValuesInRange = spanToBeFlipped - currentValuesInRange;
        short[] buffer = new short[newValuesInRange];
        int cardinalityChange = newValuesInRange - currentValuesInRange;
        int newCardinality = this.cardinality + cardinalityChange;
        if (cardinalityChange > 0) {
            if (newCardinality > this.content.length) {
                if (newCardinality > 4096) {
                    return this.toBitmapContainer().inot(firstOfRange, lastOfRange);
                }
                this.content = Arrays.copyOf(this.content, newCardinality);
            }
            System.arraycopy(this.content, lastIndex + 1, this.content, lastIndex + 1 + cardinalityChange, this.cardinality - 1 - lastIndex);
            this.negateRange(buffer, startIndex, lastIndex, firstOfRange, lastOfRange);
        } else {
            this.negateRange(buffer, startIndex, lastIndex, firstOfRange, lastOfRange);
            if (cardinalityChange < 0) {
                System.arraycopy(this.content, startIndex + newValuesInRange - cardinalityChange, this.content, startIndex + newValuesInRange, newCardinality - (startIndex + newValuesInRange));
            }
        }
        this.cardinality = newCardinality;
        return this;
    }

    @Override
    public boolean intersects(ArrayContainer value2) {
        ArrayContainer value1 = this;
        return Util.unsignedIntersects(value1.content, value1.getCardinality(), value2.content, value2.getCardinality());
    }

    @Override
    public boolean intersects(BitmapContainer x) {
        return x.intersects(this);
    }

    @Override
    public boolean intersects(RunContainer x) {
        return x.intersects(this);
    }

    @Override
    public Container ior(ArrayContainer value2) {
        return this.or(value2);
    }

    @Override
    public Container ior(BitmapContainer x) {
        return x.or(this);
    }

    @Override
    public Container ior(RunContainer x) {
        return x.or(this);
    }

    @Override
    public Container iremove(int begin, int end) {
        int indexend;
        int indexstart = Util.unsignedBinarySearch(this.content, 0, this.cardinality, (short)begin);
        if (indexstart < 0) {
            indexstart = -indexstart - 1;
        }
        indexend = (indexend = Util.unsignedBinarySearch(this.content, 0, this.cardinality, (short)(end - 1))) < 0 ? -indexend - 1 : ++indexend;
        int rangelength = indexend - indexstart;
        System.arraycopy(this.content, indexstart + rangelength, this.content, indexstart, this.cardinality - indexstart - rangelength);
        this.cardinality -= rangelength;
        return this;
    }

    @Override
    public Iterator<Short> iterator() {
        return new Iterator<Short>(){
            short pos = 0;

            @Override
            public boolean hasNext() {
                return this.pos < ArrayContainer.this.cardinality;
            }

            @Override
            public Short next() {
                short s = this.pos;
                this.pos = (short)(s + 1);
                return ArrayContainer.this.content[s];
            }

            @Override
            public void remove() {
                ArrayContainer.this.remove((short)(this.pos - 1));
                this.pos = (short)(this.pos - 1);
            }
        };
    }

    @Override
    public Container ixor(ArrayContainer value2) {
        return this.xor(value2);
    }

    @Override
    public Container ixor(BitmapContainer x) {
        return x.xor(this);
    }

    @Override
    public Container ixor(RunContainer x) {
        return x.xor(this);
    }

    @Override
    public Container limit(int maxcardinality) {
        if (maxcardinality < this.getCardinality()) {
            return new ArrayContainer(maxcardinality, this.content);
        }
        return this.clone();
    }

    protected void loadData(BitmapContainer bitmapContainer) {
        this.cardinality = bitmapContainer.cardinality;
        bitmapContainer.fillArray(this.content);
    }

    private void negateRange(short[] buffer, int startIndex, int lastIndex, int startRange, int lastRange) {
        int valInRange;
        int outPos = 0;
        int inPos = startIndex;
        for (valInRange = startRange; valInRange < lastRange && inPos <= lastIndex; ++valInRange) {
            if ((short)valInRange != this.content[inPos]) {
                buffer[outPos++] = (short)valInRange;
                continue;
            }
            ++inPos;
        }
        while (valInRange < lastRange) {
            buffer[outPos++] = (short)valInRange;
            ++valInRange;
        }
        if (outPos != buffer.length) {
            throw new RuntimeException("negateRange: outPos " + outPos + " whereas buffer.length=" + buffer.length);
        }
        int i = startIndex;
        for (short item : buffer) {
            this.content[i++] = item;
        }
    }

    @Override
    public Container not(int firstOfRange, int lastOfRange) {
        int valInRange;
        int currentValuesInRange;
        int spanToBeFlipped;
        int newValuesInRange;
        int cardinalityChange;
        int newCardinality;
        int lastIndex;
        if (firstOfRange >= lastOfRange) {
            return this.clone();
        }
        int startIndex = Util.unsignedBinarySearch(this.content, 0, this.cardinality, (short)firstOfRange);
        if (startIndex < 0) {
            startIndex = -startIndex - 1;
        }
        if ((lastIndex = Util.unsignedBinarySearch(this.content, 0, this.cardinality, (short)(lastOfRange - 1))) < 0) {
            lastIndex = -lastIndex - 2;
        }
        if ((newCardinality = this.cardinality + (cardinalityChange = (newValuesInRange = (spanToBeFlipped = lastOfRange - firstOfRange) - (currentValuesInRange = lastIndex - startIndex + 1)) - currentValuesInRange)) > 4096) {
            return this.toBitmapContainer().not(firstOfRange, lastOfRange);
        }
        ArrayContainer answer = new ArrayContainer(newCardinality);
        System.arraycopy(this.content, 0, answer.content, 0, startIndex);
        int outPos = startIndex;
        int inPos = startIndex;
        for (valInRange = firstOfRange; valInRange < lastOfRange && inPos <= lastIndex; ++valInRange) {
            if ((short)valInRange != this.content[inPos]) {
                answer.content[outPos++] = (short)valInRange;
                continue;
            }
            ++inPos;
        }
        while (valInRange < lastOfRange) {
            answer.content[outPos++] = (short)valInRange;
            ++valInRange;
        }
        for (int i = lastIndex + 1; i < this.cardinality; ++i) {
            answer.content[outPos++] = this.content[i];
        }
        answer.cardinality = newCardinality;
        return answer;
    }

    @Override
    int numberOfRuns() {
        if (this.cardinality == 0) {
            return 0;
        }
        int numRuns = 1;
        int oldv = Util.toIntUnsigned(this.content[0]);
        for (int i = 1; i < this.cardinality; ++i) {
            int newv = Util.toIntUnsigned(this.content[i]);
            if (oldv + 1 != newv) {
                ++numRuns;
            }
            oldv = newv;
        }
        return numRuns;
    }

    @Override
    public Container or(ArrayContainer value2) {
        ArrayContainer value1 = this;
        int totalCardinality = value1.getCardinality() + value2.getCardinality();
        if (totalCardinality > 4096) {
            int i;
            short v;
            int k;
            BitmapContainer bc = new BitmapContainer();
            for (k = 0; k < value2.cardinality; ++k) {
                v = value2.content[k];
                int n = i = Util.toIntUnsigned(v) >>> 6;
                bc.bitmap[n] = bc.bitmap[n] | 1L << v;
            }
            for (k = 0; k < this.cardinality; ++k) {
                v = this.content[k];
                int n = i = Util.toIntUnsigned(v) >>> 6;
                bc.bitmap[n] = bc.bitmap[n] | 1L << v;
            }
            bc.cardinality = 0;
            for (long k2 : bc.bitmap) {
                bc.cardinality += Long.bitCount(k2);
            }
            if (bc.cardinality <= 4096) {
                return bc.toArrayContainer();
            }
            return bc;
        }
        int desiredCapacity = totalCardinality;
        ArrayContainer answer = new ArrayContainer(desiredCapacity);
        answer.cardinality = Util.unsignedUnion2by2(value1.content, value1.getCardinality(), value2.content, value2.getCardinality(), answer.content);
        return answer;
    }

    @Override
    public Container or(BitmapContainer x) {
        return x.or(this);
    }

    @Override
    public Container or(RunContainer x) {
        return x.or(this);
    }

    protected Container or(ShortIterator it) {
        return this.or(it, false);
    }

    private Container or(ShortIterator it, boolean exclusive) {
        ArrayContainer ac = new ArrayContainer();
        int myItPos = 0;
        ac.cardinality = 0;
        int myHead = myItPos == this.cardinality ? -1 : Util.toIntUnsigned(this.content[myItPos++]);
        int hisHead = this.advance(it);
        while (myHead != -1 && hisHead != -1) {
            if (myHead < hisHead) {
                ac.emit((short)myHead);
                myHead = myItPos == this.cardinality ? -1 : Util.toIntUnsigned(this.content[myItPos++]);
                continue;
            }
            if (myHead > hisHead) {
                ac.emit((short)hisHead);
                hisHead = this.advance(it);
                continue;
            }
            if (!exclusive) {
                ac.emit((short)hisHead);
            }
            hisHead = this.advance(it);
            myHead = myItPos == this.cardinality ? -1 : Util.toIntUnsigned(this.content[myItPos++]);
        }
        while (myHead != -1) {
            ac.emit((short)myHead);
            myHead = myItPos == this.cardinality ? -1 : Util.toIntUnsigned(this.content[myItPos++]);
        }
        while (hisHead != -1) {
            ac.emit((short)hisHead);
            hisHead = this.advance(it);
        }
        if (ac.cardinality > 4096) {
            return ac.toBitmapContainer();
        }
        return ac;
    }

    @Override
    public int rank(short lowbits) {
        int answer = Util.unsignedBinarySearch(this.content, 0, this.cardinality, lowbits);
        if (answer >= 0) {
            return answer + 1;
        }
        return -answer - 1;
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.deserialize(in);
    }

    @Override
    public Container remove(int begin, int end) {
        int indexend;
        int indexstart = Util.unsignedBinarySearch(this.content, 0, this.cardinality, (short)begin);
        if (indexstart < 0) {
            indexstart = -indexstart - 1;
        }
        indexend = (indexend = Util.unsignedBinarySearch(this.content, 0, this.cardinality, (short)(end - 1))) < 0 ? -indexend - 1 : ++indexend;
        int rangelength = indexend - indexstart;
        ArrayContainer answer = this.clone();
        System.arraycopy(this.content, indexstart + rangelength, answer.content, indexstart, this.cardinality - indexstart - rangelength);
        answer.cardinality = this.cardinality - rangelength;
        return answer;
    }

    @Override
    public Container remove(short x) {
        int loc = Util.unsignedBinarySearch(this.content, 0, this.cardinality, x);
        if (loc >= 0) {
            System.arraycopy(this.content, loc + 1, this.content, loc, this.cardinality - loc - 1);
            --this.cardinality;
        }
        return this;
    }

    @Override
    public Container repairAfterLazy() {
        return this;
    }

    @Override
    public Container runOptimize() {
        int numRuns = this.numberOfRuns();
        int sizeAsRunContainer = RunContainer.serializedSizeInBytes(numRuns);
        if (this.getArraySizeInBytes() > sizeAsRunContainer) {
            return new RunContainer(this, numRuns);
        }
        return this;
    }

    @Override
    public short select(int j) {
        return this.content[j];
    }

    @Override
    public void serialize(DataOutput out) throws IOException {
        out.writeShort(Short.reverseBytes((short)this.cardinality));
        for (int k = 0; k < this.cardinality; ++k) {
            out.writeShort(Short.reverseBytes(this.content[k]));
        }
    }

    @Override
    public int serializedSizeInBytes() {
        return ArrayContainer.serializedSizeInBytes(this.cardinality);
    }

    public BitmapContainer toBitmapContainer() {
        BitmapContainer bc = new BitmapContainer();
        bc.loadData(this);
        return bc;
    }

    @Override
    public MappeableContainer toMappeableContainer() {
        return new MappeableArrayContainer(this);
    }

    public ShortBuffer toShortBuffer() {
        ShortBuffer sb = ShortBuffer.allocate(this.cardinality);
        sb.put(this.content, 0, this.cardinality);
        return sb;
    }

    public String toString() {
        if (this.cardinality == 0) {
            return "{}";
        }
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        for (int i = 0; i < this.cardinality - 1; ++i) {
            sb.append(this.content[i]);
            sb.append(",");
        }
        sb.append(this.content[this.cardinality - 1]);
        sb.append("}");
        return sb.toString();
    }

    @Override
    public void trim() {
        if (this.content.length == this.cardinality) {
            return;
        }
        this.content = Arrays.copyOf(this.content, this.cardinality);
    }

    @Override
    protected void writeArray(DataOutput out) throws IOException {
        for (int k = 0; k < this.cardinality; ++k) {
            short v = this.content[k];
            out.write(v & 0xFF);
            out.write(v >>> 8 & 0xFF);
        }
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        this.serialize(out);
    }

    @Override
    public Container xor(ArrayContainer value2) {
        ArrayContainer value1 = this;
        int totalCardinality = value1.getCardinality() + value2.getCardinality();
        if (totalCardinality > 4096) {
            int i;
            short v;
            int k;
            BitmapContainer bc = new BitmapContainer();
            for (k = 0; k < value2.cardinality; ++k) {
                v = value2.content[k];
                int n = i = Util.toIntUnsigned(v) >>> 6;
                bc.bitmap[n] = bc.bitmap[n] ^ 1L << v;
            }
            for (k = 0; k < this.cardinality; ++k) {
                v = this.content[k];
                int n = i = Util.toIntUnsigned(v) >>> 6;
                bc.bitmap[n] = bc.bitmap[n] ^ 1L << v;
            }
            bc.cardinality = 0;
            for (long k2 : bc.bitmap) {
                bc.cardinality += Long.bitCount(k2);
            }
            if (bc.cardinality <= 4096) {
                return bc.toArrayContainer();
            }
            return bc;
        }
        int desiredCapacity = totalCardinality;
        ArrayContainer answer = new ArrayContainer(desiredCapacity);
        answer.cardinality = Util.unsignedExclusiveUnion2by2(value1.content, value1.getCardinality(), value2.content, value2.getCardinality(), answer.content);
        return answer;
    }

    @Override
    public Container xor(BitmapContainer x) {
        return x.xor(this);
    }

    @Override
    public Container xor(RunContainer x) {
        return x.xor(this);
    }

    protected Container xor(ShortIterator it) {
        return this.or(it, true);
    }
}

