/*
 * Decompiled with CFR 0.152.
 */
package org.roaringbitmap.buffer;

import org.roaringbitmap.IntIterator;
import org.roaringbitmap.ShortIterator;
import org.roaringbitmap.buffer.BufferUtil;
import org.roaringbitmap.buffer.ImmutableRoaringBitmap;
import org.roaringbitmap.buffer.MappeableArrayContainer;
import org.roaringbitmap.buffer.MappeableArrayContainerShortIterator;
import org.roaringbitmap.buffer.MappeableBitmapContainer;
import org.roaringbitmap.buffer.MappeableBitmapContainerShortIterator;
import org.roaringbitmap.buffer.MappeableContainer;
import org.roaringbitmap.buffer.MappeableRunContainer;
import org.roaringbitmap.buffer.MappeableRunContainerShortIterator;

public class BufferIntIteratorFlyweight
implements IntIterator {
    private int hs;
    private ShortIterator iter;
    private MappeableArrayContainerShortIterator arrIter = new MappeableArrayContainerShortIterator();
    private MappeableBitmapContainerShortIterator bitmapIter = new MappeableBitmapContainerShortIterator();
    private MappeableRunContainerShortIterator runIter = new MappeableRunContainerShortIterator();
    private int pos;
    private ImmutableRoaringBitmap roaringBitmap = null;

    public BufferIntIteratorFlyweight() {
    }

    public BufferIntIteratorFlyweight(ImmutableRoaringBitmap r) {
        this.wrap(r);
    }

    @Override
    public IntIterator clone() {
        try {
            BufferIntIteratorFlyweight x = (BufferIntIteratorFlyweight)super.clone();
            x.iter = this.iter.clone();
            return x;
        }
        catch (CloneNotSupportedException e) {
            return null;
        }
    }

    @Override
    public boolean hasNext() {
        return this.pos < this.roaringBitmap.highLowContainer.size();
    }

    @Override
    public int next() {
        int x = this.iter.nextAsInt() | this.hs;
        if (!this.iter.hasNext()) {
            ++this.pos;
            this.nextContainer();
        }
        return x;
    }

    private void nextContainer() {
        if (this.pos < this.roaringBitmap.highLowContainer.size()) {
            MappeableContainer container = this.roaringBitmap.highLowContainer.getContainerAtIndex(this.pos);
            if (container instanceof MappeableBitmapContainer) {
                this.bitmapIter.wrap((MappeableBitmapContainer)container);
                this.iter = this.bitmapIter;
            } else if (container instanceof MappeableRunContainer) {
                this.runIter.wrap((MappeableRunContainer)container);
                this.iter = this.runIter;
            } else {
                this.arrIter.wrap((MappeableArrayContainer)container);
                this.iter = this.arrIter;
            }
            this.hs = BufferUtil.toIntUnsigned(this.roaringBitmap.highLowContainer.getKeyAtIndex(this.pos)) << 16;
        }
    }

    public void wrap(ImmutableRoaringBitmap r) {
        this.hs = 0;
        this.pos = 0;
        this.roaringBitmap = r;
        this.nextContainer();
    }
}

