/*
 * Decompiled with CFR 0.152.
 */
package org.roaringbitmap.buffer;

import java.io.DataOutput;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.nio.LongBuffer;
import java.util.Iterator;
import org.roaringbitmap.BitmapContainer;
import org.roaringbitmap.Container;
import org.roaringbitmap.ShortIterator;
import org.roaringbitmap.Util;
import org.roaringbitmap.buffer.BufferUtil;
import org.roaringbitmap.buffer.MappeableArrayContainer;
import org.roaringbitmap.buffer.MappeableBitmapContainerShortIterator;
import org.roaringbitmap.buffer.MappeableContainer;
import org.roaringbitmap.buffer.MappeableRunContainer;
import org.roaringbitmap.buffer.ReverseMappeableBitmapContainerShortIterator;

public final class MappeableBitmapContainer
extends MappeableContainer
implements Cloneable {
    protected static final int MAX_CAPACITY = 65536;
    private static boolean USE_IN_PLACE = true;
    LongBuffer bitmap;
    private static final long serialVersionUID = 2L;
    int cardinality;
    private static final int BLOCKSIZE = 128;
    private final int MAXRUNS = (this.getArraySizeInBytes() - 2) / 4;
    public static final boolean USE_BRANCHLESS = true;

    public MappeableBitmapContainer() {
        this.cardinality = 0;
        this.bitmap = LongBuffer.allocate(1024);
    }

    public long[] toLongArray() {
        long[] answer = new long[this.bitmap.limit()];
        this.bitmap.rewind();
        this.bitmap.get(answer);
        return answer;
    }

    public MappeableBitmapContainer(int firstOfRun, int lastOfRun) {
        this.cardinality = lastOfRun - firstOfRun;
        this.bitmap = LongBuffer.allocate(1024);
        if (this.cardinality == 65536) {
            int len = this.bitmap.limit();
            for (int k = 0; k < len; ++k) {
                this.bitmap.put(k, -1L);
            }
        } else {
            int firstWord = firstOfRun / 64;
            int lastWord = (lastOfRun - 1) / 64;
            int zeroPrefixLength = firstOfRun & 0x3F;
            int zeroSuffixLength = 63 - (lastOfRun - 1 & 0x3F);
            for (int k = firstWord; k < lastWord + 1; ++k) {
                this.bitmap.put(k, -1L);
            }
            this.bitmap.put(firstWord, this.bitmap.get(firstWord) ^ (1L << zeroPrefixLength) - 1L);
            long blockOfOnes = (1L << zeroSuffixLength) - 1L;
            long maskOnLeft = blockOfOnes << 64 - zeroSuffixLength;
            this.bitmap.put(lastWord, this.bitmap.get(lastWord) ^ maskOnLeft);
        }
    }

    MappeableBitmapContainer(int newCardinality, LongBuffer newBitmap) {
        this.cardinality = newCardinality;
        LongBuffer tmp = newBitmap.duplicate();
        this.bitmap = LongBuffer.allocate(tmp.limit());
        tmp.rewind();
        this.bitmap.put(tmp);
    }

    public MappeableBitmapContainer(LongBuffer array, int initCardinality) {
        if (array.limit() != 1024) {
            throw new RuntimeException("Mismatch between buffer and storage requirements: " + array.limit() + " vs. " + 1024);
        }
        this.cardinality = initCardinality;
        this.bitmap = array;
    }

    public MappeableBitmapContainer(BitmapContainer bc) {
        this.cardinality = bc.getCardinality();
        this.bitmap = bc.toLongBuffer();
    }

    @Override
    int numberOfRuns() {
        if (BufferUtil.isBackedBySimpleArray(this.bitmap)) {
            long[] src = this.bitmap.array();
            int numRuns = 0;
            long nextWord = src[0];
            for (int i = 0; i < src.length - 1; ++i) {
                long word = nextWord;
                nextWord = src[i + 1];
                numRuns = (int)((long)numRuns + ((long)Long.bitCount((word ^ 0xFFFFFFFFFFFFFFFFL) & word << 1) + (word >>> 63 & (nextWord ^ 0xFFFFFFFFFFFFFFFFL))));
            }
            long word = nextWord;
            numRuns += Long.bitCount((word ^ 0xFFFFFFFFFFFFFFFFL) & word << 1);
            if ((word & Long.MIN_VALUE) != 0L) {
                ++numRuns;
            }
            return numRuns;
        }
        int numRuns = 0;
        long nextWord = this.bitmap.get(0);
        int len = this.bitmap.limit();
        for (int i = 0; i < len - 1; ++i) {
            long word = nextWord;
            nextWord = this.bitmap.get(i + 1);
            numRuns = (int)((long)numRuns + ((long)Long.bitCount((word ^ 0xFFFFFFFFFFFFFFFFL) & word << 1) + (word >>> 63 & (nextWord ^ 0xFFFFFFFFFFFFFFFFL))));
        }
        long word = nextWord;
        numRuns += Long.bitCount((word ^ 0xFFFFFFFFFFFFFFFFL) & word << 1);
        if ((word & Long.MIN_VALUE) != 0L) {
            ++numRuns;
        }
        return numRuns;
    }

    public int numberOfRunsAdjustment() {
        int ans = 0;
        if (BufferUtil.isBackedBySimpleArray(this.bitmap)) {
            long[] b = this.bitmap.array();
            long nextWord = b[0];
            for (int i = 0; i < b.length - 1; ++i) {
                long word = nextWord;
                nextWord = b[i + 1];
                ans = (int)((long)ans + (word >>> 63 & (nextWord ^ 0xFFFFFFFFFFFFFFFFL)));
            }
            long word = nextWord;
            if ((word & Long.MIN_VALUE) != 0L) {
                ++ans;
            }
        } else {
            long nextWord = this.bitmap.get(0);
            int len = this.bitmap.limit();
            for (int i = 0; i < len - 1; ++i) {
                long word = nextWord;
                nextWord = this.bitmap.get(i + 1);
                ans = (int)((long)ans + (word >>> 63 & (nextWord ^ 0xFFFFFFFFFFFFFFFFL)));
            }
            long word = nextWord;
            if ((word & Long.MIN_VALUE) != 0L) {
                ++ans;
            }
        }
        return ans;
    }

    public int numberOfRunsLowerBound(int mustNotExceed) {
        int numRuns = 0;
        if (BufferUtil.isBackedBySimpleArray(this.bitmap)) {
            long[] b = this.bitmap.array();
            for (int blockOffset = 0; blockOffset < b.length; blockOffset += 128) {
                for (int i = blockOffset; i < blockOffset + 128; ++i) {
                    long word = b[i];
                    numRuns += Long.bitCount((word ^ 0xFFFFFFFFFFFFFFFFL) & word << 1);
                }
                if (numRuns <= mustNotExceed) continue;
                return numRuns;
            }
        } else {
            int len = this.bitmap.limit();
            for (int blockOffset = 0; blockOffset < len; blockOffset += 128) {
                for (int i = blockOffset; i < blockOffset + 128; ++i) {
                    long word = this.bitmap.get(i);
                    numRuns += Long.bitCount((word ^ 0xFFFFFFFFFFFFFFFFL) & word << 1);
                }
                if (numRuns <= mustNotExceed) continue;
                return numRuns;
            }
        }
        return numRuns;
    }

    @Override
    public MappeableContainer runOptimize() {
        int numRuns = this.numberOfRunsLowerBound(this.MAXRUNS);
        int sizeAsRunContainerLowerBound = MappeableRunContainer.serializedSizeInBytes(numRuns);
        if (sizeAsRunContainerLowerBound >= this.getArraySizeInBytes()) {
            return this;
        }
        int sizeAsRunContainer = MappeableRunContainer.serializedSizeInBytes(numRuns += this.numberOfRunsAdjustment());
        if (this.getArraySizeInBytes() > sizeAsRunContainer) {
            return new MappeableRunContainer(this, numRuns);
        }
        return this;
    }

    @Override
    public MappeableContainer add(short i) {
        int x = BufferUtil.toIntUnsigned(i);
        long previous = this.bitmap.get(x / 64);
        long newv = previous | 1L << x;
        this.bitmap.put(x / 64, newv);
        this.cardinality = (int)((long)this.cardinality + ((previous ^ newv) >>> x));
        return this;
    }

    @Override
    public MappeableArrayContainer and(MappeableArrayContainer value2) {
        MappeableArrayContainer answer = new MappeableArrayContainer(value2.content.limit());
        if (!BufferUtil.isBackedBySimpleArray(answer.content)) {
            throw new RuntimeException("Should not happen. Internal bug.");
        }
        short[] sarray = answer.content.array();
        if (BufferUtil.isBackedBySimpleArray(value2.content)) {
            short[] c = value2.content.array();
            int ca = value2.cardinality;
            for (int k = 0; k < ca; ++k) {
                short v = c[k];
                if (!this.contains(v)) continue;
                sarray[answer.cardinality++] = v;
            }
        } else {
            int ca = value2.cardinality;
            for (int k = 0; k < ca; ++k) {
                short v = value2.content.get(k);
                if (!this.contains(v)) continue;
                sarray[answer.cardinality++] = v;
            }
        }
        return answer;
    }

    @Override
    public MappeableContainer and(MappeableBitmapContainer value2) {
        int k;
        int len;
        int newCardinality = 0;
        if (BufferUtil.isBackedBySimpleArray(this.bitmap) && BufferUtil.isBackedBySimpleArray(value2.bitmap)) {
            long[] tb = this.bitmap.array();
            long[] v2b = value2.bitmap.array();
            len = this.bitmap.limit();
            for (k = 0; k < len; ++k) {
                newCardinality += Long.bitCount(tb[k] & v2b[k]);
            }
        } else {
            int len2 = this.bitmap.limit();
            for (int k2 = 0; k2 < len2; ++k2) {
                newCardinality += Long.bitCount(this.bitmap.get(k2) & value2.bitmap.get(k2));
            }
        }
        if (newCardinality > 4096) {
            MappeableBitmapContainer answer = new MappeableBitmapContainer();
            if (!BufferUtil.isBackedBySimpleArray(answer.bitmap)) {
                throw new RuntimeException("Should not happen. Internal bug.");
            }
            long[] bitArray = answer.bitmap.array();
            if (BufferUtil.isBackedBySimpleArray(this.bitmap) && BufferUtil.isBackedBySimpleArray(value2.bitmap)) {
                long[] tb = this.bitmap.array();
                long[] v2b = value2.bitmap.array();
                int len3 = this.bitmap.limit();
                for (int k3 = 0; k3 < len3; ++k3) {
                    bitArray[k3] = tb[k3] & v2b[k3];
                }
            } else {
                len = this.bitmap.limit();
                for (k = 0; k < len; ++k) {
                    bitArray[k] = this.bitmap.get(k) & value2.bitmap.get(k);
                }
            }
            answer.cardinality = newCardinality;
            return answer;
        }
        MappeableArrayContainer ac = new MappeableArrayContainer(newCardinality);
        if (BufferUtil.isBackedBySimpleArray(this.bitmap) && BufferUtil.isBackedBySimpleArray(value2.bitmap)) {
            Util.fillArrayAND(ac.content.array(), this.bitmap.array(), value2.bitmap.array());
        } else {
            BufferUtil.fillArrayAND(ac.content.array(), this.bitmap, value2.bitmap);
        }
        ac.cardinality = newCardinality;
        return ac;
    }

    @Override
    public MappeableContainer and(MappeableRunContainer value2) {
        return value2.and(this);
    }

    @Override
    public MappeableContainer andNot(MappeableArrayContainer value2) {
        MappeableBitmapContainer answer = this.clone();
        if (!BufferUtil.isBackedBySimpleArray(answer.bitmap)) {
            throw new RuntimeException("Should not happen. Internal bug.");
        }
        long[] bitArray = answer.bitmap.array();
        if (BufferUtil.isBackedBySimpleArray(value2.content) && BufferUtil.isBackedBySimpleArray(this.bitmap)) {
            short[] v2 = value2.content.array();
            int c = value2.cardinality;
            for (int k = 0; k < c; ++k) {
                long aft;
                short v = v2[k];
                int i = BufferUtil.toIntUnsigned(v) >>> 6;
                long w = bitArray[i];
                bitArray[i] = aft = w & (1L << v ^ 0xFFFFFFFFFFFFFFFFL);
                answer.cardinality = (int)((long)answer.cardinality - ((w ^ aft) >>> v));
            }
        } else {
            int c = value2.cardinality;
            for (int k = 0; k < c; ++k) {
                long aft;
                short v2 = value2.content.get(k);
                int i = BufferUtil.toIntUnsigned(v2) >>> 6;
                long w = bitArray[i];
                bitArray[i] = aft = bitArray[i] & (1L << v2 ^ 0xFFFFFFFFFFFFFFFFL);
                answer.cardinality = (int)((long)answer.cardinality - ((w ^ aft) >>> v2));
            }
        }
        if (answer.cardinality <= 4096) {
            return answer.toArrayContainer();
        }
        return answer;
    }

    @Override
    public MappeableContainer andNot(MappeableBitmapContainer value2) {
        int k;
        int len;
        int newCardinality = 0;
        if (BufferUtil.isBackedBySimpleArray(this.bitmap) && BufferUtil.isBackedBySimpleArray(value2.bitmap)) {
            long[] b = this.bitmap.array();
            long[] v2 = value2.bitmap.array();
            len = this.bitmap.limit();
            for (k = 0; k < len; ++k) {
                newCardinality += Long.bitCount(b[k] & (v2[k] ^ 0xFFFFFFFFFFFFFFFFL));
            }
        } else {
            int len2 = this.bitmap.limit();
            for (int k2 = 0; k2 < len2; ++k2) {
                newCardinality += Long.bitCount(this.bitmap.get(k2) & (value2.bitmap.get(k2) ^ 0xFFFFFFFFFFFFFFFFL));
            }
        }
        if (newCardinality > 4096) {
            MappeableBitmapContainer answer = new MappeableBitmapContainer();
            if (!BufferUtil.isBackedBySimpleArray(answer.bitmap)) {
                throw new RuntimeException("Should not happen. Internal bug.");
            }
            long[] bitArray = answer.bitmap.array();
            if (BufferUtil.isBackedBySimpleArray(this.bitmap) && BufferUtil.isBackedBySimpleArray(value2.bitmap)) {
                long[] b = this.bitmap.array();
                long[] v2 = value2.bitmap.array();
                int len3 = answer.bitmap.limit();
                for (int k3 = 0; k3 < len3; ++k3) {
                    bitArray[k3] = b[k3] & (v2[k3] ^ 0xFFFFFFFFFFFFFFFFL);
                }
            } else {
                len = answer.bitmap.limit();
                for (k = 0; k < len; ++k) {
                    bitArray[k] = this.bitmap.get(k) & (value2.bitmap.get(k) ^ 0xFFFFFFFFFFFFFFFFL);
                }
            }
            answer.cardinality = newCardinality;
            return answer;
        }
        MappeableArrayContainer ac = new MappeableArrayContainer(newCardinality);
        if (BufferUtil.isBackedBySimpleArray(this.bitmap) && BufferUtil.isBackedBySimpleArray(value2.bitmap)) {
            Util.fillArrayANDNOT(ac.content.array(), this.bitmap.array(), value2.bitmap.array());
        } else {
            BufferUtil.fillArrayANDNOT(ac.content.array(), this.bitmap, value2.bitmap);
        }
        ac.cardinality = newCardinality;
        return ac;
    }

    @Override
    public MappeableContainer andNot(MappeableRunContainer value2) {
        MappeableBitmapContainer answer = this.clone();
        if (BufferUtil.isBackedBySimpleArray(answer.bitmap)) {
            long[] b = answer.bitmap.array();
            for (int rlepos = 0; rlepos < value2.nbrruns; ++rlepos) {
                int start = BufferUtil.toIntUnsigned(value2.getValue(rlepos));
                int end = BufferUtil.toIntUnsigned(value2.getValue(rlepos)) + BufferUtil.toIntUnsigned(value2.getLength(rlepos)) + 1;
                Util.resetBitmapRange(b, start, end);
            }
        } else {
            for (int rlepos = 0; rlepos < value2.nbrruns; ++rlepos) {
                int start = BufferUtil.toIntUnsigned(value2.getValue(rlepos));
                int end = BufferUtil.toIntUnsigned(value2.getValue(rlepos)) + BufferUtil.toIntUnsigned(value2.getLength(rlepos)) + 1;
                BufferUtil.resetBitmapRange(answer.bitmap, start, end);
            }
        }
        answer.computeCardinality();
        if (answer.getCardinality() > 4096) {
            return answer;
        }
        return answer.toArrayContainer();
    }

    @Override
    public void clear() {
        if (this.cardinality != 0) {
            this.cardinality = 0;
            int len = this.bitmap.limit();
            for (int k = 0; k < len; ++k) {
                this.bitmap.put(k, 0L);
            }
        }
    }

    @Override
    public MappeableBitmapContainer clone() {
        return new MappeableBitmapContainer(this.cardinality, this.bitmap);
    }

    @Override
    public boolean contains(short i) {
        int x = BufferUtil.toIntUnsigned(i);
        return (this.bitmap.get(x / 64) & 1L << x) != 0L;
    }

    public boolean equals(Object o) {
        if (o instanceof MappeableBitmapContainer) {
            MappeableBitmapContainer srb = (MappeableBitmapContainer)o;
            if (srb.cardinality != this.cardinality) {
                return false;
            }
            if (BufferUtil.isBackedBySimpleArray(this.bitmap) && BufferUtil.isBackedBySimpleArray(srb.bitmap)) {
                long[] b = this.bitmap.array();
                long[] s = srb.bitmap.array();
                int len = this.bitmap.limit();
                for (int k = 0; k < len; ++k) {
                    if (b[k] == s[k]) continue;
                    return false;
                }
            } else {
                int len = this.bitmap.limit();
                for (int k = 0; k < len; ++k) {
                    if (this.bitmap.get(k) == srb.bitmap.get(k)) continue;
                    return false;
                }
            }
            return true;
        }
        if (o instanceof MappeableRunContainer) {
            return o.equals(this);
        }
        return false;
    }

    protected void fillArray(short[] array) {
        int pos = 0;
        if (BufferUtil.isBackedBySimpleArray(this.bitmap)) {
            long[] b = this.bitmap.array();
            int base = 0;
            for (int k = 0; k < b.length; ++k) {
                long t;
                for (long bitset = b[k]; bitset != 0L; bitset ^= t) {
                    t = bitset & -bitset;
                    array[pos++] = (short)(base + Long.bitCount(t - 1L));
                }
                base += 64;
            }
        } else {
            int len = this.bitmap.limit();
            int base = 0;
            for (int k = 0; k < len; ++k) {
                long t;
                for (long bitset = this.bitmap.get(k); bitset != 0L; bitset ^= t) {
                    t = bitset & -bitset;
                    array[pos++] = (short)(base + Long.bitCount(t - 1L));
                }
                base += 64;
            }
        }
    }

    @Override
    public void fillLeastSignificant16bits(int[] x, int i, int mask) {
        int pos = i;
        int base = mask;
        if (BufferUtil.isBackedBySimpleArray(this.bitmap)) {
            long[] b = this.bitmap.array();
            int len = this.bitmap.limit();
            for (int k = 0; k < len; ++k) {
                long t;
                for (long bitset = b[k]; bitset != 0L; bitset ^= t) {
                    t = bitset & -bitset;
                    x[pos++] = base + Long.bitCount(t - 1L);
                }
                base += 64;
            }
        } else {
            int len = this.bitmap.limit();
            for (int k = 0; k < len; ++k) {
                long t;
                for (long bitset = this.bitmap.get(k); bitset != 0L; bitset ^= t) {
                    t = bitset & -bitset;
                    x[pos++] = base + Long.bitCount(t - 1L);
                }
                base += 64;
            }
        }
    }

    @Override
    protected int getArraySizeInBytes() {
        return 8192;
    }

    protected static int getArraySizeInBytes(int unusedCardinality) {
        return 8192;
    }

    @Override
    public int getCardinality() {
        return this.cardinality;
    }

    @Override
    public ShortIterator getShortIterator() {
        if (this.isArrayBacked()) {
            return BitmapContainer.getShortIterator(this.bitmap.array());
        }
        return new MappeableBitmapContainerShortIterator(this);
    }

    @Override
    public ShortIterator getReverseShortIterator() {
        if (this.isArrayBacked()) {
            return BitmapContainer.getReverseShortIterator(this.bitmap.array());
        }
        return new ReverseMappeableBitmapContainerShortIterator(this);
    }

    @Override
    public int getSizeInBytes() {
        return this.bitmap.limit() * 8;
    }

    public int hashCode() {
        long hash = 0L;
        int len = this.bitmap.limit();
        for (int k = 0; k < len; ++k) {
            hash += 31L * hash + this.bitmap.get(k);
        }
        return (int)hash;
    }

    @Override
    public MappeableContainer iand(MappeableArrayContainer b2) {
        return b2.and(this);
    }

    @Override
    public MappeableContainer iand(MappeableBitmapContainer b2) {
        int k;
        if (BufferUtil.isBackedBySimpleArray(this.bitmap) && BufferUtil.isBackedBySimpleArray(b2.bitmap)) {
            int k2;
            int newCardinality = 0;
            long[] tb = this.bitmap.array();
            long[] tb2 = b2.bitmap.array();
            int len = this.bitmap.limit();
            for (k2 = 0; k2 < len; ++k2) {
                newCardinality += Long.bitCount(tb[k2] & tb2[k2]);
            }
            if (newCardinality > 4096) {
                for (k2 = 0; k2 < len; ++k2) {
                    int n = k2;
                    tb[n] = tb[n] & tb2[k2];
                }
                this.cardinality = newCardinality;
                return this;
            }
            MappeableArrayContainer ac = new MappeableArrayContainer(newCardinality);
            BufferUtil.fillArrayAND(ac.content.array(), this.bitmap, b2.bitmap);
            ac.cardinality = newCardinality;
            return ac;
        }
        int newCardinality = 0;
        int len = this.bitmap.limit();
        for (k = 0; k < len; ++k) {
            newCardinality += Long.bitCount(this.bitmap.get(k) & b2.bitmap.get(k));
        }
        if (newCardinality > 4096) {
            for (k = 0; k < len; ++k) {
                this.bitmap.put(k, this.bitmap.get(k) & b2.bitmap.get(k));
            }
            this.cardinality = newCardinality;
            return this;
        }
        MappeableArrayContainer ac = new MappeableArrayContainer(newCardinality);
        BufferUtil.fillArrayAND(ac.content.array(), this.bitmap, b2.bitmap);
        ac.cardinality = newCardinality;
        return ac;
    }

    @Override
    public MappeableContainer iand(MappeableRunContainer x) {
        int card = x.getCardinality();
        if (card <= 4096) {
            MappeableArrayContainer answer = new MappeableArrayContainer(card);
            answer.cardinality = 0;
            for (int rlepos = 0; rlepos < x.nbrruns; ++rlepos) {
                int runStart = BufferUtil.toIntUnsigned(x.getValue(rlepos));
                int runEnd = runStart + BufferUtil.toIntUnsigned(x.getLength(rlepos));
                for (int runValue = runStart; runValue <= runEnd; ++runValue) {
                    if (!this.contains((short)runValue)) continue;
                    answer.content.put(answer.cardinality++, (short)runValue);
                }
            }
            return answer;
        }
        int start = 0;
        for (int rlepos = 0; rlepos < x.nbrruns; ++rlepos) {
            int end = BufferUtil.toIntUnsigned(x.getValue(rlepos));
            BufferUtil.resetBitmapRange(this.bitmap, start, end);
            start = end + BufferUtil.toIntUnsigned(x.getLength(rlepos)) + 1;
        }
        BufferUtil.resetBitmapRange(this.bitmap, start, BufferUtil.maxLowBitAsInteger() + 1);
        this.computeCardinality();
        if (this.getCardinality() > 4096) {
            return this;
        }
        return this.toArrayContainer();
    }

    @Override
    public MappeableContainer iandNot(MappeableArrayContainer b2) {
        for (int k = 0; k < b2.cardinality; ++k) {
            this.remove(b2.content.get(k));
        }
        if (this.cardinality <= 4096) {
            return this.toArrayContainer();
        }
        return this;
    }

    @Override
    public MappeableContainer iandNot(MappeableBitmapContainer b2) {
        int k;
        int newCardinality = 0;
        if (!BufferUtil.isBackedBySimpleArray(this.bitmap)) {
            throw new RuntimeException("Should not happen. Internal bug.");
        }
        long[] b = this.bitmap.array();
        if (BufferUtil.isBackedBySimpleArray(b2.bitmap)) {
            int k2;
            long[] b2Arr = b2.bitmap.array();
            int len = this.bitmap.limit();
            for (k2 = 0; k2 < len; ++k2) {
                newCardinality += Long.bitCount(b[k2] & (b2Arr[k2] ^ 0xFFFFFFFFFFFFFFFFL));
            }
            if (newCardinality > 4096) {
                for (k2 = 0; k2 < len; ++k2) {
                    this.bitmap.put(k2, b[k2] & (b2Arr[k2] ^ 0xFFFFFFFFFFFFFFFFL));
                }
                this.cardinality = newCardinality;
                return this;
            }
            MappeableArrayContainer ac = new MappeableArrayContainer(newCardinality);
            Util.fillArrayANDNOT(ac.content.array(), b, b2Arr);
            ac.cardinality = newCardinality;
            return ac;
        }
        int len = this.bitmap.limit();
        for (k = 0; k < len; ++k) {
            newCardinality += Long.bitCount(b[k] & (b2.bitmap.get(k) ^ 0xFFFFFFFFFFFFFFFFL));
        }
        if (newCardinality > 4096) {
            for (k = 0; k < len; ++k) {
                int n = k;
                b[n] = b[n] & (b2.bitmap.get(k) ^ 0xFFFFFFFFFFFFFFFFL);
            }
            this.cardinality = newCardinality;
            return this;
        }
        MappeableArrayContainer ac = new MappeableArrayContainer(newCardinality);
        BufferUtil.fillArrayANDNOT(ac.content.array(), this.bitmap, b2.bitmap);
        ac.cardinality = newCardinality;
        return ac;
    }

    @Override
    public MappeableContainer iandNot(MappeableRunContainer x) {
        if (BufferUtil.isBackedBySimpleArray(this.bitmap)) {
            long[] b = this.bitmap.array();
            for (int rlepos = 0; rlepos < x.nbrruns; ++rlepos) {
                int start = BufferUtil.toIntUnsigned(x.getValue(rlepos));
                int end = start + BufferUtil.toIntUnsigned(x.getLength(rlepos)) + 1;
                Util.resetBitmapRange(b, start, end);
            }
            this.computeCardinality();
            if (this.getCardinality() > 4096) {
                return this;
            }
            return this.toArrayContainer();
        }
        for (int rlepos = 0; rlepos < x.nbrruns; ++rlepos) {
            int start = BufferUtil.toIntUnsigned(x.getValue(rlepos));
            int end = start + BufferUtil.toIntUnsigned(x.getLength(rlepos)) + 1;
            BufferUtil.resetBitmapRange(this.bitmap, start, end);
        }
        this.computeCardinality();
        if (this.getCardinality() > 4096) {
            return this;
        }
        return this.toArrayContainer();
    }

    @Override
    public MappeableContainer inot(int firstOfRange, int lastOfRange) {
        return this.not(this, firstOfRange, lastOfRange);
    }

    @Override
    public MappeableBitmapContainer ior(MappeableArrayContainer value2) {
        if (!BufferUtil.isBackedBySimpleArray(this.bitmap)) {
            throw new RuntimeException("Should not happen. Internal bug.");
        }
        long[] b = this.bitmap.array();
        if (BufferUtil.isBackedBySimpleArray(value2.content)) {
            short[] v2 = value2.content.array();
            int c = value2.cardinality;
            for (int k = 0; k < c; ++k) {
                long aft;
                int i = BufferUtil.toIntUnsigned(v2[k]) >>> 6;
                long bef = b[i];
                b[i] = aft = bef | 1L << v2[k];
                this.cardinality = (int)((long)this.cardinality + (bef - aft >>> 63));
            }
            return this;
        }
        int c = value2.cardinality;
        for (int k = 0; k < c; ++k) {
            long aft;
            short v2 = value2.content.get(k);
            int i = BufferUtil.toIntUnsigned(v2) >>> 6;
            long bef = b[i];
            b[i] = aft = bef | 1L << v2;
            this.cardinality = (int)((long)this.cardinality + (bef - aft >>> 63));
        }
        return this;
    }

    @Override
    public MappeableContainer ior(MappeableBitmapContainer b2) {
        if (!BufferUtil.isBackedBySimpleArray(this.bitmap)) {
            throw new RuntimeException("Should not happen. Internal bug.");
        }
        long[] b = this.bitmap.array();
        this.cardinality = 0;
        if (BufferUtil.isBackedBySimpleArray(b2.bitmap)) {
            long[] b2Arr = b2.bitmap.array();
            int len = this.bitmap.limit();
            for (int k = 0; k < len; ++k) {
                long w;
                b[k] = w = b[k] | b2Arr[k];
                this.cardinality += Long.bitCount(w);
            }
            return this;
        }
        int len = this.bitmap.limit();
        for (int k = 0; k < len; ++k) {
            long w;
            b[k] = w = b[k] | b2.bitmap.get(k);
            this.cardinality += Long.bitCount(w);
        }
        return this;
    }

    @Override
    protected boolean isArrayBacked() {
        return BufferUtil.isBackedBySimpleArray(this.bitmap);
    }

    @Override
    public MappeableContainer ior(MappeableRunContainer x) {
        if (BufferUtil.isBackedBySimpleArray(this.bitmap)) {
            long[] b = this.bitmap.array();
            for (int rlepos = 0; rlepos < x.nbrruns; ++rlepos) {
                int start = BufferUtil.toIntUnsigned(x.getValue(rlepos));
                int end = start + BufferUtil.toIntUnsigned(x.getLength(rlepos)) + 1;
                Util.setBitmapRange(b, start, end);
            }
        } else {
            for (int rlepos = 0; rlepos < x.nbrruns; ++rlepos) {
                int start = BufferUtil.toIntUnsigned(x.getValue(rlepos));
                int end = start + BufferUtil.toIntUnsigned(x.getLength(rlepos)) + 1;
                BufferUtil.setBitmapRange(this.bitmap, start, end);
            }
        }
        this.computeCardinality();
        return this;
    }

    @Override
    public Iterator<Short> iterator() {
        return new Iterator<Short>(){
            final ShortIterator si;
            {
                this.si = MappeableBitmapContainer.this.getShortIterator();
            }

            @Override
            public boolean hasNext() {
                return this.si.hasNext();
            }

            @Override
            public Short next() {
                return this.si.next();
            }

            @Override
            public void remove() {
                throw new RuntimeException("unsupported operation: remove");
            }
        };
    }

    @Override
    public MappeableContainer ixor(MappeableArrayContainer value2) {
        if (!BufferUtil.isBackedBySimpleArray(this.bitmap)) {
            throw new RuntimeException("Should not happen. Internal bug.");
        }
        long[] b = this.bitmap.array();
        if (BufferUtil.isBackedBySimpleArray(value2.content)) {
            short[] v2 = value2.content.array();
            int c = value2.cardinality;
            for (int k = 0; k < c; ++k) {
                short vc = v2[k];
                long mask = 1L << v2[k];
                int index = BufferUtil.toIntUnsigned(vc) >>> 6;
                long ba = b[index];
                this.cardinality = (int)((long)this.cardinality + (1L - 2L * ((ba & mask) >>> vc)));
                b[index] = ba ^ mask;
            }
        } else {
            int c = value2.cardinality;
            for (int k = 0; k < c; ++k) {
                short v2 = value2.content.get(k);
                long mask = 1L << v2;
                int index = BufferUtil.toIntUnsigned(v2) >>> 6;
                long ba = b[index];
                this.cardinality = (int)((long)this.cardinality + (1L - 2L * ((ba & mask) >>> v2)));
                b[index] = ba ^ mask;
            }
        }
        if (this.cardinality <= 4096) {
            return this.toArrayContainer();
        }
        return this;
    }

    @Override
    public MappeableContainer ixor(MappeableBitmapContainer b2) {
        int k;
        if (!BufferUtil.isBackedBySimpleArray(this.bitmap)) {
            throw new RuntimeException("Should not happen. Internal bug.");
        }
        long[] b = this.bitmap.array();
        if (BufferUtil.isBackedBySimpleArray(b2.bitmap)) {
            int k2;
            long[] b2Arr = b2.bitmap.array();
            int newCardinality = 0;
            int len = this.bitmap.limit();
            for (k2 = 0; k2 < len; ++k2) {
                newCardinality += Long.bitCount(b[k2] ^ b2Arr[k2]);
            }
            if (newCardinality > 4096) {
                for (k2 = 0; k2 < len; ++k2) {
                    int n = k2;
                    b[n] = b[n] ^ b2Arr[k2];
                }
                this.cardinality = newCardinality;
                return this;
            }
            MappeableArrayContainer ac = new MappeableArrayContainer(newCardinality);
            Util.fillArrayXOR(ac.content.array(), b, b2Arr);
            ac.cardinality = newCardinality;
            return ac;
        }
        int newCardinality = 0;
        int len = this.bitmap.limit();
        for (k = 0; k < len; ++k) {
            newCardinality += Long.bitCount(b[k] ^ b2.bitmap.get(k));
        }
        if (newCardinality > 4096) {
            for (k = 0; k < len; ++k) {
                int n = k;
                b[n] = b[n] ^ b2.bitmap.get(k);
            }
            this.cardinality = newCardinality;
            return this;
        }
        MappeableArrayContainer ac = new MappeableArrayContainer(newCardinality);
        BufferUtil.fillArrayXOR(ac.content.array(), this.bitmap, b2.bitmap);
        ac.cardinality = newCardinality;
        return ac;
    }

    @Override
    public MappeableContainer ixor(MappeableRunContainer x) {
        if (BufferUtil.isBackedBySimpleArray(this.bitmap)) {
            long[] b = this.bitmap.array();
            for (int rlepos = 0; rlepos < x.nbrruns; ++rlepos) {
                int start = BufferUtil.toIntUnsigned(x.getValue(rlepos));
                int end = start + BufferUtil.toIntUnsigned(x.getLength(rlepos)) + 1;
                Util.flipBitmapRange(b, start, end);
            }
        } else {
            for (int rlepos = 0; rlepos < x.nbrruns; ++rlepos) {
                int start = BufferUtil.toIntUnsigned(x.getValue(rlepos));
                int end = start + BufferUtil.toIntUnsigned(x.getLength(rlepos)) + 1;
                BufferUtil.flipBitmapRange(this.bitmap, start, end);
            }
        }
        this.computeCardinality();
        if (this.getCardinality() > 4096) {
            return this;
        }
        return this.toArrayContainer();
    }

    protected void loadData(MappeableArrayContainer arrayContainer) {
        this.cardinality = arrayContainer.cardinality;
        if (!BufferUtil.isBackedBySimpleArray(this.bitmap)) {
            throw new RuntimeException("Should not happen. Internal bug.");
        }
        long[] bitArray = this.bitmap.array();
        if (BufferUtil.isBackedBySimpleArray(this.bitmap) && BufferUtil.isBackedBySimpleArray(arrayContainer.content)) {
            long[] b = this.bitmap.array();
            short[] ac = arrayContainer.content.array();
            for (int k = 0; k < arrayContainer.cardinality; ++k) {
                short x = ac[k];
                bitArray[BufferUtil.toIntUnsigned((short)x) / 64] = b[BufferUtil.toIntUnsigned(x) / 64] | 1L << x;
            }
        } else {
            for (int k = 0; k < arrayContainer.cardinality; ++k) {
                short x = arrayContainer.content.get(k);
                bitArray[BufferUtil.toIntUnsigned((short)x) / 64] = this.bitmap.get(BufferUtil.toIntUnsigned(x) / 64) | 1L << x;
            }
        }
    }

    public int nextSetBit(int i) {
        int x = i >> 6;
        long w = this.bitmap.get(x);
        if ((w >>>= i) != 0L) {
            return i + Long.numberOfTrailingZeros(w);
        }
        ++x;
        while (x < 1024) {
            long X = this.bitmap.get(x);
            if (X != 0L) {
                return x * 64 + Long.numberOfTrailingZeros(X);
            }
            ++x;
        }
        return -1;
    }

    public int prevSetBit(int i) {
        int x = i >> 6;
        long w = this.bitmap.get(x);
        if ((w <<= 64 - i - 1) != 0L) {
            return i - Long.numberOfLeadingZeros(w);
        }
        --x;
        while (x >= 0) {
            long X = this.bitmap.get(x);
            if (X != 0L) {
                return x * 64 + 63 - Long.numberOfLeadingZeros(X);
            }
            --x;
        }
        return -1;
    }

    public short nextUnsetBit(int i) {
        int x = i / 64;
        long w = this.bitmap.get(x) ^ 0xFFFFFFFFFFFFFFFFL;
        if ((w >>>= i) != 0L) {
            return (short)(i + Long.numberOfTrailingZeros(w));
        }
        ++x;
        while (x < 1024) {
            long X = this.bitmap.get(x);
            if (X != -1L) {
                return (short)(x * 64 + Long.numberOfTrailingZeros(X ^ 0xFFFFFFFFFFFFFFFFL));
            }
            ++x;
        }
        return -1;
    }

    @Override
    public MappeableContainer not(int firstOfRange, int lastOfRange) {
        return this.not(new MappeableBitmapContainer(), firstOfRange, lastOfRange);
    }

    private MappeableContainer not(MappeableBitmapContainer answer, int firstOfRange, int lastOfRange) {
        assert (this.bitmap.limit() == 1024);
        if (lastOfRange - firstOfRange == 65536) {
            int newCardinality = 65536 - this.cardinality;
            int len = this.bitmap.limit();
            for (int k = 0; k < len; ++k) {
                answer.bitmap.put(k, this.bitmap.get(k) ^ 0xFFFFFFFFFFFFFFFFL);
            }
            answer.cardinality = newCardinality;
            if (newCardinality <= 4096) {
                return answer.toArrayContainer();
            }
            return answer;
        }
        int cardinalityChange = 0;
        int rangeFirstWord = firstOfRange / 64;
        int rangeFirstBitPos = firstOfRange & 0x3F;
        int rangeLastWord = (lastOfRange - 1) / 64;
        long rangeLastBitPos = lastOfRange - 1 & 0x3F;
        if (answer != this) {
            for (int i = 0; i < rangeFirstWord; ++i) {
                answer.bitmap.put(i, this.bitmap.get(i));
            }
            int len = this.bitmap.limit();
            for (int i = rangeLastWord + 1; i < len; ++i) {
                answer.bitmap.put(i, this.bitmap.get(i));
            }
        }
        long maskOnLeft = rangeLastBitPos == 63L ? -1L : (1L << (int)(rangeLastBitPos + 1L)) - 1L;
        long mask = -1L;
        mask ^= (1L << rangeFirstBitPos) - 1L;
        if (rangeFirstWord == rangeLastWord) {
            cardinalityChange = -Long.bitCount(this.bitmap.get(rangeFirstWord));
            answer.bitmap.put(rangeFirstWord, this.bitmap.get(rangeFirstWord) ^ (mask &= maskOnLeft));
            answer.cardinality = this.cardinality + (cardinalityChange += Long.bitCount(answer.bitmap.get(rangeFirstWord)));
            if (answer.cardinality <= 4096) {
                return answer.toArrayContainer();
            }
            return answer;
        }
        cardinalityChange += -Long.bitCount(this.bitmap.get(rangeFirstWord));
        answer.bitmap.put(rangeFirstWord, this.bitmap.get(rangeFirstWord) ^ mask);
        cardinalityChange += Long.bitCount(answer.bitmap.get(rangeFirstWord));
        cardinalityChange += -Long.bitCount(this.bitmap.get(rangeLastWord));
        answer.bitmap.put(rangeLastWord, this.bitmap.get(rangeLastWord) ^ maskOnLeft);
        cardinalityChange += Long.bitCount(answer.bitmap.get(rangeLastWord));
        for (int i = rangeFirstWord + 1; i < rangeLastWord; ++i) {
            cardinalityChange += 64 - 2 * Long.bitCount(this.bitmap.get(i));
            answer.bitmap.put(i, this.bitmap.get(i) ^ 0xFFFFFFFFFFFFFFFFL);
        }
        answer.cardinality = this.cardinality + cardinalityChange;
        if (answer.cardinality <= 4096) {
            return answer.toArrayContainer();
        }
        return answer;
    }

    @Override
    public MappeableBitmapContainer or(MappeableArrayContainer value2) {
        MappeableBitmapContainer answer = this.clone();
        if (!BufferUtil.isBackedBySimpleArray(answer.bitmap)) {
            throw new RuntimeException("Should not happen. Internal bug.");
        }
        long[] bitArray = answer.bitmap.array();
        if (BufferUtil.isBackedBySimpleArray(answer.bitmap) && BufferUtil.isBackedBySimpleArray(value2.content)) {
            long[] ab = answer.bitmap.array();
            short[] v2 = value2.content.array();
            int c = value2.cardinality;
            for (int k = 0; k < c; ++k) {
                long aft;
                short v = v2[k];
                int i = BufferUtil.toIntUnsigned(v) >>> 6;
                long w = ab[i];
                bitArray[i] = aft = w | 1L << v;
                answer.cardinality = (int)((long)answer.cardinality + (w - aft >>> 63));
            }
        } else {
            int c = value2.cardinality;
            for (int k = 0; k < c; ++k) {
                long aft;
                short v2 = value2.content.get(k);
                int i = BufferUtil.toIntUnsigned(v2) >>> 6;
                long w = answer.bitmap.get(i);
                bitArray[i] = aft = w | 1L << v2;
                answer.cardinality = (int)((long)answer.cardinality + (w - aft >>> 63));
            }
        }
        return answer;
    }

    @Override
    public MappeableContainer or(MappeableBitmapContainer value2) {
        if (USE_IN_PLACE) {
            MappeableBitmapContainer value1 = this.clone();
            return value1.ior(value2);
        }
        MappeableBitmapContainer answer = new MappeableBitmapContainer();
        if (!BufferUtil.isBackedBySimpleArray(answer.bitmap)) {
            throw new RuntimeException("Should not happen. Internal bug.");
        }
        long[] bitArray = answer.bitmap.array();
        answer.cardinality = 0;
        if (BufferUtil.isBackedBySimpleArray(this.bitmap) && BufferUtil.isBackedBySimpleArray(value2.bitmap)) {
            long[] b = this.bitmap.array();
            long[] v2 = value2.bitmap.array();
            int len = this.bitmap.limit();
            for (int k = 0; k < len; ++k) {
                long w;
                bitArray[k] = w = b[k] | v2[k];
                answer.cardinality += Long.bitCount(w);
            }
        } else {
            int len = this.bitmap.limit();
            for (int k = 0; k < len; ++k) {
                long w;
                bitArray[k] = w = this.bitmap.get(k) | value2.bitmap.get(k);
                answer.cardinality += Long.bitCount(w);
            }
        }
        return answer;
    }

    @Override
    public MappeableContainer or(MappeableRunContainer value2) {
        return value2.or(this);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.cardinality = 0;
        int len = this.bitmap.limit();
        if (BufferUtil.isBackedBySimpleArray(this.bitmap)) {
            long[] b = this.bitmap.array();
            for (int k = 0; k < len; ++k) {
                long w;
                b[k] = w = Long.reverseBytes(in.readLong());
                this.cardinality += Long.bitCount(w);
            }
        } else {
            for (int k = 0; k < len; ++k) {
                long w = Long.reverseBytes(in.readLong());
                this.bitmap.put(k, w);
                this.cardinality += Long.bitCount(w);
            }
        }
    }

    @Override
    public MappeableContainer remove(short i) {
        int x = BufferUtil.toIntUnsigned(i);
        long X = this.bitmap.get(x / 64);
        long mask = 1L << x;
        if (this.cardinality == 4097 && (X & mask) != 0L) {
            --this.cardinality;
            this.bitmap.put(x / 64, X & (mask ^ 0xFFFFFFFFFFFFFFFFL));
            return this.toArrayContainer();
        }
        long aft = X & (mask ^ 0xFFFFFFFFFFFFFFFFL);
        this.cardinality = (int)((long)this.cardinality - (aft - X >>> 63));
        this.bitmap.put(x / 64, aft);
        return this;
    }

    @Override
    public int serializedSizeInBytes() {
        return MappeableBitmapContainer.serializedSizeInBytes(0);
    }

    protected static int serializedSizeInBytes(int unusedCardinality) {
        return 8192;
    }

    public MappeableArrayContainer toArrayContainer() {
        MappeableArrayContainer ac = new MappeableArrayContainer(this.cardinality);
        ac.loadData(this);
        return ac;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        ShortIterator i = this.getShortIterator();
        sb.append("{");
        while (i.hasNext()) {
            sb.append(i);
            if (!i.hasNext()) continue;
            sb.append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @Override
    public void trim() {
    }

    @Override
    protected void writeArray(DataOutput out) throws IOException {
        int len = this.bitmap.limit();
        if (BufferUtil.isBackedBySimpleArray(this.bitmap)) {
            long[] b = this.bitmap.array();
            for (int k = 0; k < len; ++k) {
                out.writeLong(Long.reverseBytes(b[k]));
            }
        } else {
            for (int k = 0; k < len; ++k) {
                long w = this.bitmap.get(k);
                out.writeLong(Long.reverseBytes(w));
            }
        }
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        this.writeArray(out);
    }

    @Override
    public MappeableContainer xor(MappeableArrayContainer value2) {
        MappeableBitmapContainer answer = this.clone();
        if (!BufferUtil.isBackedBySimpleArray(answer.bitmap)) {
            throw new RuntimeException("Should not happen. Internal bug.");
        }
        long[] bitArray = answer.bitmap.array();
        if (BufferUtil.isBackedBySimpleArray(value2.content)) {
            short[] v2 = value2.content.array();
            int c = value2.cardinality;
            for (int k = 0; k < c; ++k) {
                short vc = v2[k];
                long mask = 1L << vc;
                int index = BufferUtil.toIntUnsigned(vc) >>> 6;
                long ba = bitArray[index];
                answer.cardinality = (int)((long)answer.cardinality + (1L - 2L * ((ba & mask) >>> vc)));
                bitArray[index] = ba ^ mask;
            }
        } else {
            int c = value2.cardinality;
            for (int k = 0; k < c; ++k) {
                short v2 = value2.content.get(k);
                long mask = 1L << v2;
                int index = BufferUtil.toIntUnsigned(v2) >>> 6;
                long ba = bitArray[index];
                answer.cardinality = (int)((long)answer.cardinality + (1L - 2L * ((ba & mask) >>> v2)));
                bitArray[index] = ba ^ mask;
            }
        }
        if (answer.cardinality <= 4096) {
            return answer.toArrayContainer();
        }
        return answer;
    }

    @Override
    public MappeableContainer xor(MappeableBitmapContainer value2) {
        int k;
        int len;
        int newCardinality = 0;
        if (BufferUtil.isBackedBySimpleArray(this.bitmap) && BufferUtil.isBackedBySimpleArray(value2.bitmap)) {
            long[] b = this.bitmap.array();
            long[] v2 = value2.bitmap.array();
            len = this.bitmap.limit();
            for (k = 0; k < len; ++k) {
                newCardinality += Long.bitCount(b[k] ^ v2[k]);
            }
        } else {
            int len2 = this.bitmap.limit();
            for (int k2 = 0; k2 < len2; ++k2) {
                newCardinality += Long.bitCount(this.bitmap.get(k2) ^ value2.bitmap.get(k2));
            }
        }
        if (newCardinality > 4096) {
            MappeableBitmapContainer answer = new MappeableBitmapContainer();
            long[] bitArray = answer.bitmap.array();
            if (BufferUtil.isBackedBySimpleArray(this.bitmap) && BufferUtil.isBackedBySimpleArray(value2.bitmap)) {
                long[] b = this.bitmap.array();
                long[] v2 = value2.bitmap.array();
                int len3 = answer.bitmap.limit();
                for (int k3 = 0; k3 < len3; ++k3) {
                    bitArray[k3] = b[k3] ^ v2[k3];
                }
            } else {
                len = answer.bitmap.limit();
                for (k = 0; k < len; ++k) {
                    bitArray[k] = this.bitmap.get(k) ^ value2.bitmap.get(k);
                }
            }
            answer.cardinality = newCardinality;
            return answer;
        }
        MappeableArrayContainer ac = new MappeableArrayContainer(newCardinality);
        if (BufferUtil.isBackedBySimpleArray(this.bitmap) && BufferUtil.isBackedBySimpleArray(value2.bitmap)) {
            Util.fillArrayXOR(ac.content.array(), this.bitmap.array(), value2.bitmap.array());
        } else {
            BufferUtil.fillArrayXOR(ac.content.array(), this.bitmap, value2.bitmap);
        }
        ac.cardinality = newCardinality;
        return ac;
    }

    @Override
    public MappeableContainer xor(MappeableRunContainer value2) {
        return value2.xor(this);
    }

    protected MappeableContainer ilazyor(MappeableArrayContainer value2) {
        this.cardinality = -1;
        if (!BufferUtil.isBackedBySimpleArray(this.bitmap)) {
            throw new RuntimeException("Should not happen. Internal bug.");
        }
        long[] b = this.bitmap.array();
        int c = value2.cardinality;
        for (int k = 0; k < c; ++k) {
            int i;
            short v2 = value2.content.get(k);
            int n = i = BufferUtil.toIntUnsigned(v2) >>> 6;
            b[n] = b[n] | 1L << v2;
        }
        return this;
    }

    protected MappeableContainer ilazyor(MappeableBitmapContainer x) {
        if (BufferUtil.isBackedBySimpleArray(x.bitmap)) {
            long[] b = this.bitmap.array();
            long[] b2 = x.bitmap.array();
            for (int k = 0; k < b.length; ++k) {
                int n = k;
                b[n] = b[n] | b2[k];
            }
        } else {
            int m = this.bitmap.limit();
            for (int k = 0; k < m; ++k) {
                this.bitmap.put(k, this.bitmap.get(k) | x.bitmap.get(k));
            }
        }
        this.cardinality = -1;
        return this;
    }

    protected MappeableContainer lazyor(MappeableArrayContainer value2) {
        MappeableBitmapContainer answer = this.clone();
        answer.cardinality = -1;
        if (!BufferUtil.isBackedBySimpleArray(answer.bitmap)) {
            throw new RuntimeException("Should not happen. Internal bug.");
        }
        long[] b = answer.bitmap.array();
        int c = value2.cardinality;
        for (int k = 0; k < c; ++k) {
            int i;
            short v2 = value2.content.get(k);
            int n = i = BufferUtil.toIntUnsigned(v2) >>> 6;
            b[n] = b[n] | 1L << v2;
        }
        return answer;
    }

    protected MappeableContainer lazyor(MappeableBitmapContainer x) {
        MappeableBitmapContainer answer = new MappeableBitmapContainer();
        answer.cardinality = -1;
        if (!BufferUtil.isBackedBySimpleArray(answer.bitmap)) {
            throw new RuntimeException("Should not happen. Internal bug.");
        }
        long[] b = answer.bitmap.array();
        for (int k = 0; k < b.length; ++k) {
            b[k] = this.bitmap.get(k) | x.bitmap.get(k);
        }
        return answer;
    }

    protected MappeableContainer lazyor(MappeableRunContainer x) {
        MappeableBitmapContainer bc = this.clone();
        bc.cardinality = -1;
        if (BufferUtil.isBackedBySimpleArray(bc.bitmap)) {
            long[] b = bc.bitmap.array();
            for (int rlepos = 0; rlepos < x.nbrruns; ++rlepos) {
                int start = BufferUtil.toIntUnsigned(x.getValue(rlepos));
                int end = start + BufferUtil.toIntUnsigned(x.getLength(rlepos)) + 1;
                Util.setBitmapRange(b, start, end);
            }
            return bc;
        }
        for (int rlepos = 0; rlepos < x.nbrruns; ++rlepos) {
            int start = BufferUtil.toIntUnsigned(x.getValue(rlepos));
            int end = start + BufferUtil.toIntUnsigned(x.getLength(rlepos)) + 1;
            BufferUtil.setBitmapRange(bc.bitmap, start, end);
        }
        return bc;
    }

    protected MappeableContainer ilazyor(MappeableRunContainer x) {
        for (int rlepos = 0; rlepos < x.nbrruns; ++rlepos) {
            int start = BufferUtil.toIntUnsigned(x.getValue(rlepos));
            int end = start + BufferUtil.toIntUnsigned(x.getLength(rlepos)) + 1;
            BufferUtil.setBitmapRange(this.bitmap, start, end);
        }
        this.cardinality = -1;
        return this;
    }

    protected void computeCardinality() {
        this.cardinality = 0;
        if (BufferUtil.isBackedBySimpleArray(this.bitmap)) {
            long[] b = this.bitmap.array();
            for (int k = 0; k < b.length; ++k) {
                this.cardinality += Long.bitCount(b[k]);
            }
        } else {
            int m = this.bitmap.limit();
            for (int k = 0; k < m; ++k) {
                this.cardinality += Long.bitCount(this.bitmap.get(k));
            }
        }
    }

    @Override
    public int rank(short lowbits) {
        int x = BufferUtil.toIntUnsigned(lowbits);
        int leftover = x + 1 & 0x3F;
        int answer = 0;
        if (BufferUtil.isBackedBySimpleArray(this.bitmap)) {
            long[] b = this.bitmap.array();
            for (int k = 0; k < (x + 1) / 64; ++k) {
                answer += Long.bitCount(b[k]);
            }
            if (leftover != 0) {
                answer += Long.bitCount(b[(x + 1) / 64] << 64 - leftover);
            }
        } else {
            for (int k = 0; k < (x + 1) / 64; ++k) {
                answer += Long.bitCount(this.bitmap.get(k));
            }
            if (leftover != 0) {
                answer += Long.bitCount(this.bitmap.get((x + 1) / 64) << 64 - leftover);
            }
        }
        return answer;
    }

    @Override
    public short select(int j) {
        int leftover = j;
        if (BufferUtil.isBackedBySimpleArray(this.bitmap)) {
            long[] b = this.bitmap.array();
            for (int k = 0; k < b.length; ++k) {
                int w = Long.bitCount(b[k]);
                if (w > leftover) {
                    return (short)(k * 64 + Util.select(b[k], leftover));
                }
                leftover -= w;
            }
        } else {
            int len = this.bitmap.limit();
            for (int k = 0; k < len; ++k) {
                long X = this.bitmap.get(k);
                int w = Long.bitCount(X);
                if (w > leftover) {
                    return (short)(k * 64 + Util.select(X, leftover));
                }
                leftover -= w;
            }
        }
        throw new IllegalArgumentException("Insufficient cardinality.");
    }

    @Override
    public MappeableContainer limit(int maxcardinality) {
        if (maxcardinality >= this.cardinality) {
            return this.clone();
        }
        if (maxcardinality <= 4096) {
            MappeableArrayContainer ac = new MappeableArrayContainer(maxcardinality);
            int pos = 0;
            if (!BufferUtil.isBackedBySimpleArray(ac.content)) {
                throw new RuntimeException("Should not happen. Internal bug.");
            }
            short[] cont = ac.content.array();
            int len = this.bitmap.limit();
            for (int k = 0; ac.cardinality < maxcardinality && k < len; ++k) {
                long t;
                for (long bitset = this.bitmap.get(k); ac.cardinality < maxcardinality && bitset != 0L; bitset ^= t) {
                    t = bitset & -bitset;
                    cont[pos++] = (short)(k * 64 + Long.bitCount(t - 1L));
                    ++ac.cardinality;
                }
            }
            return ac;
        }
        MappeableBitmapContainer bc = new MappeableBitmapContainer(maxcardinality, this.bitmap);
        int s = BufferUtil.toIntUnsigned(this.select(maxcardinality));
        int usedwords = (s + 63) / 64;
        int len = this.bitmap.limit();
        int todelete = len - usedwords;
        for (int k = 0; k < todelete; ++k) {
            bc.bitmap.put(len - 1 - k, 0L);
        }
        int lastword = s % 64;
        if (lastword != 0) {
            bc.bitmap.put(s / 64, bc.bitmap.get(s / 64) << 64 - lastword >> 64 - lastword);
        }
        return bc;
    }

    @Override
    public MappeableContainer flip(short i) {
        int x = BufferUtil.toIntUnsigned(i);
        long bef = this.bitmap.get(x / 64);
        long mask = 1L << x;
        if (this.cardinality == 4097 && (bef & mask) != 0L) {
            --this.cardinality;
            this.bitmap.put(x / 64, bef & (mask ^ 0xFFFFFFFFFFFFFFFFL));
            return this.toArrayContainer();
        }
        long aft = bef ^ mask;
        this.cardinality = (int)((long)this.cardinality + (1L - 2L * ((bef & mask) >>> x)));
        this.bitmap.put(x / 64, aft);
        return this;
    }

    @Override
    public MappeableContainer iadd(int begin, int end) {
        BufferUtil.setBitmapRange(this.bitmap, begin, end);
        this.computeCardinality();
        return this;
    }

    @Override
    public MappeableContainer iremove(int begin, int end) {
        BufferUtil.resetBitmapRange(this.bitmap, begin, end);
        this.computeCardinality();
        if (this.getCardinality() < 4096) {
            return this.toArrayContainer();
        }
        return this;
    }

    @Override
    public MappeableContainer add(int begin, int end) {
        MappeableBitmapContainer answer = this.clone();
        BufferUtil.setBitmapRange(answer.bitmap, begin, end);
        answer.computeCardinality();
        return answer;
    }

    @Override
    public MappeableContainer remove(int begin, int end) {
        MappeableBitmapContainer answer = this.clone();
        BufferUtil.resetBitmapRange(answer.bitmap, begin, end);
        answer.computeCardinality();
        if (answer.getCardinality() < 4096) {
            return answer.toArrayContainer();
        }
        return answer;
    }

    @Override
    public MappeableContainer repairAfterLazy() {
        if (this.getCardinality() < 0) {
            this.computeCardinality();
        }
        return this;
    }

    @Override
    public boolean intersects(MappeableArrayContainer value2) {
        if (BufferUtil.isBackedBySimpleArray(value2.content)) {
            short[] c = value2.content.array();
            int ca = value2.cardinality;
            for (int k = 0; k < ca; ++k) {
                if (!this.contains(c[k])) continue;
                return true;
            }
        } else {
            int ca = value2.cardinality;
            for (int k = 0; k < ca; ++k) {
                short v = value2.content.get(k);
                if (!this.contains(v)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean intersects(MappeableBitmapContainer value2) {
        if (BufferUtil.isBackedBySimpleArray(this.bitmap) && BufferUtil.isBackedBySimpleArray(value2.bitmap)) {
            long[] tb = this.bitmap.array();
            long[] v2b = value2.bitmap.array();
            int len = this.bitmap.limit();
            for (int k = 0; k < len; ++k) {
                if ((tb[k] & v2b[k]) == 0L) continue;
                return true;
            }
        } else {
            int len = this.bitmap.limit();
            for (int k = 0; k < len; ++k) {
                if ((this.bitmap.get(k) & value2.bitmap.get(k)) == 0L) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean intersects(MappeableRunContainer x) {
        return x.intersects(this);
    }

    @Override
    public Container toContainer() {
        return new BitmapContainer(this);
    }
}

