/*
 * Decompiled with CFR 0.152.
 */
package org.roaringbitmap;

import java.util.Arrays;
import java.util.BitSet;
import org.roaringbitmap.ArrayContainer;
import org.roaringbitmap.BitmapContainer;
import org.roaringbitmap.Container;
import org.roaringbitmap.IntIterator;
import org.roaringbitmap.RoaringBitmap;
import org.roaringbitmap.Util;

public class BitSetUtil {
    private static final int BLOCK_LENGTH = 1024;

    public static boolean equals(BitSet bitset, RoaringBitmap bitmap) {
        if (bitset.cardinality() != bitmap.getCardinality()) {
            return false;
        }
        IntIterator it = bitmap.getIntIterator();
        while (it.hasNext()) {
            int val = it.next();
            if (bitset.get(val)) continue;
            return false;
        }
        return true;
    }

    public static RoaringBitmap bitmapOf(BitSet bitSet) {
        return BitSetUtil.bitmapOf(bitSet.toLongArray());
    }

    public static RoaringBitmap bitmapOf(long[] words) {
        RoaringBitmap ans = new RoaringBitmap();
        int containerIndex = 0;
        for (int from = 0; from < words.length; from += 1024) {
            int to = Math.min(from + 1024, words.length);
            int blockCardinality = BitSetUtil.cardinality(from, to, words);
            if (blockCardinality <= 0) continue;
            ans.highLowContainer.insertNewKeyValueAt(containerIndex++, Util.highbits(from * 64), BitSetUtil.containerOf(from, to, blockCardinality, words));
        }
        return ans;
    }

    private static Container containerOf(int from, int to, int blockCardinality, long[] words) {
        if (blockCardinality <= 4096) {
            return BitSetUtil.arrayContainerOf(from, to, blockCardinality, words);
        }
        return new BitmapContainer(Arrays.copyOfRange(words, from, from + 1024), blockCardinality);
    }

    private static ArrayContainer arrayContainerOf(int from, int to, int cardinality, long[] words) {
        short[] content = new short[cardinality];
        int index = 0;
        int i = from;
        int socket = 0;
        while (i < to) {
            long t;
            for (long word = words[i]; word != 0L; word ^= t) {
                t = word & -word;
                content[index++] = (short)(socket + Long.bitCount(t - 1L));
            }
            ++i;
            socket += 64;
        }
        return new ArrayContainer(content);
    }

    private static int cardinality(int from, int to, long[] words) {
        int sum = 0;
        for (int i = from; i < to; ++i) {
            sum += Long.bitCount(words[i]);
        }
        return sum;
    }
}

