/*
 * Decompiled with CFR 0.152.
 */
package org.roaringbitmap.buffer;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.LongBuffer;
import java.nio.ShortBuffer;
import java.util.Arrays;
import org.roaringbitmap.buffer.BufferUtil;
import org.roaringbitmap.buffer.ImmutableRoaringArray;
import org.roaringbitmap.buffer.MappeableArrayContainer;
import org.roaringbitmap.buffer.MappeableBitmapContainer;
import org.roaringbitmap.buffer.MappeableContainer;
import org.roaringbitmap.buffer.MappeableContainerPointer;
import org.roaringbitmap.buffer.PointableRoaringArray;

public final class MutableRoaringArray
implements Cloneable,
Externalizable,
PointableRoaringArray {
    protected static final int INITIAL_CAPACITY = 4;
    protected static final short SERIAL_COOKIE = 12346;
    private static final long serialVersionUID = 4L;
    Element[] array = null;
    int size = 0;

    protected MutableRoaringArray() {
        this.array = new Element[4];
    }

    protected MutableRoaringArray(ByteBuffer bb) {
        int k;
        bb.order(ByteOrder.LITTLE_ENDIAN);
        if (bb.getInt() != 12346) {
            throw new RuntimeException("I failed to find the right cookie.");
        }
        this.size = bb.getInt();
        this.array = new Element[this.size];
        short[] keys = new short[this.size];
        int[] cardinalities = new int[this.size];
        boolean[] isBitmap = new boolean[this.size];
        for (k = 0; k < this.size; ++k) {
            keys[k] = bb.getShort();
            cardinalities[k] = BufferUtil.toIntUnsigned(bb.getShort()) + 1;
            isBitmap[k] = cardinalities[k] > 4096;
        }
        for (k = 0; k < this.size; ++k) {
            MappeableContainer val;
            if (cardinalities[k] == 0) {
                throw new RuntimeException("no");
            }
            if (isBitmap[k]) {
                LongBuffer bitmapArray = bb.asLongBuffer().slice();
                bitmapArray.limit(1024);
                bb.position(bb.position() + 8192);
                val = new MappeableBitmapContainer(bitmapArray, cardinalities[k]);
            } else {
                ShortBuffer shortArray = bb.asShortBuffer().slice();
                shortArray.limit(cardinalities[k]);
                bb.position(bb.position() + cardinalities[k] * 2);
                val = new MappeableArrayContainer(shortArray, cardinalities[k]);
            }
            this.array[k] = new Element(keys[k], val);
        }
    }

    protected void append(short key, MappeableContainer value) {
        this.extendArray(1);
        this.array[this.size++] = new Element(key, value);
    }

    protected void appendCopiesAfter(PointableRoaringArray highLowContainer, short beforeStart) {
        int startLocation = highLowContainer.getIndex(beforeStart);
        startLocation = startLocation >= 0 ? ++startLocation : -startLocation - 1;
        this.extendArray(highLowContainer.size() - startLocation);
        for (int i = startLocation; i < highLowContainer.size(); ++i) {
            this.array[this.size++] = new Element(highLowContainer.getKeyAtIndex(i), highLowContainer.getContainerAtIndex(i).clone());
        }
    }

    protected void appendCopiesUntil(PointableRoaringArray highLowContainer, short stoppingKey) {
        int stopKey = BufferUtil.toIntUnsigned(stoppingKey);
        MappeableContainerPointer cp = highLowContainer.getContainerPointer();
        while (cp.hasContainer() && BufferUtil.toIntUnsigned(cp.key()) < stopKey) {
            this.extendArray(1);
            this.array[this.size++] = new Element(cp.key(), cp.getContainer().clone());
            cp.advance();
        }
    }

    protected void appendCopy(PointableRoaringArray highLowContainer, int startingIndex, int end) {
        this.extendArray(end - startingIndex);
        for (int i = startingIndex; i < end; ++i) {
            this.array[this.size++] = new Element(highLowContainer.getKeyAtIndex(i), highLowContainer.getContainerAtIndex(i).clone());
        }
    }

    protected void appendCopy(short key, MappeableContainer value) {
        this.extendArray(1);
        this.array[this.size++] = new Element(key, value.clone());
    }

    private int binarySearch(int begin, int end, short key) {
        int low = begin;
        int high = end - 1;
        int ikey = BufferUtil.toIntUnsigned(key);
        while (low <= high) {
            int middleIndex = low + high >>> 1;
            int middleValue = BufferUtil.toIntUnsigned(this.array[middleIndex].key);
            if (middleValue < ikey) {
                low = middleIndex + 1;
                continue;
            }
            if (middleValue > ikey) {
                high = middleIndex - 1;
                continue;
            }
            return middleIndex;
        }
        return -(low + 1);
    }

    protected void clear() {
        this.array = null;
        this.size = 0;
    }

    @Override
    public MutableRoaringArray clone() {
        try {
            MutableRoaringArray sa = (MutableRoaringArray)super.clone();
            sa.array = Arrays.copyOf(this.array, this.size);
            for (int k = 0; k < this.size; ++k) {
                sa.array[k] = sa.array[k].clone();
            }
            sa.size = this.size;
            return sa;
        }
        catch (CloneNotSupportedException e) {
            return null;
        }
    }

    public void deserialize(DataInput in) throws IOException {
        int k;
        this.clear();
        int cookie = Integer.reverseBytes(in.readInt());
        if (cookie != 12346) {
            throw new IOException("I failed to find the right cookie.");
        }
        this.size = Integer.reverseBytes(in.readInt());
        if (this.array == null || this.array.length < this.size) {
            this.array = new Element[this.size];
        }
        short[] keys = new short[this.size];
        int[] cardinalities = new int[this.size];
        boolean[] isBitmap = new boolean[this.size];
        for (k = 0; k < this.size; ++k) {
            keys[k] = Short.reverseBytes(in.readShort());
            cardinalities[k] = 1 + (0xFFFF & Short.reverseBytes(in.readShort()));
            isBitmap[k] = cardinalities[k] > 4096;
        }
        in.skipBytes(this.size * 4);
        for (k = 0; k < this.size; ++k) {
            MappeableContainer val;
            int l;
            if (isBitmap[k]) {
                LongBuffer bitmapArray = LongBuffer.allocate(1024);
                for (l = 0; l < bitmapArray.limit(); ++l) {
                    bitmapArray.put(l, Long.reverseBytes(in.readLong()));
                }
                val = new MappeableBitmapContainer(bitmapArray, cardinalities[k]);
            } else {
                ShortBuffer shortArray = ShortBuffer.allocate(cardinalities[k]);
                for (l = 0; l < shortArray.limit(); ++l) {
                    shortArray.put(l, Short.reverseBytes(in.readShort()));
                }
                val = new MappeableArrayContainer(shortArray, cardinalities[k]);
            }
            this.array[k] = new Element(keys[k], val);
        }
    }

    public boolean equals(Object o) {
        if (o instanceof MutableRoaringArray) {
            MutableRoaringArray srb = (MutableRoaringArray)o;
            if (srb.size != this.size) {
                return false;
            }
            for (int i = 0; i < srb.size; ++i) {
                Element self = this.array[i];
                Element other = srb.array[i];
                if (self.key == other.key && self.value.equals(other.value)) continue;
                return false;
            }
            return true;
        }
        if (o instanceof ImmutableRoaringArray) {
            ImmutableRoaringArray srb = (ImmutableRoaringArray)o;
            MappeableContainerPointer cp1 = srb.getContainerPointer();
            MappeableContainerPointer cp2 = srb.getContainerPointer();
            while (cp1.hasContainer()) {
                if (!cp2.hasContainer()) {
                    return false;
                }
                if (cp1.key() != cp2.key()) {
                    return false;
                }
                if (cp1.getCardinality() != cp2.getCardinality()) {
                    return false;
                }
                if (cp1.getContainer().equals(cp2.getContainer())) continue;
                return false;
            }
            return !cp2.hasContainer();
        }
        return false;
    }

    protected void extendArray(int k) {
        if (this.size + k >= this.array.length) {
            int newCapacity = this.array.length < 1024 ? 2 * (this.size + k) : 5 * (this.size + k) / 4;
            this.array = Arrays.copyOf(this.array, newCapacity);
        }
    }

    @Override
    public MappeableContainer getContainer(short x) {
        int i = this.binarySearch(0, this.size, x);
        if (i < 0) {
            return null;
        }
        return this.array[i].value;
    }

    @Override
    public MappeableContainer getContainerAtIndex(int i) {
        return this.array[i].value;
    }

    @Override
    public MappeableContainerPointer getContainerPointer() {
        return this.getContainerPointer(0);
    }

    @Override
    public MappeableContainerPointer getContainerPointer(final int startIndex) {
        return new MappeableContainerPointer(){
            int k;
            {
                this.k = startIndex;
            }

            @Override
            public void advance() {
                ++this.k;
            }

            @Override
            public void previous() {
                --this.k;
            }

            @Override
            public int compareTo(MappeableContainerPointer o) {
                if (this.key() != o.key()) {
                    return BufferUtil.toIntUnsigned(this.key()) - BufferUtil.toIntUnsigned(o.key());
                }
                return o.getCardinality() - this.getCardinality();
            }

            @Override
            public int getCardinality() {
                return this.getContainer().getCardinality();
            }

            @Override
            public MappeableContainer getContainer() {
                if (this.k >= MutableRoaringArray.this.size) {
                    return null;
                }
                return MutableRoaringArray.this.array[this.k].value;
            }

            @Override
            public boolean hasContainer() {
                return 0 <= this.k & this.k < MutableRoaringArray.this.size;
            }

            @Override
            public short key() {
                return MutableRoaringArray.this.array[this.k].key;
            }

            @Override
            public MappeableContainerPointer clone() {
                try {
                    return (MappeableContainerPointer)super.clone();
                }
                catch (CloneNotSupportedException e) {
                    return null;
                }
            }
        };
    }

    @Override
    public int getIndex(short x) {
        if (this.size == 0 || this.array[this.size - 1].key == x) {
            return this.size - 1;
        }
        return this.binarySearch(0, this.size, x);
    }

    @Override
    public short getKeyAtIndex(int i) {
        return this.array[i].key;
    }

    @Override
    public int advanceUntil(short x, int pos) {
        int upper;
        int lower = pos + 1;
        if (lower >= this.size || BufferUtil.toIntUnsigned(this.array[lower].key) >= BufferUtil.toIntUnsigned(x)) {
            return lower;
        }
        int spansize = 1;
        while (lower + spansize < this.size && BufferUtil.toIntUnsigned(this.array[lower + spansize].key) < BufferUtil.toIntUnsigned(x)) {
            spansize *= 2;
        }
        int n = upper = lower + spansize < this.size ? lower + spansize : this.size - 1;
        if (this.array[upper].key == x) {
            return upper;
        }
        if (BufferUtil.toIntUnsigned(this.array[upper].key) < BufferUtil.toIntUnsigned(x)) {
            return this.size;
        }
        lower += spansize / 2;
        while (lower + 1 != upper) {
            int mid = (lower + upper) / 2;
            if (this.array[mid].key == x) {
                return mid;
            }
            if (BufferUtil.toIntUnsigned(this.array[mid].key) < BufferUtil.toIntUnsigned(x)) {
                lower = mid;
                continue;
            }
            upper = mid;
        }
        return upper;
    }

    public int hashCode() {
        int hashvalue = 0;
        for (int k = 0; k < this.size; ++k) {
            hashvalue = 31 * hashvalue + this.array[k].hashCode();
        }
        return hashvalue;
    }

    protected void insertNewKeyValueAt(int i, short key, MappeableContainer value) {
        this.extendArray(1);
        System.arraycopy(this.array, i, this.array, i + 1, this.size - i);
        this.array[i] = new Element(key, value);
        ++this.size;
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.deserialize(in);
    }

    protected void removeAtIndex(int i) {
        System.arraycopy(this.array, i + 1, this.array, i, this.size - i - 1);
        this.array[this.size - 1] = null;
        --this.size;
    }

    protected void removeIndexRange(int begin, int end) {
        if (end <= begin) {
            return;
        }
        int range = end - begin;
        System.arraycopy(this.array, end, this.array, begin, this.size - end);
        for (int i = 1; i <= range; ++i) {
            this.array[this.size - i] = null;
        }
        this.size -= range;
    }

    protected void resize(int newLength) {
        Arrays.fill(this.array, newLength, this.size, null);
        this.size = newLength;
    }

    protected void copyRange(int begin, int end, int newBegin) {
        int range = end - begin;
        System.arraycopy(this.array, begin, this.array, newBegin, range);
    }

    @Override
    public void serialize(DataOutput out) throws IOException {
        int k;
        out.writeInt(Integer.reverseBytes(12346));
        out.writeInt(Integer.reverseBytes(this.size));
        for (int k2 = 0; k2 < this.size; ++k2) {
            out.writeShort(Short.reverseBytes(this.array[k2].key));
            out.writeShort(Short.reverseBytes((short)(this.array[k2].value.getCardinality() - 1)));
        }
        int startOffset = 8 + this.size * 4 + this.size * 4;
        for (k = 0; k < this.size; ++k) {
            out.writeInt(Integer.reverseBytes(startOffset));
            startOffset += this.array[k].value.getArraySizeInBytes();
        }
        for (k = 0; k < this.size; ++k) {
            this.array[k].value.writeArray(out);
        }
    }

    @Override
    public int serializedSizeInBytes() {
        int count = 8 + 4 * this.size + 4 * this.size;
        for (int k = 0; k < this.size; ++k) {
            count += this.array[k].value.getArraySizeInBytes();
        }
        return count;
    }

    protected void setContainerAtIndex(int i, MappeableContainer c) {
        this.array[i].value = c;
    }

    protected void replaceKeyAndContainerAtIndex(int i, short key, MappeableContainer c) {
        this.array[i].key = key;
        this.array[i].value = c;
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        this.serialize(out);
    }

    @Override
    public int getCardinality(int i) {
        return this.getContainerAtIndex(i).getCardinality();
    }

    protected static final class Element
    implements Cloneable,
    Comparable<Element> {
        short key;
        MappeableContainer value;

        public Element(short key, MappeableContainer value) {
            this.key = key;
            this.value = value;
        }

        public Element clone() throws CloneNotSupportedException {
            Element c = (Element)super.clone();
            c.value = this.value.clone();
            return c;
        }

        @Override
        public int compareTo(Element o) {
            return BufferUtil.toIntUnsigned(this.key) - BufferUtil.toIntUnsigned(o.key);
        }

        public boolean equals(Object o) {
            if (o instanceof Element) {
                Element e = (Element)o;
                return e.key == this.key && e.value.equals(this.value);
            }
            return false;
        }

        public int hashCode() {
            return this.key * 0xF0F0F0 + this.value.hashCode();
        }
    }
}

