/*
 * Decompiled with CFR 0.152.
 */
package org.roaringbitmap;

import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.PriorityQueue;
import org.roaringbitmap.RoaringBitmap;

public final class FastAggregation {
    private FastAggregation() {
    }

    public static RoaringBitmap and(RoaringBitmap ... bitmaps) {
        if (bitmaps.length == 0) {
            return new RoaringBitmap();
        }
        RoaringBitmap[] array = Arrays.copyOf(bitmaps, bitmaps.length);
        Arrays.sort(array, new Comparator<RoaringBitmap>(){

            @Override
            public int compare(RoaringBitmap a, RoaringBitmap b) {
                return a.getSizeInBytes() - b.getSizeInBytes();
            }
        });
        RoaringBitmap answer = array[0];
        for (int k = 1; k < array.length; ++k) {
            answer = RoaringBitmap.and(answer, array[k]);
        }
        return answer;
    }

    public static RoaringBitmap or(RoaringBitmap ... bitmaps) {
        PriorityQueue<RoaringBitmap> pq = new PriorityQueue<RoaringBitmap>(bitmaps.length, new Comparator<RoaringBitmap>(){

            @Override
            public int compare(RoaringBitmap a, RoaringBitmap b) {
                return a.getSizeInBytes() - b.getSizeInBytes();
            }
        });
        Collections.addAll(pq, bitmaps);
        while (pq.size() > 1) {
            RoaringBitmap x1 = pq.poll();
            RoaringBitmap x2 = pq.poll();
            pq.add(RoaringBitmap.or(x1, x2));
        }
        return pq.poll();
    }

    public static RoaringBitmap xor(RoaringBitmap ... bitmaps) {
        PriorityQueue<RoaringBitmap> pq = new PriorityQueue<RoaringBitmap>(bitmaps.length, new Comparator<RoaringBitmap>(){

            @Override
            public int compare(RoaringBitmap a, RoaringBitmap b) {
                return a.getSizeInBytes() - b.getSizeInBytes();
            }
        });
        Collections.addAll(pq, bitmaps);
        while (pq.size() > 1) {
            RoaringBitmap x1 = pq.poll();
            RoaringBitmap x2 = pq.poll();
            pq.add(RoaringBitmap.xor(x1, x2));
        }
        return pq.poll();
    }
}

