/*
 * Decompiled with CFR 0.152.
 */
package org.roaringbitmap;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Arrays;
import org.roaringbitmap.ArrayContainer;
import org.roaringbitmap.BitmapContainer;
import org.roaringbitmap.Container;
import org.roaringbitmap.Util;

public final class RoaringArray
implements Cloneable,
Externalizable {
    protected Element[] array = new Element[4];
    protected int size = 0;
    static final int initialCapacity = 4;
    private static final long serialVersionUID = 6L;

    protected RoaringArray() {
    }

    protected void append(short key, Container value) {
        this.extendArray(1);
        this.array[this.size++] = new Element(key, value);
    }

    protected void appendCopy(RoaringArray sa, int index) {
        this.extendArray(1);
        this.array[this.size++] = new Element(sa.array[index].key, sa.array[index].value.clone());
    }

    protected void appendCopy(RoaringArray sa, int startingindex, int end) {
        this.extendArray(end - startingindex);
        for (int i = startingindex; i < end; ++i) {
            this.array[this.size++] = new Element(sa.array[i].key, sa.array[i].value.clone());
        }
    }

    protected void appendCopiesUntil(RoaringArray sa, short stoppingKey) {
        int stopKey = Util.toIntUnsigned(stoppingKey);
        for (int i = 0; i < sa.size && Util.toIntUnsigned(sa.array[i].key) < stopKey; ++i) {
            this.extendArray(1);
            this.array[this.size++] = new Element(sa.array[i].key, sa.array[i].value.clone());
        }
    }

    protected void appendCopiesAfter(RoaringArray sa, short beforeStart) {
        int startLocation = sa.getIndex(beforeStart);
        startLocation = startLocation >= 0 ? ++startLocation : -startLocation - 1;
        this.extendArray(sa.size - startLocation);
        for (int i = startLocation; i < sa.size; ++i) {
            this.array[this.size++] = new Element(sa.array[i].key, sa.array[i].value.clone());
        }
    }

    protected void clear() {
        this.array = null;
        this.size = 0;
    }

    public RoaringArray clone() throws CloneNotSupportedException {
        RoaringArray sa = (RoaringArray)super.clone();
        sa.array = Arrays.copyOf(this.array, this.size);
        for (int k = 0; k < this.size; ++k) {
            sa.array[k] = sa.array[k].clone();
        }
        sa.size = this.size;
        return sa;
    }

    protected boolean ContainsKey(short x) {
        return this.binarySearch(0, this.size, x) >= 0;
    }

    public boolean equals(Object o) {
        if (o instanceof RoaringArray) {
            RoaringArray srb = (RoaringArray)o;
            if (srb.size != this.size) {
                return false;
            }
            for (int i = 0; i < srb.size; ++i) {
                if (this.array[i].key != srb.array[i].key) {
                    return false;
                }
                if (this.array[i].value.equals(srb.array[i].value)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    protected void extendArray(int k) {
        if (this.size + k >= this.array.length) {
            int newcapacity = this.array.length < 1024 ? 2 * (this.size + k) : 5 * (this.size + k) / 4;
            this.array = Arrays.copyOf(this.array, newcapacity);
        }
    }

    protected Container getContainer(short x) {
        int i = this.binarySearch(0, this.size, x);
        if (i < 0) {
            return null;
        }
        return this.array[i].value;
    }

    protected Container getContainerAtIndex(int i) {
        return this.array[i].value;
    }

    protected int getIndex(short x) {
        if (this.size == 0 || this.array[this.size - 1].key == x) {
            return this.size - 1;
        }
        return this.binarySearch(0, this.size, x);
    }

    protected short getKeyAtIndex(int i) {
        return this.array[i].key;
    }

    public int hashCode() {
        return this.array.hashCode();
    }

    protected void insertNewKeyValueAt(int i, short key, Container value) {
        this.extendArray(1);
        System.arraycopy(this.array, i, this.array, i + 1, this.size - i);
        this.array[i] = new Element(key, value);
        ++this.size;
    }

    protected void resize(int newlength) {
        for (int k = newlength; k < this.size; ++k) {
            this.array[k] = null;
        }
        this.size = newlength;
    }

    protected boolean remove(short key) {
        int i = this.binarySearch(0, this.size, key);
        if (i >= 0) {
            this.removeAtIndex(i);
            return true;
        }
        return false;
    }

    protected void removeAtIndex(int i) {
        System.arraycopy(this.array, i + 1, this.array, i, this.size - i - 1);
        this.array[this.size - 1] = null;
        --this.size;
    }

    protected void setContainerAtIndex(int i, Container c) {
        this.array[i].value = c;
    }

    protected int size() {
        return this.size;
    }

    private int binarySearch(int begin, int end, short key) {
        int low = begin;
        int high = end - 1;
        int ikey = Util.toIntUnsigned(key);
        while (low <= high) {
            int middleIndex = low + high >>> 1;
            int middleValue = Util.toIntUnsigned(this.array[middleIndex].key);
            if (middleValue < ikey) {
                low = middleIndex + 1;
                continue;
            }
            if (middleValue > ikey) {
                high = middleIndex - 1;
                continue;
            }
            return middleIndex;
        }
        return -(low + 1);
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.deserialize(in);
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        this.serialize(out);
    }

    public void serialize(DataOutput out) throws IOException {
        out.write(this.size >>> 0 & 0xFF);
        out.write(this.size >>> 8 & 0xFF);
        out.write(this.size >>> 16 & 0xFF);
        out.write(this.size >>> 24 & 0xFF);
        for (int k = 0; k < this.size; ++k) {
            out.write(this.array[k].key >>> 0 & 0xFF);
            out.write(this.array[k].key >>> 8 & 0xFF);
            out.writeBoolean(this.array[k].value instanceof BitmapContainer);
            this.array[k].value.serialize(out);
        }
    }

    public void deserialize(DataInput in) throws IOException {
        this.clear();
        byte[] buffer4 = new byte[4];
        in.readFully(buffer4);
        this.size = buffer4[0] | (buffer4[1] & 0xFF) << 8 | (buffer4[2] & 0xFF) << 16 | (buffer4[3] & 0xFF) << 24;
        if (this.array == null || this.array.length < this.size) {
            this.array = new Element[this.size];
        }
        byte[] buffer = new byte[2];
        for (int k = 0; k < this.size; ++k) {
            Container val;
            in.readFully(buffer);
            short key = (short)(buffer[0] & 0xFF | (buffer[1] & 0xFF) << 8);
            boolean isbitmap = in.readBoolean();
            if (isbitmap) {
                val = new BitmapContainer();
                val.deserialize(in);
            } else {
                val = new ArrayContainer(0);
                val.deserialize(in);
            }
            this.array[k] = new Element(key, val);
        }
    }

    public int serializedSizeInBytes() {
        int count = 4;
        for (int k = 0; k < this.size; ++k) {
            count += 3;
            count += this.array[k].value.serializedSizeInBytes();
        }
        return count;
    }

    protected final class Element
    implements Cloneable {
        public short key;
        public Container value = null;

        public Element(short key, Container value) {
            this.key = key;
            this.value = value;
        }

        public Element clone() {
            try {
                Element c = (Element)super.clone();
                c.key = this.key;
                c.value = this.value.clone();
                return c;
            }
            catch (CloneNotSupportedException e) {
                return null;
            }
        }
    }
}

