/*
 * Decompiled with CFR 0.152.
 */
package org.roaringbitmap.buffer;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.ObjectOutput;
import java.nio.ByteBuffer;
import java.util.Iterator;
import org.roaringbitmap.IntIterator;
import org.roaringbitmap.buffer.Container;
import org.roaringbitmap.buffer.RoaringArray;
import org.roaringbitmap.buffer.RoaringBitmap;
import org.roaringbitmap.buffer.Util;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ImmutableRoaringBitmap
implements Iterable<Integer> {
    protected RoaringArray highlowcontainer = null;

    public ImmutableRoaringBitmap(ByteBuffer b) {
        this.highlowcontainer = new RoaringArray(b);
    }

    protected ImmutableRoaringBitmap() {
    }

    public boolean contains(int x) {
        short hb = Util.highbits(x);
        Container C = this.highlowcontainer.getContainer(hb);
        if (C == null) {
            return false;
        }
        return C.contains(Util.lowbits(x));
    }

    public void deserialize(DataInput in) throws IOException {
        this.highlowcontainer.deserialize(in);
    }

    public boolean equals(Object o) {
        if (o instanceof ImmutableRoaringBitmap) {
            ImmutableRoaringBitmap srb = (ImmutableRoaringBitmap)o;
            return srb.highlowcontainer.equals(this.highlowcontainer);
        }
        return false;
    }

    public int getCardinality() {
        int size = 0;
        for (int i = 0; i < this.highlowcontainer.size(); ++i) {
            size += this.highlowcontainer.getContainerAtIndex(i).getCardinality();
        }
        return size;
    }

    public int getSizeInBytes() {
        int size = 2;
        for (int i = 0; i < this.highlowcontainer.size(); ++i) {
            Container c = this.highlowcontainer.getContainerAtIndex(i);
            size += 4 + c.getSizeInBytes();
        }
        return size;
    }

    public int hashCode() {
        return this.highlowcontainer.hashCode();
    }

    @Override
    public Iterator<Integer> iterator() {
        return new Iterator<Integer>(){
            int hs = 0;
            Iterator<Short> iter;
            short pos = 0;
            int x;

            @Override
            public boolean hasNext() {
                return this.pos < ImmutableRoaringBitmap.this.highlowcontainer.size();
            }

            public Iterator<Integer> init() {
                if (this.pos < ImmutableRoaringBitmap.this.highlowcontainer.size()) {
                    this.iter = ImmutableRoaringBitmap.this.highlowcontainer.getContainerAtIndex(this.pos).iterator();
                    this.hs = Util.toIntUnsigned(ImmutableRoaringBitmap.this.highlowcontainer.getKeyAtIndex(this.pos)) << 16;
                }
                return this;
            }

            @Override
            public Integer next() {
                this.x = Util.toIntUnsigned(this.iter.next()) | this.hs;
                if (!this.iter.hasNext()) {
                    this.pos = (short)(this.pos + 1);
                    this.init();
                }
                return this.x;
            }

            @Override
            public void remove() {
                throw new RuntimeException("Cannot modify.");
            }
        }.init();
    }

    public void serialize(DataOutput out) throws IOException {
        this.highlowcontainer.serialize(out);
    }

    public int[] toArray() {
        int[] array = new int[this.getCardinality()];
        int pos = 0;
        int pos2 = 0;
        while (pos < this.highlowcontainer.size()) {
            int hs = Util.toIntUnsigned(this.highlowcontainer.getKeyAtIndex(pos)) << 16;
            Container C = this.highlowcontainer.getContainerAtIndex(pos++);
            C.fillLeastSignificant16bits(array, pos2, hs);
            pos2 += C.getCardinality();
        }
        return array;
    }

    public String toString() {
        StringBuffer answer = new StringBuffer();
        IntIterator i = this.getIntIterator();
        answer.append("{");
        if (i.hasNext()) {
            answer.append(i.next());
        }
        while (i.hasNext()) {
            answer.append(",");
            answer.append(i.next());
        }
        answer.append("}");
        return answer.toString();
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        this.highlowcontainer.writeExternal(out);
    }

    private IntIterator getIntIterator() {
        return new IntIterator(){
            int hs = 0;
            Iterator<Short> iter;
            short pos = 0;
            int x;

            public boolean hasNext() {
                return this.pos < ImmutableRoaringBitmap.this.highlowcontainer.size();
            }

            public IntIterator init() {
                if (this.pos < ImmutableRoaringBitmap.this.highlowcontainer.size()) {
                    this.iter = ImmutableRoaringBitmap.this.highlowcontainer.getContainerAtIndex(this.pos).iterator();
                    this.hs = Util.toIntUnsigned(ImmutableRoaringBitmap.this.highlowcontainer.getKeyAtIndex(this.pos)) << 16;
                }
                return this;
            }

            public int next() {
                this.x = Util.toIntUnsigned(this.iter.next()) | this.hs;
                if (!this.iter.hasNext()) {
                    this.pos = (short)(this.pos + 1);
                    this.init();
                }
                return this.x;
            }

            public void remove() {
                throw new RuntimeException("Cannot modify");
            }
        }.init();
    }

    public static RoaringBitmap and(ImmutableRoaringBitmap x1, ImmutableRoaringBitmap x2) {
        RoaringBitmap answer = new RoaringBitmap();
        int pos1 = 0;
        int pos2 = 0;
        int length1 = x1.highlowcontainer.size();
        int length2 = x2.highlowcontainer.size();
        if (pos1 < length1 && pos2 < length2) {
            short s1 = x1.highlowcontainer.getKeyAtIndex(pos1);
            short s2 = x2.highlowcontainer.getKeyAtIndex(pos2);
            while (true) {
                if (s1 < s2) {
                    if (++pos1 == length1) break;
                    s1 = x1.highlowcontainer.getKeyAtIndex(pos1);
                    continue;
                }
                if (s1 > s2) {
                    if (++pos2 == length2) break;
                    s2 = x2.highlowcontainer.getKeyAtIndex(pos2);
                    continue;
                }
                Container C = x1.highlowcontainer.getContainerAtIndex(pos1).and(x2.highlowcontainer.getContainerAtIndex(pos2));
                if (C.getCardinality() > 0) {
                    answer.highlowcontainer.append(s1, C);
                }
                if (++pos1 == length1 || ++pos2 == length2) break;
                s1 = x1.highlowcontainer.getKeyAtIndex(pos1);
                s2 = x2.highlowcontainer.getKeyAtIndex(pos2);
            }
        }
        return answer;
    }

    public static RoaringBitmap andNot(ImmutableRoaringBitmap x1, ImmutableRoaringBitmap x2) {
        RoaringBitmap answer = new RoaringBitmap();
        int pos1 = 0;
        int pos2 = 0;
        int length1 = x1.highlowcontainer.size();
        int length2 = x2.highlowcontainer.size();
        if (pos1 < length1 && pos2 < length2) {
            short s1 = x1.highlowcontainer.getKeyAtIndex(pos1);
            short s2 = x2.highlowcontainer.getKeyAtIndex(pos2);
            while (true) {
                if (s1 < s2) {
                    answer.highlowcontainer.appendCopy(x1.highlowcontainer, pos1);
                    if (++pos1 == length1) break;
                    s1 = x1.highlowcontainer.getKeyAtIndex(pos1);
                    continue;
                }
                if (s1 > s2) {
                    if (++pos2 == length2) break;
                    s2 = x2.highlowcontainer.getKeyAtIndex(pos2);
                    continue;
                }
                Container C = x1.highlowcontainer.getContainerAtIndex(pos1).andNot(x2.highlowcontainer.getContainerAtIndex(pos2));
                if (C.getCardinality() > 0) {
                    answer.highlowcontainer.append(s1, C);
                }
                if (++pos1 == length1 || ++pos2 == length2) break;
                s1 = x1.highlowcontainer.getKeyAtIndex(pos1);
                s2 = x2.highlowcontainer.getKeyAtIndex(pos2);
            }
        }
        if (pos2 == length2) {
            answer.highlowcontainer.appendCopy(x1.highlowcontainer, pos1, length1);
        }
        return answer;
    }

    public static RoaringBitmap flip(ImmutableRoaringBitmap bm, int rangeStart, int rangeEnd) {
        RoaringBitmap answer = null;
        if (rangeStart >= rangeEnd) {
            throw new RuntimeException("Invalid range " + rangeStart + " -- " + rangeEnd);
        }
        answer = new RoaringBitmap();
        short hbStart = Util.highbits(rangeStart);
        short lbStart = Util.lowbits(rangeStart);
        short hbLast = Util.highbits(rangeEnd - 1);
        short lbLast = Util.lowbits(rangeEnd - 1);
        answer.highlowcontainer.appendCopiesUntil(bm.highlowcontainer, hbStart);
        int max = Util.toIntUnsigned(Util.maxLowBit());
        for (short hb = hbStart; hb <= hbLast; hb = (short)(hb + 1)) {
            int containerStart = hb == hbStart ? Util.toIntUnsigned(lbStart) : 0;
            int containerLast = hb == hbLast ? Util.toIntUnsigned(lbLast) : max;
            int i = bm.highlowcontainer.getIndex(hb);
            int j = answer.highlowcontainer.getIndex(hb);
            assert (j < 0);
            if (i >= 0) {
                Container c = bm.highlowcontainer.getContainerAtIndex(i).not(containerStart, containerLast);
                if (c.getCardinality() <= 0) continue;
                answer.highlowcontainer.insertNewKeyValueAt(-j - 1, hb, c);
                continue;
            }
            answer.highlowcontainer.insertNewKeyValueAt(-j - 1, hb, Container.rangeOfOnes(containerStart, containerLast));
        }
        answer.highlowcontainer.appendCopiesAfter(bm.highlowcontainer, hbLast);
        return answer;
    }

    public static RoaringBitmap or(ImmutableRoaringBitmap x1, ImmutableRoaringBitmap x2) {
        RoaringBitmap answer = new RoaringBitmap();
        int pos1 = 0;
        int pos2 = 0;
        int length1 = x1.highlowcontainer.size();
        int length2 = x2.highlowcontainer.size();
        if (pos1 < length1 && pos2 < length2) {
            short s1 = x1.highlowcontainer.getKeyAtIndex(pos1);
            short s2 = x2.highlowcontainer.getKeyAtIndex(pos2);
            while (true) {
                if (s1 < s2) {
                    answer.highlowcontainer.appendCopy(x1.highlowcontainer, pos1);
                    if (++pos1 == length1) break;
                    s1 = x1.highlowcontainer.getKeyAtIndex(pos1);
                    continue;
                }
                if (s1 > s2) {
                    answer.highlowcontainer.appendCopy(x2.highlowcontainer, pos2);
                    if (++pos2 == length2) break;
                    s2 = x2.highlowcontainer.getKeyAtIndex(pos2);
                    continue;
                }
                answer.highlowcontainer.append(s1, x1.highlowcontainer.getContainerAtIndex(pos1).or(x2.highlowcontainer.getContainerAtIndex(pos2)));
                if (++pos1 == length1 || ++pos2 == length2) break;
                s1 = x1.highlowcontainer.getKeyAtIndex(pos1);
                s2 = x2.highlowcontainer.getKeyAtIndex(pos2);
            }
        }
        if (pos1 == length1) {
            answer.highlowcontainer.appendCopy(x2.highlowcontainer, pos2, length2);
        } else if (pos2 == length2) {
            answer.highlowcontainer.appendCopy(x1.highlowcontainer, pos1, length1);
        }
        return answer;
    }

    public static RoaringBitmap xor(ImmutableRoaringBitmap x1, ImmutableRoaringBitmap x2) {
        RoaringBitmap answer = new RoaringBitmap();
        int pos1 = 0;
        int pos2 = 0;
        int length1 = x1.highlowcontainer.size();
        int length2 = x2.highlowcontainer.size();
        if (pos1 < length1 && pos2 < length2) {
            short s1 = x1.highlowcontainer.getKeyAtIndex(pos1);
            short s2 = x2.highlowcontainer.getKeyAtIndex(pos2);
            while (true) {
                if (s1 < s2) {
                    answer.highlowcontainer.appendCopy(x1.highlowcontainer, pos1);
                    if (++pos1 == length1) break;
                    s1 = x1.highlowcontainer.getKeyAtIndex(pos1);
                    continue;
                }
                if (s1 > s2) {
                    answer.highlowcontainer.appendCopy(x2.highlowcontainer, pos2);
                    if (++pos2 == length2) break;
                    s2 = x2.highlowcontainer.getKeyAtIndex(pos2);
                    continue;
                }
                Container C = x1.highlowcontainer.getContainerAtIndex(pos1).xor(x2.highlowcontainer.getContainerAtIndex(pos2));
                if (C.getCardinality() > 0) {
                    answer.highlowcontainer.append(s1, C);
                }
                if (++pos1 == length1 || ++pos2 == length2) break;
                s1 = x1.highlowcontainer.getKeyAtIndex(pos1);
                s2 = x2.highlowcontainer.getKeyAtIndex(pos2);
            }
        }
        if (pos1 == length1) {
            answer.highlowcontainer.appendCopy(x2.highlowcontainer, pos2, length2);
        } else if (pos2 == length2) {
            answer.highlowcontainer.appendCopy(x1.highlowcontainer, pos1, length1);
        }
        return answer;
    }
}

