/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.renderkit.html;

import java.io.IOException;
import java.util.LinkedHashMap;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.richfaces.renderkit.DragIndicatorRendererBase;
import org.richfaces.renderkit.RenderKitUtils;

public class DragIndicatorRenderer
extends DragIndicatorRendererBase {
    private static String convertToString(Object object) {
        return object != null ? object.toString() : "";
    }

    @Override
    public void doEncodeBegin(ResponseWriter responseWriter, FacesContext facesContext, UIComponent component) throws IOException {
        String clientId = component.getClientId(facesContext);
        responseWriter.startElement("div", component);
        String value = "rf-ind " + DragIndicatorRenderer.convertToString(component.getAttributes().get("styleClass"));
        if (null != value && value.length() > 0) {
            responseWriter.writeAttribute("class", (Object)value, null);
        }
        if (null != (value = clientId) && value.length() > 0) {
            responseWriter.writeAttribute("id", (Object)value, null);
        }
        responseWriter.writeAttribute("style", (Object)"display: none;", null);
    }

    @Override
    public void doEncodeEnd(ResponseWriter responseWriter, FacesContext facesContext, UIComponent component) throws IOException {
        String clientId = component.getClientId(facesContext);
        LinkedHashMap<String, Object> options = new LinkedHashMap<String, Object>();
        RenderKitUtils.addToScriptHash(options, "acceptClass", this.concatClasses("rf-ind-acpt", component.getAttributes().get("acceptClass")), null, null);
        RenderKitUtils.addToScriptHash(options, "rejectClass", this.concatClasses("rf-ind-rejt", component.getAttributes().get("rejectClass")), null, null);
        RenderKitUtils.addToScriptHash(options, "draggingClass", this.concatClasses("rf-ind-drag", component.getAttributes().get("draggingClass")), null, null);
        responseWriter.startElement("script", component);
        responseWriter.writeAttribute("type", (Object)"text/javascript", null);
        String text = "new RichFaces.ui.DragIndicator(\"" + DragIndicatorRenderer.convertToString(clientId) + "\", " + DragIndicatorRenderer.convertToString(RenderKitUtils.toScriptArgs(options)) + ");";
        if (text != null) {
            responseWriter.writeText((Object)text, null);
        }
        responseWriter.endElement("script");
        responseWriter.endElement("div");
    }
}

