/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.renderkit;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.faces.FacesException;
import javax.faces.application.ResourceDependencies;
import javax.faces.application.ResourceDependency;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.PartialResponseWriter;
import javax.faces.context.PartialViewContext;
import javax.faces.context.ResponseWriter;
import org.ajax4jsf.javascript.JSFunction;
import org.ajax4jsf.javascript.JSReference;
import org.ajax4jsf.javascript.ScriptUtils;
import org.ajax4jsf.model.DataVisitResult;
import org.ajax4jsf.model.DataVisitor;
import org.ajax4jsf.model.Range;
import org.ajax4jsf.model.SequenceRange;
import org.richfaces.component.AbstractColumn;
import org.richfaces.component.AbstractExtendedDataTable;
import org.richfaces.component.ExtendedDataTableState;
import org.richfaces.component.SortOrder;
import org.richfaces.component.UIDataTableBase;
import org.richfaces.component.util.HtmlUtil;
import org.richfaces.context.OnOffResponseWriter;
import org.richfaces.model.SelectionMode;
import org.richfaces.renderkit.AjaxFunction;
import org.richfaces.renderkit.ComponentAttribute;
import org.richfaces.renderkit.MetaComponentRenderer;
import org.richfaces.renderkit.RenderKitUtils;
import org.richfaces.renderkit.RowHolderBase;
import org.richfaces.renderkit.SelectionRenderer;
import org.richfaces.renderkit.util.AjaxRendererUtils;

@ResourceDependencies(value={@ResourceDependency(library="javax.faces", name="jsf.js"), @ResourceDependency(name="jquery.js"), @ResourceDependency(name="richfaces.js"), @ResourceDependency(library="org.richfaces", name="richfaces-queue.reslib"), @ResourceDependency(name="richfaces-base-component.js"), @ResourceDependency(name="jquery.position.js"), @ResourceDependency(name="richfaces-event.js"), @ResourceDependency(library="org.richfaces", name="extendedDataTable.js"), @ResourceDependency(library="org.richfaces", name="extendedDataTable.ecss")})
public class ExtendedDataTableRenderer
extends SelectionRenderer
implements MetaComponentRenderer {
    private static final JSReference CLIENT_PARAMS = new JSReference("clientParams");
    private static final Map<String, ComponentAttribute> EVENT_ATTRIBUTES = Collections.unmodifiableMap(ComponentAttribute.createMap(new ComponentAttribute("onselectionchange").setEventNames("selectionchange"), new ComponentAttribute("onbeforeselectionchange").setEventNames("beforeselectionchange"), new ComponentAttribute("onready").setEventNames("ready")));

    private void encodeEmptyFooterCell(FacesContext context, ResponseWriter writer, UIComponent column, boolean isLastColumn) throws IOException {
        if (column.isRendered()) {
            writer.startElement("td", column);
            if (!isLastColumn) {
                writer.writeAttribute("class", (Object)("rf-edt-td-" + column.getId()), null);
            }
            writer.startElement("div", column);
            writer.writeAttribute("class", (Object)("rf-edt-ftr-c-emp rf-edt-c-" + column.getId()), null);
            writer.endElement("div");
            writer.endElement("td");
        }
    }

    private void encodeHeaderOrFooterCell(FacesContext context, ResponseWriter writer, UIComponent column, String facetName, boolean isLastColumn) throws IOException {
        if (column.isRendered()) {
            String classAttribute = facetName + "Class";
            boolean useBuiltInSort = "header".equals(facetName) && column instanceof AbstractColumn && ((AbstractColumn)column).useBuiltInSort();
            writer.startElement("td", column);
            if (!isLastColumn) {
                writer.writeAttribute("class", (Object)("rf-edt-td-" + column.getId()), null);
            }
            if ("header".equals(facetName)) {
                writer.startElement("div", column);
                writer.writeAttribute("class", (Object)("rf-edt-rsz-cntr rf-edt-c-" + column.getId()), null);
                writer.startElement("div", column);
                writer.writeAttribute("class", (Object)"rf-edt-rsz", null);
                writer.endElement("div");
                writer.endElement("div");
            }
            writer.startElement("div", column);
            writer.writeAttribute("class", (Object)HtmlUtil.concatClasses("rf-edt-" + this.getFacetClassName(facetName) + "-c", "rf-edt-c-" + column.getId()), null);
            writer.startElement("div", column);
            String columnHeaderClass = "rf-edt-" + this.getFacetClassName(facetName) + "-c-cnt";
            if (useBuiltInSort) {
                columnHeaderClass = HtmlUtil.concatClasses(columnHeaderClass, "rf-edt-c-srt");
            }
            columnHeaderClass = HtmlUtil.concatClasses(columnHeaderClass, column.getAttributes().get(classAttribute));
            writer.writeAttribute("class", (Object)columnHeaderClass, null);
            UIComponent facet = column.getFacet(facetName);
            if (facet != null && facet.isRendered()) {
                facet.encodeAll(context);
            }
            if ("header".equals(facetName) && column instanceof AbstractColumn && ((AbstractColumn)column).useBuiltInSort()) {
                writer.startElement("span", column);
                String classAttr = "rf-edt-srt rf-edt-srt-btn ";
                SortOrder sortOrder = (SortOrder)column.getAttributes().get("sortOrder");
                if (sortOrder == null || sortOrder == SortOrder.unsorted) {
                    classAttr = classAttr + "rf-edt-srt-uns";
                } else if (sortOrder == SortOrder.ascending) {
                    classAttr = classAttr + "rf-edt-srt-asc";
                } else if (sortOrder == SortOrder.descending) {
                    classAttr = classAttr + "rf-edt-srt-des";
                }
                writer.writeAttribute("class", (Object)classAttr, null);
                writer.writeAttribute("data-columnid", (Object)column.getId(), null);
                writer.endElement("span");
            }
            writer.endElement("div");
            writer.endElement("div");
            writer.endElement("td");
        }
    }

    private String getFacetClassName(String name) {
        if ("header".equals(name)) {
            return "hdr";
        }
        if ("footer".equals(name)) {
            return "ftr";
        }
        throw new IllegalArgumentException(name);
    }

    private void encodeHeaderOrFooter(RendererState state, String facetName) throws IOException {
        FacesContext context = state.getContext();
        ResponseWriter writer = context.getResponseWriter();
        UIDataTableBase table = state.getRow();
        boolean columnFacetPresent = table.isColumnFacetPresent(facetName);
        if (columnFacetPresent || "footer".equals(facetName)) {
            writer.startElement("div", (UIComponent)table);
            writer.writeAttribute("class", (Object)("rf-edt-" + this.getFacetClassName(facetName)), null);
            writer.startElement("table", (UIComponent)table);
            writer.writeAttribute("class", (Object)"rf-edt-tbl", null);
            writer.startElement("tbody", (UIComponent)table);
            writer.startElement("tr", (UIComponent)table);
            String clientId = table.getClientId(context);
            state.startIterate();
            while (state.hasNextPart()) {
                Part part = state.nextPart();
                PartName partName = part.getName();
                Iterator<UIComponent> columns = part.getColumns().iterator();
                if (!columns.hasNext()) continue;
                writer.startElement("td", (UIComponent)table);
                if (PartName.frozen.equals((Object)partName) && "footer".equals(facetName)) {
                    writer.writeAttribute("class", (Object)"rf-edt-ftr-fzn", null);
                }
                writer.startElement("div", (UIComponent)table);
                if (PartName.frozen.equals((Object)partName)) {
                    if ("header".equals(facetName)) {
                        writer.writeAttribute("id", (Object)(clientId + ":frozenHeader"), null);
                    }
                } else {
                    writer.writeAttribute("id", (Object)(clientId + ":" + facetName), null);
                    writer.writeAttribute("class", (Object)("rf-edt-cnt" + ("footer".equals(facetName) ? " rf-edt-ftr-cnt" : "")), null);
                }
                String tableId = clientId + ":cf" + facetName.charAt(0) + partName.getId();
                EncoderVariance encoderVariance = state.getEncoderVariance();
                encoderVariance.encodeStartUpdate(context, tableId);
                writer.startElement("table", (UIComponent)table);
                writer.writeAttribute("id", (Object)tableId, null);
                writer.writeAttribute("class", (Object)"rf-edt-tbl", null);
                writer.startElement("tbody", (UIComponent)table);
                writer.startElement("tr", (UIComponent)table);
                int columnNumber = 0;
                boolean filterRowRequired = false;
                int lastColumnNumber = part.getColumns().size() - 1;
                while (columns.hasNext()) {
                    UIComponent column = columns.next();
                    if (!filterRowRequired && "header".equals(facetName) && column instanceof AbstractColumn && ((AbstractColumn)column).useBuiltInFilter()) {
                        filterRowRequired = true;
                    }
                    if (columnFacetPresent) {
                        this.encodeHeaderOrFooterCell(context, writer, column, facetName, columnNumber == lastColumnNumber);
                    } else {
                        this.encodeEmptyFooterCell(context, writer, column, columnNumber == lastColumnNumber);
                    }
                    ++columnNumber;
                }
                writer.endElement("tr");
                if (filterRowRequired) {
                    writer.startElement("tr", (UIComponent)table);
                    for (UIComponent column : part.getColumns()) {
                        if (!column.isRendered()) continue;
                        writer.startElement("td", column);
                        writer.startElement("div", column);
                        writer.writeAttribute("class", (Object)("rf-edt-flt-c rf-edt-c-" + column.getId()), null);
                        writer.startElement("div", column);
                        writer.writeAttribute("class", (Object)"rf-edt-flt-cnt", null);
                        if (column.getAttributes().get("filterField") != null && !"custom".equals(column.getAttributes().get("filterType"))) {
                            writer.startElement("input", column);
                            writer.writeAttribute("id", (Object)(clientId + ":" + column.getId() + ":flt"), null);
                            writer.writeAttribute("name", (Object)(clientId + ":" + column.getId() + ":flt"), null);
                            String inputClass = "rf-edt-flt-i";
                            List messages = context.getMessageList(column.getClientId());
                            if (!messages.isEmpty()) {
                                inputClass = inputClass + " rf-edt-flt-i-err";
                                writer.writeAttribute("value", column.getAttributes().get("submittedFilterValue"), null);
                            } else {
                                writer.writeAttribute("value", column.getAttributes().get("filterValue"), null);
                            }
                            writer.writeAttribute("class", (Object)inputClass, null);
                            writer.writeAttribute("data-columnid", (Object)column.getId(), null);
                            writer.endElement("input");
                        }
                        writer.endElement("div");
                        writer.endElement("div");
                        writer.endElement("td");
                    }
                    writer.endElement("tr");
                }
                writer.endElement("tbody");
                writer.endElement("table");
                encoderVariance.encodeEndUpdate(context);
                writer.endElement("div");
                writer.endElement("td");
            }
            writer.endElement("tr");
            if ("footer".equals(facetName)) {
                int frozenColumns = 0;
                int scrollingColumns = 0;
                state.startIterate();
                while (state.hasNextPart()) {
                    Part part = state.nextPart();
                    PartName partName = part.getName();
                    Iterator<UIComponent> columns = part.getColumns().iterator();
                    if (!columns.hasNext()) continue;
                    if (PartName.frozen.equals((Object)partName)) {
                        ++frozenColumns;
                        continue;
                    }
                    ++scrollingColumns;
                }
                writer.startElement("tr", (UIComponent)table);
                if (frozenColumns > 0) {
                    writer.startElement("td", (UIComponent)table);
                    writer.writeAttribute("colspan", (Object)frozenColumns, null);
                    writer.endElement("td");
                }
                if (scrollingColumns > 0) {
                    writer.startElement("td", (UIComponent)table);
                    writer.writeAttribute("colspan", (Object)scrollingColumns, null);
                    writer.startElement("div", (UIComponent)table);
                    writer.writeAttribute("id", (Object)(clientId + ":scrl"), null);
                    writer.writeAttribute("class", (Object)"rf-edt-scrl", null);
                    writer.startElement("div", (UIComponent)table);
                    writer.writeAttribute("id", (Object)(clientId + ":scrl-cnt"), null);
                    writer.writeAttribute("class", (Object)"rf-edt-scrl-cnt", null);
                    writer.endElement("div");
                    writer.endElement("div");
                    writer.endElement("td");
                }
                writer.endElement("tr");
            }
            writer.endElement("tbody");
            writer.endElement("table");
            writer.endElement("div");
        }
    }

    public void encodeHeader(RendererState state) throws IOException {
        FacesContext context = state.getContext();
        ResponseWriter writer = context.getResponseWriter();
        UIDataTableBase table = state.getRow();
        UIComponent header = table.getFacet("header");
        if (header != null && header.isRendered()) {
            String elementId = table.getClientId(context) + ":tfh";
            EncoderVariance encoderVariance = state.getEncoderVariance();
            encoderVariance.encodeStartUpdate(context, elementId);
            writer.startElement("div", (UIComponent)table);
            writer.writeAttribute("id", (Object)elementId, null);
            writer.writeAttribute("class", (Object)HtmlUtil.concatClasses("rf-edt-tbl-hdr", table.getHeaderClass()), null);
            header.encodeAll(context);
            writer.endElement("div");
            encoderVariance.encodeEndUpdate(context);
        }
        this.encodeHeaderOrFooter(state, "header");
    }

    public void encodeBody(RendererState state) throws IOException {
        FacesContext context = state.getContext();
        ResponseWriter writer = context.getResponseWriter();
        UIDataTableBase table = state.getRow();
        String clientId = table.getClientId(context);
        String tableBodyId = clientId + ":b";
        EncoderVariance encoderVariance = state.getEncoderVariance();
        encoderVariance.encodeStartUpdate(context, tableBodyId);
        writer.startElement("div", (UIComponent)table);
        writer.writeAttribute("id", (Object)tableBodyId, null);
        writer.writeAttribute("class", (Object)"rf-edt-b", null);
        if (table.getRowCount() == 0) {
            UIComponent facet = table.getFacet("noData");
            writer.startElement("div", (UIComponent)table);
            writer.writeAttribute("class", (Object)"rf-edt-ndt", null);
            if (facet != null && facet.isRendered()) {
                facet.encodeAll(context);
            } else {
                Object noDataLabel = table.getAttributes().get("noDataLabel");
                if (noDataLabel != null) {
                    writer.writeText(noDataLabel, "noDataLabel");
                }
            }
            writer.endElement("div");
        } else {
            table.getAttributes().put("clientFirst", 0);
            writer.startElement("div", (UIComponent)table);
            writer.startElement("div", (UIComponent)table);
            writer.writeAttribute("class", (Object)"rf-edt-spcr", null);
            writer.endElement("div");
            writer.startElement("table", (UIComponent)table);
            writer.writeAttribute("class", (Object)"rf-edt-tbl", null);
            writer.startElement("tbody", (UIComponent)table);
            writer.startElement("tr", (UIComponent)table);
            state.startIterate();
            while (state.hasNextPart()) {
                writer.startElement("td", (UIComponent)table);
                writer.startElement("div", (UIComponent)table);
                PartName partName = state.nextPart().getName();
                if (PartName.normal.equals((Object)partName)) {
                    writer.writeAttribute("id", (Object)(clientId + ":body"), null);
                    writer.writeAttribute("class", (Object)"rf-edt-cnt", null);
                }
                String targetId = clientId + ":tbt" + partName.getId();
                writer.startElement("table", (UIComponent)table);
                writer.writeAttribute("id", (Object)targetId, null);
                writer.writeAttribute("class", (Object)"rf-edt-tbl", null);
                writer.startElement("tbody", (UIComponent)table);
                writer.writeAttribute("id", (Object)(clientId + ":tb" + partName.getId()), null);
                this.encodeRows(context, state);
                writer.endElement("tbody");
                writer.endElement("table");
                writer.endElement("div");
                writer.endElement("td");
            }
            writer.endElement("tr");
            writer.endElement("tbody");
            writer.endElement("table");
            writer.endElement("div");
        }
        writer.endElement("div");
        encoderVariance.encodeEndUpdate(context);
    }

    public void encodeFooter(RendererState state) throws IOException {
        FacesContext context = state.getContext();
        ResponseWriter writer = context.getResponseWriter();
        UIDataTableBase table = state.getRow();
        this.encodeHeaderOrFooter(state, "footer");
        UIComponent footer = table.getFacet("footer");
        if (footer != null && footer.isRendered()) {
            String elementId = table.getClientId(context) + ":tff";
            EncoderVariance encoderVariance = state.getEncoderVariance();
            encoderVariance.encodeStartUpdate(context, elementId);
            writer.startElement("div", (UIComponent)table);
            writer.writeAttribute("id", (Object)elementId, null);
            writer.writeAttribute("class", (Object)HtmlUtil.concatClasses("rf-edt-tbl-ftr", table.getFooterClass()), null);
            footer.encodeAll(context);
            writer.endElement("div");
            encoderVariance.encodeEndUpdate(context);
        }
    }

    @Override
    protected Class<? extends UIComponent> getComponentClass() {
        return AbstractExtendedDataTable.class;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void encodeMetaComponent(FacesContext context, UIComponent component, String metaComponentId) throws IOException {
        block18: {
            AbstractExtendedDataTable table = (AbstractExtendedDataTable)component;
            if ("scroll".equals(metaComponentId)) {
                final PartialResponseWriter writer = context.getPartialViewContext().getPartialResponseWriter();
                int clientFirst = table.getClientFirst();
                Integer oldClientFirst = (Integer)table.getAttributes().remove("oldClientFirst");
                if (oldClientFirst == null) {
                    oldClientFirst = clientFirst;
                }
                int clientRows = ((SequenceRange)table.getComponentState().getRange()).getRows();
                int difference = clientFirst - oldClientFirst;
                SequenceRange addRange = null;
                SequenceRange removeRange = null;
                if (Math.abs(difference) >= clientRows) {
                    difference = 0;
                    addRange = new SequenceRange(clientFirst, clientRows);
                    removeRange = new SequenceRange(oldClientFirst.intValue(), clientRows);
                } else if (difference < 0) {
                    addRange = new SequenceRange(clientFirst += table.getFirst(), -difference);
                    removeRange = new SequenceRange(clientFirst + clientRows, -difference);
                } else if (difference > 0) {
                    oldClientFirst = oldClientFirst + table.getFirst();
                    removeRange = new SequenceRange(oldClientFirst.intValue(), difference);
                    int last = oldClientFirst + clientRows;
                    addRange = new SequenceRange(last, difference);
                }
                if (addRange != null) {
                    Object key = table.getRowKey();
                    table.captureOrigValue(context);
                    table.setRowKey(context, null);
                    final RendererState state = this.createRowHolder(context, (UIComponent)table, null);
                    state.setCurrentRow(addRange.getFirstRow());
                    String clientId = table.getClientId(context);
                    state.startIterate();
                    while (state.hasNextPart()) {
                        String partId = state.nextPart().getName().getId();
                        final LinkedList ids = new LinkedList();
                        table.walk(context, new DataVisitor(){

                            public DataVisitResult process(FacesContext context, Object rowKey, Object argument) {
                                UIDataTableBase dataTable = state.getRow();
                                dataTable.setRowKey(context, rowKey);
                                ids.add(dataTable.getContainerClientId(context) + ":" + state.getPart().getName().getId());
                                return DataVisitResult.CONTINUE;
                            }
                        }, (Range)removeRange, null);
                        table.walk(context, new DataVisitor(){

                            public DataVisitResult process(FacesContext context, Object rowKey, Object argument) {
                                UIDataTableBase dataTable = state.getRow();
                                dataTable.setRowKey(context, rowKey);
                                HashMap<String, String> attributes = new HashMap<String, String>(1);
                                String id = dataTable.getContainerClientId(context) + ":" + state.getPart().getName().getId();
                                attributes.put("id", id);
                                try {
                                    writer.updateAttributes((String)ids.remove(0), attributes);
                                    writer.startUpdate(id);
                                    ExtendedDataTableRenderer.this.encodeRow((ResponseWriter)writer, context, state);
                                    writer.endUpdate();
                                }
                                catch (IOException e) {
                                    throw new FacesException((Throwable)e);
                                }
                                RowHolderBase holder = (RowHolderBase)argument;
                                holder.nextRow();
                                return DataVisitResult.CONTINUE;
                            }
                        }, (Range)addRange, state);
                        writer.startEval();
                        if (difference < 0) {
                            difference += clientRows;
                        }
                        writer.write("var richTBody = document.getElementById('" + clientId + ":tb" + partId + "');");
                        writer.write("var richRows = richTBody.rows;");
                        writer.write("for (var i = 0; i < " + difference + "; i++ ) richTBody.appendChild(richTBody.removeChild(richRows[0]));");
                        writer.endEval();
                    }
                    writer.startUpdate(clientId + ":si");
                    this.encodeSelectionInput((ResponseWriter)writer, context, component);
                    writer.endUpdate();
                    writer.startEval();
                    writer.write("jQuery(" + ScriptUtils.toScript((Object)('#' + ScriptUtils.escapeCSSMetachars((String)clientId))) + ").triggerHandler('rich:onajaxcomplete', {first: " + table.getClientFirst() + "});");
                    writer.endEval();
                    table.setRowKey(context, key);
                    table.restoreOrigValue(context);
                }
            } else {
                ResponseWriter initialWriter = context.getResponseWriter();
                assert (!(initialWriter instanceof OnOffResponseWriter));
                try {
                    context.setResponseWriter((ResponseWriter)new OnOffResponseWriter(initialWriter));
                    RendererState state = this.createRowHolder(context, component, null);
                    state.setEncoderVariance(EncoderVariance.partial);
                    PartialResponseWriter writer = context.getPartialViewContext().getPartialResponseWriter();
                    if ("header".equals(metaComponentId)) {
                        this.encodeHeader(state);
                        writer.startEval();
                        writer.write("jQuery(" + ScriptUtils.toScript((Object)('#' + ScriptUtils.escapeCSSMetachars((String)table.getClientId(context)))) + ").triggerHandler('rich:onajaxcomplete', {reinitializeHeader: true});");
                        writer.endEval();
                        break block18;
                    }
                    if ("footer".equals(metaComponentId)) {
                        this.encodeFooter(state);
                        break block18;
                    }
                    if ("body".equals(metaComponentId)) {
                        this.encodeBody(state);
                        String clientId = table.getClientId(context);
                        writer.startUpdate(clientId + ":si");
                        this.encodeSelectionInput((ResponseWriter)writer, context, component);
                        writer.endUpdate();
                        writer.startEval();
                        writer.write("jQuery(" + ScriptUtils.toScript((Object)('#' + ScriptUtils.escapeCSSMetachars((String)clientId))) + ").triggerHandler('rich:onajaxcomplete', {first: " + table.getClientFirst() + ", rowCount: " + this.getRowCount(component) + ", reinitializeBody: true});");
                        writer.endEval();
                        break block18;
                    }
                    throw new IllegalArgumentException("Unsupported metaComponentIdentifier: " + metaComponentId);
                }
                finally {
                    context.setResponseWriter(initialWriter);
                }
            }
        }
    }

    public void decodeMetaComponent(FacesContext context, UIComponent component, String metaComponentId) {
        throw new UnsupportedOperationException();
    }

    @Override
    protected void doEncodeBegin(ResponseWriter writer, FacesContext context, UIComponent component) throws IOException {
        String savedTableState = (String)component.getAttributes().get("tableState");
        if (savedTableState != null && !savedTableState.isEmpty()) {
            ExtendedDataTableState tableState = new ExtendedDataTableState(savedTableState);
            this.consumeTableState(context, (UIDataTableBase)component, tableState);
        }
        Map attributes = component.getAttributes();
        writer.startElement("div", component);
        writer.writeAttribute("id", (Object)component.getClientId(context), null);
        writer.writeAttribute("class", (Object)HtmlUtil.concatClasses("rf-edt", (String)attributes.get("styleClass")), null);
        RenderKitUtils.renderAttribute(context, "style", attributes.get("style"));
    }

    @Override
    public RendererState createRowHolder(FacesContext context, UIComponent component, Object[] options) {
        return new RendererState(context, (UIDataTableBase)component);
    }

    @Override
    protected void doEncodeChildren(ResponseWriter writer, FacesContext context, UIComponent component) throws IOException {
        UIDataTableBase table = (UIDataTableBase)component;
        Object key = table.getRowKey();
        table.captureOrigValue(context);
        table.setRowKey(context, null);
        RendererState state = this.createRowHolder(context, (UIComponent)table, null);
        this.encodeStyle(state);
        this.encodeHeader(state);
        this.encodeBody(state);
        this.encodeFooter(state);
        table.setRowKey(context, key);
        table.restoreOrigValue(context);
    }

    @Override
    protected void doEncodeEnd(ResponseWriter writer, FacesContext context, UIComponent component) throws IOException {
        writer.startElement("table", component);
        String clientId = component.getClientId(context);
        writer.writeAttribute("id", (Object)(clientId + ":r"), null);
        writer.writeAttribute("class", (Object)"rf-edt-rord rf-edt-tbl", null);
        writer.startElement("tr", component);
        writer.startElement("th", component);
        writer.write("&#160;");
        writer.endElement("th");
        writer.endElement("tr");
        for (int i = 0; i < 6; ++i) {
            writer.startElement("tr", component);
            writer.startElement("td", component);
            writer.write("&#160;");
            writer.endElement("td");
            writer.endElement("tr");
        }
        writer.endElement("table");
        writer.startElement("div", component);
        writer.writeAttribute("id", (Object)(clientId + ":d"), null);
        writer.writeAttribute("class", (Object)"rf-edt-rsz-mkr", null);
        writer.endElement("div");
        writer.startElement("div", component);
        writer.writeAttribute("id", (Object)(clientId + ":rm"), null);
        writer.writeAttribute("class", (Object)"rf-edt-rord-mkr", null);
        writer.endElement("div");
        writer.startElement("input", component);
        writer.writeAttribute("id", (Object)(clientId + ":wi"), null);
        writer.writeAttribute("name", (Object)(clientId + ":wi"), null);
        writer.writeAttribute("type", (Object)"hidden", null);
        writer.endElement("input");
        this.encodeSelectionInput(writer, context, component);
        AjaxFunction ajaxFunction = AjaxRendererUtils.buildAjaxFunction(context, component);
        ajaxFunction.getOptions().setClientParameters(CLIENT_PARAMS);
        Map attributes = component.getAttributes();
        HashMap<String, Object> options = new HashMap<String, Object>();
        RenderKitUtils.addToScriptHash(options, "selectionMode", attributes.get("selectionMode"), SelectionMode.multiple);
        RenderKitUtils.addToScriptHash(options, "onbeforeselectionchange", RenderKitUtils.getAttributeAndBehaviorsValue(context, component, EVENT_ATTRIBUTES.get("onbeforeselectionchange")), null, RenderKitUtils.ScriptHashVariableWrapper.eventHandler);
        RenderKitUtils.addToScriptHash(options, "onselectionchange", RenderKitUtils.getAttributeAndBehaviorsValue(context, component, EVENT_ATTRIBUTES.get("onselectionchange")), null, RenderKitUtils.ScriptHashVariableWrapper.eventHandler);
        RenderKitUtils.addToScriptHash(options, "onready", RenderKitUtils.getAttributeAndBehaviorsValue(context, component, EVENT_ATTRIBUTES.get("onready")), null, RenderKitUtils.ScriptHashVariableWrapper.eventHandler);
        StringBuilder builder = new StringBuilder("new RichFaces.ui.ExtendedDataTable('");
        builder.append(clientId).append("', ").append(this.getRowCount(component)).append(", function(event, clientParams) {").append(ajaxFunction.toScript()).append(";}");
        if (!options.isEmpty()) {
            builder.append(",").append(ScriptUtils.toScript(options));
        }
        builder.append(");");
        this.getUtils().writeScript(context, component, builder.toString());
        writer.endElement("div");
    }

    private int getRowCount(UIComponent component) {
        UIDataTableBase table = (UIDataTableBase)component;
        int rows = table.getRows();
        int rowCount = table.getRowCount() - table.getFirst();
        rows = rows > 0 ? Math.min(rows, rowCount) : rowCount;
        return rows;
    }

    private void encodeStyle(RendererState state) throws IOException {
        FacesContext context = state.getContext();
        ResponseWriter writer = context.getResponseWriter();
        UIDataTableBase table = state.getRow();
        PartialViewContext pvc = context.getPartialViewContext();
        if (!pvc.isAjaxRequest()) {
            writer.startElement("style", (UIComponent)table);
            writer.writeAttribute("type", (Object)"text/css", null);
            writer.writeText((Object)this.getCSSText(context, table), null);
            writer.endElement("style");
        } else {
            writer.startElement("script", (UIComponent)table);
            writer.writeAttribute("type", (Object)"text/javascript", null);
            String cssText = this.getCSSText(context, table);
            JSFunction function = new JSFunction("RichFaces.utils.addCSSText", new Object[]{cssText, table.getClientId(context) + ":st"});
            writer.writeText((Object)function.toScript(), null);
            writer.endElement("script");
        }
    }

    protected String getCSSText(FacesContext context, UIDataTableBase table) throws IOException {
        StringBuilder sb = new StringBuilder();
        String tableLocator = "div.rf-edt[id=\"" + table.getClientId() + "\"]";
        sb.append("div.rf-edt-cnt { width: 100%; }");
        Iterator<UIComponent> columns = table.columns();
        while (columns.hasNext()) {
            UIComponent column = columns.next();
            String id = column.getId();
            if (id == null) {
                column.getClientId(context);
                id = column.getId();
            }
            String width = this.getColumnWidth(column);
            sb.append(tableLocator);
            sb.append(" .rf-edt-c-" + id + " {");
            sb.append("width: " + width + ";");
            sb.append("}");
            sb.append(tableLocator);
            sb.append(" .rf-edt-td-" + id + " {");
            sb.append("width: " + width + ";");
            sb.append("}");
        }
        return sb.toString();
    }

    @Override
    public void encodeRow(ResponseWriter writer, FacesContext facesContext, RowHolderBase rowHolder) throws IOException {
        RendererState state = (RendererState)rowHolder;
        AbstractExtendedDataTable table = (AbstractExtendedDataTable)state.getRow();
        writer.startElement("tr", (UIComponent)table);
        if (rowHolder.getRow() instanceof UIDataTableBase) {
            this.renderRowHandlers(facesContext, (UIDataTableBase)rowHolder.getRow());
        }
        String rowClass = this.getRowClass(rowHolder);
        StringBuilder builder = new StringBuilder();
        Collection<Object> selection = table.getSelection();
        if (selection != null && selection.contains(table.getRowKey())) {
            builder.append("rf-edt-r-sel");
        }
        if (table.getRowKey().equals(table.getAttributes().get("activeRowKey"))) {
            if (builder.length() > 0) {
                builder.append(' ');
            }
            builder.append("rf-edt-r-act");
        }
        if (table.getRowKey().equals(table.getAttributes().get("shiftRowKey"))) {
            if (builder.length() > 0) {
                builder.append(' ');
            }
            builder.append("rf-edt-r-sht");
        }
        if ((rowClass = this.concatClasses(builder.toString(), rowClass)).length() > 0) {
            writer.writeAttribute("class", (Object)rowClass, null);
        }
        Iterator<UIComponent> columns = null;
        Part part = state.getPart();
        writer.writeAttribute("id", (Object)(table.getContainerClientId(facesContext) + ":" + part.getName().getId()), null);
        columns = part.getColumns().iterator();
        int columnNumber = 0;
        int lastColumnNumber = part.getColumns().size() - 1;
        while (columns.hasNext()) {
            String columnStyle;
            UIComponent column = columns.next();
            if (!column.isRendered()) continue;
            writer.startElement("td", (UIComponent)table);
            String columnClass = "";
            if (columnNumber != lastColumnNumber) {
                columnClass = "rf-edt-td-" + column.getId();
            }
            if (!"".equals(columnClass = this.concatClasses(columnClass, this.getColumnClass(rowHolder, columnNumber), column.getAttributes().get("styleClass")))) {
                writer.writeAttribute("class", (Object)columnClass, null);
            }
            if (!"".equals(columnStyle = (String)column.getAttributes().get("style"))) {
                writer.writeAttribute("style", (Object)columnStyle, null);
            }
            ++columnNumber;
            writer.startElement("div", (UIComponent)table);
            writer.writeAttribute("class", (Object)("rf-edt-c rf-edt-c-" + column.getId()), null);
            writer.startElement("div", column);
            writer.writeAttribute("class", (Object)"rf-edt-c-cnt", null);
            this.renderChildren(facesContext, column);
            writer.endElement("div");
            writer.endElement("div");
            writer.endElement("td");
        }
        writer.endElement("tr");
    }

    @Override
    protected void doDecode(FacesContext context, UIComponent component) {
        super.doDecode(context, component);
        Map map = context.getExternalContext().getRequestParameterMap();
        String clientId = component.getClientId(context);
        this.updateWidthOfColumns(context, component, (String)map.get(clientId + ":wi"));
        if (map.get(clientId) != null) {
            this.updateColumnsOrder(context, component, (String)map.get("rich:columnsOrder"));
        }
        if (map.get(clientId) != null) {
            this.updateClientFirst(context, component, (String)map.get("rich:clientFirst"));
        }
        this.decodeSortingFiltering(context, component);
        if (component.getAttributes().get("tableState") != null) {
            ExtendedDataTableState tableState = new ExtendedDataTableState((UIDataTableBase)component);
            this.updateAttribute(context, component, "tableState", tableState.toString());
        }
    }

    private void updateWidthOfColumns(FacesContext context, UIComponent component, String widthString) {
        if (widthString != null && widthString.length() > 0) {
            String[] widthArray = widthString.split(",");
            for (int i = 0; i < widthArray.length; ++i) {
                String[] widthEntry = widthArray[i].split(":");
                UIComponent column = component.findComponent(widthEntry[0]);
                this.updateAttribute(context, column, "width", widthEntry[1]);
            }
        }
    }

    private void updateColumnsOrder(FacesContext context, UIComponent component, String columnsOrderString) {
        if (columnsOrderString != null && columnsOrderString.length() > 0) {
            String[] columnsOrder = columnsOrderString.split(",");
            this.updateAttribute(context, component, "columnsOrder", columnsOrder);
            context.getPartialViewContext().getRenderIds().add(component.getClientId(context));
        }
    }

    private void updateClientFirst(FacesContext context, UIComponent component, String clientFirst) {
        Map attributes;
        Integer value;
        if (clientFirst != null && clientFirst.length() > 0 && !(value = Integer.valueOf(clientFirst)).equals((attributes = component.getAttributes()).get("clientFirst"))) {
            attributes.put("submittedClientFirst", value);
            context.getPartialViewContext().getRenderIds().add(component.getClientId(context) + "@" + "scroll");
        }
    }

    public void consumeTableState(FacesContext facesContext, UIDataTableBase table, ExtendedDataTableState tableState) {
        Iterator<UIComponent> columns = table.columns();
        while (columns.hasNext()) {
            SortOrder sortOrder;
            String sort;
            String stateFilterValue;
            UIComponent component = columns.next();
            if (!(component instanceof AbstractColumn)) continue;
            AbstractColumn column = (AbstractColumn)component;
            String width = tableState.getColumnWidth((UIComponent)column);
            if (width != null && !width.equals(column.getWidth())) {
                this.updateAttribute(facesContext, (UIComponent)column, "width", width);
            }
            if (!((stateFilterValue = tableState.getColumnFilter((UIComponent)column)) == null || column.getFilterValue() != null && column.getFilterValue().toString().equals(stateFilterValue))) {
                this.updateAttribute(facesContext, (UIComponent)column, "filterValue", stateFilterValue);
            }
            if ((sort = tableState.getColumnSort((UIComponent)column)) == null || (sortOrder = SortOrder.valueOf((String)sort)).equals((Object)column.getSortOrder())) continue;
            this.updateAttribute(facesContext, (UIComponent)column, "sortOrder", sortOrder);
        }
        String[] columnsOrder = tableState.getColumnsOrder();
        if (columnsOrder != null) {
            this.updateAttribute(facesContext, (UIComponent)table, "columnsOrder", columnsOrder);
        }
    }

    private String getColumnWidth(UIComponent column) {
        String width = (String)column.getAttributes().get("width");
        if (width == null || width.length() == 0 || width.indexOf("%") != -1) {
            width = "100px";
        }
        return width;
    }

    private static enum EncoderVariance {
        full{

            @Override
            public void encodeStartUpdate(FacesContext context, String targetId) throws IOException {
            }

            @Override
            public void encodeEndUpdate(FacesContext context) throws IOException {
            }
        }
        ,
        partial{

            private void switchResponseWriter(FacesContext context, boolean writerState) {
                ResponseWriter writer = context.getResponseWriter();
                ((OnOffResponseWriter)writer).setSwitchedOn(writerState);
            }

            @Override
            public void encodeStartUpdate(FacesContext context, String targetId) throws IOException {
                this.switchResponseWriter(context, true);
                context.getPartialViewContext().getPartialResponseWriter().startUpdate(targetId);
            }

            @Override
            public void encodeEndUpdate(FacesContext context) throws IOException {
                context.getPartialViewContext().getPartialResponseWriter().endUpdate();
                this.switchResponseWriter(context, false);
            }
        };


        public abstract void encodeStartUpdate(FacesContext var1, String var2) throws IOException;

        public abstract void encodeEndUpdate(FacesContext var1) throws IOException;
    }

    private class RendererState
    extends RowHolderBase {
        private UIDataTableBase table;
        private List<Part> parts;
        private Part current;
        private Iterator<Part> partIterator;
        private EncoderVariance encoderVariance;

        public RendererState(FacesContext context, UIDataTableBase table) {
            super(context);
            this.encoderVariance = EncoderVariance.full;
            this.table = table;
            List<UIComponent> columns = this.getOrderedColumns(context);
            int frozenColumnsAttribute = (Integer)table.getAttributes().get("frozenColumns");
            if (frozenColumnsAttribute < 0 || frozenColumnsAttribute >= columns.size()) {
                frozenColumnsAttribute = 0;
            }
            int count = Math.min(frozenColumnsAttribute, columns.size());
            List<UIComponent> frozenColumns = columns.subList(0, count);
            columns = columns.subList(count, columns.size());
            this.parts = new ArrayList<Part>(PartName.values().length);
            if (frozenColumns.size() > 0) {
                this.parts.add(new Part(PartName.frozen, frozenColumns));
            }
            if (columns.size() > 0) {
                this.parts.add(new Part(PartName.normal, columns));
            }
        }

        private List<UIComponent> getOrderedColumns(FacesContext context) {
            LinkedHashMap<String, UIComponent> columnsMap = new LinkedHashMap<String, UIComponent>();
            Iterator<UIComponent> iterator = this.table.columns();
            while (iterator.hasNext()) {
                UIComponent component = iterator.next();
                if (!component.isRendered()) continue;
                columnsMap.put(component.getId(), component);
            }
            ArrayList<UIComponent> columns = new ArrayList<UIComponent>();
            String[] columnsOrder = (String[])RenderKitUtils.evaluateAttribute("columnsOrder", (UIComponent)this.table, context);
            if (columnsOrder != null && columnsOrder.length > 0) {
                for (int i = 0; i < columnsOrder.length && !columnsMap.isEmpty(); ++i) {
                    columns.add((UIComponent)columnsMap.remove(columnsOrder[i]));
                }
            }
            for (UIComponent column : columnsMap.values()) {
                columns.add(column);
            }
            return columns;
        }

        @Override
        public UIDataTableBase getRow() {
            return this.table;
        }

        public void startIterate() {
            this.partIterator = this.parts.iterator();
        }

        public Part nextPart() {
            this.current = this.partIterator.next();
            return this.current;
        }

        public Part getPart() {
            return this.current;
        }

        public boolean hasNextPart() {
            return this.partIterator.hasNext();
        }

        public EncoderVariance getEncoderVariance() {
            return this.encoderVariance;
        }

        public void setEncoderVariance(EncoderVariance encoderVariance) {
            this.encoderVariance = encoderVariance;
        }
    }

    private class Part {
        private PartName name;
        private List<UIComponent> columns;

        public Part(PartName name, List<UIComponent> columns) {
            this.name = name;
            this.columns = columns;
        }

        public PartName getName() {
            return this.name;
        }

        public List<UIComponent> getColumns() {
            return this.columns;
        }
    }

    private static enum PartName {
        frozen,
        normal;

        private String id = String.valueOf(this.toString().charAt(0));

        public String getId() {
            return this.id;
        }
    }
}

