/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.validator;

import javax.faces.application.FacesMessage;
import javax.faces.component.EditableValueHolder;
import javax.faces.context.FacesContext;
import javax.faces.validator.DoubleRangeValidator;
import javax.faces.validator.LengthValidator;
import javax.faces.validator.LongRangeValidator;
import javax.faces.validator.RegexValidator;
import javax.faces.validator.RequiredValidator;
import javax.faces.validator.Validator;
import org.richfaces.validator.BaseFacesObjectDescriptor;
import org.richfaces.validator.FacesServiceBase;
import org.richfaces.validator.FacesValidatorDescriptor;
import org.richfaces.validator.FacesValidatorService;
import org.richfaces.validator.ValidatorDescriptor;

public class FacesValidatorServiceImpl
extends FacesServiceBase<Validator>
implements FacesValidatorService {
    private static final String PATTERN = "pattern";
    private static final String MINIMUM = "min";
    private static final String MAXIMUM = "max";

    public ValidatorDescriptor getValidatorDescription(FacesContext context, EditableValueHolder input, Validator validator, String validatorMessage) {
        FacesMessage message = this.getMessage(context, validator, input, validatorMessage);
        FacesValidatorDescriptor descriptor = new FacesValidatorDescriptor((Class<? extends Validator>)validator.getClass(), message);
        this.setLabelParameter(input, descriptor);
        this.fillParameters((BaseFacesObjectDescriptor<Validator>)descriptor, validator);
        descriptor.makeImmutable();
        return descriptor;
    }

    @Override
    protected String getMessageId(Validator component) {
        DoubleRangeValidator validator;
        String messageId = component instanceof DoubleRangeValidator ? ((validator = (DoubleRangeValidator)component).getMaximum() < Double.MAX_VALUE ? (validator.getMinimum() > Double.MIN_VALUE ? "javax.faces.validator.DoubleRangeValidator.NOT_IN_RANGE" : "javax.faces.validator.DoubleRangeValidator.MAXIMUM") : (validator.getMinimum() > Double.MIN_VALUE ? "javax.faces.validator.DoubleRangeValidator.MINIMUM" : "javax.faces.validator.DoubleRangeValidator.NOT_IN_RANGE")) : (component instanceof LengthValidator ? ((validator = (LengthValidator)component).getMaximum() > 0 ? (validator.getMinimum() > 0 ? "javax.faces.validator.DoubleRangeValidator.NOT_IN_RANGE" : "javax.faces.validator.LengthValidator.MAXIMUM") : (validator.getMinimum() > 0 ? "javax.faces.validator.LengthValidator.MINIMUM" : "javax.faces.validator.DoubleRangeValidator.NOT_IN_RANGE")) : (component instanceof LongRangeValidator ? ((validator = (LongRangeValidator)component).getMaximum() != 0L ? (validator.getMinimum() != 0L ? "javax.faces.validator.DoubleRangeValidator.NOT_IN_RANGE" : "javax.faces.validator.LongRangeValidator.MAXIMUM") : (validator.getMinimum() != 0L ? "javax.faces.validator.LongRangeValidator.MINIMUM" : "javax.faces.validator.DoubleRangeValidator.NOT_IN_RANGE")) : (component instanceof RegexValidator ? "javax.faces.validator.RegexValidator.NOT_MATCHED" : (component instanceof RequiredValidator ? "javax.faces.component.UIInput.REQUIRED" : "javax.faces.component.UIInput.UPDATE"))));
        return messageId;
    }

    @Override
    protected void fillParameters(BaseFacesObjectDescriptor<Validator> descriptor, Validator component) {
        if (component instanceof DoubleRangeValidator) {
            DoubleRangeValidator validator = (DoubleRangeValidator)component;
            if (validator.getMaximum() < Double.MAX_VALUE) {
                descriptor.addParameter(MAXIMUM, validator.getMaximum());
            }
            if (validator.getMinimum() > Double.MIN_VALUE) {
                descriptor.addParameter(MINIMUM, validator.getMinimum());
            }
        } else if (component instanceof LengthValidator) {
            LengthValidator validator = (LengthValidator)component;
            if (validator.getMaximum() > 0) {
                descriptor.addParameter(MAXIMUM, validator.getMaximum());
            }
            if (validator.getMinimum() > 0) {
                descriptor.addParameter(MINIMUM, validator.getMinimum());
            }
        } else if (component instanceof LongRangeValidator) {
            LongRangeValidator validator = (LongRangeValidator)component;
            if (validator.getMaximum() != 0L) {
                descriptor.addParameter(MAXIMUM, validator.getMaximum());
            }
            if (validator.getMinimum() != 0L) {
                descriptor.addParameter(MINIMUM, validator.getMinimum());
            }
        } else if (component instanceof RegexValidator) {
            RegexValidator validator = (RegexValidator)component;
            descriptor.addParameter(PATTERN, validator.getPattern());
        } else if (!(component instanceof RequiredValidator)) {
            super.fillParameters(descriptor, component);
        }
    }
}

