/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.resource;

import java.io.IOException;
import java.io.Writer;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import org.ajax4jsf.javascript.ScriptUtils;
import org.richfaces.application.ServiceTracker;
import org.richfaces.application.push.PushContext;
import org.richfaces.application.push.PushContextFactory;
import org.richfaces.application.push.Session;
import org.richfaces.application.push.TopicKey;
import org.richfaces.resource.AbstractUserResource;
import org.richfaces.resource.DynamicResource;

@DynamicResource
public class PushResource
extends AbstractUserResource {
    private static final String PUSH_TOPIC_PARAM = "pushTopic";
    private static final String FORGET_PUSH_SESSION_ID_PARAM = "forgetPushSessionId";

    private Map<String, String> getFailuresMap(Map<TopicKey, String> failedSubscriptions) {
        HashMap<String, String> result = new HashMap<String, String>();
        for (Map.Entry<TopicKey, String> entry : failedSubscriptions.entrySet()) {
            result.put(entry.getKey().getTopicAddress(), entry.getValue());
        }
        return result;
    }

    public void encode(FacesContext facesContext) throws IOException {
        Session oldSession;
        ExternalContext externalContext = facesContext.getExternalContext();
        PushContextFactory pushContextFactory = (PushContextFactory)ServiceTracker.getService(PushContextFactory.class);
        if (pushContextFactory == null) {
            return;
        }
        PushContext pushContext = pushContextFactory.getPushContext();
        String forgetPushSessionId = (String)externalContext.getRequestParameterMap().get(FORGET_PUSH_SESSION_ID_PARAM);
        if (forgetPushSessionId != null && (oldSession = pushContext.getSessionManager().getPushSession(forgetPushSessionId)) != null) {
            oldSession.invalidate();
        }
        Session session = pushContext.getSessionFactory().createSession(UUID.randomUUID().toString());
        String[] topicNames = (String[])externalContext.getRequestParameterValuesMap().get(PUSH_TOPIC_PARAM);
        if (topicNames == null) {
            throw new IllegalArgumentException();
        }
        session.subscribe(topicNames);
        HashMap<String, Object> subscriptionData = new HashMap<String, Object>(4);
        subscriptionData.put("sessionId", session.getId());
        Map failedSubscriptions = session.getFailedSubscriptions();
        subscriptionData.put("failures", this.getFailuresMap(failedSubscriptions));
        Writer outWriter = facesContext.getExternalContext().getResponseOutputWriter();
        ScriptUtils.appendScript((Appendable)outWriter, subscriptionData);
    }

    public String getContentType() {
        return "text/javascript; charset=utf-8";
    }
}

