/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.renderkit;

import java.io.IOException;
import java.text.MessageFormat;
import java.util.Collections;
import java.util.Map;
import javax.faces.FacesException;
import javax.faces.application.ResourceDependency;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.render.Renderer;
import org.ajax4jsf.model.DataVisitResult;
import org.ajax4jsf.model.DataVisitor;
import org.richfaces.component.AbstractList;
import org.richfaces.component.ListType;
import org.richfaces.component.UISequence;
import org.richfaces.component.util.HtmlUtil;
import org.richfaces.log.RichfacesLogger;
import org.richfaces.renderkit.ComponentAttribute;
import org.richfaces.renderkit.RenderKitUtils;
import org.richfaces.renderkit.SequenceRendererHelper;
import org.richfaces.renderkit.util.RendererUtils;

@ResourceDependency(library="org.richfaces", name="list.ecss")
public abstract class ListRendererBase
extends Renderer {
    private static final Map<String, ComponentAttribute> ROW_HANDLER_ATTRIBUTES = Collections.unmodifiableMap(ComponentAttribute.createMap(new ComponentAttribute("onclick").setEventNames("rowclick").setComponentAttributeName("onrowclick"), new ComponentAttribute("ondblclick").setEventNames("rowdblclick").setComponentAttributeName("onrowdblclick"), new ComponentAttribute("onmousedown").setEventNames("rowmousedown").setComponentAttributeName("onrowmousedown"), new ComponentAttribute("onmouseup").setEventNames("rowmouseup").setComponentAttributeName("onrowmouseup"), new ComponentAttribute("onmouseover").setEventNames("rowmouseover").setComponentAttributeName("onrowmouseover"), new ComponentAttribute("onmousemove").setEventNames("rowmousemove").setComponentAttributeName("onrowmousemove"), new ComponentAttribute("onmouseout").setEventNames("rowmouseout").setComponentAttributeName("onrowmouseout"), new ComponentAttribute("onkeypress").setEventNames("rowkeypress").setComponentAttributeName("onrowkeypress"), new ComponentAttribute("onkeydown").setEventNames("rowkeydown").setComponentAttributeName("onrowkeydown"), new ComponentAttribute("onkeyup").setEventNames("rowkeyup").setComponentAttributeName("onrowkeyup")));
    private RendererUtils rendererUtils = RendererUtils.getInstance();
    private ItemsEncoder unorderedListItemsEncoder = new SimpleItemsEncoder("rf-ulst-itm");
    private ItemsEncoder orderedListItemsEncoder = new SimpleItemsEncoder("rf-olst-itm");
    private ItemsEncoder definitionItemsEncoder = new DefinitionItemsEncoder();

    protected String getListClass(ListType type) {
        switch (type) {
            case ordered: {
                return "rf-olst";
            }
            case unordered: {
                return "rf-ulst";
            }
            case definitions: {
                return "rf-dlst";
            }
        }
        throw new IllegalArgumentException(type.toString());
    }

    protected ItemsEncoder getItemsEncoderByType(ListType type) {
        switch (type) {
            case ordered: {
                return this.orderedListItemsEncoder;
            }
            case unordered: {
                return this.unorderedListItemsEncoder;
            }
            case definitions: {
                return this.definitionItemsEncoder;
            }
        }
        throw new IllegalArgumentException(type.toString());
    }

    protected ListType getType(UIComponent component) {
        ListType type = ((AbstractList)component).getType();
        if (type == null) {
            String exceptionMessage = MessageFormat.format("Type for rich:list {0} is required!", RichfacesLogger.getComponentPath((UIComponent)component));
            throw new IllegalArgumentException(exceptionMessage);
        }
        return type;
    }

    protected String getStyleClass(UIComponent component, ListType listType) {
        String styleClass = (String)component.getAttributes().get("styleClass");
        return HtmlUtil.concatClasses(styleClass, this.getListClass(listType));
    }

    protected String getElementId(FacesContext facesContext, UIComponent component) {
        if (this.rendererUtils.hasExplicitId(component)) {
            return component.getContainerClientId(facesContext);
        }
        return null;
    }

    protected void encodeListItems(FacesContext context, UIComponent component, ListType listType) throws IOException {
        AbstractList list = (AbstractList)component;
        try {
            ItemsEncoder itemsEncoder = this.getItemsEncoderByType(listType);
            SequenceRendererHelper rendererHelper = new SequenceRendererHelper(list);
            list.walk(context, itemsEncoder, rendererHelper);
            if (!rendererHelper.hasWalkedOverRows()) {
                itemsEncoder.encodeFakeItem(context, component);
            }
        }
        catch (FacesException e) {
            if (e.getCause() instanceof IOException) {
                throw (IOException)e.getCause();
            }
            throw e;
        }
    }

    public void encodeBegin(FacesContext context, UIComponent component) throws IOException {
    }

    public void encodeChildren(FacesContext context, UIComponent component) throws IOException {
    }

    private abstract class ItemsEncoder
    implements DataVisitor {
        private ItemsEncoder() {
        }

        protected void renderHandlers(FacesContext context, UISequence sequence) throws IOException {
            RenderKitUtils.renderPassThroughAttributesOptimized(context, (UIComponent)sequence, ROW_HANDLER_ATTRIBUTES);
        }

        protected abstract void encodeRow(FacesContext var1, UISequence var2, SequenceRendererHelper var3) throws IOException;

        public DataVisitResult process(FacesContext context, Object rowKey, Object argument) {
            SequenceRendererHelper helper = (SequenceRendererHelper)argument;
            UISequence sequence = helper.getSequence();
            sequence.setRowKey(context, rowKey);
            if (sequence.isRowAvailable()) {
                helper.nextRow();
                try {
                    this.encodeRow(context, sequence, helper);
                }
                catch (IOException e) {
                    throw new FacesException(e.getMessage(), (Throwable)e);
                }
                return DataVisitResult.CONTINUE;
            }
            return DataVisitResult.STOP;
        }

        public abstract void encodeFakeItem(FacesContext var1, UIComponent var2) throws IOException;
    }

    private final class DefinitionItemsEncoder
    extends ItemsEncoder {
        private DefinitionItemsEncoder() {
        }

        @Override
        protected void encodeRow(FacesContext context, UISequence sequence, SequenceRendererHelper helper) throws IOException {
            ResponseWriter writer = context.getResponseWriter();
            UIComponent termFacet = sequence.getFacet("term");
            if (termFacet != null) {
                writer.startElement("dt", (UIComponent)sequence);
                if (ListRendererBase.this.rendererUtils.hasExplicitId((UIComponent)sequence)) {
                    writer.writeAttribute("id", (Object)(sequence.getContainerClientId(context) + ".dt"), null);
                }
                writer.writeAttribute("class", (Object)HtmlUtil.concatClasses(helper.getRowClass(), helper.getColumnClass(), "rf-dlst-trm"), null);
                this.renderHandlers(context, sequence);
                termFacet.encodeAll(context);
                writer.endElement("dt");
            }
            writer.startElement("dd", (UIComponent)sequence);
            if (ListRendererBase.this.rendererUtils.hasExplicitId((UIComponent)sequence)) {
                writer.writeAttribute("id", (Object)sequence.getContainerClientId(context), null);
            }
            writer.writeAttribute("class", (Object)HtmlUtil.concatClasses(helper.getRowClass(), helper.getColumnClass(), "rf-dlst-dfn"), null);
            this.renderHandlers(context, sequence);
            ListRendererBase.this.rendererUtils.encodeChildren(context, (UIComponent)sequence);
            writer.endElement("dd");
        }

        @Override
        public void encodeFakeItem(FacesContext context, UIComponent component) throws IOException {
            ResponseWriter writer = context.getResponseWriter();
            writer.startElement("dd", component);
            writer.writeAttribute("style", (Object)"display:none", null);
            writer.endElement("dd");
        }
    }

    private class SimpleItemsEncoder
    extends ItemsEncoder {
        private String itemClass;

        public SimpleItemsEncoder(String itemClass) {
            this.itemClass = itemClass;
        }

        @Override
        protected void encodeRow(FacesContext context, UISequence sequence, SequenceRendererHelper helper) throws IOException {
            ResponseWriter writer = context.getResponseWriter();
            writer.startElement("li", (UIComponent)sequence);
            if (ListRendererBase.this.rendererUtils.hasExplicitId((UIComponent)sequence)) {
                writer.writeAttribute("id", (Object)sequence.getContainerClientId(context), null);
            }
            writer.writeAttribute("class", (Object)HtmlUtil.concatClasses(helper.getRowClass(), helper.getColumnClass(), this.itemClass), null);
            this.renderHandlers(context, sequence);
            ListRendererBase.this.rendererUtils.encodeChildren(context, (UIComponent)sequence);
            writer.endElement("li");
        }

        @Override
        public void encodeFakeItem(FacesContext context, UIComponent component) throws IOException {
            ResponseWriter writer = context.getResponseWriter();
            writer.startElement("li", component);
            writer.writeAttribute("style", (Object)"display:none", null);
            writer.endElement("li");
        }
    }
}

