/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.renderkit.html;

import com.google.common.collect.ImmutableSet;
import java.io.IOException;
import java.util.Collection;
import org.richfaces.renderkit.html.AjaxOnlyScript;
import org.richfaces.renderkit.html.ClientOnlyScript;
import org.richfaces.renderkit.html.LibraryScriptFunction;
import org.richfaces.resource.ResourceKey;

public class ClientAndAjaxScript
extends ClientOnlyScript {
    private final String ajaxScript;
    private final Iterable<ResourceKey> resources;

    public ClientAndAjaxScript(LibraryScriptFunction clientSideConverterScript, Collection<? extends LibraryScriptFunction> validatorScripts, String ajaxScript) {
        super(clientSideConverterScript, validatorScripts);
        this.ajaxScript = ajaxScript;
        ImmutableSet.Builder builder = ImmutableSet.builder();
        builder.add((Object)AjaxOnlyScript.AJAX_RESOURCE);
        builder.addAll(super.getResources());
        this.resources = builder.build();
    }

    @Override
    public Iterable<ResourceKey> getResources() {
        return this.resources;
    }

    @Override
    protected void appendAjaxParameter(Appendable target) throws IOException {
        target.append(',');
        this.appendAjaxParameter(target, this.ajaxScript);
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.ajaxScript == null ? 0 : this.ajaxScript.hashCode());
        result = 31 * result + (this.converter == null ? 0 : this.converter.hashCode());
        result = 31 * result + (this.validators == null ? 0 : this.validators.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ClientAndAjaxScript other = (ClientAndAjaxScript)obj;
        if (this.ajaxScript == null ? other.ajaxScript != null : !this.ajaxScript.equals(other.ajaxScript)) {
            return false;
        }
        if (this.converter == null ? other.converter != null : !this.converter.equals(other.converter)) {
            return false;
        }
        return !(this.validators == null ? other.validators != null : !this.validators.equals((Object)other.validators));
    }
}

