/*
 * Decompiled with CFR 0.152.
 */
package org.revapi.maven.utils;

import java.util.Arrays;
import org.eclipse.aether.collection.DependencyCollectionContext;
import org.eclipse.aether.collection.DependencySelector;
import org.eclipse.aether.graph.Dependency;

final class ScopeDependencySelector
implements DependencySelector {
    private final String[] topLevelScopes;
    private final String[] transitiveScopes;
    private final int depth;

    public ScopeDependencySelector(String[] topLevelScopes, String[] transitiveScopes) {
        this(topLevelScopes, transitiveScopes, 0);
    }

    private ScopeDependencySelector(String[] topLevelScopes, String[] transitiveScopes, int depth) {
        this.topLevelScopes = topLevelScopes;
        this.transitiveScopes = transitiveScopes;
        this.depth = depth;
    }

    private boolean hasRequiredScope(Dependency dep) {
        String scope = dep.getScope();
        if (scope == null || scope.isEmpty()) {
            scope = "compile";
        }
        for (String s : this.depth > 1 ? this.transitiveScopes : this.topLevelScopes) {
            if (!s.equals(scope)) continue;
            return true;
        }
        return false;
    }

    public boolean selectDependency(Dependency dependency) {
        return this.hasRequiredScope(dependency);
    }

    public DependencySelector deriveChildSelector(DependencyCollectionContext context) {
        if (this.depth > 1) {
            return this;
        }
        return new ScopeDependencySelector(this.topLevelScopes, this.transitiveScopes, this.depth + 1);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (null == obj || !this.getClass().equals(obj.getClass())) {
            return false;
        }
        ScopeDependencySelector that = (ScopeDependencySelector)obj;
        return this.depth == that.depth && (this.depth > 1 ? Arrays.equals(this.transitiveScopes, that.transitiveScopes) : Arrays.equals(this.topLevelScopes, that.topLevelScopes));
    }

    public int hashCode() {
        return this.depth > 1 ? Arrays.hashCode(this.transitiveScopes) : Arrays.hashCode(this.topLevelScopes);
    }
}

